/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.performancetest.main;

import java.util.ArrayList;
import java.util.List;
import org.copperengine.performancetest.main.ConfigParameterGroup;

public enum ConfigParameter {
    PROC_POOL_NUMB_OF_THREADS("procPool.numberOfThreads", "Number of processor threads per processor pool", Runtime.getRuntime().availableProcessors(), ConfigParameterGroup.common),
    PROC_DEQUEUE_BULK_SIZE("procPool.dequeueBulkSize", "Max. bulk size when fetching workflow instances from the underlying DB", 2000, ConfigParameterGroup.common),
    MOCK_ADAPTER_NUMB_OF_THREADS("mockAdapter.numberOfThreads", "Number of processor threads in adapter mock", Runtime.getRuntime().availableProcessors(), ConfigParameterGroup.common),
    COMPRESSION("compression", "compress workflow instances in DB?", true, ConfigParameterGroup.common),
    DS_JDBC_URL("ds.jdbcURL", "jdbc URL", null, ConfigParameterGroup.rdbms, "mandatory when testing RDBMS"),
    DS_DRIVER_CLASS("ds.driverClass", "jdbc driver class", null, ConfigParameterGroup.rdbms),
    DS_USER("ds.user", "jdbc user", null, ConfigParameterGroup.rdbms),
    DS_PASSWORD("ds.password", "jdbc password", null, ConfigParameterGroup.rdbms),
    DS_MIN_POOL_SIZE("ds.minPoolSize", "minimum size of the connection pool", Runtime.getRuntime().availableProcessors(), ConfigParameterGroup.rdbms),
    DS_MAX_POOL_SIZE("ds.maxPoolSize", "maximum size of the connection pool", Runtime.getRuntime().availableProcessors() * 2, ConfigParameterGroup.rdbms),
    BATCHER_NUMB_OF_THREADS("batcher.numberOfThreads", "Number of DB batcher threads", Runtime.getRuntime().availableProcessors(), ConfigParameterGroup.rdbms),
    CASSANDRA_HOSTS("cassandra.hosts", "comma separated list of initial cassandra nodes", null, ConfigParameterGroup.cassandra, "mandatory when testing with Cassandra DB"),
    CASSANDRA_PORT("cassandra.port", "cassandra port", 9042, ConfigParameterGroup.cassandra),
    CASSANDRA_KEYSPACE("cassandra.keyspace", "cassandra keyspace", "copper", ConfigParameterGroup.cassandra),
    THROUGHPUTTEST_NUMBER_OF_WORKFLOW_INSTANCES("throughput.numberOfWfI", "Number of workflow instances to process in the test", 20000, ConfigParameterGroup.throughput),
    THROUGHPUTTEST_DATA_SIZE("throughput.dataSize", "Size of the data argument passed to the workflow instances", 50, ConfigParameterGroup.throughput),
    THROUGHPUTTEST_NUMBER_OF_INSERT_THREADS("throughput.numberOfInsertThreads", "Number of concurrent insert threads", 1, ConfigParameterGroup.throughput),
    THROUGHPUTTEST_BATCHS_SIZE("throughput.batchSize", "insert batch size", 100, ConfigParameterGroup.throughput),
    THROUGHPUTTEST_NUMBER_OF_EXTRA_PROC_POOLS("throughput.numberOfExtraProcPools", "number of extra processor pools", 0, ConfigParameterGroup.throughput),
    LATENCY_NUMBER_OF_WORKFLOW_INSTANCES("latency.numberOfWfI", "Number of workflow instances to process in the test", 50, ConfigParameterGroup.latency),
    LATENCY_DATA_SIZE("latency.dataSize", "Size of the data argument passed to the workflow instances", 1000, ConfigParameterGroup.latency);

    private final String key;
    private final String description;
    private final ConfigParameterGroup grp;
    private final String mandatory;
    private final Object defaultValue;

    private ConfigParameter(String key, String description, Object defaultValue, ConfigParameterGroup grp) {
        this.key = key;
        this.description = description;
        this.grp = grp;
        this.mandatory = "optional";
        this.defaultValue = defaultValue;
    }

    private ConfigParameter(String key, String description, Object defaultValue, ConfigParameterGroup grp, String mandatory) {
        this.key = key;
        this.description = description;
        this.grp = grp;
        this.mandatory = mandatory;
        this.defaultValue = defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigParameterGroup getGrp() {
        return this.grp;
    }

    public String getKey() {
        return this.key;
    }

    public static List<ConfigParameter> all4group(ConfigParameterGroup grp) {
        ArrayList<ConfigParameter> rv = new ArrayList<ConfigParameter>();
        for (ConfigParameter x : ConfigParameter.values()) {
            if (x.grp != grp) continue;
            rv.add(x);
        }
        return rv;
    }

    public String getMandatory() {
        return this.mandatory;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

