/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.performancetest.main;

import java.io.PrintStream;
import java.util.Properties;
import org.copperengine.performancetest.main.ConfigParameter;
import org.copperengine.performancetest.main.ConfigParameterGroup;
import org.slf4j.Logger;

public class ConfigurationManager {
    private final Properties props;

    public ConfigurationManager(Properties props) {
        this.props = props;
    }

    public int getConfigInt(ConfigParameter p) {
        String v = this.props.getProperty(p.getKey());
        if (v == null || v.trim().isEmpty()) {
            return (Integer)p.getDefaultValue();
        }
        return Integer.parseInt(v);
    }

    public boolean getConfigBoolean(ConfigParameter p) {
        String v = this.props.getProperty(p.getKey());
        if (v == null || v.trim().isEmpty()) {
            return (Boolean)p.getDefaultValue();
        }
        return Boolean.parseBoolean(v);
    }

    public Integer getConfigInteger(ConfigParameter p) {
        String v = this.props.getProperty(p.getKey());
        if (v == null || v.trim().isEmpty()) {
            return (Integer)p.getDefaultValue();
        }
        return Integer.parseInt(v);
    }

    public String getConfigString(ConfigParameter p) {
        String v = this.props.getProperty(p.getKey());
        if (v == null || v.trim().isEmpty()) {
            return (String)p.getDefaultValue();
        }
        return v;
    }

    private Object getConfig(ConfigParameter p) {
        String v = this.props.getProperty(p.getKey());
        return v == null ? p.getDefaultValue() : v;
    }

    public void print(PrintStream ps) {
        for (ConfigParameterGroup grp : ConfigParameterGroup.values()) {
            for (ConfigParameter p : ConfigParameter.all4group(grp)) {
                System.out.println(p.getKey() + "=" + this.getConfig(p));
            }
        }
    }

    public void log(Logger logger, ConfigParameterGroup ... grps) {
        logger.info("Configuration parameters:");
        for (ConfigParameterGroup grp : grps) {
            for (ConfigParameter p : ConfigParameter.all4group(grp)) {
                logger.info("{}={}", (Object)p.getKey(), this.getConfig(p));
            }
        }
    }
}

