/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.performancetest.main;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.util.Properties;
import org.copperengine.performancetest.main.ConfigParameter;

public class DataSourceFactory {
    public static ComboPooledDataSource createDataSource(Properties props) {
        try {
            String jdbcUrl = DataSourceFactory.trim(props.getProperty(ConfigParameter.DS_JDBC_URL.getKey()));
            String user = DataSourceFactory.trim(props.getProperty(ConfigParameter.DS_USER.getKey()));
            String password = DataSourceFactory.trim(props.getProperty(ConfigParameter.DS_PASSWORD.getKey()));
            String driverClass = DataSourceFactory.trim(props.getProperty(ConfigParameter.DS_DRIVER_CLASS.getKey()));
            int minPoolSize = Integer.valueOf(props.getProperty(ConfigParameter.DS_MIN_POOL_SIZE.getKey(), Integer.toString(Runtime.getRuntime().availableProcessors())));
            int maxPoolSize = Integer.valueOf(props.getProperty(ConfigParameter.DS_MAX_POOL_SIZE.getKey(), Integer.toString(2 * Runtime.getRuntime().availableProcessors())));
            ComboPooledDataSource ds = new ComboPooledDataSource();
            ds.setJdbcUrl(jdbcUrl.replace("${NOW}", Long.toString(System.currentTimeMillis())));
            if (!DataSourceFactory.isNullOrEmpty(user)) {
                ds.setUser(user);
            }
            if (!DataSourceFactory.isNullOrEmpty(password)) {
                ds.setPassword(password);
            }
            if (!DataSourceFactory.isNullOrEmpty(driverClass)) {
                ds.setDriverClass(driverClass);
            }
            ds.setMinPoolSize(minPoolSize);
            ds.setInitialPoolSize(minPoolSize);
            ds.setMaxPoolSize(maxPoolSize);
            return ds;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create datasource", e);
        }
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    private static String trim(String s) {
        return s == null ? null : s.trim();
    }
}

