/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.performancetest.main;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.copperengine.core.PersistentProcessingEngine;
import org.copperengine.core.WorkflowInstanceDescr;
import org.copperengine.management.model.MeasurePointData;
import org.copperengine.performancetest.main.ConfigParameter;
import org.copperengine.performancetest.main.ConfigParameterGroup;
import org.copperengine.performancetest.main.PerformanceTestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyPerformanceTest {
    private static final Logger logger = LoggerFactory.getLogger(LatencyPerformanceTest.class);

    protected String createTestData(int size) {
        StringBuilder sb = new StringBuilder(size);
        Random r = new Random();
        for (int i = 0; i < size; ++i) {
            sb.append(r.nextInt(2) == 0 ? "0" : "1");
        }
        return sb.toString();
    }

    public void run() {
        try (PerformanceTestContext context = new PerformanceTestContext();){
            int dataSize = context.getConfigManager().getConfigInt(ConfigParameter.LATENCY_DATA_SIZE);
            int numbOfWfI = context.getConfigManager().getConfigInt(ConfigParameter.LATENCY_NUMBER_OF_WORKFLOW_INSTANCES);
            String data = this.createTestData(dataSize);
            PersistentProcessingEngine engine = context.getEngine();
            Random random = new Random();
            context.getConfigManager().log(logger, ConfigParameterGroup.latency, ConfigParameterGroup.common, context.isCassandraTest() ? ConfigParameterGroup.cassandra : ConfigParameterGroup.rdbms);
            logger.info("Starting latency performance test with {} workflow instances and data size {} chars ...", (Object)numbOfWfI, (Object)dataSize);
            long startTS = System.currentTimeMillis();
            for (int i = 0; i < numbOfWfI; ++i) {
                String wfiId = engine.run(new WorkflowInstanceDescr("org.copperengine.performancetest.workflows.SavepointPerfTestWorkflow", (Object)data));
                context.getBackchannel().wait(wfiId, 1L, TimeUnit.MINUTES);
                Thread.sleep(random.nextInt(100) + 5);
            }
            long et = System.currentTimeMillis() - startTS;
            MeasurePointData mp = context.getStatisticsCollector().query("savepoint.latency");
            double avgLatency = (double)(mp.getElapsedTimeMicros() / mp.getCount()) / 1000.0;
            logger.info("Finished performance test with {} workflow instances in {} msec, avg latency is {} msec", new Object[]{numbOfWfI, et, avgLatency});
            Thread.sleep(5000L);
            logger.info("statistics:\n{}", (Object)context.getStatisticsCollector().print());
        }
        catch (Exception e) {
            logger.error("performance test failed", (Throwable)e);
        }
    }
}

