/*
 * Decompiled with CFR 0.152.
 */
package org.copperengine.performancetest.main;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.copperengine.core.AbstractDependencyInjector;
import org.copperengine.core.CopperRuntimeException;
import org.copperengine.core.DependencyInjector;
import org.copperengine.core.EngineIdProvider;
import org.copperengine.core.EngineIdProviderBean;
import org.copperengine.core.PersistentProcessingEngine;
import org.copperengine.core.ProcessingEngine;
import org.copperengine.core.batcher.BatchRunner;
import org.copperengine.core.batcher.Batcher;
import org.copperengine.core.batcher.RetryingTxnBatchRunner;
import org.copperengine.core.batcher.impl.BatcherImpl;
import org.copperengine.core.common.DefaultProcessorPoolManager;
import org.copperengine.core.common.IdFactory;
import org.copperengine.core.common.JdkRandomUUIDFactory;
import org.copperengine.core.common.ProcessorPoolManager;
import org.copperengine.core.common.WorkflowRepository;
import org.copperengine.core.monitoring.LoggingStatisticCollector;
import org.copperengine.core.monitoring.RuntimeStatisticsCollector;
import org.copperengine.core.persistent.DatabaseDialect;
import org.copperengine.core.persistent.DerbyDbDialect;
import org.copperengine.core.persistent.H2Dialect;
import org.copperengine.core.persistent.MySqlDialect;
import org.copperengine.core.persistent.OracleDialect;
import org.copperengine.core.persistent.OracleSimpleDialect;
import org.copperengine.core.persistent.PersistentPriorityProcessorPool;
import org.copperengine.core.persistent.PersistentProcessorPool;
import org.copperengine.core.persistent.PersistentScottyEngine;
import org.copperengine.core.persistent.PostgreSQLDialect;
import org.copperengine.core.persistent.ScottyDBStorage;
import org.copperengine.core.persistent.ScottyDBStorageInterface;
import org.copperengine.core.persistent.Serializer;
import org.copperengine.core.persistent.StandardJavaSerializer;
import org.copperengine.core.persistent.cassandra.CassandraSessionManager;
import org.copperengine.core.persistent.cassandra.CassandraSessionManagerImpl;
import org.copperengine.core.persistent.cassandra.CassandraStorage;
import org.copperengine.core.persistent.hybrid.DefaultTimeoutManager;
import org.copperengine.core.persistent.hybrid.HybridDBStorage;
import org.copperengine.core.persistent.hybrid.HybridTransactionController;
import org.copperengine.core.persistent.hybrid.Storage;
import org.copperengine.core.persistent.hybrid.StorageCache;
import org.copperengine.core.persistent.hybrid.TimeoutManager;
import org.copperengine.core.persistent.txn.CopperTransactionController;
import org.copperengine.core.persistent.txn.TransactionController;
import org.copperengine.core.util.Backchannel;
import org.copperengine.core.util.BackchannelDefaultImpl;
import org.copperengine.ext.wfrepo.classpath.ClasspathWorkflowRepository;
import org.copperengine.performancetest.impl.MockAdapter;
import org.copperengine.performancetest.main.ConfigParameter;
import org.copperengine.performancetest.main.ConfigurationManager;
import org.copperengine.performancetest.main.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceTestContext
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(PerformanceTestContext.class);
    protected final Map<String, Supplier<?>> suppliers = new HashMap();
    protected final Supplier<Properties> props;
    protected final Supplier<MockAdapter> mockAdapter;
    protected final Supplier<DependencyInjector> dependencyInjector;
    protected final Supplier<Backchannel> backchannel;
    protected final Supplier<PersistentProcessingEngine> engine;
    protected final Supplier<WorkflowRepository> repo;
    protected final Supplier<LoggingStatisticCollector> statisticsCollector;
    protected final Supplier<EngineIdProvider> engineIdProvider;
    protected final Supplier<Serializer> serializer;
    protected final Supplier<ProcessorPoolManager<PersistentProcessorPool>> processorPoolManager;
    protected final Supplier<ConfigurationManager> configManager;
    protected TransactionController transactionController = null;
    private final List<Runnable> shutdownHooks = new ArrayList<Runnable>();

    public PerformanceTestContext() {
        this.configManager = Suppliers.memoize((Supplier)new Supplier<ConfigurationManager>(){

            public ConfigurationManager get() {
                return PerformanceTestContext.this.createConfigurationManager();
            }
        });
        this.suppliers.put("configManager", this.configManager);
        this.processorPoolManager = Suppliers.memoize((Supplier)new Supplier<ProcessorPoolManager<PersistentProcessorPool>>(){

            public ProcessorPoolManager<PersistentProcessorPool> get() {
                return PerformanceTestContext.this.createProcessorPoolManager();
            }
        });
        this.suppliers.put("processorPoolManager", this.processorPoolManager);
        this.serializer = Suppliers.memoize((Supplier)new Supplier<Serializer>(){

            public Serializer get() {
                return PerformanceTestContext.this.createSerializer();
            }
        });
        this.suppliers.put("serializer", this.serializer);
        this.engineIdProvider = Suppliers.memoize((Supplier)new Supplier<EngineIdProvider>(){

            public EngineIdProvider get() {
                return PerformanceTestContext.this.createEngineIdProvider();
            }
        });
        this.suppliers.put("engineIdProvider", this.engineIdProvider);
        this.statisticsCollector = Suppliers.memoize((Supplier)new Supplier<LoggingStatisticCollector>(){

            public LoggingStatisticCollector get() {
                return PerformanceTestContext.this.createStatisticsCollector();
            }
        });
        this.suppliers.put("statisticsCollector", this.statisticsCollector);
        this.repo = Suppliers.memoize((Supplier)new Supplier<WorkflowRepository>(){

            public WorkflowRepository get() {
                return PerformanceTestContext.this.createWorkflowRepository();
            }
        });
        this.suppliers.put("repo", this.repo);
        this.engine = Suppliers.memoize((Supplier)new Supplier<PersistentProcessingEngine>(){

            public PersistentProcessingEngine get() {
                return PerformanceTestContext.this.createPersistentProcessingEngine();
            }
        });
        this.suppliers.put("engine", this.engine);
        this.props = Suppliers.memoize((Supplier)new Supplier<Properties>(){

            public Properties get() {
                return PerformanceTestContext.this.createProperties();
            }
        });
        this.suppliers.put("props", this.props);
        this.mockAdapter = Suppliers.memoize((Supplier)new Supplier<MockAdapter>(){

            public MockAdapter get() {
                return PerformanceTestContext.this.createMockAdapter();
            }
        });
        this.suppliers.put("mockAdapter", this.mockAdapter);
        this.backchannel = Suppliers.memoize((Supplier)new Supplier<Backchannel>(){

            public Backchannel get() {
                return PerformanceTestContext.this.createBackchannel();
            }
        });
        this.suppliers.put("backchannel", this.backchannel);
        this.dependencyInjector = Suppliers.memoize((Supplier)new Supplier<DependencyInjector>(){

            public DependencyInjector get() {
                return PerformanceTestContext.this.createDependencyInjector();
            }
        });
        this.suppliers.put("dependencyInjector", this.dependencyInjector);
        this.startup();
    }

    protected ConfigurationManager createConfigurationManager() {
        return new ConfigurationManager((Properties)this.props.get());
    }

    protected ProcessorPoolManager<PersistentProcessorPool> createProcessorPoolManager() {
        return new DefaultProcessorPoolManager();
    }

    protected Serializer createSerializer() {
        StandardJavaSerializer serializer = new StandardJavaSerializer();
        boolean compression = ((ConfigurationManager)this.configManager.get()).getConfigBoolean(ConfigParameter.COMPRESSION);
        logger.debug("compression={}", (Object)compression);
        serializer.setCompress(compression);
        return serializer;
    }

    protected EngineIdProvider createEngineIdProvider() {
        return new EngineIdProviderBean("perftest");
    }

    protected LoggingStatisticCollector createStatisticsCollector() {
        LoggingStatisticCollector statCollector = new LoggingStatisticCollector();
        statCollector.setLoggingIntervalSec(10);
        statCollector.setResetAfterLogging(false);
        return statCollector;
    }

    protected WorkflowRepository createWorkflowRepository() {
        return new ClasspathWorkflowRepository("org.copperengine.performancetest.workflows");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DatabaseDialect createDialect(DataSource ds, WorkflowRepository wfRepository, EngineIdProvider engineIdProvider, RuntimeStatisticsCollector runtimeStatisticsCollector, Serializer serializer) {
        try (Connection c = ds.getConnection();){
            String name = c.getMetaData().getDatabaseProductName();
            logger.info("Test database type is {}", (Object)name);
            if ("oracle".equalsIgnoreCase(name)) {
                if (OracleDialect.schemaMatches((Connection)c)) {
                    OracleDialect dialect = new OracleDialect();
                    dialect.setWfRepository(wfRepository);
                    dialect.setEngineIdProvider(engineIdProvider);
                    dialect.setMultiEngineMode(false);
                    dialect.setRuntimeStatisticsCollector(runtimeStatisticsCollector);
                    dialect.setSerializer(serializer);
                    dialect.startup();
                    OracleDialect oracleDialect = dialect;
                    return oracleDialect;
                }
                OracleSimpleDialect dialect = new OracleSimpleDialect();
                dialect.setWfRepository(wfRepository);
                dialect.setEngineIdProvider(engineIdProvider);
                dialect.setMultiEngineMode(false);
                dialect.setRuntimeStatisticsCollector(runtimeStatisticsCollector);
                dialect.setSerializer(serializer);
                dialect.startup();
                OracleSimpleDialect oracleSimpleDialect = dialect;
                return oracleSimpleDialect;
            }
            if ("Apache Derby".equalsIgnoreCase(name)) {
                DerbyDbDialect dialect = new DerbyDbDialect();
                dialect.setDataSource(ds);
                dialect.setWfRepository(wfRepository);
                dialect.setRuntimeStatisticsCollector(runtimeStatisticsCollector);
                dialect.setSerializer(serializer);
                DerbyDbDialect.checkAndCreateSchema((DataSource)ds);
                DerbyDbDialect derbyDbDialect = dialect;
                return derbyDbDialect;
            }
            if ("H2".equalsIgnoreCase(name)) {
                H2Dialect dialect = new H2Dialect();
                dialect.setDataSource(ds);
                dialect.setWfRepository(wfRepository);
                dialect.setRuntimeStatisticsCollector(runtimeStatisticsCollector);
                dialect.setSerializer(serializer);
                H2Dialect.checkAndCreateSchema((DataSource)ds);
                H2Dialect h2Dialect = dialect;
                return h2Dialect;
            }
            if ("MySQL".equalsIgnoreCase(name)) {
                MySqlDialect dialect = new MySqlDialect();
                dialect.setWfRepository(wfRepository);
                dialect.setRuntimeStatisticsCollector(runtimeStatisticsCollector);
                dialect.setSerializer(serializer);
                MySqlDialect mySqlDialect = dialect;
                return mySqlDialect;
            }
            if (!"PostgreSQL".equalsIgnoreCase(name)) throw new Error("No dialect available for DBMS " + name);
            PostgreSQLDialect dialect = new PostgreSQLDialect();
            dialect.setWfRepository(wfRepository);
            dialect.setRuntimeStatisticsCollector(runtimeStatisticsCollector);
            dialect.setSerializer(serializer);
            PostgreSQLDialect postgreSQLDialect = dialect;
            return postgreSQLDialect;
        }
        catch (Exception e) {
            throw new CopperRuntimeException("Unable to create dialect", (Throwable)e);
        }
    }

    protected PersistentProcessingEngine createPersistentProcessingEngine() {
        HybridDBStorage dbStorageInterface = null;
        if (!this.isCassandraTest()) {
            int batcherNumbOfThreads = ((ConfigurationManager)this.configManager.get()).getConfigInt(ConfigParameter.BATCHER_NUMB_OF_THREADS);
            logger.debug("Starting batcher with {} worker threads", (Object)batcherNumbOfThreads);
            final ComboPooledDataSource dataSource = DataSourceFactory.createDataSource((Properties)this.props.get());
            this.transactionController = new CopperTransactionController((DataSource)dataSource);
            final BatcherImpl batcher = new BatcherImpl(batcherNumbOfThreads);
            batcher.setBatchRunner((BatchRunner)new RetryingTxnBatchRunner((DataSource)dataSource));
            batcher.setStatisticsCollector((RuntimeStatisticsCollector)this.statisticsCollector.get());
            batcher.startup();
            ScottyDBStorage dbStorage = new ScottyDBStorage();
            dbStorage.setBatcher((Batcher)batcher);
            dbStorage.setCheckDbConsistencyAtStartup(false);
            dbStorage.setDialect(this.createDialect((DataSource)dataSource, (WorkflowRepository)this.repo.get(), (EngineIdProvider)this.engineIdProvider.get(), (RuntimeStatisticsCollector)this.statisticsCollector.get(), (Serializer)this.serializer.get()));
            dbStorage.setTransactionController(this.transactionController);
            dbStorageInterface = dbStorage;
            this.shutdownHooks.add(new Runnable(){

                @Override
                public void run() {
                    batcher.shutdown();
                    dataSource.close();
                }
            });
        } else {
            HybridDBStorage dbStorage;
            this.transactionController = new HybridTransactionController();
            String cassandraHosts = ((Properties)this.props.get()).getProperty(ConfigParameter.CASSANDRA_HOSTS.getKey());
            final CassandraSessionManagerImpl sessionManager = new CassandraSessionManagerImpl(Arrays.asList(cassandraHosts.split(",")), ((ConfigurationManager)this.configManager.get()).getConfigInteger(ConfigParameter.CASSANDRA_PORT), ((ConfigurationManager)this.configManager.get()).getConfigString(ConfigParameter.CASSANDRA_KEYSPACE));
            sessionManager.startup();
            final DefaultTimeoutManager timeoutManager = new DefaultTimeoutManager();
            timeoutManager.startup();
            final ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            CassandraStorage storage = new CassandraStorage((CassandraSessionManager)sessionManager, (Executor)pool, (RuntimeStatisticsCollector)this.statisticsCollector.get());
            storage.setCreateSchemaOnStartup(true);
            dbStorageInterface = dbStorage = new HybridDBStorage((Serializer)this.serializer.get(), (WorkflowRepository)this.repo.get(), (Storage)new StorageCache((Storage)storage), (TimeoutManager)timeoutManager, (Executor)pool);
            this.shutdownHooks.add(new Runnable(){

                @Override
                public void run() {
                    try {
                        timeoutManager.shutdown();
                        sessionManager.shutdown();
                        pool.shutdown();
                        pool.awaitTermination(5L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        logger.error("shutdown failed", (Throwable)e);
                    }
                }
            });
        }
        int procPoolNumbOfThreads = ((ConfigurationManager)this.configManager.get()).getConfigInt(ConfigParameter.PROC_POOL_NUMB_OF_THREADS);
        logger.debug("Starting default processor pool with {} worker threads", (Object)procPoolNumbOfThreads);
        ArrayList<PersistentPriorityProcessorPool> pools = new ArrayList<PersistentPriorityProcessorPool>();
        PersistentPriorityProcessorPool pool = new PersistentPriorityProcessorPool("P#DEFAULT", this.transactionController, procPoolNumbOfThreads);
        pool.setDequeueBulkSize(((ConfigurationManager)this.configManager.get()).getConfigInt(ConfigParameter.PROC_DEQUEUE_BULK_SIZE));
        pools.add(pool);
        ((ProcessorPoolManager)this.processorPoolManager.get()).setProcessorPools(pools);
        PersistentScottyEngine engine = new PersistentScottyEngine();
        engine.setWfRepository((WorkflowRepository)this.repo.get());
        engine.setStatisticsCollector((RuntimeStatisticsCollector)this.statisticsCollector.get());
        engine.setEngineIdProvider((EngineIdProvider)this.engineIdProvider.get());
        engine.setIdFactory((IdFactory)new JdkRandomUUIDFactory());
        engine.setProcessorPoolManager((ProcessorPoolManager)this.processorPoolManager.get());
        engine.setDbStorage((ScottyDBStorageInterface)dbStorageInterface);
        engine.setDependencyInjector((DependencyInjector)this.dependencyInjector.get());
        return engine;
    }

    protected DependencyInjector createDependencyInjector() {
        AbstractDependencyInjector dependencyInjector = new AbstractDependencyInjector(){

            public String getType() {
                return null;
            }

            protected Object getBean(String beanId) {
                Supplier<?> supplier = PerformanceTestContext.this.suppliers.get(beanId);
                if (supplier == null) {
                    throw new RuntimeException("No supplier with id '" + beanId + "' found!");
                }
                return supplier.get();
            }
        };
        return dependencyInjector;
    }

    protected Properties createProperties() {
        try {
            Properties defaults = new Properties();
            logger.debug("Loading properties from 'performancetest.default.properties'...");
            defaults.load(DataSourceFactory.class.getResourceAsStream("/performancetest.default.properties"));
            Properties specific = new Properties();
            String username = System.getProperty("user.name", "undefined");
            InputStream is = DataSourceFactory.class.getResourceAsStream("/performancetest." + username + ".properties");
            if (is != null) {
                logger.info("Loading properties from 'performancetest." + username + ".properties'...");
                specific.load(is);
            }
            Properties p = new Properties();
            p.putAll((Map<?, ?>)defaults);
            p.putAll((Map<?, ?>)specific);
            p.putAll((Map<?, ?>)System.getProperties());
            ArrayList<String> keys = new ArrayList<String>();
            for (Object object : p.keySet()) {
                keys.add(object.toString());
            }
            Collections.sort(keys);
            for (String string : keys) {
                logger.debug("Property {}='{}'", (Object)string, (Object)p.getProperty(string));
            }
            return p;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load properties", e);
        }
    }

    protected Backchannel createBackchannel() {
        return new BackchannelDefaultImpl();
    }

    protected MockAdapter createMockAdapter() {
        int numberOfThreads = ((ConfigurationManager)this.configManager.get()).getConfigInt(ConfigParameter.MOCK_ADAPTER_NUMB_OF_THREADS);
        logger.debug("MockAdapter.numberOfThreads={}", (Object)numberOfThreads);
        MockAdapter x = new MockAdapter(numberOfThreads);
        x.setEngine((ProcessingEngine)this.engine.get());
        return x;
    }

    public PersistentProcessingEngine getEngine() {
        return (PersistentProcessingEngine)this.engine.get();
    }

    public void startup() {
        for (Supplier<?> s : this.suppliers.values()) {
            s.get();
        }
        ((MockAdapter)this.mockAdapter.get()).startup();
        ((LoggingStatisticCollector)this.statisticsCollector.get()).start();
        ((PersistentProcessingEngine)this.engine.get()).startup();
    }

    public void shutdown() {
        ((PersistentProcessingEngine)this.engine.get()).shutdown();
        ((LoggingStatisticCollector)this.statisticsCollector.get()).shutdown();
        ((MockAdapter)this.mockAdapter.get()).shutdown();
        for (Runnable r : this.shutdownHooks) {
            r.run();
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public void registerBean(String id, final Object bean) {
        this.suppliers.put(id, new Supplier<Object>(){

            public Object get() {
                return bean;
            }
        });
    }

    public LoggingStatisticCollector getStatisticsCollector() {
        return (LoggingStatisticCollector)this.statisticsCollector.get();
    }

    public Backchannel getBackchannel() {
        return (Backchannel)this.backchannel.get();
    }

    public ProcessorPoolManager<PersistentProcessorPool> getProcessorPoolManager() {
        return (ProcessorPoolManager)this.processorPoolManager.get();
    }

    public TransactionController getTransactionController() {
        return this.transactionController;
    }

    public ConfigurationManager getConfigManager() {
        return (ConfigurationManager)this.configManager.get();
    }

    public boolean isCassandraTest() {
        String cassandraHosts = ((Properties)this.props.get()).getProperty(ConfigParameter.CASSANDRA_HOSTS.getKey());
        return cassandraHosts != null && !cassandraHosts.isEmpty();
    }
}

