/*
 * Decompiled with CFR 0.152.
 */
package de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.resources;

import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.BasicTranscription;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.ExmaraldaBasicFactory;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.exceptions.ExmaraldaException;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.resources.EXBReader;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.resources.EXBWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class EXBResource
extends ResourceImpl {
    public void save(Map<?, ?> options) throws IOException {
        if (this.getContents().size() > 1) {
            throw new ExmaraldaException("Cannot write more than one basic transcription object per file.");
        }
        if (!(this.getContents().get(0) instanceof BasicTranscription)) {
            throw new ExmaraldaException("The object to store is not of type BasicTranscription.");
        }
        BasicTranscription basicTranscription = (BasicTranscription)this.getContents().get(0);
        EXBWriter writer = new EXBWriter();
        writer.write(basicTranscription, this.getURI());
    }

    public void load(Map<?, ?> options) throws IOException {
        XMLReader xmlReader;
        SAXParser parser;
        if (this.getURI() == null) {
            throw new ExmaraldaException("Cannot load any resource, because no uri is given.");
        }
        File exmaraldaFile = new File(this.getURI().toFileString());
        if (!exmaraldaFile.exists()) {
            throw new ExmaraldaException("Cannot load resource, because the file does not exist: " + exmaraldaFile);
        }
        if (!exmaraldaFile.canRead()) {
            throw new ExmaraldaException("Cannot load resource, because the file can not be read: " + exmaraldaFile);
        }
        BasicTranscription basicTranscription = null;
        basicTranscription = ExmaraldaBasicFactory.eINSTANCE.createBasicTranscription();
        this.getContents().add((Object)basicTranscription);
        EXBReader exbReader = new EXBReader();
        exbReader.setExmaraldaFile(exmaraldaFile);
        exbReader.setBasicTranscription(basicTranscription);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            parser = factory.newSAXParser();
            xmlReader = parser.getXMLReader();
            xmlReader.setContentHandler(exbReader);
        }
        catch (ParserConfigurationException e) {
            throw new ExmaraldaException("Cannot load exmaralda from resource '" + exmaraldaFile.getAbsolutePath() + "'.", e);
        }
        catch (Exception e) {
            throw new ExmaraldaException("Cannot load exmaralda from resource '" + exmaraldaFile.getAbsolutePath() + "'.", e);
        }
        try {
            FileInputStream inputStream = new FileInputStream(exmaraldaFile);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            InputSource is = new InputSource(reader);
            is.setEncoding("UTF-8");
            xmlReader.parse(is);
        }
        catch (SAXException e) {
            try {
                parser = factory.newSAXParser();
                xmlReader = parser.getXMLReader();
                xmlReader.setContentHandler(exbReader);
                xmlReader.parse(exmaraldaFile.getAbsolutePath());
            }
            catch (Exception e1) {
                throw new ExmaraldaException("Cannot load exmaralda from resource '" + exmaraldaFile.getAbsolutePath() + "'.", e1);
            }
        }
    }
}

