/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.metrics.datadog.transport;

import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientErrorHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.coursera.metrics.datadog.model.DatadogCounter;
import org.coursera.metrics.datadog.model.DatadogGauge;
import org.coursera.metrics.datadog.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpTransport
implements Transport {
    private static final Logger LOG = LoggerFactory.getLogger(UdpTransport.class);
    private final StatsDClient statsd;
    private final Map lastSeenCounters = new HashMap();

    private UdpTransport(String prefix, String statsdHost, int port, boolean isRetryingLookup, String[] globalTags) {
        Callable<InetSocketAddress> socketAddressCallable = isRetryingLookup ? UdpTransport.volatileAddressResolver(statsdHost, port) : UdpTransport.staticAddressResolver(statsdHost, port);
        this.statsd = new NonBlockingStatsDClient(prefix, Integer.MAX_VALUE, globalTags, new StatsDClientErrorHandler(){

            public void handle(Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }, socketAddressCallable);
    }

    @Override
    public void close() throws IOException {
        this.statsd.stop();
    }

    @Override
    public Transport.Request prepare() throws IOException {
        return new DogstatsdRequest(this.statsd, this.lastSeenCounters);
    }

    static Callable<InetSocketAddress> staticAddressResolver(String host, int port) {
        try {
            return NonBlockingStatsDClient.staticAddressResolution((String)host, (int)port);
        }
        catch (Exception e) {
            LOG.error("Error during constructing statsd address resolver.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static Callable<InetSocketAddress> volatileAddressResolver(String host, int port) {
        return NonBlockingStatsDClient.volatileAddressResolution((String)host, (int)port);
    }

    public static class DogstatsdRequest
    implements Transport.Request {
        private final StatsDClient statsdClient;
        private final Map<String, Long> lastSeenCounters;

        public DogstatsdRequest(StatsDClient statsdClient, Map<String, Long> lastSeenCounters) {
            this.statsdClient = statsdClient;
            this.lastSeenCounters = lastSeenCounters;
        }

        @Override
        public void addGauge(DatadogGauge gauge) {
            if (gauge.getPoints().size() > 1) {
                LOG.debug("Gauge " + gauge.getMetric() + " has more than one data point, will pick the first point only");
            }
            double value = gauge.getPoints().get(0).get(1).doubleValue();
            String[] tags = gauge.getTags().toArray(new String[gauge.getTags().size()]);
            this.statsdClient.gauge(gauge.getMetric(), value, tags);
        }

        @Override
        public void addCounter(DatadogCounter counter) {
            if (counter.getPoints().size() > 1) {
                LOG.debug("Counter " + counter.getMetric() + " has more than one data point, will pick the first point only");
            }
            long value = counter.getPoints().get(0).get(1).longValue();
            String[] tags = counter.getTags().toArray(new String[counter.getTags().size()]);
            StringBuilder sb = new StringBuilder("");
            for (int i = tags.length - 1; i >= 0; --i) {
                sb.append(tags[i]);
                if (i <= 0) continue;
                sb.append(",");
            }
            String metric = counter.getMetric();
            String finalMetricsSeenName = metric + ":" + sb.toString();
            long finalValue = value;
            if (this.lastSeenCounters.containsKey(finalMetricsSeenName)) {
                finalValue = Math.max(0L, value - this.lastSeenCounters.get(finalMetricsSeenName));
            }
            this.lastSeenCounters.put(finalMetricsSeenName, value);
            this.statsdClient.count(metric, finalValue, tags);
        }

        @Override
        public void send() {
        }
    }

    public static class Builder {
        String prefix = null;
        String statsdHost = "localhost";
        int port = 8125;
        boolean isLookupRetrying = false;

        public Builder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder withStatsdHost(String statsdHost) {
            this.statsdHost = statsdHost;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withRetryingLookup(boolean isRetrying) {
            this.isLookupRetrying = isRetrying;
            return this;
        }

        public UdpTransport build() {
            return new UdpTransport(this.prefix, this.statsdHost, this.port, this.isLookupRetrying, new String[0]);
        }
    }
}

