/*
 * Decompiled with CFR 0.152.
 */
package org.coursera.metrics.datadog;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedName {
    private static final Pattern tagPattern = Pattern.compile("([\\w\\.]+)\\[([\\w\\W]+)\\]");
    private final String metricName;
    private final List<String> encodedTags;

    private TaggedName(String metricName, List<String> encodedTags) {
        this.metricName = metricName;
        this.encodedTags = encodedTags;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public List<String> getEncodedTags() {
        return this.encodedTags;
    }

    public String encode() {
        if (!this.encodedTags.isEmpty()) {
            StringBuilder sb = new StringBuilder(this.metricName);
            sb.append('[');
            String prefix = "";
            for (String encodedTag : this.encodedTags) {
                sb.append(prefix);
                sb.append(encodedTag);
                prefix = ",";
            }
            sb.append(']');
            return sb.toString();
        }
        return this.metricName;
    }

    public static TaggedName decode(String encodedTaggedName) {
        TaggedNameBuilder builder = new TaggedNameBuilder();
        Matcher matcher = tagPattern.matcher(encodedTaggedName);
        if (matcher.find() && matcher.groupCount() == 2) {
            builder.metricName(matcher.group(1));
            for (String t : matcher.group(2).split("\\,")) {
                builder.addTag(t);
            }
        } else {
            builder.metricName(encodedTaggedName);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaggedName that = (TaggedName)o;
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        return !(this.encodedTags != null ? !this.encodedTags.equals(that.encodedTags) : that.encodedTags != null);
    }

    public int hashCode() {
        int result = this.metricName != null ? this.metricName.hashCode() : 0;
        result = 31 * result + (this.encodedTags != null ? this.encodedTags.hashCode() : 0);
        return result;
    }

    public static class TaggedNameBuilder {
        private String metricName;
        private final List<String> encodedTags = new ArrayList<String>();

        public TaggedNameBuilder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public TaggedNameBuilder addTag(String key, String val) {
            this.assertNonEmpty(key, "tagKey");
            this.encodedTags.add(key + ':' + val);
            return this;
        }

        public TaggedNameBuilder addTag(String encodedTag) {
            this.assertNonEmpty(encodedTag, "encodedTag");
            this.encodedTags.add(encodedTag);
            return this;
        }

        private void assertNonEmpty(String s, String field) {
            if (s == null || "".equals(s.trim())) {
                throw new IllegalArgumentException(field + " must be defined");
            }
        }

        public TaggedName build() {
            this.assertNonEmpty(this.metricName, "metricName");
            return new TaggedName(this.metricName, this.encodedTags);
        }
    }
}

