/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.common.config.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import mu.KotlinLogging;
import org.cqfn.diktat.common.utils.LoggingUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u0000 \u0011*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0015\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\tH$\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/cqfn/diktat/common/config/reader/JsonResourceConfigReader;", "T", "", "()V", "classLoader", "Ljava/lang/ClassLoader;", "getClassLoader", "()Ljava/lang/ClassLoader;", "getConfigFile", "Ljava/io/BufferedReader;", "resourceFileName", "", "parseResource", "fileStream", "(Ljava/io/BufferedReader;)Ljava/lang/Object;", "readResource", "(Ljava/lang/String;)Ljava/lang/Object;", "Companion", "diktat-common"})
public abstract class JsonResourceConfigReader<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log = (Logger)LoggingUtilsKt.loggerWithKtlintConfig(KotlinLogging.INSTANCE, Reflection.getOrCreateKotlinClass(JsonResourceConfigReader.class));

    @NotNull
    public abstract ClassLoader getClassLoader();

    @Nullable
    public final T readResource(@NotNull String resourceFileName) {
        block4: {
            Unit unit;
            BufferedReader resourceStream;
            Intrinsics.checkNotNullParameter((Object)resourceFileName, (String)"resourceFileName");
            BufferedReader bufferedReader = resourceStream = this.getConfigFile(resourceFileName);
            if (bufferedReader != null) {
                BufferedReader it = bufferedReader;
                boolean bl = false;
                try {
                    return this.parseResource(it);
                }
                catch (IOException e) {
                    log.error("Cannot read config file " + resourceFileName + " due to: ", (Throwable)e);
                    unit = Unit.INSTANCE;
                }
            } else {
                unit = null;
            }
            if (unit != null) break block4;
            log.error("Not able to open file " + resourceFileName + " from the resources");
        }
        return null;
    }

    @Nullable
    protected BufferedReader getConfigFile(@NotNull String resourceFileName) {
        BufferedReader bufferedReader;
        Intrinsics.checkNotNullParameter((Object)resourceFileName, (String)"resourceFileName");
        InputStream inputStream = this.getClassLoader().getResourceAsStream(resourceFileName);
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        } else {
            bufferedReader = null;
        }
        return bufferedReader;
    }

    protected abstract T parseResource(@NotNull BufferedReader var1);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/cqfn/diktat/common/config/reader/JsonResourceConfigReader$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "diktat-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

