/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.common.config.rules;

import com.charleskorn.kaml.Yaml;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.internal.ArrayListSerializer;
import mu.KLogger;
import mu.KotlinLogging;
import org.cqfn.diktat.common.config.reader.JsonResourceConfigReader;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfig$;
import org.cqfn.diktat.common.config.rules.RulesConfigReader;
import org.cqfn.diktat.common.utils.LoggingUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00152\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u0010H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/cqfn/diktat/common/config/rules/RulesConfigReader;", "Lorg/cqfn/diktat/common/config/reader/JsonResourceConfigReader;", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "classLoader", "Ljava/lang/ClassLoader;", "(Ljava/lang/ClassLoader;)V", "getClassLoader", "()Ljava/lang/ClassLoader;", "yamlSerializer", "Lcom/charleskorn/kaml/Yaml;", "getYamlSerializer", "()Lcom/charleskorn/kaml/Yaml;", "yamlSerializer$delegate", "Lkotlin/Lazy;", "getConfigFile", "Ljava/io/BufferedReader;", "resourceFileName", "", "parseResource", "fileStream", "Companion", "diktat-common"})
@SourceDebugExtension(value={"SMAP\nRulesConfigReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RulesConfigReader.kt\norg/cqfn/diktat/common/config/rules/RulesConfigReader\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n123#2:248\n1655#3,8:249\n*S KotlinDebug\n*F\n+ 1 RulesConfigReader.kt\norg/cqfn/diktat/common/config/rules/RulesConfigReader\n*L\n87#1:248\n87#1:249,8\n*E\n"})
public class RulesConfigReader
extends JsonResourceConfigReader<List<? extends RulesConfig>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassLoader classLoader;
    @NotNull
    private final Lazy yamlSerializer$delegate;
    @NotNull
    private static final KLogger log = LoggingUtilsKt.loggerWithKtlintConfig(KotlinLogging.INSTANCE, Reflection.getOrCreateKotlinClass(RulesConfigReader.class));

    public RulesConfigReader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.classLoader = classLoader;
        this.yamlSerializer$delegate = LazyKt.lazy((Function0)yamlSerializer.2.INSTANCE);
    }

    @Override
    @NotNull
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private final Yaml getYamlSerializer() {
        Lazy lazy = this.yamlSerializer$delegate;
        return (Yaml)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<RulesConfig> parseResource(@NotNull BufferedReader fileStream) {
        List list;
        Intrinsics.checkNotNullParameter((Object)fileStream, (String)"fileStream");
        Closeable closeable = fileStream;
        Throwable throwable = null;
        try {
            void $this$decodeFromString$iv;
            BufferedReader stream = (BufferedReader)closeable;
            boolean bl = false;
            StringFormat stringFormat = (StringFormat)this.getYamlSerializer();
            String string$iv = CollectionsKt.joinToString$default((Iterable)TextStreamsKt.readLines((Reader)stream), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            boolean $i$f$decodeFromString = false;
            $this$decodeFromString$iv.getSerializersModule();
            Iterable $this$distinctBy$iv = CollectionsKt.reversed((Iterable)((Iterable)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer((KSerializer)RulesConfig$.serializer.INSTANCE), string$iv)));
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                RulesConfig it = (RulesConfig)e$iv;
                boolean bl2 = false;
                String key$iv = it.getName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            list = list$iv;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    @Override
    @Nullable
    protected BufferedReader getConfigFile(@NotNull String resourceFileName) {
        BufferedReader bufferedReader;
        Intrinsics.checkNotNullParameter((Object)resourceFileName, (String)"resourceFileName");
        File resourceFile = new File(resourceFileName);
        if (resourceFile.exists()) {
            log.debug("Using diktat-analysis.yml file from the following path: " + resourceFile.getAbsolutePath());
            File file = new File(resourceFileName);
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            Object object = file;
            object = new InputStreamReader((InputStream)new FileInputStream((File)object), charset);
            bufferedReader = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        } else {
            log.debug("Using the default diktat-analysis.yml file from the class path");
            InputStream inputStream = this.getClassLoader().getResourceAsStream(resourceFileName);
            if (inputStream != null) {
                InputStream inputStream2 = inputStream;
                Charset charset = Charsets.UTF_8;
                Reader reader = new InputStreamReader(inputStream2, charset);
                int n = 8192;
                bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
            } else {
                bufferedReader = null;
            }
        }
        return bufferedReader;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/cqfn/diktat/common/config/rules/RulesConfigReader$Companion;", "", "()V", "log", "Lmu/KLogger;", "getLog$diktat_common", "()Lmu/KLogger;", "diktat-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLog$diktat_common() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

