/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.plugin.gradle;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.cqfn.diktat.plugin.gradle.DiktatExtension;
import org.cqfn.diktat.plugin.gradle.DiktatJavaExecTaskBase;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B7\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u001f\u001a\u00020 H\u0017J\b\u0010!\u001a\u00020 H\u0002J\b\u0010\"\u001a\u00020\u0016H\u0016J\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u0016H\u0016J\u0018\u0010+\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010,\u001a\u00020-H\u0002J\u001a\u0010.\u001a\u00020 *\b\u0012\u0004\u0012\u00020\u00040/2\u0006\u0010'\u001a\u00020(H\u0002R\u001b\u0010\u000e\u001a\u00020\u000f8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u00020\u00168AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u00060"}, d2={"Lorg/cqfn/diktat/plugin/gradle/DiktatJavaExecTaskBase;", "Lorg/gradle/api/tasks/JavaExec;", "Lorg/gradle/api/tasks/VerificationTask;", "gradleVersionString", "", "diktatExtension", "Lorg/cqfn/diktat/plugin/gradle/DiktatExtension;", "diktatConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "inputs", "Lorg/gradle/api/tasks/util/PatternFilterable;", "additionalFlags", "", "(Ljava/lang/String;Lorg/cqfn/diktat/plugin/gradle/DiktatExtension;Lorg/gradle/api/artifacts/Configuration;Lorg/gradle/api/tasks/util/PatternFilterable;Ljava/lang/Iterable;)V", "actualInputs", "Lorg/gradle/api/file/FileCollection;", "getActualInputs", "()Lorg/gradle/api/file/FileCollection;", "actualInputs$delegate", "Lkotlin/Lazy;", "ignoreFailuresProp", "Lorg/gradle/api/provider/Property;", "", "getIgnoreFailuresProp$diktat_gradle_plugin", "()Lorg/gradle/api/provider/Property;", "shouldRun", "getShouldRun$diktat_gradle_plugin", "()Z", "setShouldRun$diktat_gradle_plugin", "(Z)V", "createReporterFlag", "exec", "", "fixForNewJpms", "getIgnoreFailures", "getJavaExecJvmVersion", "Lorg/gradle/api/JavaVersion;", "isMainClassPropertySupported", "resolveConfigFile", "file", "Ljava/io/File;", "setIgnoreFailures", "ignoreFailures", "setReporter", "flag", "Ljava/lang/StringBuilder;", "addInput", "", "diktat-gradle-plugin"})
public class DiktatJavaExecTaskBase
extends JavaExec
implements VerificationTask {
    @NotNull
    private final Property<Boolean> ignoreFailuresProp;
    private boolean shouldRun;
    @NotNull
    private final Lazy actualInputs$delegate;
    private final String gradleVersionString;
    private final PatternFilterable inputs;

    @Internal
    @NotNull
    public final Property<Boolean> getIgnoreFailuresProp$diktat_gradle_plugin() {
        return this.ignoreFailuresProp;
    }

    @Internal
    public final boolean getShouldRun$diktat_gradle_plugin() {
        return this.shouldRun;
    }

    public final void setShouldRun$diktat_gradle_plugin(boolean bl) {
        this.shouldRun = bl;
    }

    @IgnoreEmptyDirectories
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    @NotNull
    public final FileCollection getActualInputs() {
        Lazy lazy = this.actualInputs$delegate;
        DiktatJavaExecTaskBase diktatJavaExecTaskBase = this;
        Object var3_3 = null;
        boolean bl = false;
        return (FileCollection)lazy.getValue();
    }

    @TaskAction
    public void exec() {
        this.fixForNewJpms();
        if (this.shouldRun) {
            super.exec();
        } else {
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            project.getLogger().info("Skipping diktat execution");
        }
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailuresProp.set((Object)ignoreFailures);
    }

    public boolean getIgnoreFailures() {
        Object object = this.ignoreFailuresProp.getOrElse((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ignoreFailuresProp.getOrElse(false)");
        return (Boolean)object;
    }

    private final String createReporterFlag(DiktatExtension diktatExtension) {
        String string;
        StringBuilder flag = new StringBuilder();
        this.setReporter(diktatExtension, flag);
        if (diktatExtension.getGithubActions()) {
            StringBuilder stringBuilder = new StringBuilder();
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            Path reportDir = Files.createDirectories(Paths.get(stringBuilder.append(project.getBuildDir()).append("/reports/diktat").toString(), new String[0]), new FileAttribute[0]);
            this.getOutputs().dir((Object)reportDir);
            string = ",output=" + reportDir.resolve("diktat.sarif");
        } else {
            CharSequence charSequence = diktatExtension.getOutput();
            boolean bl = false;
            string = charSequence.length() > 0 ? ",output=" + diktatExtension.getOutput() : "";
        }
        String outFlag = string;
        flag.append(outFlag);
        String string2 = flag.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"flag.toString()");
        return string2;
    }

    private final void setReporter(DiktatExtension diktatExtension, StringBuilder flag) {
        String reporterFlag;
        String string;
        String string2 = diktatExtension.getReporter();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String name = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        List validReporters = CollectionsKt.listOf((Object[])new String[]{"sarif", "plain", "json", "html"});
        CharSequence charSequence = name;
        boolean bl2 = false;
        if (charSequence.length() == 0 || !validReporters.contains(name)) {
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            project.getLogger().warn("Reporter name " + name + " was not specified or is invalid. Falling to 'plain' reporter");
            string = "--reporter=plain";
        } else {
            string = reporterFlag = "--reporter=" + name;
        }
        if (diktatExtension.getGithubActions()) {
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            this.systemProperty("user.home", project.getProjectDir().toString());
            reporterFlag = "--reporter=sarif";
        }
        flag.append(reporterFlag);
    }

    private final boolean isMainClassPropertySupported(String gradleVersionString) {
        return GradleVersion.version((String)gradleVersionString).compareTo(GradleVersion.version((String)"6.4")) >= 0;
    }

    private final void addInput(List<String> $this$addInput, File file) {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        File file2 = project.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"project.projectDir");
        $this$addInput.add(FilesKt.toRelativeString((File)file, (File)file2));
    }

    private final String resolveConfigFile(File file) {
        File file2;
        Object v4;
        Sequence $this$run;
        block3: {
            Path path = file.toPath();
            Project project = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            if (path.startsWith(project.getRootDir().toPath())) {
                String string = file.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
                return string;
            }
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            Sequence sequence = SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)project2.getProjectDir(), (Function1)resolveConfigFile.1.INSTANCE), (Function1)((Function1)new Function1<File, File>(file){
                final /* synthetic */ File $file;

                @NotNull
                public final File invoke(@NotNull File it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return FilesKt.resolve((File)it, (File)this.$file);
                }
                {
                    this.$file = file;
                    super(1);
                }
            }));
            boolean bl = false;
            boolean bl2 = false;
            $this$run = sequence;
            boolean bl3 = false;
            Sequence $this$firstOrNull$iv = $this$run;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File it = (File)element$iv;
                boolean bl4 = false;
                if (!it.exists()) continue;
                v4 = element$iv;
                break block3;
            }
            v4 = null;
        }
        if ((file2 = (File)v4) == null) {
            file2 = (File)SequencesKt.first((Sequence)$this$run);
        }
        String string = file2.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"generateSequence(project\u2026            .absolutePath");
        return string;
    }

    private final void fixForNewJpms() {
        JavaVersion javaVersion = this.getJavaExecJvmVersion();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        project.getLogger().debug("For diktat execution jvm version " + javaVersion + " will be used");
        String string = javaVersion.getMajorVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaVersion.majorVersion");
        String string2 = string;
        boolean bl = false;
        if (Integer.parseInt(string2) >= 16) {
            Project project2 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            project2.getLogger().debug("Adding `--add-opens` flag for JVM version >=16 compatibility");
            this.jvmArgs(new Object[]{"--add-opens", "java.base/java.lang=ALL-UNNAMED"});
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final JavaVersion getJavaExecJvmVersion() {
        JavaVersion javaVersion;
        if (GradleVersion.version((String)this.gradleVersionString).compareTo(GradleVersion.version((String)"6.7")) >= 0) {
            Property property = this.getJavaLauncher();
            Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"javaLauncher");
            if (property.isPresent()) {
                Provider provider = this.getJavaLauncher().map((Transformer)getJavaExecJvmVersion.1.INSTANCE);
                Object object = getJavaExecJvmVersion.2.INSTANCE;
                if (object != null) {
                    Function1 function1 = object;
                    object = new Transformer(function1){
                        private final /* synthetic */ Function1 function;
                        {
                            this.function = function1;
                        }

                        public final /* synthetic */ Object transform(Object p0) {
                            return this.function.invoke(p0);
                        }
                    };
                }
                Object object2 = provider.map((Transformer)object).get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"javaLauncher.map { it.me\u2026Version::toVersion).get()");
                javaVersion = (JavaVersion)object2;
                return javaVersion;
            }
        }
        JavaVersion javaVersion = this.getJavaVersion();
        javaVersion = javaVersion;
        Intrinsics.checkExpressionValueIsNotNull((Object)javaVersion2, (String)"javaVersion");
        return javaVersion;
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public DiktatJavaExecTaskBase(@NotNull String gradleVersionString, @NotNull DiktatExtension diktatExtension, @NotNull Configuration diktatConfiguration2, @NotNull PatternFilterable inputs, @NotNull Iterable<String> additionalFlags) {
        void $this$forEach$iv;
        String it;
        boolean bl;
        boolean bl2;
        Object object;
        void $this$apply;
        Object it2;
        Intrinsics.checkParameterIsNotNull((Object)gradleVersionString, (String)"gradleVersionString");
        Intrinsics.checkParameterIsNotNull((Object)diktatExtension, (String)"diktatExtension");
        Intrinsics.checkParameterIsNotNull((Object)diktatConfiguration2, (String)"diktatConfiguration");
        Intrinsics.checkParameterIsNotNull((Object)inputs, (String)"inputs");
        Intrinsics.checkParameterIsNotNull(additionalFlags, (String)"additionalFlags");
        this.gradleVersionString = gradleVersionString;
        this.inputs = inputs;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Property property = project.getObjects().property(Boolean.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"project.objects.property\u2026an::class.javaObjectType)");
        this.ignoreFailuresProp = property;
        this.shouldRun = true;
        this.actualInputs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConfigurableFileCollection>(this, diktatExtension){
            final /* synthetic */ DiktatJavaExecTaskBase this$0;
            final /* synthetic */ DiktatExtension $diktatExtension;

            /*
             * WARNING - void declaration
             */
            public final ConfigurableFileCollection invoke() {
                void $this$apply;
                DiktatExtension diktatExtension = this.$diktatExtension;
                boolean bl = false;
                boolean bl2 = false;
                DiktatExtension $this$with = diktatExtension;
                boolean bl3 = false;
                boolean bl4 = $this$with.getInputs() == null && $this$with.getExcludes() == null;
                boolean bl5 = false;
                boolean bl6 = false;
                if (!bl4) {
                    boolean bl7 = false;
                    String string = "`inputs` and `excludes` arguments for diktat task are deprecated and now should be changed for `inputs {}` with configuration for PatternFilterable. Please check https://github.com/analysis-dev/diktat/README.md for more info.";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                if (DiktatJavaExecTaskBase.access$getInputs$p(this.this$0).getIncludes().isEmpty() && DiktatJavaExecTaskBase.access$getInputs$p(this.this$0).getExcludes().isEmpty()) {
                    DiktatJavaExecTaskBase.access$getInputs$p(this.this$0).include(new String[]{"src/**/*.kt"});
                }
                Project project = this.this$0.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                ConfigurableFileCollection configurableFileCollection = project.getObjects().fileCollection();
                Object[] objectArray = new Object[1];
                Project project2 = this.this$0.getProject();
                Project project3 = this.this$0.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
                diktatExtension = project2.fileTree((Object)String.valueOf(project3.getProjectDir()));
                bl = false;
                bl2 = false;
                $this$with = diktatExtension;
                int n = 0;
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = objectArray;
                ConfigurableFileCollection configurableFileCollection2 = configurableFileCollection;
                boolean bl8 = false;
                String[] stringArray = new String[1];
                Project project4 = this.this$0.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
                stringArray[0] = String.valueOf(project4.getBuildDir());
                $this$apply.exclude(stringArray);
                Unit unit = Unit.INSTANCE;
                objectArray2[n] = diktatExtension.matching(DiktatJavaExecTaskBase.access$getInputs$p(this.this$0));
                return configurableFileCollection2.from(objectArray3);
            }
            {
                this.this$0 = diktatJavaExecTaskBase;
                this.$diktatExtension = diktatExtension;
                super(0);
            }
        }));
        this.setGroup("verification");
        if (this.isMainClassPropertySupported(this.gradleVersionString)) {
            this.getMainClass().set((Object)"com.pinterest.ktlint.Main");
        } else {
            this.setMain("com.pinterest.ktlint.Main");
        }
        this.setClasspath((FileCollection)diktatConfiguration2);
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Logger logger = project2.getLogger();
        StringBuilder stringBuilder = new StringBuilder().append("Setting diktatCheck classpath to ");
        DependencySet dependencySet = diktatConfiguration2.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencySet, (String)"diktatConfiguration.dependencies");
        logger.debug(stringBuilder.append(CollectionsKt.toSet((Iterable)((Iterable)dependencySet))).toString());
        if (diktatExtension.getDebug()) {
            Project project3 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            project3.getLogger().lifecycle("Running diktat 1.1.0 with ktlint 0.44.0");
        }
        this.setIgnoreFailures(diktatExtension.getIgnoreFailures());
        this.setIgnoreExitValue(this.getIgnoreFailures());
        Object object2 = this.resolveConfigFile(diktatExtension.getDiktatConfigFile());
        boolean bl3 = false;
        boolean bl4 = false;
        String string = object2;
        String string2 = "diktat.config.path";
        DiktatJavaExecTaskBase diktatJavaExecTaskBase = this;
        boolean bl5 = false;
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        project4.getLogger().info("Setting system property for diktat config to " + (String)it2);
        Unit unit = Unit.INSTANCE;
        diktatJavaExecTaskBase.systemProperty(string2, object2);
        object2 = CollectionsKt.toMutableList(additionalFlags);
        bl3 = false;
        bl4 = false;
        it2 = object2;
        diktatJavaExecTaskBase = this;
        boolean bl6 = false;
        if (diktatExtension.getDebug()) {
            $this$apply.add("--debug");
        }
        String string3 = diktatExtension.getBaseline();
        if (string3 != null) {
            object = string3;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl7 = false;
            $this$apply.add("--baseline=" + diktatExtension.getBaseline());
        }
        object = this.getActualInputs();
        bl2 = false;
        bl = false;
        it = object;
        boolean bl8 = false;
        if (it.isEmpty()) {
            Project project5 = this.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
            project5.getLogger().warn("Inputs for " + this.getName() + " do not exist, will not run diktat");
            this.shouldRun = false;
        }
        object = object.getFiles();
        bl2 = false;
        bl = false;
        Object files = object;
        boolean bl9 = false;
        Project project6 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
        Logger logger2 = project6.getLogger();
        StringBuilder stringBuilder2 = new StringBuilder().append("Analyzing ").append(files.size()).append(" files with diktat in project ");
        Project project7 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
        logger2.info(stringBuilder2.append(project7.getName()).toString());
        Project project8 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project8, (String)"project");
        project8.getLogger().debug("Analyzing " + files);
        Object object3 = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"actualInputs.also {\n    \u2026files\")\n                }");
        object = (Iterable)object3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it3 = (File)element$iv;
            boolean bl10 = false;
            File file = it3;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
            this.addInput((List<String>)$this$apply, file);
        }
        $this$apply.add(this.createReporterFlag(diktatExtension));
        string2 = Unit.INSTANCE;
        diktatJavaExecTaskBase.setArgs((List)object2);
        Project project9 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project9, (String)"project");
        project9.getLogger().debug("Setting JavaExec args to " + this.getArgs());
    }

    public /* synthetic */ DiktatJavaExecTaskBase(String string, DiktatExtension diktatExtension, Configuration configuration, PatternFilterable patternFilterable, Iterable iterable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        this(string, diktatExtension, configuration, patternFilterable, iterable);
    }

    public static final /* synthetic */ PatternFilterable access$getInputs$p(DiktatJavaExecTaskBase $this) {
        return $this.inputs;
    }
}

