/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.plugin.gradle;

import groovy.lang.Closure;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.plugin.gradle.DiktatExtension;
import org.cqfn.diktat.plugin.gradle.KotlinClosure1;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a1\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\"\u0004\b\u0000\u0010\u0007*\u00020\u00062\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000b\u001a\u0012\u0010\f\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a8\u0006\u0012"}, d2={"isSarifReporterActive", "", "reporterFlag", "", "closureOf", "Lgroovy/lang/Closure;", "", "T", "action", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "createReporterFlag", "Lorg/gradle/api/Project;", "diktatExtension", "Lorg/cqfn/diktat/plugin/gradle/DiktatExtension;", "getOutputFile", "Ljava/io/File;", "diktat-gradle-plugin"})
public final class UtilsKt {
    @NotNull
    public static final <T> Closure<Object> closureOf(@NotNull Object $this$closureOf, @NotNull Function1<? super T, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)$this$closureOf, (String)"$this$closureOf");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        return new KotlinClosure1<T, Unit>(action, $this$closureOf, $this$closureOf);
    }

    @NotNull
    public static final String createReporterFlag(@NotNull Project $this$createReporterFlag, @NotNull DiktatExtension diktatExtension) {
        String string;
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)$this$createReporterFlag, (String)"$this$createReporterFlag");
        Intrinsics.checkParameterIsNotNull((Object)diktatExtension, (String)"diktatExtension");
        String string2 = diktatExtension.getReporter();
        String name = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        List validReporters = CollectionsKt.listOf((Object[])new String[]{"sarif", "plain", "json", "html"});
        if (diktatExtension.getGithubActions()) {
            charSequence = diktatExtension.getReporter();
            if (charSequence.length() > 0) {
                $this$createReporterFlag.getLogger().warn("`diktat.githubActions` is set to true, so custom reporter [" + name + "] will be ignored and SARIF reporter will be used");
            }
            string = "--reporter=sarif";
        } else {
            charSequence = name;
            if (charSequence.length() == 0) {
                $this$createReporterFlag.getLogger().info("Reporter name was not set. Using 'plain' reporter");
                string = "--reporter=plain";
            } else if (!validReporters.contains(name)) {
                $this$createReporterFlag.getLogger().warn("Reporter name is invalid (provided value: [" + name + "]). Falling back to 'plain' reporter");
                string = "--reporter=plain";
            } else {
                string = "--reporter=" + name;
            }
        }
        String reporterFlag = string;
        return reporterFlag;
    }

    @Nullable
    public static final File getOutputFile(@NotNull Project $this$getOutputFile, @NotNull DiktatExtension diktatExtension) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)$this$getOutputFile, (String)"$this$getOutputFile");
        Intrinsics.checkParameterIsNotNull((Object)diktatExtension, (String)"diktatExtension");
        if (diktatExtension.getGithubActions()) {
            StringBuilder stringBuilder = new StringBuilder();
            Project project = $this$getOutputFile.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            Path reportDir = Files.createDirectories(Paths.get(stringBuilder.append(project.getBuildDir()).append("/reports/diktat").toString(), new String[0]), new FileAttribute[0]);
            file = reportDir.resolve("diktat.sarif").toFile();
        } else {
            CharSequence charSequence = diktatExtension.getOutput();
            file = charSequence.length() > 0 ? $this$getOutputFile.file((Object)diktatExtension.getOutput()) : null;
        }
        return file;
    }

    public static final boolean isSarifReporterActive(@NotNull String reporterFlag) {
        Intrinsics.checkParameterIsNotNull((Object)reporterFlag, (String)"reporterFlag");
        return StringsKt.contains$default((CharSequence)reporterFlag, (CharSequence)"sarif", (boolean)false, (int)2, null);
    }
}

