/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.core.RuleSetProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReader;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRuleSetProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.org.jline.utils.Levenshtein;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/DiktatRuleSetProvider;", "Lcom/pinterest/ktlint/core/RuleSetProvider;", "diktatConfigFile", "", "(Ljava/lang/String;)V", "get", "Lcom/pinterest/ktlint/core/RuleSet;", "validate", "", "config", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "Companion", "diktat-rules"})
public final class DiktatRuleSetProvider
implements RuleSetProvider {
    private final String diktatConfigFile;
    private static final Logger log;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public RuleSet get() {
        void $this$mapTo$iv$iv;
        Iterable iterable;
        List list;
        block8: {
            block7: {
                void $this$onEach$iv;
                log.debug("Will run diktat-ruleset with " + this.diktatConfigFile + " (it can be placed to the run directory or the default file from resources will be used)");
                if (!new File(this.diktatConfigFile).exists()) {
                    log.warn("Configuration file " + this.diktatConfigFile + " not found in file system, the file included in jar will be used. " + "Some configuration options will be disabled or substituted with defaults. " + "Custom configuration file should be placed in diktat working directory if run from CLI " + "or provided as configuration options in plugins.");
                }
                ClassLoader classLoader = this.getClass().getClassLoader();
                Intrinsics.checkExpressionValueIsNotNull((Object)classLoader, (String)"javaClass.classLoader");
                list = (List)new RulesConfigReader(classLoader).readResource(this.diktatConfigFile);
                if (list == null) break block7;
                Iterable iterable2 = list;
                DiktatRuleSetProvider diktatRuleSetProvider = this;
                boolean $i$f$onEach = false;
                iterable = $this$onEach$iv;
                boolean bl = false;
                boolean bl2 = false;
                void $this$apply$iv = iterable;
                boolean bl3 = false;
                for (Object element$iv : $this$apply$iv) {
                    RulesConfig p1 = (RulesConfig)element$iv;
                    boolean bl4 = false;
                    diktatRuleSetProvider.validate(p1);
                }
                list = (List)iterable;
                if (list != null) break block8;
            }
            list = CollectionsKt.emptyList();
        }
        List configRules = list;
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])new KFunction[]{get.rules.1.INSTANCE, get.rules.2.INSTANCE, get.rules.3.INSTANCE, get.rules.4.INSTANCE, get.rules.5.INSTANCE, get.rules.6.INSTANCE, get.rules.7.INSTANCE, get.rules.8.INSTANCE, get.rules.9.INSTANCE, get.rules.10.INSTANCE, get.rules.11.INSTANCE, get.rules.12.INSTANCE, get.rules.13.INSTANCE, get.rules.14.INSTANCE, get.rules.15.INSTANCE, get.rules.16.INSTANCE, get.rules.17.INSTANCE, get.rules.18.INSTANCE, get.rules.19.INSTANCE, get.rules.20.INSTANCE, get.rules.21.INSTANCE, get.rules.22.INSTANCE, get.rules.23.INSTANCE, get.rules.24.INSTANCE, get.rules.25.INSTANCE, get.rules.26.INSTANCE, get.rules.27.INSTANCE, get.rules.28.INSTANCE, get.rules.29.INSTANCE, get.rules.30.INSTANCE, get.rules.31.INSTANCE, get.rules.32.INSTANCE, get.rules.33.INSTANCE, get.rules.34.INSTANCE, get.rules.35.INSTANCE, get.rules.36.INSTANCE, get.rules.37.INSTANCE, get.rules.38.INSTANCE, get.rules.39.INSTANCE, get.rules.40.INSTANCE, get.rules.41.INSTANCE, get.rules.42.INSTANCE, get.rules.43.INSTANCE, get.rules.44.INSTANCE, get.rules.45.INSTANCE, get.rules.46.INSTANCE, get.rules.47.INSTANCE, get.rules.48.INSTANCE, get.rules.49.INSTANCE, get.rules.50.INSTANCE, get.rules.51.INSTANCE, get.rules.52.INSTANCE, get.rules.53.INSTANCE, get.rules.54.INSTANCE});
        boolean $i$f$map = false;
        iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KFunction kFunction = (KFunction)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Rule rule = (Rule)((Function1)it).invoke((Object)configRules);
            collection.add(rule);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Rule[] ruleArray = thisCollection$iv.toArray(new Rule[0]);
        if (ruleArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Rule[] rules2 = ruleArray;
        return new RuleSet("diktat-ruleset", Arrays.copyOf(rules2, rules2.length));
    }

    private final void validate(RulesConfig config) {
        boolean bl = Intrinsics.areEqual((Object)config.getName(), (Object)"DIKTAT_COMMON") || Warnings.Companion.getNames().contains(config.getName());
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            Object v0;
            boolean bl4 = false;
            Iterable $this$minBy$iv = Warnings.Companion.getNames();
            boolean $i$f$minBy = false;
            Iterable $this$minByOrNull$iv$iv = $this$minBy$iv;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv$iv = $this$minByOrNull$iv$iv.iterator();
            if (!iterator$iv$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv$iv = iterator$iv$iv.next();
                if (!iterator$iv$iv.hasNext()) {
                    v0 = minElem$iv$iv;
                } else {
                    String it = (String)minElem$iv$iv;
                    boolean bl5 = false;
                    int minValue$iv$iv = Levenshtein.distance((CharSequence)it, (CharSequence)config.getName());
                    do {
                        Object e$iv$iv = iterator$iv$iv.next();
                        String it2 = (String)e$iv$iv;
                        $i$a$-minBy-DiktatRuleSetProvider$validate$1$closestMatch$1 = false;
                        int v$iv$iv = Levenshtein.distance((CharSequence)it2, (CharSequence)config.getName());
                        if (minValue$iv$iv <= v$iv$iv) continue;
                        minElem$iv$iv = e$iv$iv;
                        minValue$iv$iv = v$iv$iv;
                    } while (iterator$iv$iv.hasNext());
                    v0 = minElem$iv$iv;
                }
            }
            String closestMatch = v0;
            String string = "Warning name <" + config.getName() + "> in configuration file is invalid, did you mean <" + closestMatch + ">?";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public DiktatRuleSetProvider(@NotNull String diktatConfigFile) {
        Intrinsics.checkParameterIsNotNull((Object)diktatConfigFile, (String)"diktatConfigFile");
        this.diktatConfigFile = diktatConfigFile;
    }

    public /* synthetic */ DiktatRuleSetProvider(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "diktat-analysis.yml";
        }
        this(string);
    }

    public DiktatRuleSetProvider() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(DiktatRuleSetProvider.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/cqfn/diktat/ruleset/rules/DiktatRuleSetProvider$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

