/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001bB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002Je\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000e2K\u0010\u001a\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RS\u0010\u0006\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/cqfn/diktat/ruleset/rules/EmptyBlock;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "isFixMode", "checkEmptyBlock", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "configuration", "Lorg/cqfn/diktat/ruleset/rules/EmptyBlock$EmptyBlockStyleConfiguration;", "searchNode", "visit", "autoCorrect", "emit", "EmptyBlockStyleConfiguration", "diktat-rules"})
public final class EmptyBlock
extends Rule {
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private boolean isFixMode;
    private final List<RulesConfig> configRules;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        Object object = RulesConfigReaderKt.getRuleConfig(this.configRules, (org.cqfn.diktat.common.config.rules.Rule)Warnings.EMPTY_BLOCK_STRUCTURE_ERROR);
        if (object == null || (object = object.getConfiguration()) == null) {
            boolean bl = false;
            object = MapsKt.emptyMap();
        }
        EmptyBlockStyleConfiguration configuration2 = new EmptyBlockStyleConfiguration((Map<String, String>)object);
        this.searchNode(node, configuration2);
    }

    private final void searchNode(ASTNode node, EmptyBlockStyleConfiguration configuration2) {
        ASTNode aSTNode = AstNodeUtilsKt.findLBrace(node);
        if (aSTNode == null || (aSTNode = aSTNode.getTreeParent()) == null) {
            return;
        }
        ASTNode newNode = aSTNode;
        this.checkEmptyBlock(newNode, configuration2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void checkEmptyBlock(ASTNode node, EmptyBlockStyleConfiguration configuration2) {
        ASTNode aSTNode = node.getTreeParent().findChildByType(ElementType.INSTANCE.getMODIFIER_LIST());
        if ((aSTNode != null ? aSTNode.findChildByType(ElementType.INSTANCE.getOVERRIDE_KEYWORD()) : null) != null) {
            return;
        }
        if (!AstNodeUtilsKt.isBlockEmpty(node)) return;
        if (!configuration2.getEmptyBlockExist()) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.EMPTY_BLOCK_STRUCTURE_ERROR.warn(this.configRules, function3, this.isFixMode, "empty blocks are forbidden unless it is function with override keyword", node.getStartOffset(), node);
            return;
        }
        ASTNode aSTNode2 = node.findChildByType(ElementType.INSTANCE.getRBRACE());
        if (aSTNode2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"node.findChildByType(RBRACE)!!");
        ASTNode space = aSTNode2.getTreePrev();
        if (configuration2.getEmptyBlockNewline()) {
            ASTNode aSTNode3 = space;
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode3, (String)"space");
            String string = aSTNode3.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"space.text");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                Warnings.warnAndFix$default(Warnings.EMPTY_BLOCK_STRUCTURE_ERROR, this.configRules, function3, this.isFixMode, "different style for empty block", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(space, node){
                    final /* synthetic */ ASTNode $space;
                    final /* synthetic */ ASTNode $node;

                    public final void invoke() {
                        ASTNode aSTNode = this.$space;
                        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"space");
                        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                            ASTNode aSTNode2 = this.$space;
                            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"space");
                            ASTNode aSTNode3 = aSTNode2.getTreeNext();
                            if (aSTNode3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)((LeafPsiElement)aSTNode3).replaceWithText("\n"), (String)"(space.treeNext as LeafP\u2026nt).replaceWithText(\"\\n\")");
                        } else {
                            ASTNode aSTNode4 = (ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n");
                            ASTNode aSTNode5 = this.$space;
                            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode5, (String)"space");
                            this.$node.addChild(aSTNode4, aSTNode5.getTreeNext());
                        }
                    }
                    {
                        this.$space = aSTNode;
                        this.$node = aSTNode2;
                        super(0);
                    }
                }, 64, null);
                return;
            }
        }
        if (configuration2.getEmptyBlockNewline()) return;
        ASTNode aSTNode4 = space;
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode4, (String)"space");
        String string = aSTNode4.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"space.text");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) return;
        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
        if (function3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
        }
        Warnings.warnAndFix$default(Warnings.EMPTY_BLOCK_STRUCTURE_ERROR, this.configRules, function3, this.isFixMode, "different style for empty block", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node, space){
            final /* synthetic */ ASTNode $node;
            final /* synthetic */ ASTNode $space;

            public final void invoke() {
                this.$node.removeChild(this.$space);
            }
            {
                this.$node = aSTNode;
                this.$space = aSTNode2;
                super(0);
            }
        }, 64, null);
    }

    public EmptyBlock(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkParameterIsNotNull(configRules, (String)"configRules");
        super("empty-block-structure");
        this.configRules = configRules;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/EmptyBlock$EmptyBlockStyleConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "emptyBlockExist", "", "getEmptyBlockExist", "()Z", "emptyBlockNewline", "getEmptyBlockNewline", "diktat-rules"})
    public static final class EmptyBlockStyleConfiguration
    extends RuleConfiguration {
        private final boolean emptyBlockExist;
        private final boolean emptyBlockNewline;

        public final boolean getEmptyBlockExist() {
            return this.emptyBlockExist;
        }

        public final boolean getEmptyBlockNewline() {
            return this.emptyBlockNewline;
        }

        public EmptyBlockStyleConfiguration(@NotNull Map<String, String> config) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            String string;
            boolean bl4;
            String string2;
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            super(config);
            String string3 = config.get("allowEmptyBlocks");
            if (string3 != null) {
                string2 = string3;
                bl4 = false;
                string = string2;
                bl3 = false;
                bl2 = Boolean.parseBoolean(string);
            } else {
                bl2 = false;
            }
            this.emptyBlockExist = bl2;
            String string4 = config.get("styleEmptyBlockWithNewline");
            if (string4 != null) {
                string2 = string4;
                bl4 = false;
                string = string2;
                bl3 = false;
                bl = Boolean.parseBoolean(string);
            } else {
                bl = true;
            }
            this.emptyBlockNewline = bl;
        }
    }
}

