/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.IdentifierNaming;
import org.cqfn.diktat.ruleset.rules.IdentifierNaming$WhenMappings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.StringCaseUtilsKt;
import org.cqfn.diktat.ruleset.utils.StringUtilsKt;
import org.cqfn.diktat.ruleset.utils.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u001e\u0010\u0018\u001a\u00020\u00102\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u001a\u001a\u00020\u000eH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0013H\u0002Je\u0010\"\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u000e2K\u0010$\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007H\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0013H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RS\u0010\u0006\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/cqfn/diktat/ruleset/rules/IdentifierNaming;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "isFixMode", "checkCLassNamings", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "node", "checkEnumValues", "checkExceptionSuffix", "checkFunctionName", "checkIdentifierLength", "nodes", "isVariable", "checkObjectNaming", "checkVariableName", "extractVariableIdentifiers", "isIdentifierWithBackticks", "validCatchIdentifier", "validGenericTypeName", "generic", "visit", "autoCorrect", "emit", "warnConfusingName", "variableName", "Companion", "IdentifierNamingConfiguration", "diktat-rules"})
public final class IdentifierNaming
extends com.pinterest.ktlint.core.Rule {
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private boolean isFixMode;
    private final List<RulesConfig> configRules;
    @NotNull
    private static final Set<String> ONE_CHAR_IDENTIFIERS;
    @NotNull
    private static final Set<String> BOOLEAN_METHOD_PREFIXES;
    @NotNull
    private static final Set<String> CONFUSING_IDENTIFIER_NAMES;
    public static final int MAX_IDENTIFIER_LENGTH = 64;
    public static final int MIN_IDENTIFIER_LENGTH = 2;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        void identifierNodes;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        this.isFixMode = autoCorrect;
        this.emitWarn = emit;
        if (this.isIdentifierWithBackticks(node)) {
            return;
        }
        IElementType iElementType = node.getElementType();
        Pair pair = Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCLASS()) ? new Pair(this.checkCLassNamings(node), (Object)false) : (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getOBJECT_DECLARATION()) ? new Pair(this.checkObjectNaming(node), (Object)false) : (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getPROPERTY()) || Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_PARAMETER()) ? new Pair(this.checkVariableName(node), (Object)true) : (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getENUM_ENTRY()) ? new Pair(this.checkEnumValues(node), (Object)false) : (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getFUN()) ? new Pair(this.checkFunctionName(node), (Object)false) : new Pair(null, (Object)false)))));
        List list = (List)pair.component1();
        boolean isVariable = (Boolean)pair.component2();
        if (identifierNodes != null) {
            this.checkIdentifierLength((List<? extends ASTNode>)identifierNodes, isVariable);
        }
    }

    private final boolean isIdentifierWithBackticks(ASTNode node) {
        ASTNode identifier = AstNodeUtilsKt.getIdentifierName(node);
        if (identifier != null && Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getREFERENCE_EXPRESSION()) ^ true) {
            String string = identifier.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"identifier.text");
            String identifierText = string;
            if (StringsKt.startsWith$default((CharSequence)identifierText, (char)'`', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)identifierText, (char)'`', (boolean)false, (int)2, null)) {
                if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFUN()) || !AstNodeUtilsKt.hasTestAnnotation(node)) {
                    Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                    if (function3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                    }
                    Warnings.BACKTICKS_PROHIBITED.warn(this.configRules, function3, this.isFixMode, identifierText, identifier.getStartOffset(), identifier);
                }
                return true;
            }
        }
        return false;
    }

    private final List<ASTNode> checkVariableName(ASTNode node) {
        ASTNode variableName;
        List<ASTNode> namesOfVariables = this.extractVariableIdentifiers(node);
        Iterable $this$forEach$iv = namesOfVariables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            variableName = (ASTNode)element$iv;
            boolean bl = false;
            String string = variableName.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variableName.text");
            if (StringUtilsKt.containsOneLetterOrZero(string) && variableName.getText().length() > 1) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                String string2 = variableName.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"variableName.text");
                Warnings.VARIABLE_NAME_INCORRECT.warn(this.configRules, function3, this.isFixMode, string2, variableName.getStartOffset(), node);
            }
            if (CONFUSING_IDENTIFIER_NAMES.contains(variableName.getText()) && !this.validCatchIdentifier(variableName) && Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY())) {
                this.warnConfusingName(variableName);
            }
            if (AstNodeUtilsKt.isConstant(node)) {
                String string3 = variableName.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"variableName.text");
                if (StringCaseUtilsKt.isUpperSnakeCase(string3) || variableName.getText().length() <= 1) continue;
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                String string4 = variableName.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"variableName.text");
                Warnings.warnAndFix$default(Warnings.CONSTANT_UPPERCASE, this.configRules, function3, this.isFixMode, string4, variableName.getStartOffset(), node, false, (Function0)new Function0<Unit>(variableName){
                    final /* synthetic */ ASTNode $variableName;

                    public final void invoke() {
                        ASTNode aSTNode = this.$variableName;
                        if (aSTNode == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                        }
                        LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                        String string = ((LeafPsiElement)this.$variableName).getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variableName.text");
                        leafPsiElement.replaceWithText(StringCaseUtilsKt.toUpperSnakeCase(string));
                    }
                    {
                        this.$variableName = aSTNode;
                        super(0);
                    }
                }, 64, null);
                continue;
            }
            if (!(Intrinsics.areEqual((Object)variableName.getText(), (Object)"_") ^ true)) continue;
            String string5 = variableName.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"variableName.text");
            if (StringCaseUtilsKt.isLowerCamelCase(string5)) continue;
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string6 = variableName.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"variableName.text");
            Warnings.warnAndFix$default(Warnings.VARIABLE_NAME_INCORRECT_FORMAT, this.configRules, function3, this.isFixMode, string6, variableName.getStartOffset(), node, false, (Function0)new Function0<Unit>(variableName){
                final /* synthetic */ ASTNode $variableName;

                public final void invoke() {
                    ASTNode aSTNode = this.$variableName;
                    if (aSTNode == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                    String string = ((LeafPsiElement)this.$variableName).getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variableName.text");
                    leafPsiElement.replaceWithText(StringCaseUtilsKt.toLowerCamelCase(string));
                }
                {
                    this.$variableName = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
        namesOfVariables = this.extractVariableIdentifiers(node);
        $this$forEach$iv = namesOfVariables;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            variableName = (ASTNode)element$iv;
            boolean bl = false;
            String string = variableName.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variableName.text");
            if (!StringUtilsKt.hasPrefix(string)) continue;
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string7 = variableName.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"variableName.text");
            Warnings.warnAndFix$default(Warnings.VARIABLE_HAS_PREFIX, this.configRules, function3, this.isFixMode, string7, variableName.getStartOffset(), node, false, (Function0)new Function0<Unit>(variableName){
                final /* synthetic */ ASTNode $variableName;

                public final void invoke() {
                    ASTNode aSTNode = this.$variableName;
                    if (aSTNode == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                    String string = ((LeafPsiElement)this.$variableName).getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variableName.text");
                    leafPsiElement.replaceWithText(StringUtilsKt.removePrefix(string));
                }
                {
                    this.$variableName = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
        return namesOfVariables;
    }

    /*
     * Unable to fully structure code
     */
    private final void warnConfusingName(ASTNode variableName) {
        block21: {
            block20: {
                block18: {
                    block15: {
                        block17: {
                            block16: {
                                block19: {
                                    var3_2 = variableName.getText();
                                    switch (var3_2.hashCode()) {
                                        case 66: {
                                            if (!var3_2.equals("B")) ** break;
                                            break block15;
                                        }
                                        case 83: {
                                            if (!var3_2.equals("S")) ** break;
                                            break block16;
                                        }
                                        case 68: {
                                            if (!var3_2.equals("D")) ** break;
                                            ** GOTO lbl38
                                        }
                                        case 101: {
                                            if (!var3_2.equals("e")) ** break;
                                            break block17;
                                        }
                                        case 104: {
                                            if (!var3_2.equals("h")) ** break;
                                            break block18;
                                        }
                                        case 73: {
                                            if (!var3_2.equals("I")) ** break;
                                            break;
                                        }
                                        case 90: {
                                            if (!var3_2.equals("Z")) ** break;
                                            break block19;
                                        }
                                        case 108: {
                                            if (!var3_2.equals("l")) ** break;
                                            break;
                                        }
                                        case 3644: {
                                            if (!var3_2.equals("rn")) ** break;
                                            break block20;
                                        }
                                        case 109: {
                                            if (!var3_2.equals("m")) ** break;
                                            break block20;
                                        }
                                        case 110: {
                                            if (!var3_2.equals("n")) ** break;
                                            break block18;
                                        }
                                        case 79: {
                                            if (!var3_2.equals("O")) ** break;
lbl38:
                                            // 2 sources

                                            v0 = "better name is: obj, dgt";
                                            break block21;
                                        }
                                    }
                                    v0 = "better name is: it, ln, line";
                                    break block21;
                                }
                                v0 = "better name is: n1, n2";
                                break block21;
                            }
                            v0 = "better name is: xs, str";
                            break block21;
                        }
                        v0 = "better name is: ex, elm";
                        break block21;
                    }
                    v0 = "better name is: bt, nxt";
                    break block21;
                }
                v0 = "better name is: nr, head, height";
                break block21;
            }
            v0 = "better name is: mbr, item";
            break block21;
            v0 = "";
        }
        warnText = v0;
        v1 = this.emitWarn;
        if (v1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
        }
        Warnings.CONFUSING_IDENTIFIER_NAMING.warn(this.configRules, v1, false, warnText, variableName.getStartOffset(), variableName);
    }

    /*
     * Unable to fully structure code
     */
    private final List<ASTNode> extractVariableIdentifiers(ASTNode node) {
        block7: {
            block6: {
                destructingDeclaration = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getDESTRUCTURING_DECLARATION());
                if (destructingDeclaration == null) break block6;
                $this$map$iv = AstNodeUtilsKt.getAllChildrenWithType(destructingDeclaration, ElementType.INSTANCE.getDESTRUCTURING_DECLARATION_ENTRY());
                $i$f$map = false;
                var6_5 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var11_10 = (ASTNode)item$iv$iv;
                    var13_12 = destination$iv$iv;
                    $i$a$-map-IdentifierNaming$extractVariableIdentifiers$result$1 = false;
                    if (AstNodeUtilsKt.getIdentifierName(it) == null) {
                        Intrinsics.throwNpe();
                    }
                    var13_12.add(var14_13);
                }
                v0 = (List)destination$iv$iv;
                break block7;
            }
            if (SequencesKt.count((Sequence)PsiUtilsKt.parents((ASTNode)node)) <= 1) ** GOTO lbl-1000
            v1 = node.getTreeParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"node.treeParent");
            if (!Intrinsics.areEqual((Object)v1.getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST())) ** GOTO lbl-1000
            v2 = node.getTreeParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"node.treeParent");
            v3 = v2.getTreeParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"node.treeParent.treeParent");
            if (Intrinsics.areEqual((Object)v3.getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_TYPE())) {
                v0 = CollectionsKt.listOfNotNull((Object)AstNodeUtilsKt.getIdentifierName(node));
            } else lbl-1000:
            // 3 sources

            {
                v4 = AstNodeUtilsKt.getIdentifierName(node);
                if (v4 == null) {
                    Intrinsics.throwNpe();
                }
                v0 = CollectionsKt.listOf((Object)v4);
            }
        }
        result = v0;
        $this$filterNot$iv = result;
        $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            $i$a$-filterNot-IdentifierNaming$extractVariableIdentifiers$1 = false;
            if (IdentifierNaming.ONE_CHAR_IDENTIFIERS.contains(it.getText())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<ASTNode> checkCLassNamings(ASTNode node) {
        ASTNode genericType = AstNodeUtilsKt.getTypeParameterList(node);
        if (genericType != null && !this.validGenericTypeName(genericType)) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string = genericType.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"genericType.text");
            Warnings.warnAndFix$default(Warnings.GENERIC_NAME, this.configRules, function3, this.isFixMode, string, genericType.getStartOffset(), genericType, false, checkCLassNamings.1.INSTANCE, 64, null);
        }
        ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(node);
        if (aSTNode == null) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        ASTNode className = aSTNode;
        String string = className.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.text");
        if (!StringCaseUtilsKt.isPascalCase(string)) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string2 = className.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"className.text");
            Warnings.warnAndFix$default(Warnings.CLASS_NAME_INCORRECT, this.configRules, function3, this.isFixMode, string2, className.getStartOffset(), className, false, (Function0)new Function0<Unit>(className){
                final /* synthetic */ ASTNode $className;

                public final void invoke() {
                    ASTNode aSTNode = this.$className;
                    if (aSTNode == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                    String string = ((LeafPsiElement)this.$className).getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className.text");
                    leafPsiElement.replaceWithText(StringCaseUtilsKt.toPascalCase(string));
                }
                {
                    this.$className = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
        this.checkExceptionSuffix(node);
        return CollectionsKt.listOf((Object)className);
    }

    private final void checkExceptionSuffix(ASTNode node) {
        String superClassName;
        checkExceptionSuffix.1 $fun$hasExceptionSuffix$1 = checkExceptionSuffix.1.INSTANCE;
        ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(node);
        if (aSTNode == null) {
            return;
        }
        ASTNode classNameNode = aSTNode;
        ASTNode aSTNode2 = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getSUPER_TYPE_LIST());
        String string = aSTNode2 != null && (aSTNode2 = AstNodeUtilsKt.findLeafWithSpecificType(aSTNode2, ElementType.INSTANCE.getTYPE_REFERENCE())) != null ? aSTNode2.getText() : (superClassName = null);
        if (superClassName != null && $fun$hasExceptionSuffix$1.invoke(superClassName)) {
            String string2 = classNameNode.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"classNameNode.text");
            if (!$fun$hasExceptionSuffix$1.invoke(string2)) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                String string3 = classNameNode.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"classNameNode.text");
                Warnings.warnAndFix$default(Warnings.EXCEPTION_SUFFIX, this.configRules, function3, this.isFixMode, string3, classNameNode.getStartOffset(), classNameNode, false, (Function0)new Function0<Unit>(classNameNode){
                    final /* synthetic */ ASTNode $classNameNode;

                    public final void invoke() {
                        ASTNode aSTNode = this.$classNameNode;
                        if (aSTNode == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                        }
                        ((LeafPsiElement)aSTNode).replaceWithText(((LeafPsiElement)this.$classNameNode).getText() + "Exception");
                    }
                    {
                        this.$classNameNode = aSTNode;
                        super(0);
                    }
                }, 64, null);
            }
        }
    }

    private final List<ASTNode> checkObjectNaming(ASTNode node) {
        ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(node);
        if (aSTNode == null) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        ASTNode objectName = aSTNode;
        String string = objectName.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"objectName.text");
        if (!StringCaseUtilsKt.isPascalCase(string)) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string2 = objectName.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"objectName.text");
            Warnings.warnAndFix$default(Warnings.OBJECT_NAME_INCORRECT, this.configRules, function3, this.isFixMode, string2, objectName.getStartOffset(), objectName, false, (Function0)new Function0<Unit>(objectName){
                final /* synthetic */ ASTNode $objectName;

                public final void invoke() {
                    ASTNode aSTNode = this.$objectName;
                    if (aSTNode == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                    String string = ((LeafPsiElement)this.$objectName).getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"objectName.text");
                    leafPsiElement.replaceWithText(StringCaseUtilsKt.toPascalCase(string));
                }
                {
                    this.$objectName = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
        return CollectionsKt.listOf((Object)objectName);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ASTNode> checkEnumValues(ASTNode node) {
        void $this$filterTo$iv$iv;
        ASTNode[] aSTNodeArray = node.getChildren(null);
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNodeArray, (String)"node.getChildren(null)");
        ASTNode[] $this$filter$iv = aSTNodeArray;
        boolean $i$f$filter = false;
        ASTNode[] aSTNodeArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var8_8 = $this$filterTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var8_8[i];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            if (!Intrinsics.areEqual((Object)v1.getElementType(), (Object)ElementType.INSTANCE.getIDENTIFIER())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enumValues = (List)destination$iv$iv;
        Iterable $this$forEach$iv = enumValues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FunctionReference functionReference;
            FunctionReference functionReference2;
            ASTNode value = (ASTNode)element$iv;
            boolean bl = false;
            Object object = RulesConfigReaderKt.getRuleConfig(this.configRules, (Rule)Warnings.ENUM_VALUE);
            if (object == null || (object = object.getConfiguration()) == null) {
                n = 0;
                object = MapsKt.emptyMap();
            }
            IdentifierNamingConfiguration configuration2 = new IdentifierNamingConfiguration((Map<String, String>)object);
            switch (IdentifierNaming$WhenMappings.$EnumSwitchMapping$0[configuration2.getEnumStyle().ordinal()]) {
                case 1: {
                    functionReference2 = checkEnumValues.1.validator.1.INSTANCE;
                    break;
                }
                case 2: {
                    functionReference2 = checkEnumValues.1.validator.2.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            FunctionReference validator2 = functionReference2;
            switch (IdentifierNaming$WhenMappings.$EnumSwitchMapping$1[configuration2.getEnumStyle().ordinal()]) {
                case 1: {
                    functionReference = checkEnumValues.1.autofix.1.INSTANCE;
                    break;
                }
                case 2: {
                    functionReference = checkEnumValues.1.autofix.2.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            FunctionReference autofix2 = functionReference;
            Function1 function1 = validator2;
            String string = value.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.text");
            if (!((Boolean)function1.invoke((Object)string)).booleanValue()) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                String string2 = value.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"value.text");
                Warnings.warnAndFix$default(Warnings.ENUM_VALUE, this.configRules, function3, this.isFixMode, string2, value.getStartOffset(), value, false, (Function0)new Function0<Unit>(value, (KFunction)autofix2){
                    final /* synthetic */ ASTNode $value;
                    final /* synthetic */ KFunction $autofix;

                    public final void invoke() {
                        ASTNode aSTNode = this.$value;
                        if (aSTNode == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                        }
                        LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                        Function1 function1 = (Function1)this.$autofix;
                        String string = ((LeafPsiElement)this.$value).getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"value.text");
                        leafPsiElement.replaceWithText((String)function1.invoke((Object)string));
                    }
                    {
                        this.$value = aSTNode;
                        this.$autofix = kFunction;
                        super(0);
                    }
                }, 64, null);
            }
            if (!CONFUSING_IDENTIFIER_NAMES.contains(value.getText())) continue;
            this.warnConfusingName(value);
        }
        return enumValues;
    }

    private final List<ASTNode> checkFunctionName(ASTNode node) {
        String functionReturnType;
        ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(node);
        if (aSTNode == null) {
            Intrinsics.throwNpe();
        }
        ASTNode functionName = aSTNode;
        String string = functionName.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"functionName.text");
        if (!StringCaseUtilsKt.isLowerCamelCase(string)) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string2 = functionName.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"functionName.text");
            Warnings.warnAndFix$default(Warnings.FUNCTION_NAME_INCORRECT_CASE, this.configRules, function3, this.isFixMode, string2, functionName.getStartOffset(), functionName, false, (Function0)new Function0<Unit>(functionName){
                final /* synthetic */ ASTNode $functionName;

                public final void invoke() {
                    ASTNode aSTNode = this.$functionName;
                    if (aSTNode == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                    String string = ((LeafPsiElement)this.$functionName).getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"functionName.text");
                    leafPsiElement.replaceWithText(StringCaseUtilsKt.toLowerCamelCase(string));
                }
                {
                    this.$functionName = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
        ASTNode aSTNode2 = AstNodeUtilsKt.findChildAfter(node, ElementType.INSTANCE.getVALUE_PARAMETER_LIST(), ElementType.INSTANCE.getTYPE_REFERENCE());
        String string3 = functionReturnType = aSTNode2 != null ? aSTNode2.getText() : null;
        if (functionReturnType != null && Intrinsics.areEqual((Object)functionReturnType, (Object)PrimitiveType.BOOLEAN.getTypeName().asString())) {
            boolean bl;
            block9: {
                Iterable $this$none$iv = BOOLEAN_METHOD_PREFIXES;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        String string4 = functionName.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"functionName.text");
                        if (!StringsKt.startsWith$default((String)string4, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                String string5 = functionName.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"functionName.text");
                Warnings.warnAndFix$default(Warnings.FUNCTION_BOOLEAN_PREFIX, this.configRules, function3, this.isFixMode, string5, functionName.getStartOffset(), functionName, false, checkFunctionName.3.INSTANCE, 64, null);
            }
        }
        return CollectionsKt.listOf((Object)functionName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validGenericTypeName(ASTNode generic) {
        ASTNode[] aSTNodeArray = generic.getChildren(TokenSet.create((IElementType[])new IElementType[]{ElementType.INSTANCE.getTYPE_PARAMETER()}));
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNodeArray, (String)"generic.getChildren(Toke\u2026t.create(TYPE_PARAMETER))");
        ASTNode[] $this$all$iv = aSTNodeArray;
        boolean $i$f$all = false;
        ASTNode[] aSTNodeArray2 = $this$all$iv;
        int n = aSTNodeArray2.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode element$iv;
            ASTNode it = element$iv = aSTNodeArray2[n2];
            boolean bl = false;
            ASTNode aSTNode = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it");
            ASTNode aSTNode2 = AstNodeUtilsKt.getIdentifierName(aSTNode);
            Object object = aSTNode2;
            if (aSTNode2 == null) return false;
            String string = object.getText();
            object = string;
            if (string == null) return false;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.getIdentifierName()?.text ?: return false");
            Object typeText = object;
            char c = ((String)typeText).charAt(0);
            if ('A' > c) return false;
            if ('Z' < c) return false;
            if (((String)typeText).length() != 1) {
                Object object2 = typeText;
                int n3 = 1;
                boolean bl2 = false;
                Object object3 = object2;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object3).substring(n3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                if (!StringUtilsKt.isDigits(string2)) return false;
            }
            boolean bl3 = true;
            if (!bl3) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private final void checkIdentifierLength(List<? extends ASTNode> nodes, boolean isVariable) {
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n;
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getText(), (Object)"_") ^ true) || AstNodeUtilsKt.checkLength(it, new IntRange(n = 2, 64)) || ONE_CHAR_IDENTIFIERS.contains(it.getText()) && isVariable || this.validCatchIdentifier(it)) continue;
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string = it.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.text");
            Warnings.IDENTIFIER_LENGTH.warn(this.configRules, function3, this.isFixMode, string, it.getStartOffset(), it);
        }
    }

    private final boolean validCatchIdentifier(ASTNode node) {
        ASTNode parentValueParamList = AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getVALUE_PARAMETER_LIST());
        ASTNode aSTNode = parentValueParamList;
        boolean prevCatchKeyWord = Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = PackageKt.prevCodeSibling((ASTNode)aSTNode)) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getCATCH_KEYWORD());
        return Intrinsics.areEqual((Object)node.getText(), (Object)"e") && AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getCATCH()) != null && prevCatchKeyWord;
    }

    public IdentifierNaming(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkParameterIsNotNull(configRules, (String)"configRules");
        super("identifier-naming");
        this.configRules = configRules;
    }

    static {
        Companion = new Companion(null);
        ONE_CHAR_IDENTIFIERS = SetsKt.setOf((Object[])new String[]{"i", "j", "k", "x", "y", "z"});
        BOOLEAN_METHOD_PREFIXES = SetsKt.setOf((Object[])new String[]{"has", "is"});
        CONFUSING_IDENTIFIER_NAMES = SetsKt.setOf((Object[])new String[]{"O", "D", "I", "l", "Z", "S", "e", "B", "h", "n", "m", "rn"});
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u000b*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\r"}, d2={"Lorg/cqfn/diktat/ruleset/rules/IdentifierNaming$IdentifierNamingConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "enumStyle", "Lorg/cqfn/diktat/ruleset/utils/Style;", "getEnumStyle", "()Lorg/cqfn/diktat/ruleset/utils/Style;", "isEnumStyle", "", "(Lorg/cqfn/diktat/ruleset/utils/Style;)Z", "diktat-rules"})
    public static final class IdentifierNamingConfiguration
    extends RuleConfiguration {
        @NotNull
        private final Style enumStyle;

        private final boolean isEnumStyle(Style $this$isEnumStyle) {
            return CollectionsKt.listOf((Object[])new Style[]{Style.PASCAL_CASE, Style.SNAKE_CASE}).contains((Object)$this$isEnumStyle);
        }

        @NotNull
        public final Style getEnumStyle() {
            return this.enumStyle;
        }

        /*
         * WARNING - void declaration
         */
        public IdentifierNamingConfiguration(@NotNull Map<String, String> config) {
            Style style;
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            super(config);
            IdentifierNamingConfiguration identifierNamingConfiguration = this;
            String string = config.get("enumStyle");
            if (string != null) {
                Style style2;
                void styleString;
                IdentifierNamingConfiguration identifierNamingConfiguration2;
                block4: {
                    Style style3;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String string3 = string2;
                    identifierNamingConfiguration2 = identifierNamingConfiguration;
                    boolean bl3 = false;
                    Style[] $this$firstOrNull$iv = Style.values();
                    boolean $i$f$firstOrNull = false;
                    Style[] styleArray = $this$firstOrNull$iv;
                    int n = styleArray.length;
                    for (int i = 0; i < n; ++i) {
                        Style element$iv;
                        Style it = element$iv = styleArray[i];
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)StringCaseUtilsKt.toUpperSnakeCase((String)styleString))) continue;
                        style3 = element$iv;
                        break block4;
                    }
                    style3 = style2 = null;
                }
                if (style2 == null || !this.isEnumStyle(style2)) {
                    String string4 = (String)styleString + " is unsupported for enum style";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string4.toString());
                }
                Style style4 = style2;
                identifierNamingConfiguration = identifierNamingConfiguration2;
                style = style4;
            } else {
                style = Style.SNAKE_CASE;
            }
            identifierNamingConfiguration.enumStyle = style;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/IdentifierNaming$Companion;", "", "()V", "BOOLEAN_METHOD_PREFIXES", "", "", "getBOOLEAN_METHOD_PREFIXES", "()Ljava/util/Set;", "CONFUSING_IDENTIFIER_NAMES", "getCONFUSING_IDENTIFIER_NAMES", "MAX_IDENTIFIER_LENGTH", "", "MIN_IDENTIFIER_LENGTH", "ONE_CHAR_IDENTIFIERS", "getONE_CHAR_IDENTIFIERS", "diktat-rules"})
    public static final class Companion {
        @NotNull
        public final Set<String> getONE_CHAR_IDENTIFIERS() {
            return ONE_CHAR_IDENTIFIERS;
        }

        @NotNull
        public final Set<String> getBOOLEAN_METHOD_PREFIXES() {
            return BOOLEAN_METHOD_PREFIXES;
        }

        @NotNull
        public final Set<String> getCONFUSING_IDENTIFIER_NAMES() {
            return CONFUSING_IDENTIFIER_NAMES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

