/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.LongNumericalValuesSeparatedRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 %2\u00020\u0001:\u0002%&B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\bH\u0002J \u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0002Je\u0010\"\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u000e2K\u0010$\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RS\u0010\u0006\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/cqfn/diktat/ruleset/rules/LongNumericalValuesSeparatedRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "isFixMode", "checkBlocks", "text", "configuration", "Lorg/cqfn/diktat/ruleset/rules/LongNumericalValuesSeparatedRule$LongNumericalValuesConfiguration;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "fixFloatConstantPart", "realPart", "fractionalPart", "fixIntegerConstant", "maxBlockLength", "isValidConstant", "nodePrefix", "nodeText", "nodeSuffix", "removePrefixSuffix", "visit", "autoCorrect", "emit", "Companion", "LongNumericalValuesConfiguration", "diktat-rules"})
public final class LongNumericalValuesSeparatedRule
extends Rule {
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private boolean isFixMode;
    private final List<RulesConfig> configRules;
    private static final int DELIMITER_LENGTH = 3;
    private static final int MAX_NUMBER_LENGTH = 3;
    public static final Companion Companion = new Companion(null);

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        Object object = RulesConfigReaderKt.getRuleConfig(this.configRules, (org.cqfn.diktat.common.config.rules.Rule)Warnings.LONG_NUMERICAL_VALUES_SEPARATED);
        if (object == null || (object = object.getConfiguration()) == null) {
            boolean bl = false;
            object = MapsKt.emptyMap();
        }
        LongNumericalValuesConfiguration configuration2 = new LongNumericalValuesConfiguration((Map<String, String>)object);
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getINTEGER_LITERAL())) {
            String string = node.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.text");
            if (!this.isValidConstant(string, configuration2, node)) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                String string2 = node.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"node.text");
                Warnings.warnAndFix$default(Warnings.LONG_NUMERICAL_VALUES_SEPARATED, this.configRules, function3, this.isFixMode, string2, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, node, configuration2){
                    final /* synthetic */ LongNumericalValuesSeparatedRule this$0;
                    final /* synthetic */ ASTNode $node;
                    final /* synthetic */ LongNumericalValuesConfiguration $configuration;

                    public final void invoke() {
                        LongNumericalValuesSeparatedRule.access$fixIntegerConstant(this.this$0, this.$node, this.$configuration.getMaxBlockLength());
                    }
                    {
                        this.this$0 = longNumericalValuesSeparatedRule;
                        this.$node = aSTNode;
                        this.$configuration = longNumericalValuesConfiguration;
                        super(0);
                    }
                }, 64, null);
            }
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFLOAT_LITERAL())) {
            String string = node.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.text");
            if (!this.isValidConstant(string, configuration2, node)) {
                String string3 = node.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"node.text");
                List parts = StringsKt.split$default((CharSequence)string3, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                String string4 = node.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"node.text");
                Warnings.warnAndFix$default(Warnings.LONG_NUMERICAL_VALUES_SEPARATED, this.configRules, function3, this.isFixMode, string4, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, parts, configuration2, node){
                    final /* synthetic */ LongNumericalValuesSeparatedRule this$0;
                    final /* synthetic */ List $parts;
                    final /* synthetic */ LongNumericalValuesConfiguration $configuration;
                    final /* synthetic */ ASTNode $node;

                    public final void invoke() {
                        LongNumericalValuesSeparatedRule.access$fixFloatConstantPart(this.this$0, (String)this.$parts.get(0), (String)this.$parts.get(1), this.$configuration, this.$node);
                    }
                    {
                        this.this$0 = longNumericalValuesSeparatedRule;
                        this.$parts = list;
                        this.$configuration = longNumericalValuesConfiguration;
                        this.$node = aSTNode;
                        super(0);
                    }
                }, 64, null);
            }
        }
    }

    private final void fixIntegerConstant(ASTNode node, int maxBlockLength) {
        String string = node.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.text");
        StringBuilder resultRealPart = new StringBuilder(this.nodePrefix(string));
        String string2 = node.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"node.text");
        String string3 = this.removePrefixSuffix(string2);
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        List chunks = CollectionsKt.reversed((Iterable)StringsKt.chunked((CharSequence)((Object)StringsKt.reversed((CharSequence)string4)).toString(), (int)maxBlockLength));
        resultRealPart.append(CollectionsKt.joinToString$default((Iterable)chunks, (CharSequence)"_", null, null, (int)0, null, (Function1)fixIntegerConstant.1.INSTANCE, (int)30, null));
        String string5 = node.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"node.text");
        resultRealPart.append(this.nodeSuffix(string5));
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
        }
        ((LeafPsiElement)aSTNode).replaceWithText(resultRealPart.toString());
    }

    private final void fixFloatConstantPart(String realPart, String fractionalPart, LongNumericalValuesConfiguration configuration2, ASTNode node) {
        StringBuilder resultRealPart = new StringBuilder(this.nodePrefix(realPart));
        StringBuilder resultFractionalPart = new StringBuilder();
        String realNumber = this.removePrefixSuffix(realPart);
        if (realNumber.length() > configuration2.getMaxLength()) {
            String string = realNumber;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            List chunks = CollectionsKt.reversed((Iterable)StringsKt.chunked((CharSequence)((Object)StringsKt.reversed((CharSequence)string2)).toString(), (int)configuration2.getMaxBlockLength()));
            resultRealPart.append(CollectionsKt.joinToString$default((Iterable)chunks, (CharSequence)"_", null, null, (int)0, null, (Function1)fixFloatConstantPart.1.INSTANCE, (int)30, null));
            resultRealPart.append(this.nodeSuffix(realPart)).append(".");
        } else {
            resultRealPart.append(realNumber).append(".");
        }
        String fractionalNumber = this.removePrefixSuffix(fractionalPart);
        if (fractionalNumber.length() > configuration2.getMaxLength()) {
            List chunks = StringsKt.chunked((CharSequence)fractionalNumber, (int)configuration2.getMaxBlockLength());
            resultFractionalPart.append(CollectionsKt.joinToString$default((Iterable)chunks, (CharSequence)"_", null, (CharSequence)this.nodeSuffix(fractionalPart), (int)0, null, (Function1)fixFloatConstantPart.2.INSTANCE, (int)26, null));
            resultFractionalPart.append(this.nodeSuffix(fractionalPart));
        } else {
            resultFractionalPart.append(fractionalNumber).append(this.nodeSuffix(fractionalPart));
        }
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
        }
        ((LeafPsiElement)aSTNode).replaceWithText(resultRealPart.append((CharSequence)resultFractionalPart).toString());
    }

    private final String nodePrefix(String nodeText) {
        return StringsKt.startsWith$default((String)nodeText, (String)"0b", (boolean)false, (int)2, null) ? "0b" : (StringsKt.startsWith$default((String)nodeText, (String)"0x", (boolean)false, (int)2, null) ? "0x" : "");
    }

    private final String nodeSuffix(String nodeText) {
        return StringsKt.endsWith$default((String)nodeText, (String)"L", (boolean)false, (int)2, null) ? "L" : (StringsKt.endsWith((String)nodeText, (String)"f", (boolean)true) ? "f" : "");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValidConstant(String text, LongNumericalValuesConfiguration configuration2, ASTNode node) {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            if (StringsKt.contains$default((CharSequence)text, (CharSequence)"_", (boolean)false, (int)2, null)) {
                this.checkBlocks(this.removePrefixSuffix(text), configuration2, node);
                return true;
            }
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)text, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string2 = this.removePrefixSuffix((String)it);
                collection.add(string2);
            }
            Iterable $this$all$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (it.length() < configuration2.getMaxLength()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void checkBlocks(String text, LongNumericalValuesConfiguration configuration2, ASTNode node) {
        List blocks = StringsKt.split$default((CharSequence)text, (String[])new String[]{"_", "."}, (boolean)false, (int)0, (int)6, null);
        Iterable $this$forEach$iv = blocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (it.length() <= configuration2.getMaxBlockLength()) continue;
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.LONG_NUMERICAL_VALUES_SEPARATED.warn(this.configRules, function3, false, "this block is too long " + it, node.getStartOffset(), node);
        }
    }

    private final String removePrefixSuffix(String text) {
        if (StringsKt.startsWith$default((String)text, (String)"0x", (boolean)false, (int)2, null)) {
            return StringsKt.removePrefix((String)text, (CharSequence)"0x");
        }
        return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)text, (CharSequence)"0b"), (CharSequence)"L"), (CharSequence)"f"), (CharSequence)"F");
    }

    public LongNumericalValuesSeparatedRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkParameterIsNotNull(configRules, (String)"configRules");
        super("long-numerical-values");
        this.configRules = configRules;
    }

    public static final /* synthetic */ void access$fixIntegerConstant(LongNumericalValuesSeparatedRule $this, ASTNode node, int maxBlockLength) {
        $this.fixIntegerConstant(node, maxBlockLength);
    }

    public static final /* synthetic */ void access$fixFloatConstantPart(LongNumericalValuesSeparatedRule $this, String realPart, String fractionalPart, LongNumericalValuesConfiguration configuration2, ASTNode node) {
        $this.fixFloatConstantPart(realPart, fractionalPart, configuration2, node);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/LongNumericalValuesSeparatedRule$LongNumericalValuesConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "maxBlockLength", "", "getMaxBlockLength", "()I", "maxLength", "getMaxLength", "diktat-rules"})
    public static final class LongNumericalValuesConfiguration
    extends RuleConfiguration {
        private final int maxLength;
        private final int maxBlockLength;

        public final int getMaxLength() {
            return this.maxLength;
        }

        public final int getMaxBlockLength() {
            return this.maxBlockLength;
        }

        public LongNumericalValuesConfiguration(@NotNull Map<String, String> config) {
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            super(config);
            Object object = config.get("maxNumberLength");
            this.maxLength = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 3;
            Object object2 = config.get("maxBlockLength");
            this.maxBlockLength = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 3;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/cqfn/diktat/ruleset/rules/LongNumericalValuesSeparatedRule$Companion;", "", "()V", "DELIMITER_LENGTH", "", "MAX_NUMBER_LENGTH", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

