/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.NullChecksRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0015H\u0002Je\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000e2K\u0010\u001d\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007H\u0016J&\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/cqfn/diktat/ruleset/rules/NullChecksRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "conditionInIfStatement", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "isNullCheckBinaryExpession", "condition", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "nullCheckInOtherStatements", "binaryExprNode", "visit", "autoCorrect", "emit", "warnAndFixOnNullCheck", "canBeAutoFixed", "autofix", "Lkotlin/Function0;", "diktat-rules"})
public final class NullChecksRule
extends Rule {
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        ASTNode aSTNode;
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getCONDITION())) {
            ASTNode aSTNode2 = PackageKt.parent$default((ASTNode)node, (IElementType)ElementType.INSTANCE.getIF(), (boolean)false, (int)2, null);
            if (aSTNode2 != null) {
                object = aSTNode2;
                bl2 = false;
                bl = false;
                ASTNode it = object;
                boolean bl3 = false;
                this.conditionInIfStatement(node);
            }
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION()) && (aSTNode = PackageKt.parent$default((ASTNode)node, (IElementType)ElementType.INSTANCE.getCONDITION(), (boolean)false, (int)2, null)) == null) {
            object = this;
            bl2 = false;
            bl = false;
            NullChecksRule $this$run = (NullChecksRule)((Object)object);
            boolean bl4 = false;
            $this$run.nullCheckInOtherStatements(node);
            aSTNode = Unit.INSTANCE;
        }
    }

    private final void conditionInIfStatement(ASTNode node) {
        Iterable $this$forEach$iv = AstNodeUtilsKt.findAllNodesWithSpecificType$default(node, ElementType.INSTANCE.getBINARY_EXPRESSION(), false, 2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode binaryExprNode = (ASTNode)element$iv;
            boolean bl = false;
            PsiElement psiElement = binaryExprNode.getPsi();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            }
            KtBinaryExpression condition = (KtBinaryExpression)psiElement;
            if (!this.isNullCheckBinaryExpession(condition)) continue;
            IElementType iElementType = condition.getOperationToken();
            if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getEQEQ()) || Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getEQEQEQ())) {
                this.warnAndFixOnNullCheck(condition, true, (Function0<Unit>)((Function0)conditionInIfStatement.1.1.INSTANCE));
                continue;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getEXCLEQ()) && !Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getEXCLEQEQEQ())) continue;
            this.warnAndFixOnNullCheck(condition, true, (Function0<Unit>)((Function0)conditionInIfStatement.1.2.INSTANCE));
        }
    }

    private final void nullCheckInOtherStatements(ASTNode binaryExprNode) {
        PsiElement psiElement = binaryExprNode.getPsi();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtBinaryExpression condition = (KtBinaryExpression)psiElement;
        if (this.isNullCheckBinaryExpession(condition)) {
            this.warnAndFixOnNullCheck(condition, false, (Function0<Unit>)((Function0)nullCheckInOtherStatements.1.INSTANCE));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isNullCheckBinaryExpession(KtBinaryExpression condition) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = SetsKt.setOf((Object[])new KtExpression[]{condition.getRight(), condition.getLeft()});
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtExpression ktExpression = (KtExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v0 = it;
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"it!!");
            ASTNode aSTNode = v0.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it!!.node");
            IElementType iElementType = aSTNode.getElementType();
            collection.add(iElementType);
        }
        return ((List)destination$iv$iv).contains(ElementType.INSTANCE.getNULL()) && SetsKt.setOf((Object[])new IElementType[]{ElementType.INSTANCE.getEQEQ(), ElementType.INSTANCE.getEQEQEQ(), ElementType.INSTANCE.getEXCLEQ(), ElementType.INSTANCE.getEXCLEQEQEQ()}).contains(condition.getOperationToken());
    }

    private final void warnAndFixOnNullCheck(KtBinaryExpression condition, boolean canBeAutoFixed, Function0<Unit> autofix2) {
        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
        if (function3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
        }
        String string = condition.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"condition.text");
        ASTNode aSTNode = condition.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"condition.node");
        int n = aSTNode.getStartOffset();
        ASTNode aSTNode2 = condition.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"condition.node");
        Warnings.AVOID_NULL_CHECKS.warnAndFix(this.configRules, function3, this.isFixMode, string, n, aSTNode2, canBeAutoFixed, (Function0<Unit>)((Function0)new Function0<Unit>(autofix2){
            final /* synthetic */ Function0 $autofix;

            public final void invoke() {
                this.$autofix.invoke();
            }
            {
                this.$autofix = function0;
                super(0);
            }
        }));
    }

    public NullChecksRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkParameterIsNotNull(configRules, (String)"configRules");
        super("null-checks");
        this.configRules = configRules;
    }
}

