/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.comments;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bH\u0002Je\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00102K\u0010\u001e\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\nH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RS\u0010\t\u001aG\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/cqfn/diktat/ruleset/rules/comments/HeaderCommentRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "copyrightWords", "", "", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "", "canBeAutoCorrected", "", "fileName", "isFixMode", "checkCopyright", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "checkHeaderKdoc", "checkHeaderKdocPosition", "makeCopyrightCorrectYear", "copyrightText", "visit", "autoCorrect", "emit", "Companion", "CopyrightConfiguration", "diktat-rules"})
public final class HeaderCommentRule
extends Rule {
    private final Set<String> copyrightWords;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private boolean isFixMode;
    private String fileName;
    private final List<RulesConfig> configRules;
    @NotNull
    private static final Regex hyphenRegex;
    @NotNull
    private static final Regex afterCopyrightRegex;
    private static final int curYear;
    public static final Companion Companion;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        this.isFixMode = autoCorrect;
        this.emitWarn = emit;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            this.fileName = AstNodeUtilsKt.getFileName(node);
            this.checkCopyright(node);
            if (this.checkHeaderKdocPosition(node)) {
                this.checkHeaderKdoc(node);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkCopyright(ASTNode node) {
        block15: {
            v0 /* !! */  = RulesConfigReaderKt.getRuleConfig(this.configRules, (org.cqfn.diktat.common.config.rules.Rule)Warnings.HEADER_MISSING_OR_WRONG_COPYRIGHT);
            if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getConfiguration()) == null) {
                var3_2 = false;
                v0 /* !! */  = MapsKt.emptyMap();
            }
            configuration = new CopyrightConfiguration((Map<String, String>)v0 /* !! */ );
            if (!configuration.isCopyrightMandatory() && !configuration.hasCopyrightText()) {
                return;
            }
            copyrightText = configuration.getCopyrightText();
            headerComment = AstNodeUtilsKt.findChildBefore(node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getBLOCK_COMMENT());
            if (headerComment == null) ** GOTO lbl-1000
            v1 = headerComment.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"headerComment.text");
            if (!StringsKt.contains$default((CharSequence)v1, (CharSequence)copyrightText, (boolean)false, (int)2, null)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            isWrongCopyright = v2;
            isMissingCopyright = headerComment == null && configuration.isCopyrightMandatory() != false;
            $this$any$iv = CollectionsKt.plus((Collection)AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getKDOC()), (Iterable)AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getEOL_COMMENT()));
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v3 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    block14: {
                        commentNode = (ASTNode)element$iv;
                        $i$a$-any-HeaderCommentRule$checkCopyright$isCopyrightInsideKdoc$1 = false;
                        $this$any$iv = this.copyrightWords;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v4 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                $i$a$-any-HeaderCommentRule$checkCopyright$isCopyrightInsideKdoc$1$1 = false;
                                v5 = commentNode.getText();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"commentNode.text");
                                if (!StringsKt.contains((CharSequence)v5, (CharSequence)it, (boolean)true)) continue;
                                v4 = true;
                                break block14;
                            }
                            v4 = false;
                        }
                    }
                    if (!v4) continue;
                    v3 = true;
                    break block15;
                }
                v3 = isCopyrightInsideKdoc = false;
            }
        }
        if (isWrongCopyright || isMissingCopyright || isCopyrightInsideKdoc) {
            v6 = this.emitWarn;
            if (v6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.warnAndFix$default(Warnings.HEADER_MISSING_OR_WRONG_COPYRIGHT, this.configRules, v6, this.isFixMode, this.fileName, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(headerComment, node, copyrightText){
                final /* synthetic */ ASTNode $headerComment;
                final /* synthetic */ ASTNode $node;
                final /* synthetic */ String $copyrightText;

                public final void invoke() {
                    if (this.$headerComment != null) {
                        this.$node.removeChild(this.$headerComment);
                    }
                    String newLines = AstNodeUtilsKt.findChildBefore(this.$node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getKDOC()) != null ? "\n" : "\n\n";
                    this.$node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)newLines), this.$node.getFirstChildNode());
                    this.$node.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getBLOCK_COMMENT(), (CharSequence)StringsKt.trimIndent((String)("\n                            /*\n                             * " + this.$copyrightText + "\n                             */\n                        "))), this.$node.getFirstChildNode());
                }
                {
                    this.$headerComment = aSTNode;
                    this.$node = aSTNode2;
                    this.$copyrightText = string;
                    super(0);
                }
            }, 64, null);
        }
        copyrightWithCorrectYear = this.makeCopyrightCorrectYear(copyrightText);
        var9_10 = copyrightWithCorrectYear;
        var10_12 = false;
        if (var9_10.length() > 0) {
            v7 = this.emitWarn;
            if (v7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.warnAndFix$default(Warnings.WRONG_COPYRIGHT_YEAR, this.configRules, v7, this.isFixMode, this.fileName, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(headerComment, copyrightText, copyrightWithCorrectYear){
                final /* synthetic */ ASTNode $headerComment;
                final /* synthetic */ String $copyrightText;
                final /* synthetic */ String $copyrightWithCorrectYear;

                public final void invoke() {
                    ASTNode aSTNode = this.$headerComment;
                    if (aSTNode == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
                    }
                    LeafElement leafElement = (LeafElement)aSTNode;
                    String string = ((LeafElement)this.$headerComment).getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"headerComment.text");
                    leafElement.replaceWithText(StringsKt.replace$default((String)string, (String)this.$copyrightText, (String)this.$copyrightWithCorrectYear, (boolean)false, (int)4, null));
                }
                {
                    this.$headerComment = aSTNode;
                    this.$copyrightText = string;
                    this.$copyrightWithCorrectYear = string2;
                    super(0);
                }
            }, 64, null);
        }
    }

    private final String makeCopyrightCorrectYear(String copyrightText) {
        MatchResult afterCopyrightYear;
        MatchResult hyphenYear = Regex.find$default((Regex)hyphenRegex, (CharSequence)copyrightText, (int)0, (int)2, null);
        if (hyphenYear != null) {
            List copyrightYears = StringsKt.split$default((CharSequence)hyphenYear.getValue(), (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null);
            String string = (String)copyrightYears.get(1);
            boolean bl = false;
            if (Integer.parseInt(string) != curYear) {
                String validYears = (String)copyrightYears.get(0) + '-' + curYear;
                CharSequence charSequence = copyrightText;
                Regex regex = hyphenRegex;
                boolean bl2 = false;
                return regex.replace(charSequence, validYears);
            }
        }
        if ((afterCopyrightYear = Regex.find$default((Regex)afterCopyrightRegex, (CharSequence)copyrightText, (int)0, (int)2, null)) != null) {
            List copyrightYears = StringsKt.split$default((CharSequence)afterCopyrightYear.getValue(), (String[])new String[]{"(c)", "(C)", "\u00a9"}, (boolean)false, (int)0, (int)6, null);
            String string = (String)copyrightYears.get(1);
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            bl = false;
            if (Integer.parseInt(string) != curYear) {
                String validYears = (String)copyrightYears.get(0) + '-' + curYear;
                CharSequence charSequence = copyrightText;
                Regex regex = afterCopyrightRegex;
                boolean bl3 = false;
                return regex.replace(charSequence, validYears);
            }
        }
        return "";
    }

    private final boolean checkHeaderKdocPosition(ASTNode node) {
        ASTNode firstKdoc = AstNodeUtilsKt.findChildAfter(node, ElementType.INSTANCE.getIMPORT_LIST(), ElementType.INSTANCE.getKDOC());
        if (AstNodeUtilsKt.findChildBefore(node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getKDOC()) == null && firstKdoc != null) {
            ASTNode aSTNode = firstKdoc.getTreeParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"firstKdoc.treeParent");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                Warnings.warnAndFix$default(Warnings.HEADER_NOT_BEFORE_PACKAGE, this.configRules, function3, this.isFixMode, this.fileName, firstKdoc.getStartOffset(), firstKdoc, false, (Function0)new Function0<Unit>(node, firstKdoc){
                    final /* synthetic */ ASTNode $node;
                    final /* synthetic */ ASTNode $firstKdoc;

                    public final void invoke() {
                        block2: {
                            AstNodeUtilsKt.moveChildBefore(this.$node, this.$firstKdoc, AstNodeUtilsKt.getFirstChildWithType(this.$node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE()), true);
                            ASTNode aSTNode = AstNodeUtilsKt.findChildBefore(this.$node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getBLOCK_COMMENT());
                            if (aSTNode == null) break block2;
                            ASTNode aSTNode2 = aSTNode;
                            boolean bl = false;
                            boolean bl2 = false;
                            ASTNode $this$apply = aSTNode2;
                            boolean bl3 = false;
                            ASTNode aSTNode3 = $this$apply.getTreeNext();
                            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode3, (String)"treeNext");
                            if (Intrinsics.areEqual((Object)aSTNode3.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                                this.$node.replaceChild($this$apply.getTreeNext(), (ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"));
                            } else {
                                this.$node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), $this$apply.getTreeNext());
                            }
                        }
                    }
                    {
                        this.$node = aSTNode;
                        this.$firstKdoc = aSTNode2;
                        super(0);
                    }
                }, 64, null);
                if (!this.isFixMode) {
                    return false;
                }
            }
        }
        return true;
    }

    private final void checkHeaderKdoc(ASTNode node) {
        ASTNode headerKdoc = AstNodeUtilsKt.findChildBefore(node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getKDOC());
        if (headerKdoc == null) {
            int nDeclaredClassesAndObjects = AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getCLASS()).size() + AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getOBJECT_DECLARATION()).size();
            if (nDeclaredClassesAndObjects == 0 || nDeclaredClassesAndObjects > 1) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                Warnings.HEADER_MISSING_IN_NON_SINGLE_CLASS_FILE.warn(this.configRules, function3, this.isFixMode, this.fileName, node.getStartOffset(), node);
            }
        } else {
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv;
            String string = headerKdoc.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"headerKdoc.text");
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)string, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                String it2 = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it2, (CharSequence)"@author", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                element$iv$iv = it;
                boolean it2 = false;
                Object object = element$iv$iv;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                Warnings.HEADER_CONTAINS_DATE_OR_AUTHOR.warn(this.configRules, function3, this.isFixMode, ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString(), headerKdoc.getStartOffset(), headerKdoc);
            }
            if (headerKdoc.getTreeNext() != null) {
                ASTNode aSTNode = headerKdoc.getTreeNext();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"headerKdoc.treeNext");
                if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                    ASTNode aSTNode2 = headerKdoc.getTreeNext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"headerKdoc.treeNext");
                    String string2 = aSTNode2.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"headerKdoc.treeNext.text");
                    CharSequence $this$count$iv = string2;
                    boolean $i$f$count = false;
                    int count$iv = 0;
                    CharSequence charSequence = $this$count$iv;
                    for (int i = 0; i < charSequence.length(); ++i) {
                        char element$iv;
                        char it = element$iv = charSequence.charAt(i);
                        boolean bl = false;
                        if (!(it == '\n')) continue;
                        ++count$iv;
                    }
                    if (count$iv != 2) {
                        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                        if (function3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                        }
                        Warnings.warnAndFix$default(Warnings.HEADER_WRONG_FORMAT, this.configRules, function3, this.isFixMode, "header KDoc should have a new line after", headerKdoc.getStartOffset(), headerKdoc, false, (Function0)new Function0<Unit>(node, headerKdoc){
                            final /* synthetic */ ASTNode $node;
                            final /* synthetic */ ASTNode $headerKdoc;

                            public final void invoke() {
                                this.$node.replaceChild(this.$headerKdoc.getTreeNext(), (ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n\n"));
                            }
                            {
                                this.$node = aSTNode;
                                this.$headerKdoc = aSTNode2;
                                super(0);
                            }
                        }, 64, null);
                    }
                }
            }
        }
    }

    public HeaderCommentRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkParameterIsNotNull(configRules, (String)"configRules");
        super("header-comment");
        this.configRules = configRules;
        this.copyrightWords = SetsKt.setOf((Object[])new String[]{"copyright", "\u7248\u6743"});
        this.fileName = "";
    }

    static {
        Companion = new Companion(null);
        hyphenRegex = new Regex("\\b(\\d+-\\d+)\\b");
        afterCopyrightRegex = new Regex("((\u00a9|\\([cC]\\))+ *\\d+)");
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"LocalDate.now()");
        curYear = localDate.getYear();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/comments/HeaderCommentRule$CopyrightConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "getCopyrightText", "hasCopyrightText", "", "isCopyrightMandatory", "diktat-rules"})
    public static final class CopyrightConfiguration
    extends RuleConfiguration {
        public final boolean isCopyrightMandatory() {
            boolean bl;
            String string = (String)this.getConfig().get("isCopyrightMandatory");
            if (string != null) {
                String string2 = string;
                boolean bl2 = false;
                String string3 = string2;
                boolean bl3 = false;
                bl = Boolean.parseBoolean(string3);
            } else {
                bl = false;
            }
            return bl;
        }

        public final boolean hasCopyrightText() {
            return this.getConfig().keySet().contains("copyrightText");
        }

        @NotNull
        public final String getCopyrightText() {
            String string = (String)this.getConfig().get("copyrightText");
            if (string == null) {
                String string2 = "Copyright is not set in configuration";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return string;
        }

        public CopyrightConfiguration(@NotNull Map<String, String> config) {
            Intrinsics.checkParameterIsNotNull(config, (String)"config");
            super(config);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/cqfn/diktat/ruleset/rules/comments/HeaderCommentRule$Companion;", "", "()V", "afterCopyrightRegex", "Lkotlin/text/Regex;", "getAfterCopyrightRegex", "()Lkotlin/text/Regex;", "curYear", "", "getCurYear", "()I", "hyphenRegex", "getHyphenRegex", "diktat-rules"})
    public static final class Companion {
        @NotNull
        public final Regex getHyphenRegex() {
            return hyphenRegex;
        }

        @NotNull
        public final Regex getAfterCopyrightRegex() {
            return afterCopyrightRegex;
        }

        public final int getCurYear() {
            return curYear;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

