/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.files;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002Je\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000e2K\u0010\u0018\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RS\u0010\u0006\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/cqfn/diktat/ruleset/rules/files/BlankLinesRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "isFixMode", "handleBlankLine", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "handleTooManyBlankLines", "visit", "autoCorrect", "emit", "diktat-rules"})
public final class BlankLinesRule
extends Rule {
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private boolean isFixMode;
    private final List<RulesConfig> configRules;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
            if (AstNodeUtilsKt.numNewLines(node) == 2) {
                this.handleBlankLine(node);
            } else if (AstNodeUtilsKt.numNewLines(node) > 2) {
                this.handleTooManyBlankLines(node);
            }
        }
    }

    private final void handleBlankLine(ASTNode node) {
        ASTNode aSTNode = node.getTreeParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node.treeParent");
        IElementType iElementType = aSTNode.getElementType();
        boolean bl = false;
        boolean bl2 = false;
        IElementType it = iElementType;
        boolean bl3 = false;
        if (Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getBLOCK()) || Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getCLASS_BODY())) {
            ASTNode aSTNode2 = node.getTreeNext();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode2, (String)"node.treeNext");
            boolean bl4 = Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)ElementType.INSTANCE.getRBRACE());
            ASTNode aSTNode3 = node.getTreePrev();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode3, (String)"node.treePrev");
            if (bl4 ^ Intrinsics.areEqual((Object)aSTNode3.getElementType(), (Object)ElementType.INSTANCE.getLBRACE())) {
                StringBuilder stringBuilder = new StringBuilder().append("do not put newlines ");
                ASTNode aSTNode4 = node.getTreePrev();
                Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode4, (String)"node.treePrev");
                String freeText = stringBuilder.append(Intrinsics.areEqual((Object)aSTNode4.getElementType(), (Object)ElementType.INSTANCE.getLBRACE()) ? "in the beginning" : "at the end").append(" of code blocks").toString();
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                Warnings.warnAndFix$default(Warnings.TOO_MANY_BLANK_LINES, this.configRules, function3, this.isFixMode, freeText, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                    final /* synthetic */ ASTNode $node;

                    public final void invoke() {
                        AstNodeUtilsKt.leaveOnlyOneNewLine(this.$node);
                    }
                    {
                        this.$node = aSTNode;
                        super(0);
                    }
                }, 64, null);
            }
        }
    }

    private final void handleTooManyBlankLines(ASTNode node) {
        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
        if (function3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
        }
        Warnings.warnAndFix$default(Warnings.TOO_MANY_BLANK_LINES, this.configRules, function3, this.isFixMode, "do not use more than two consecutive blank lines", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
            final /* synthetic */ ASTNode $node;

            public final void invoke() {
                AstNodeUtilsKt.leaveExactlyNumNewLines(this.$node, 2);
            }
            {
                this.$node = aSTNode;
                super(0);
            }
        }, 64, null);
    }

    public BlankLinesRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkParameterIsNotNull(configRules, (String)"configRules");
        super("blank-lines");
        this.configRules = configRules;
    }
}

