/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.files;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.StringUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002Je\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u000e2K\u0010\u001b\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RS\u0010\u0006\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/cqfn/diktat/ruleset/rules/files/FileSize;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "fileName", "isFixMode", "calculateFilePath", "checkFileSize", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "maxSize", "", "visit", "autoCorrect", "emit", "Companion", "FileSizeConfiguration", "diktat-rules"})
public final class FileSize
extends Rule {
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private String fileName;
    private boolean isFixMode;
    private final List<RulesConfig> configRules;
    private static final Logger log;
    public static final long MAX_SIZE = 2000L;
    private static final List<String> IGNORE_FOLDER;
    @NotNull
    public static final String IGNORE_FOLDERS_SEPARATOR = ",";
    @NotNull
    public static final String SRC_PATH = "src";
    public static final Companion Companion;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            this.fileName = AstNodeUtilsKt.getFileName(node);
            Object object = RulesConfigReaderKt.getRuleConfig(this.configRules, (org.cqfn.diktat.common.config.rules.Rule)Warnings.FILE_IS_TOO_LONG);
            if (object == null || (object = object.getConfiguration()) == null) {
                boolean bl = false;
                object = MapsKt.emptyMap();
            }
            FileSizeConfiguration configuration2 = new FileSizeConfiguration((Map<String, String>)object);
            List<String> ignoreFolders = configuration2.getIgnoreFolders();
            List<String> realFilePath = this.calculateFilePath(this.fileName);
            if (!realFilePath.contains(SRC_PATH)) {
                log.error("src directory is not found in file path");
            } else {
                boolean bl;
                block8: {
                    Iterable $this$none$iv = ignoreFolders;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!realFilePath.containsAll((Collection)StringUtilsKt.splitPathToDirs(it))) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    this.checkFileSize(node, configuration2.getMaxSize());
                }
            }
            return;
        }
    }

    private final List<String> calculateFilePath(String fileName) {
        List list;
        List filePathParts;
        String string = fileName;
        List list2 = filePathParts = string != null ? StringUtilsKt.splitPathToDirs(string) : null;
        if (filePathParts == null) {
            log.error("Could not find absolute path to file");
            boolean bl = false;
            list = CollectionsKt.emptyList();
        } else {
            list = filePathParts;
        }
        return list;
    }

    private final void checkFileSize(ASTNode node, long maxSize) {
        String string = node.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node\n                .text");
        int size = StringsKt.split$default((CharSequence)string, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null).size();
        if ((long)size > maxSize) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.FILE_IS_TOO_LONG.warn(this.configRules, function3, this.isFixMode, String.valueOf(size), node.getStartOffset(), node);
        }
    }

    public FileSize(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkParameterIsNotNull(configRules, (String)"configRules");
        super("file-size");
        this.configRules = configRules;
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(FileSize.class);
        IGNORE_FOLDER = CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/cqfn/diktat/ruleset/rules/files/FileSize$FileSizeConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "ignoreFolders", "", "getIgnoreFolders", "()Ljava/util/List;", "maxSize", "", "getMaxSize", "()J", "diktat-rules"})
    public static final class FileSizeConfiguration
    extends RuleConfiguration {
        private final long maxSize;
        @NotNull
        private final List<String> ignoreFolders;

        public final long getMaxSize() {
            return this.maxSize;
        }

        @NotNull
        public final List<String> getIgnoreFolders() {
            return this.ignoreFolders;
        }

        public FileSizeConfiguration(@NotNull Map<String, String> config) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkParameterIsNotNull(config, (String)"config");
                    super(config);
                    Object object2 = config.get("maxSize");
                    long l = this.maxSize = object2 != null && (object2 = StringsKt.toLongOrNull((String)object2)) != null ? (Long)object2 : 2000L;
                    object = config.get("ignoreFolders");
                    if (object == null) break block2;
                    CharSequence charSequence = (CharSequence)object;
                    String string = "\\s+";
                    boolean bl = false;
                    string = new Regex(string);
                    String string2 = "";
                    boolean bl2 = false;
                    object = string.replace(charSequence, string2);
                    if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{FileSize.IGNORE_FOLDERS_SEPARATOR}, (boolean)false, (int)0, (int)6, null)) != null) break block3;
                }
                object = IGNORE_FOLDER;
            }
            this.ignoreFolders = object;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/cqfn/diktat/ruleset/rules/files/FileSize$Companion;", "", "()V", "IGNORE_FOLDER", "", "", "IGNORE_FOLDERS_SEPARATOR", "MAX_SIZE", "", "SRC_PATH", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

