/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002Ji\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000e2O\u0010\u001a\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/AvoidEmptyPrimaryConstructor;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "checkClass", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visit", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "emit", "diktat-rules"})
public final class AvoidEmptyPrimaryConstructor
extends Rule {
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getCLASS())) {
            PsiElement psiElement = node.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
            }
            this.checkClass((KtClass)psiElement);
        }
    }

    private final void checkClass(KtClass ktClass) {
        block5: {
            block4: {
                Object object = ktClass.getPrimaryConstructor();
                if (object == null || (object = object.getValueParameters()) == null) break block4;
                Collection collection = (Collection)object;
                boolean bl = false;
                if (!collection.isEmpty()) break block4;
                if (ktClass.getPrimaryConstructorModifierList() == null) break block5;
            }
            return;
        }
        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
        if (function3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
        }
        PsiElement psiElement = ktClass.getNameIdentifier();
        Intrinsics.checkNotNull((Object)psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"ktClass.nameIdentifier!!");
        String string = psiElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ktClass.nameIdentifier!!.text");
        ASTNode aSTNode = ktClass.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"ktClass.node");
        int n = aSTNode.getStartOffset();
        ASTNode aSTNode2 = ktClass.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"ktClass.node");
        Warnings.warnAndFix$default(Warnings.EMPTY_PRIMARY_CONSTRUCTOR, this.configRules, function3, this.isFixMode, string, n, aSTNode2, false, (Function0)new Function0<Unit>(ktClass){
            final /* synthetic */ KtClass $ktClass;

            public final void invoke() {
                ASTNode aSTNode = this.$ktClass.getNode();
                KtPrimaryConstructor ktPrimaryConstructor = this.$ktClass.getPrimaryConstructor();
                Intrinsics.checkNotNull((Object)ktPrimaryConstructor);
                aSTNode.removeChild(ktPrimaryConstructor.getNode());
            }
            {
                this.$ktClass = ktClass;
                super(0);
            }
        }, 64, null);
    }

    public AvoidEmptyPrimaryConstructor(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("avoid-empty-primary-constructor");
        this.configRules = configRules;
    }
}

