/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.AvoidNestedFunctionsRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00032\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0015H\u0002Ji\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000e2O\u0010\u001c\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011H\u0016J\u0014\u0010\u001d\u001a\u00020\u000e*\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/cqfn/diktat/ruleset/rules/AvoidNestedFunctionsRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "checkFunctionReferences", "func", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "getParameterNames", "node", "handleNestedFunctions", "isNestedFunction", "visit", "autoCorrect", "emit", "hasFunParentUntil", "stopNode", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "diktat-rules"})
public final class AvoidNestedFunctionsRule
extends Rule {
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFUN())) {
            this.handleNestedFunctions(node);
        }
    }

    private final void handleNestedFunctions(ASTNode node) {
        if (this.isNestedFunction(node)) {
            ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getIDENTIFIER());
            Intrinsics.checkNotNull((Object)aSTNode);
            String string = aSTNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.getFirstChildWithType(IDENTIFIER)!!.text");
            String funcName = string;
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.AVOID_NESTED_FUNCTIONS.warnAndFix(this.configRules, function3, this.isFixMode, "fun " + funcName, node.getStartOffset(), node, this.checkFunctionReferences(node), (Function0<Unit>)((Function0)new Function0<Unit>(node){
                final /* synthetic */ ASTNode $node;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    ASTNode lastFunc = (ASTNode)CollectionsKt.last((List)AstNodeUtilsKt.findAllNodesWithSpecificType$default(this.$node, ElementType.INSTANCE.getFUN(), false, 2, null));
                    List funcSeq2 = SequencesKt.toMutableList((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.parents((ASTNode)lastFunc), (Function1)handleNestedFunctions.funcSeq.1.INSTANCE));
                    funcSeq2.add(0, lastFunc);
                    ASTNode firstFunc = (ASTNode)CollectionsKt.last((List)funcSeq2);
                    Iterable $this$forEachIndexed$iv = CollectionsKt.dropLast((List)funcSeq2, (int)1);
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        void it;
                        int n = index$iv++;
                        boolean bl = false;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        ASTNode aSTNode = (ASTNode)item$iv;
                        int index = n;
                        boolean bl2 = false;
                        ASTNode parent = (ASTNode)funcSeq2.get(index + 1);
                        if (PackageKt.isWhiteSpaceWithNewline((ASTNode)it.getTreePrev())) {
                            parent.removeChild(it.getTreePrev());
                        }
                        Object object = it.clone();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.lang.ASTNode");
                        }
                        firstFunc.getTreeParent().addChild((ASTNode)object, firstFunc);
                        firstFunc.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), firstFunc);
                        parent.removeChild((ASTNode)it);
                    }
                }
                {
                    this.$node = aSTNode;
                    super(0);
                }
            }));
        }
    }

    private final boolean isNestedFunction(ASTNode node) {
        return AstNodeUtilsKt.hasParent(node, ElementType.INSTANCE.getFUN()) && this.hasFunParentUntil(node, ElementType.INSTANCE.getCLASS_BODY()) && !AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getMODIFIER_LIST());
    }

    private final boolean hasFunParentUntil(ASTNode $this$hasFunParentUntil, IElementType stopNode) {
        boolean bl;
        block1: {
            Sequence sequence = PsiUtilsKt.parents((ASTNode)$this$hasFunParentUntil);
            boolean bl2 = false;
            Sequence $this$any$iv = SequencesKt.takeWhile((Sequence)sequence, (Function1)((Function1)new Function1<ASTNode, Boolean>(stopNode){
                final /* synthetic */ IElementType $stopNode;

                public final boolean invoke(@NotNull ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getElementType(), (Object)this.$stopNode) ^ true;
                }
                {
                    this.$stopNode = iElementType;
                    super(1);
                }
            }));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getFUN())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkFunctionReferences(ASTNode func) {
        boolean bl;
        block4: {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl2 = false;
            List localProperties2 = new ArrayList();
            localProperties2.addAll(AstNodeUtilsKt.findAllNodesWithSpecificType$default(func, ElementType.INSTANCE.getPROPERTY(), false, 2, null));
            boolean bl3 = false;
            List list = new ArrayList();
            boolean bl4 = false;
            boolean bl5 = false;
            List $this$apply = list;
            boolean bl6 = false;
            Iterable iterable = localProperties2;
            List list2 = $this$apply;
            boolean $i$f$map = false;
            void var12_17 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void it;
                ASTNode aSTNode = (ASTNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                ASTNode aSTNode2 = AstNodeUtilsKt.getFirstChildWithType((ASTNode)it, ElementType.INSTANCE.getIDENTIFIER());
                Intrinsics.checkNotNull((Object)aSTNode2);
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2.getText(), (String)"it.getFirstChildWithType(IDENTIFIER)!!.text");
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            list2.addAll((Collection)collection);
            $this$apply.addAll((Collection)this.getParameterNames(func));
            List propertiesNames = CollectionsKt.toList((Iterable)list);
            Iterable $this$all$iv = AstNodeUtilsKt.findAllNodesWithSpecificType$default(func, ElementType.INSTANCE.getREFERENCE_EXPRESSION(), false, 2, null);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl8 = false;
                    if (propertiesNames.contains(it.getText())) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getParameterNames(ASTNode node) {
        void $this$mapTo$iv$iv;
        PsiElement psiElement = node.getPsi();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        List list = ((KtFunction)psiElement).getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"(node.psi as KtFunction).valueParameters");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            KtParameter ktParameter = (KtParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            Intrinsics.checkNotNull((Object)v2.getName());
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public AvoidNestedFunctionsRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("avoid-nested-functions");
        this.configRules = configRules;
    }
}

