/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0002\"#B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002Ji\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000e2O\u0010\u001d\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011H\u0016J\f\u0010\u001e\u001a\u00020\u000e*\u00020\u0015H\u0002J\u0011\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b!*\u00020\u0015H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/cqfn/diktat/ruleset/rules/ConsecutiveSpacesRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "checkWhiteSpace", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "configuration", "Lorg/cqfn/diktat/ruleset/rules/ConsecutiveSpacesRule$TooManySpacesRuleConfiguration;", "checkWhiteSpaceEnum", "isWhitespaceInEnum", "squeezeSpacesToOne", "visit", "autoCorrect", "emit", "hasEolComment", "squeezeSpaces", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement;", "Lorg/jetbrains/annotations/NotNull;", "Companion", "TooManySpacesRuleConfiguration", "diktat-rules"})
public final class ConsecutiveSpacesRule
extends Rule {
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;
    private static final int MAX_SPACES = 1;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        Object object = RulesConfigReaderKt.getRuleConfig(this.configRules, (org.cqfn.diktat.common.config.rules.Rule)Warnings.TOO_MANY_CONSECUTIVE_SPACES);
        if (object == null || (object = object.getConfiguration()) == null) {
            object = MapsKt.emptyMap();
        }
        TooManySpacesRuleConfiguration configuration2 = new TooManySpacesRuleConfiguration((Map<String, String>)object);
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
            this.checkWhiteSpace(node, configuration2);
        }
    }

    private final void checkWhiteSpace(ASTNode node, TooManySpacesRuleConfiguration configuration2) {
        if (configuration2.getEnumInitialFormatting()) {
            this.checkWhiteSpaceEnum(node, configuration2);
        } else {
            this.squeezeSpacesToOne(node, configuration2);
        }
    }

    private final void checkWhiteSpaceEnum(ASTNode node, TooManySpacesRuleConfiguration configuration2) {
        boolean isInEnum = this.isWhitespaceInEnum(node);
        if (!isInEnum) {
            this.squeezeSpacesToOne(node, configuration2);
        }
    }

    private final boolean isWhitespaceInEnum(ASTNode node) {
        return PackageKt.parent$default((ASTNode)node, (IElementType)ElementType.INSTANCE.getENUM_ENTRY(), (boolean)false, (int)2, null) != null;
    }

    private final void squeezeSpacesToOne(ASTNode node, TooManySpacesRuleConfiguration configuration2) {
        int spaces = node.getTextLength();
        if (spaces > configuration2.getNumberOfSpaces() && !PackageKt.isWhiteSpaceWithNewline((ASTNode)node) && !this.hasEolComment(node)) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.warnAndFix$default(Warnings.TOO_MANY_CONSECUTIVE_SPACES, this.configRules, function3, this.isFixMode, "found: " + spaces + ". need to be: " + configuration2.getNumberOfSpaces(), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, node){
                final /* synthetic */ ConsecutiveSpacesRule this$0;
                final /* synthetic */ ASTNode $node;

                public final void invoke() {
                    ConsecutiveSpacesRule.access$squeezeSpaces(this.this$0, this.$node);
                }
                {
                    this.this$0 = consecutiveSpacesRule;
                    this.$node = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
    }

    private final boolean hasEolComment(ASTNode $this$hasEolComment) {
        ASTNode aSTNode = $this$hasEolComment.getTreeNext();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"this.treeNext");
        return Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getEOL_COMMENT());
    }

    private final LeafElement squeezeSpaces(ASTNode $this$squeezeSpaces) {
        ASTNode aSTNode = $this$squeezeSpaces;
        if (aSTNode == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
        }
        LeafElement leafElement = ((LeafElement)aSTNode).replaceWithText(" ");
        Intrinsics.checkNotNullExpressionValue((Object)leafElement, (String)"(this as LeafElement).replaceWithText(\" \")");
        return leafElement;
    }

    public ConsecutiveSpacesRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("too-many-spaces");
        this.configRules = configRules;
    }

    public static final /* synthetic */ LeafElement access$squeezeSpaces(ConsecutiveSpacesRule $this, ASTNode $this$access_u24squeezeSpaces) {
        return $this.squeezeSpaces($this$access_u24squeezeSpaces);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/cqfn/diktat/ruleset/rules/ConsecutiveSpacesRule$TooManySpacesRuleConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "enumInitialFormatting", "", "getEnumInitialFormatting", "()Z", "numberOfSpaces", "", "getNumberOfSpaces", "()I", "diktat-rules"})
    public static final class TooManySpacesRuleConfiguration
    extends RuleConfiguration {
        private final int numberOfSpaces;
        private final boolean enumInitialFormatting;

        public final int getNumberOfSpaces() {
            return this.numberOfSpaces;
        }

        public final boolean getEnumInitialFormatting() {
            return this.enumInitialFormatting;
        }

        public TooManySpacesRuleConfiguration(@NotNull Map<String, String> config) {
            boolean bl;
            Intrinsics.checkNotNullParameter(config, (String)"config");
            super(config);
            Object object = config.get("maxSpaces");
            this.numberOfSpaces = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 1;
            String string = config.get("saveInitialFormattingForEnums");
            if (string != null) {
                String string2 = string;
                boolean bl2 = false;
                bl = Boolean.parseBoolean(string2);
            } else {
                bl = false;
            }
            this.enumInitialFormatting = bl;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/ConsecutiveSpacesRule$Companion;", "", "()V", "MAX_SPACES", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

