/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.IdentifierNaming;
import org.cqfn.diktat.ruleset.rules.IdentifierNaming$WhenMappings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.StringCaseUtilsKt;
import org.cqfn.diktat.ruleset.utils.StringUtilsKt;
import org.cqfn.diktat.ruleset.utils.Style;
import org.cqfn.diktat.ruleset.utils.search.VariablesWithUsagesSearchKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u0000 62\u00020\u0001:\u0003567B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00032\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00032\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00032\u0006\u0010 \u001a\u00020\u001fH\u0002J\u001e\u0010$\u001a\u00020\u001b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00032\u0006\u0010&\u001a\u00020\u0019H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00032\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00032\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00032\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\bH\u0002J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001fH\u0002J\u0010\u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001fH\u0002Ji\u00100\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001f2\u0006\u00101\u001a\u00020\u00192O\u00102\u001aK\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b0\u0013j\u0002`\u001cH\u0016J\u0010\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001fH\u0002R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010RW\u0010\u0012\u001aK\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b0\u0013j\u0002`\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/cqfn/diktat/ruleset/rules/IdentifierNaming;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "allMethodPrefixes", "", "", "getAllMethodPrefixes", "()Ljava/util/Set;", "allMethodPrefixes$delegate", "Lkotlin/Lazy;", "configuration", "Lorg/cqfn/diktat/ruleset/rules/IdentifierNaming$BooleanFunctionsConfiguration;", "getConfiguration", "()Lorg/cqfn/diktat/ruleset/rules/IdentifierNaming$BooleanFunctionsConfiguration;", "configuration$delegate", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "checkClassNamings", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "node", "checkEnumValues", "checkExceptionSuffix", "checkFunctionName", "checkIdentifierLength", "nodes", "isVariable", "checkObjectNaming", "checkVariableName", "extractVariableIdentifiers", "hasExceptionSuffix", "text", "isIdentifierWithBackticks", "isValidCatchIdentifier", "validGenericTypeName", "generic", "visit", "autoCorrect", "emit", "warnConfusingName", "variableName", "BooleanFunctionsConfiguration", "Companion", "IdentifierNamingConfiguration", "diktat-rules"})
public final class IdentifierNaming
extends com.pinterest.ktlint.core.Rule {
    private final Lazy allMethodPrefixes$delegate;
    @NotNull
    private final Lazy configuration$delegate;
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;
    public static final int MAX_IDENTIFIER_LENGTH = 64;
    public static final int MIN_IDENTIFIER_LENGTH = 2;
    @NotNull
    private static final Set<String> oneCharIdentifiers;
    @NotNull
    private static final Set<String> booleanMethodPrefixes;
    @NotNull
    private static final Set<String> confusingIdentifierNames;
    @NotNull
    public static final Companion Companion;

    private final Set<String> getAllMethodPrefixes() {
        Lazy lazy = this.allMethodPrefixes$delegate;
        IdentifierNaming identifierNaming = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final BooleanFunctionsConfiguration getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        IdentifierNaming identifierNaming = this;
        Object var3_3 = null;
        boolean bl = false;
        return (BooleanFunctionsConfiguration)((Object)lazy.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block1: {
            void identifierNodes;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(emit, (String)"emit");
            this.isFixMode = autoCorrect;
            this.emitWarn = emit;
            if (this.isIdentifierWithBackticks(node)) {
                return;
            }
            IElementType iElementType = node.getElementType();
            Pair pair = Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCLASS()) ? new Pair(this.checkClassNamings(node), (Object)false) : (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getOBJECT_DECLARATION()) ? new Pair(this.checkObjectNaming(node), (Object)false) : (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getPROPERTY()) || Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_PARAMETER()) ? new Pair(this.checkVariableName(node), (Object)true) : (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getENUM_ENTRY()) ? new Pair(this.checkEnumValues(node), (Object)false) : (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getFUN()) ? new Pair(this.checkFunctionName(node), (Object)false) : new Pair(null, (Object)false)))));
            List list = (List)pair.component1();
            boolean isVariable = (Boolean)pair.component2();
            void v0 = identifierNodes;
            if (v0 == null) break block1;
            pair = v0;
            boolean bl = false;
            boolean bl2 = false;
            Pair it = pair;
            boolean bl3 = false;
            this.checkIdentifierLength((List<? extends ASTNode>)it, isVariable);
        }
    }

    private final boolean isIdentifierWithBackticks(ASTNode node) {
        ASTNode identifier = AstNodeUtilsKt.getIdentifierName(node);
        if (identifier != null && Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getREFERENCE_EXPRESSION()) ^ true) {
            String string = identifier.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"identifier.text");
            String identifierText = string;
            if (StringsKt.startsWith$default((CharSequence)identifierText, (char)'`', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)identifierText, (char)'`', (boolean)false, (int)2, null)) {
                if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFUN()) || !AstNodeUtilsKt.hasTestAnnotation(node)) {
                    Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                    if (function3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                    }
                    Warnings.BACKTICKS_PROHIBITED.warn(this.configRules, function3, this.isFixMode, identifierText, identifier.getStartOffset(), identifier);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final List<ASTNode> checkVariableName(ASTNode node) {
        namesOfVariables = this.extractVariableIdentifiers(node);
        if (!this.isFixMode) ** GOTO lbl-1000
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY())) {
            v0 = node.getPsi();
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
            }
            var4_3 = (KtProperty)v0;
            var5_4 = false;
            var6_5 = false;
            $this$run = var4_3;
            $i$a$-run-IdentifierNaming$checkVariableName$isFix$1 = false;
            v1 = $this$run.isLocal() || KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)$this$run));
        } else {
            v1 = true;
        }
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        isFix = v2;
        $this$forEach$iv = namesOfVariables;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            variableName = (ASTNode)element$iv;
            $i$a$-forEach-IdentifierNaming$checkVariableName$1 = false;
            v3 = variableName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"variableName.text");
            if (StringUtilsKt.containsOneLetterOrZero(v3) && variableName.getText().length() > 1) {
                v4 = this.emitWarn;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                v5 = variableName.getText();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"variableName.text");
                Warnings.VARIABLE_NAME_INCORRECT.warn(this.configRules, v4, this.isFixMode, v5, variableName.getStartOffset(), node);
            }
            if (IdentifierNaming.confusingIdentifierNames.contains(variableName.getText()) && !this.isValidCatchIdentifier(variableName) && Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY())) {
                this.warnConfusingName(variableName);
            }
            if (AstNodeUtilsKt.isConstant(node)) {
                v6 = variableName.getText();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"variableName.text");
                if (StringCaseUtilsKt.isUpperSnakeCase(v6) || variableName.getText().length() <= 1) continue;
                v7 = this.emitWarn;
                if (v7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                v8 = variableName.getText();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"variableName.text");
                Warnings.warnAndFix$default(Warnings.CONSTANT_UPPERCASE, this.configRules, v7, isFix, v8, variableName.getStartOffset(), node, false, (Function0)new Function0<Unit>(variableName){
                    final /* synthetic */ ASTNode $variableName;

                    public final void invoke() {
                        ASTNode aSTNode = this.$variableName;
                        if (aSTNode == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                        }
                        LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                        String string = ((LeafPsiElement)this.$variableName).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variableName.text");
                        leafPsiElement.replaceWithText(StringCaseUtilsKt.toUpperSnakeCase(string));
                    }
                    {
                        this.$variableName = aSTNode;
                        super(0);
                    }
                }, 64, null);
                continue;
            }
            if (!(Intrinsics.areEqual((Object)variableName.getText(), (Object)"_") ^ true)) continue;
            v9 = variableName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"variableName.text");
            if (StringCaseUtilsKt.isLowerCamelCase(v9)) continue;
            v10 = this.emitWarn;
            if (v10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            v11 = variableName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"variableName.text");
            Warnings.warnAndFix$default(Warnings.VARIABLE_NAME_INCORRECT_FORMAT, this.configRules, v10, isFix, v11, variableName.getStartOffset(), node, false, (Function0)new Function0<Unit>(variableName){
                final /* synthetic */ ASTNode $variableName;

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    String string = this.$variableName.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variableName.text");
                    String correctVariableName = StringCaseUtilsKt.toLowerCamelCase(string);
                    Object object = PackageKt.parent$default((ASTNode)this.$variableName, (Function1)checkVariableName.1.1.INSTANCE, (boolean)false, (int)2, null);
                    if (object != null && (object = VariablesWithUsagesSearchKt.findAllVariablesWithUsages(object, (Function1<? super KtProperty, Boolean>)((Function1)new Function1<KtProperty, Boolean>(this){
                        final /* synthetic */ checkVariableName.1.2 this$0;

                        public final boolean invoke(@NotNull KtProperty it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return Intrinsics.areEqual((Object)it.getName(), (Object)this.this$0.$variableName.getText());
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }))) != null) {
                        void $this$flatMapTo$iv$iv;
                        Object $this$flatMap$iv = object;
                        boolean $i$f$flatMap = false;
                        ASTNode aSTNode = $this$flatMap$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$flatMapTo = false;
                        void var7_8 = $this$flatMapTo$iv$iv;
                        boolean bl = false;
                        Iterator<Map.Entry<K, V>> iterator = var7_8.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv$iv;
                            Map.Entry<K, V> it = element$iv$iv = iterator.next();
                            boolean bl2 = false;
                            Iterable list$iv$iv = CollectionsKt.toList((Iterable)((Iterable)it.getValue()));
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        Iterable $this$forEach$iv = (List)destination$iv$iv;
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            KtNameReferenceExpression it = (KtNameReferenceExpression)element$iv;
                            boolean bl3 = false;
                            ASTNode aSTNode2 = it.getNode();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"it.node");
                            ASTNode aSTNode3 = aSTNode2.getFirstChildNode();
                            if (aSTNode3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                            }
                            ((LeafPsiElement)aSTNode3).replaceWithText(correctVariableName);
                        }
                    }
                    ASTNode aSTNode = this.$variableName;
                    if (aSTNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    ((LeafPsiElement)aSTNode).replaceWithText(correctVariableName);
                }
                {
                    this.$variableName = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
        namesOfVariables = this.extractVariableIdentifiers(node);
        $this$forEach$iv = namesOfVariables;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            variableName = (ASTNode)element$iv;
            $i$a$-forEach-IdentifierNaming$checkVariableName$2 = false;
            v12 = variableName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"variableName.text");
            if (!StringUtilsKt.hasPrefix(v12)) continue;
            v13 = this.emitWarn;
            if (v13 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            v14 = variableName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"variableName.text");
            Warnings.warnAndFix$default(Warnings.VARIABLE_HAS_PREFIX, this.configRules, v13, this.isFixMode, v14, variableName.getStartOffset(), node, false, (Function0)new Function0<Unit>(variableName){
                final /* synthetic */ ASTNode $variableName;

                public final void invoke() {
                    ASTNode aSTNode = this.$variableName;
                    if (aSTNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                    String string = ((LeafPsiElement)this.$variableName).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variableName.text");
                    leafPsiElement.replaceWithText(StringUtilsKt.removePrefix(string));
                }
                {
                    this.$variableName = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
        return namesOfVariables;
    }

    /*
     * Unable to fully structure code
     */
    private final void warnConfusingName(ASTNode variableName) {
        block21: {
            block20: {
                block18: {
                    block15: {
                        block17: {
                            block16: {
                                block19: {
                                    var3_2 = variableName.getText();
                                    switch (var3_2.hashCode()) {
                                        case 66: {
                                            if (!var3_2.equals("B")) ** break;
                                            break block15;
                                        }
                                        case 83: {
                                            if (!var3_2.equals("S")) ** break;
                                            break block16;
                                        }
                                        case 68: {
                                            if (!var3_2.equals("D")) ** break;
                                            ** GOTO lbl38
                                        }
                                        case 101: {
                                            if (!var3_2.equals("e")) ** break;
                                            break block17;
                                        }
                                        case 104: {
                                            if (!var3_2.equals("h")) ** break;
                                            break block18;
                                        }
                                        case 73: {
                                            if (!var3_2.equals("I")) ** break;
                                            break;
                                        }
                                        case 90: {
                                            if (!var3_2.equals("Z")) ** break;
                                            break block19;
                                        }
                                        case 108: {
                                            if (!var3_2.equals("l")) ** break;
                                            break;
                                        }
                                        case 3644: {
                                            if (!var3_2.equals("rn")) ** break;
                                            break block20;
                                        }
                                        case 109: {
                                            if (!var3_2.equals("m")) ** break;
                                            break block20;
                                        }
                                        case 110: {
                                            if (!var3_2.equals("n")) ** break;
                                            break block18;
                                        }
                                        case 79: {
                                            if (!var3_2.equals("O")) ** break;
lbl38:
                                            // 2 sources

                                            v0 = "better name is: obj, dgt";
                                            break block21;
                                        }
                                    }
                                    v0 = "better name is: it, ln, line";
                                    break block21;
                                }
                                v0 = "better name is: n1, n2";
                                break block21;
                            }
                            v0 = "better name is: xs, str";
                            break block21;
                        }
                        v0 = "better name is: ex, elm";
                        break block21;
                    }
                    v0 = "better name is: bt, nxt";
                    break block21;
                }
                v0 = "better name is: nr, head, height";
                break block21;
            }
            v0 = "better name is: mbr, item";
            break block21;
            v0 = "";
        }
        warnText = v0;
        v1 = this.emitWarn;
        if (v1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
        }
        Warnings.CONFUSING_IDENTIFIER_NAMING.warn(this.configRules, v1, false, warnText, variableName.getStartOffset(), variableName);
    }

    /*
     * Unable to fully structure code
     */
    private final List<ASTNode> extractVariableIdentifiers(ASTNode node) {
        block5: {
            block4: {
                destructingDeclaration = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getDESTRUCTURING_DECLARATION());
                if (destructingDeclaration == null) break block4;
                $this$map$iv = AstNodeUtilsKt.getAllChildrenWithType(destructingDeclaration, ElementType.INSTANCE.getDESTRUCTURING_DECLARATION_ENTRY());
                $i$f$map = false;
                var6_5 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var11_10 = (ASTNode)item$iv$iv;
                    var13_12 = destination$iv$iv;
                    $i$a$-map-IdentifierNaming$extractVariableIdentifiers$result$1 = false;
                    Intrinsics.checkNotNull((Object)AstNodeUtilsKt.getIdentifierName(it));
                    var13_12.add(var14_13);
                }
                v0 = (List)destination$iv$iv;
                break block5;
            }
            if (SequencesKt.count((Sequence)PsiUtilsKt.parents((ASTNode)node)) <= 1) ** GOTO lbl-1000
            v1 = node.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"node.treeParent");
            if (!Intrinsics.areEqual((Object)v1.getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST())) ** GOTO lbl-1000
            v2 = node.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"node.treeParent");
            v3 = v2.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"node.treeParent.treeParent");
            if (Intrinsics.areEqual((Object)v3.getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_TYPE())) {
                v0 = CollectionsKt.listOfNotNull((Object)AstNodeUtilsKt.getIdentifierName(node));
            } else lbl-1000:
            // 3 sources

            {
                v4 = AstNodeUtilsKt.getIdentifierName(node);
                Intrinsics.checkNotNull((Object)v4);
                v0 = CollectionsKt.listOf((Object)v4);
            }
        }
        result = v0;
        $this$filterNot$iv = result;
        $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            $i$a$-filterNot-IdentifierNaming$extractVariableIdentifiers$1 = false;
            if (IdentifierNaming.oneCharIdentifiers.contains(it.getText())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<ASTNode> checkClassNamings(ASTNode node) {
        ASTNode genericType = AstNodeUtilsKt.getTypeParameterList(node);
        if (genericType != null && !this.validGenericTypeName(genericType)) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string = genericType.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"genericType.text");
            Warnings.warnAndFix$default(Warnings.GENERIC_NAME, this.configRules, function3, this.isFixMode, string, genericType.getStartOffset(), genericType, false, checkClassNamings.1.INSTANCE, 64, null);
        }
        ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(node);
        if (aSTNode == null) {
            return CollectionsKt.emptyList();
        }
        ASTNode className = aSTNode;
        String string = className.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.text");
        if (!StringCaseUtilsKt.isPascalCase(string)) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string2 = className.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"className.text");
            Warnings.warnAndFix$default(Warnings.CLASS_NAME_INCORRECT, this.configRules, function3, this.isFixMode, string2, className.getStartOffset(), className, false, (Function0)new Function0<Unit>(className){
                final /* synthetic */ ASTNode $className;

                public final void invoke() {
                    ASTNode aSTNode = this.$className;
                    if (aSTNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                    String string = ((LeafPsiElement)this.$className).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.text");
                    leafPsiElement.replaceWithText(StringCaseUtilsKt.toPascalCase(string));
                }
                {
                    this.$className = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
        this.checkExceptionSuffix(node);
        return CollectionsKt.listOf((Object)className);
    }

    private final void checkExceptionSuffix(ASTNode node) {
        String superClassName;
        ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(node);
        if (aSTNode == null) {
            return;
        }
        ASTNode classNameNode = aSTNode;
        ASTNode aSTNode2 = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getSUPER_TYPE_LIST());
        String string = aSTNode2 != null && (aSTNode2 = AstNodeUtilsKt.findLeafWithSpecificType(aSTNode2, ElementType.INSTANCE.getTYPE_REFERENCE())) != null ? aSTNode2.getText() : (superClassName = null);
        if (superClassName != null && this.hasExceptionSuffix(superClassName)) {
            String string2 = classNameNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classNameNode.text");
            if (!this.hasExceptionSuffix(string2)) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                String string3 = classNameNode.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"classNameNode.text");
                Warnings.warnAndFix$default(Warnings.EXCEPTION_SUFFIX, this.configRules, function3, this.isFixMode, string3, classNameNode.getStartOffset(), classNameNode, false, (Function0)new Function0<Unit>(classNameNode){
                    final /* synthetic */ ASTNode $classNameNode;

                    public final void invoke() {
                        ASTNode aSTNode = this.$classNameNode;
                        if (aSTNode == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                        }
                        ((LeafPsiElement)aSTNode).replaceWithText(((LeafPsiElement)this.$classNameNode).getText() + "Exception");
                    }
                    {
                        this.$classNameNode = aSTNode;
                        super(0);
                    }
                }, 64, null);
            }
        }
    }

    private final boolean hasExceptionSuffix(String text) {
        String string = text;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        return StringsKt.endsWith$default((String)string3, (String)"exception", (boolean)false, (int)2, null);
    }

    private final List<ASTNode> checkObjectNaming(ASTNode node) {
        ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(node);
        if (aSTNode == null) {
            return CollectionsKt.emptyList();
        }
        ASTNode objectName = aSTNode;
        String string = objectName.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectName.text");
        if (!StringCaseUtilsKt.isPascalCase(string)) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string2 = objectName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"objectName.text");
            Warnings.warnAndFix$default(Warnings.OBJECT_NAME_INCORRECT, this.configRules, function3, this.isFixMode, string2, objectName.getStartOffset(), objectName, false, (Function0)new Function0<Unit>(objectName){
                final /* synthetic */ ASTNode $objectName;

                public final void invoke() {
                    ASTNode aSTNode = this.$objectName;
                    if (aSTNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                    String string = ((LeafPsiElement)this.$objectName).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectName.text");
                    leafPsiElement.replaceWithText(StringCaseUtilsKt.toPascalCase(string));
                }
                {
                    this.$objectName = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
        return CollectionsKt.listOf((Object)objectName);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ASTNode> checkEnumValues(ASTNode node) {
        void $this$filterTo$iv$iv;
        ASTNode[] aSTNodeArray = node.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node.getChildren(null)");
        ASTNode[] $this$filter$iv = aSTNodeArray;
        boolean $i$f$filter = false;
        ASTNode[] aSTNodeArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var8_8 = $this$filterTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var8_8[i];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            if (!Intrinsics.areEqual((Object)v1.getElementType(), (Object)ElementType.INSTANCE.getIDENTIFIER())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enumValues = (List)destination$iv$iv;
        Iterable $this$forEach$iv = enumValues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FunctionReferenceImpl functionReferenceImpl;
            FunctionReferenceImpl functionReferenceImpl2;
            ASTNode value = (ASTNode)element$iv;
            boolean bl = false;
            Object object = RulesConfigReaderKt.getRuleConfig(this.configRules, (Rule)Warnings.ENUM_VALUE);
            if (object == null || (object = object.getConfiguration()) == null) {
                object = MapsKt.emptyMap();
            }
            IdentifierNamingConfiguration configuration2 = new IdentifierNamingConfiguration((Map<String, String>)object);
            switch (IdentifierNaming$WhenMappings.$EnumSwitchMapping$0[configuration2.getEnumStyle().ordinal()]) {
                case 1: {
                    functionReferenceImpl2 = checkEnumValues.1.validator.1.INSTANCE;
                    break;
                }
                case 2: {
                    functionReferenceImpl2 = checkEnumValues.1.validator.2.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            FunctionReferenceImpl validator2 = functionReferenceImpl2;
            switch (IdentifierNaming$WhenMappings.$EnumSwitchMapping$1[configuration2.getEnumStyle().ordinal()]) {
                case 1: {
                    functionReferenceImpl = checkEnumValues.1.autofix.1.INSTANCE;
                    break;
                }
                case 2: {
                    functionReferenceImpl = checkEnumValues.1.autofix.2.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            FunctionReferenceImpl autofix2 = functionReferenceImpl;
            Function1 function1 = validator2;
            String string = value.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.text");
            if (!((Boolean)function1.invoke((Object)string)).booleanValue()) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                String string2 = value.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.text");
                Warnings.warnAndFix$default(Warnings.ENUM_VALUE, this.configRules, function3, this.isFixMode, string2, value.getStartOffset(), value, false, (Function0)new Function0<Unit>(value, (KFunction)autofix2){
                    final /* synthetic */ ASTNode $value;
                    final /* synthetic */ KFunction $autofix;

                    public final void invoke() {
                        ASTNode aSTNode = this.$value;
                        if (aSTNode == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                        }
                        LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                        Function1 function1 = (Function1)this.$autofix;
                        String string = ((LeafPsiElement)this.$value).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.text");
                        leafPsiElement.replaceWithText((String)function1.invoke((Object)string));
                    }
                    {
                        this.$value = aSTNode;
                        this.$autofix = kFunction;
                        super(0);
                    }
                }, 64, null);
            }
            if (!confusingIdentifierNames.contains(value.getText())) continue;
            this.warnConfusingName(value);
        }
        return enumValues;
    }

    private final List<ASTNode> checkFunctionName(ASTNode node) {
        String functionReturnType;
        ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(node);
        Intrinsics.checkNotNull((Object)aSTNode);
        ASTNode functionName = aSTNode;
        String string = functionName.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"functionName.text");
        if (!StringCaseUtilsKt.isLowerCamelCase(string)) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string2 = functionName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"functionName.text");
            Warnings.warnAndFix$default(Warnings.FUNCTION_NAME_INCORRECT_CASE, this.configRules, function3, this.isFixMode, string2, functionName.getStartOffset(), functionName, false, (Function0)new Function0<Unit>(functionName){
                final /* synthetic */ ASTNode $functionName;

                public final void invoke() {
                    ASTNode aSTNode = this.$functionName;
                    if (aSTNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                    String string = ((LeafPsiElement)this.$functionName).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"functionName.text");
                    leafPsiElement.replaceWithText(StringCaseUtilsKt.toLowerCamelCase(string));
                }
                {
                    this.$functionName = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
        ASTNode aSTNode2 = AstNodeUtilsKt.findChildAfter(node, ElementType.INSTANCE.getVALUE_PARAMETER_LIST(), ElementType.INSTANCE.getTYPE_REFERENCE());
        String string3 = functionReturnType = aSTNode2 != null ? aSTNode2.getText() : null;
        if (!AstNodeUtilsKt.isOverridden(node) && functionReturnType != null && Intrinsics.areEqual((Object)functionReturnType, (Object)PrimitiveType.BOOLEAN.getTypeName().asString())) {
            boolean bl;
            block8: {
                Iterable $this$none$iv = this.getAllMethodPrefixes();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        String string4 = functionName.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"functionName.text");
                        if (!StringsKt.startsWith$default((String)string4, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                String string5 = functionName.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"functionName.text");
                Warnings.warnAndFix$default(Warnings.FUNCTION_BOOLEAN_PREFIX, this.configRules, function3, this.isFixMode, string5, functionName.getStartOffset(), functionName, false, checkFunctionName.3.INSTANCE, 64, null);
            }
        }
        return CollectionsKt.listOf((Object)functionName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validGenericTypeName(ASTNode generic) {
        ASTNode[] aSTNodeArray = generic.getChildren(TokenSet.create((IElementType[])new IElementType[]{ElementType.INSTANCE.getTYPE_PARAMETER()}));
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"generic.getChildren(Toke\u2026t.create(TYPE_PARAMETER))");
        ASTNode[] $this$all$iv = aSTNodeArray;
        boolean $i$f$all = false;
        ASTNode[] aSTNodeArray2 = $this$all$iv;
        int n = aSTNodeArray2.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode element$iv;
            ASTNode it = element$iv = aSTNodeArray2[n2];
            boolean bl = false;
            ASTNode aSTNode = it;
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it");
            ASTNode aSTNode2 = AstNodeUtilsKt.getIdentifierName(aSTNode);
            Object object = aSTNode2;
            if (aSTNode2 == null) return false;
            String string = object.getText();
            object = string;
            if (string == null) return false;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.getIdentifierName()?.text ?: return false");
            Object typeText = object;
            char c = ((String)typeText).charAt(0);
            if ('A' > c) return false;
            if ('Z' < c) return false;
            if (((String)typeText).length() != 1) {
                Object object2 = typeText;
                int n3 = 1;
                boolean bl2 = false;
                Object object3 = object2;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)object3).substring(n3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                if (!StringUtilsKt.isDigits(string2)) return false;
            }
            boolean bl3 = true;
            if (!bl3) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private final void checkIdentifierLength(List<? extends ASTNode> nodes, boolean isVariable) {
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n;
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getText(), (Object)"_") ^ true) || AstNodeUtilsKt.isTextLengthInRange(it, new IntRange(n = 2, 64)) || oneCharIdentifiers.contains(it.getText()) && isVariable || this.isValidCatchIdentifier(it)) continue;
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            Warnings.IDENTIFIER_LENGTH.warn(this.configRules, function3, this.isFixMode, string, it.getStartOffset(), it);
        }
    }

    private final boolean isValidCatchIdentifier(ASTNode node) {
        ASTNode parentValueParamList = AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getVALUE_PARAMETER_LIST());
        ASTNode aSTNode = parentValueParamList;
        boolean prevCatchKeyWord = Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = PackageKt.prevCodeSibling((ASTNode)aSTNode)) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getCATCH_KEYWORD());
        return Intrinsics.areEqual((Object)node.getText(), (Object)"e") && AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getCATCH()) != null && prevCatchKeyWord;
    }

    public IdentifierNaming(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("identifier-naming");
        this.configRules = configRules;
        this.allMethodPrefixes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ IdentifierNaming this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<String> invoke() {
                Set set;
                Iterable<E> iterable = this.this$0.getConfiguration().getAllowedBooleanPrefixes();
                boolean bl = false;
                boolean bl2 = false;
                if (iterable == null || iterable.isEmpty()) {
                    set = IdentifierNaming.Companion.getBooleanMethodPrefixes();
                } else {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    iterable = this.this$0.getConfiguration().getAllowedBooleanPrefixes();
                    Set<String> set2 = IdentifierNaming.Companion.getBooleanMethodPrefixes();
                    boolean $i$f$filter = false;
                    void var3_4 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl3 = false;
                        CharSequence charSequence = it;
                        boolean bl4 = false;
                        if (!(charSequence.length() > 0)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List list = (List)destination$iv$iv;
                    set = SetsKt.plus(set2, (Iterable)list);
                }
                return set;
            }
            {
                this.this$0 = identifierNaming;
                super(0);
            }
        }));
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BooleanFunctionsConfiguration>(this){
            final /* synthetic */ IdentifierNaming this$0;

            @NotNull
            public final BooleanFunctionsConfiguration invoke() {
                Object object = RulesConfigReaderKt.getRuleConfig((List)IdentifierNaming.access$getConfigRules$p(this.this$0), (Rule)Warnings.FUNCTION_BOOLEAN_PREFIX);
                if (object == null || (object = object.getConfiguration()) == null) {
                    object = MapsKt.emptyMap();
                }
                return new BooleanFunctionsConfiguration((Map<String, String>)object);
            }
            {
                this.this$0 = identifierNaming;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        oneCharIdentifiers = SetsKt.setOf((Object[])new String[]{"i", "j", "k", "x", "y", "z"});
        booleanMethodPrefixes = SetsKt.setOf((Object[])new String[]{"has", "is", "are", "have", "should"});
        confusingIdentifierNames = SetsKt.setOf((Object[])new String[]{"O", "D", "I", "l", "Z", "S", "e", "B", "h", "n", "m", "rn"});
    }

    public static final /* synthetic */ List access$getConfigRules$p(IdentifierNaming $this) {
        return $this.configRules;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b*\u00020\u00078BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/IdentifierNaming$IdentifierNamingConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "enumStyle", "Lorg/cqfn/diktat/ruleset/utils/Style;", "getEnumStyle", "()Lorg/cqfn/diktat/ruleset/utils/Style;", "isEnumStyle", "", "isEnumStyle$annotations", "(Lorg/cqfn/diktat/ruleset/utils/Style;)V", "(Lorg/cqfn/diktat/ruleset/utils/Style;)Z", "diktat-rules"})
    public static final class IdentifierNamingConfiguration
    extends RuleConfiguration {
        @NotNull
        private final Style enumStyle;

        private static /* synthetic */ void isEnumStyle$annotations(Style style) {
        }

        private final boolean isEnumStyle(Style $this$isEnumStyle) {
            return CollectionsKt.listOf((Object[])new Style[]{Style.PASCAL_CASE, Style.SNAKE_CASE}).contains((Object)$this$isEnumStyle);
        }

        @NotNull
        public final Style getEnumStyle() {
            return this.enumStyle;
        }

        /*
         * WARNING - void declaration
         */
        public IdentifierNamingConfiguration(@NotNull Map<String, String> config) {
            Style style;
            Intrinsics.checkNotNullParameter(config, (String)"config");
            super(config);
            IdentifierNamingConfiguration identifierNamingConfiguration = this;
            String string = config.get("enumStyle");
            if (string != null) {
                Style style2;
                void styleString;
                IdentifierNamingConfiguration identifierNamingConfiguration2;
                block4: {
                    Style style3;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String string3 = string2;
                    identifierNamingConfiguration2 = identifierNamingConfiguration;
                    boolean bl3 = false;
                    Style[] $this$firstOrNull$iv = Style.values();
                    boolean $i$f$firstOrNull = false;
                    Style[] styleArray = $this$firstOrNull$iv;
                    int n = styleArray.length;
                    for (int i = 0; i < n; ++i) {
                        Style element$iv;
                        Style it = element$iv = styleArray[i];
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)StringCaseUtilsKt.toUpperSnakeCase((String)styleString))) continue;
                        style3 = element$iv;
                        break block4;
                    }
                    style3 = style2 = null;
                }
                if (style2 == null || !this.isEnumStyle(style2)) {
                    String string4 = (String)styleString + " is unsupported for enum style";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string4.toString());
                }
                Style style4 = style2;
                identifierNamingConfiguration = identifierNamingConfiguration2;
                style = style4;
            } else {
                style = Style.SNAKE_CASE;
            }
            identifierNamingConfiguration.enumStyle = style;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/IdentifierNaming$BooleanFunctionsConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "allowedBooleanPrefixes", "", "getAllowedBooleanPrefixes", "()Ljava/util/List;", "diktat-rules"})
    public static final class BooleanFunctionsConfiguration
    extends RuleConfiguration {
        @NotNull
        private final List<String> allowedBooleanPrefixes;

        @NotNull
        public final List<String> getAllowedBooleanPrefixes() {
            return this.allowedBooleanPrefixes;
        }

        /*
         * WARNING - void declaration
         */
        public BooleanFunctionsConfiguration(@NotNull Map<String, String> config) {
            List list;
            Intrinsics.checkNotNullParameter(config, (String)"config");
            super(config);
            BooleanFunctionsConfiguration booleanFunctionsConfiguration = this;
            Object object = config.get("allowedPrefixes");
            if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) != null) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = (Iterable)object;
                BooleanFunctionsConfiguration booleanFunctionsConfiguration2 = booleanFunctionsConfiguration;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void var11_12 = it;
                    boolean bl2 = false;
                    void v2 = var11_12;
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v2))).toString();
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv;
                booleanFunctionsConfiguration = booleanFunctionsConfiguration2;
                list = collection;
            } else {
                list = CollectionsKt.emptyList();
            }
            booleanFunctionsConfiguration.allowedBooleanPrefixes = list;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/IdentifierNaming$Companion;", "", "()V", "MAX_IDENTIFIER_LENGTH", "", "MIN_IDENTIFIER_LENGTH", "booleanMethodPrefixes", "", "", "getBooleanMethodPrefixes", "()Ljava/util/Set;", "confusingIdentifierNames", "getConfusingIdentifierNames", "oneCharIdentifiers", "getOneCharIdentifiers", "diktat-rules"})
    public static final class Companion {
        @NotNull
        public final Set<String> getOneCharIdentifiers() {
            return oneCharIdentifiers;
        }

        @NotNull
        public final Set<String> getBooleanMethodPrefixes() {
            return booleanMethodPrefixes;
        }

        @NotNull
        public final Set<String> getConfusingIdentifierNames() {
            return confusingIdentifierNames;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

