/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.LineLength;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.KotlinParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 ?2\u00020\u0001:\u0003?@AB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#H\u0002J\u001e\u0010$\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190&H\u0002J\u0010\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u0019H\u0002J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u0017H\u0002J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u00102\u0006\u0010\"\u001a\u000202H\u0002J\u0018\u00103\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u0019H\u0002J\u0010\u00105\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u0018\u00106\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u00107\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u001e\u00108\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190&H\u0002J \u00109\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\bH\u0002Ji\u0010<\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010=\u001a\u00020\u000e2O\u0010>\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00150\u0014X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/cqfn/diktat/ruleset/rules/LineLength;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "positionByOffset", "Lkotlin/Function1;", "Lkotlin/Pair;", "checkComment", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases;", "wrongNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "configuration", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LineLengthConfiguration;", "checkCondition", "checkFun", "checkLength", "node", "checkProperty", "createSplitProperty", "wrongProperty", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$Property;", "dfsForProperty", "binList", "", "findAllText", "astNode", "fixComment", "wrongComment", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$Comment;", "fixError", "fixableType", "fixLongBinaryExpression", "wrongBinaryExpression", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$Condition;", "fixLongString", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$PropertyWithTemplateEntry;", "getBraceAndBeforeText", "prevNode", "getTextFromParenthesized", "isFixable", "isKdocValid", "searchBinaryExpression", "splitTextAndCreateNode", "text", "index", "visit", "autoCorrect", "emit", "Companion", "LineLengthConfiguration", "LongLineFixableCases", "diktat-rules"})
public final class LineLength
extends com.pinterest.ktlint.core.Rule {
    private boolean isFixMode;
    private Function1<? super Integer, Pair<Integer, Integer>> positionByOffset;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;
    private static final long MAX_LENGTH = 120L;
    private static final int STRING_PART_OFFSET = 4;
    private static final List<IElementType> propertyList;
    @NotNull
    public static final Companion Companion;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        Object object = RulesConfigReaderKt.getRuleConfig(this.configRules, (Rule)Warnings.LONG_LINE);
        if (object == null || (object = object.getConfiguration()) == null) {
            object = MapsKt.emptyMap();
        }
        LineLengthConfiguration configuration2 = new LineLengthConfiguration((Map<String, String>)object);
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            ASTNode[] aSTNodeArray = node.getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node.getChildren(null)");
            ASTNode[] $this$forEach$iv = aSTNodeArray;
            boolean $i$f$forEach = false;
            ASTNode[] aSTNodeArray2 = $this$forEach$iv;
            int n = aSTNodeArray2.length;
            for (int i = 0; i < n; ++i) {
                ASTNode element$iv;
                ASTNode it = element$iv = aSTNodeArray2[i];
                boolean bl = false;
                ASTNode aSTNode = it;
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it");
                if (!(Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getPACKAGE_DIRECTIVE()) ^ true) && !(Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getIMPORT_LIST()) ^ true)) continue;
                this.checkLength(it, configuration2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkLength(ASTNode node, LineLengthConfiguration configuration2) {
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)string);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if ((long)it.length() > configuration2.getLineLength()) {
                ASTNode newNode;
                void offset2;
                PsiElement psiElement = node.getPsi().findElementAt(offset2.element + (int)configuration2.getLineLength());
                Intrinsics.checkNotNull((Object)psiElement);
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"node.psi.findElementAt(o\u2026ion.lineLength.toInt())!!");
                ASTNode aSTNode = newNode = psiElement.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"newNode");
                if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getKDOC_TEXT()) ^ true && Intrinsics.areEqual((Object)newNode.getElementType(), (Object)ElementType.INSTANCE.getKDOC_MARKDOWN_INLINE_LINK()) ^ true || !this.isKdocValid(newNode)) {
                    ASTNode aSTNode2 = node.getTreeParent();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.treeParent");
                    this.positionByOffset = AstNodeUtilsKt.calculateLineColByOffset(aSTNode2);
                    LongLineFixableCases fixableType = this.isFixable(newNode, configuration2);
                    Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                    if (function3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                    }
                    Warnings.LONG_LINE.warnAndFix(this.configRules, function3, this.isFixMode, "max line length " + configuration2.getLineLength() + ", but was " + it.length(), offset2.element + node.getStartOffset(), node, Intrinsics.areEqual((Object)fixableType, (Object)LongLineFixableCases.None.INSTANCE) ^ true, (Function0<Unit>)((Function0)new Function0<Unit>(fixableType, this, configuration2, node, (Ref.IntRef)offset2){
                        final /* synthetic */ LongLineFixableCases $fixableType;
                        final /* synthetic */ LineLength this$0;
                        final /* synthetic */ LineLengthConfiguration $configuration$inlined;
                        final /* synthetic */ ASTNode $node$inlined;
                        final /* synthetic */ Ref.IntRef $offset$inlined;
                        {
                            this.$fixableType = longLineFixableCases;
                            this.this$0 = lineLength;
                            this.$configuration$inlined = lineLengthConfiguration;
                            this.$node$inlined = aSTNode;
                            this.$offset$inlined = intRef;
                            super(0);
                        }

                        public final void invoke() {
                            LineLength.access$fixError(this.this$0, this.$fixableType);
                        }
                    }));
                }
            }
            offset2.element += it.length() + 1;
        }
    }

    private final LongLineFixableCases isFixable(ASTNode wrongNode, LineLengthConfiguration configuration2) {
        ASTNode parent = wrongNode;
        do {
            IElementType iElementType;
            if (Intrinsics.areEqual((Object)(iElementType = parent.getElementType()), (Object)ElementType.INSTANCE.getFUN())) {
                return this.checkFun(parent);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCONDITION())) {
                return this.checkCondition(parent, configuration2);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getPROPERTY())) {
                return this.checkProperty(parent, configuration2);
            }
            if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getEOL_COMMENT())) {
                return this.checkComment(parent, configuration2);
            }
            Intrinsics.checkNotNullExpressionValue((Object)parent.getTreeParent(), (String)"parent.treeParent");
        } while (parent.getTreeParent() != null);
        return LongLineFixableCases.None.INSTANCE;
    }

    private final LongLineFixableCases checkFun(ASTNode wrongNode) {
        return !AstNodeUtilsKt.hasChildOfType(wrongNode, ElementType.INSTANCE.getBLOCK()) ? (LongLineFixableCases)new LongLineFixableCases.Fun(wrongNode) : (LongLineFixableCases)LongLineFixableCases.None.INSTANCE;
    }

    private final LongLineFixableCases checkComment(ASTNode wrongNode, LineLengthConfiguration configuration2) {
        Function1<? super Integer, Pair<Integer, Integer>> function1 = this.positionByOffset;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"positionByOffset");
        }
        int leftOffset = ((Number)((Pair)function1.invoke((Object)wrongNode.getStartOffset())).getSecond()).intValue();
        String string = wrongNode.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrongNode.text");
        String string2 = string;
        int n = 0;
        int n2 = (int)configuration2.getLineLength() - leftOffset;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        int indexLastSpace = StringsKt.lastIndexOf$default((CharSequence)string4, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (indexLastSpace == -1) {
            return LongLineFixableCases.None.INSTANCE;
        }
        return new LongLineFixableCases.Comment(wrongNode, indexLastSpace);
    }

    private final LongLineFixableCases checkCondition(ASTNode wrongNode, LineLengthConfiguration configuration2) {
        Function1<? super Integer, Pair<Integer, Integer>> function1 = this.positionByOffset;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"positionByOffset");
        }
        ASTNode aSTNode = wrongNode.getFirstChildNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"wrongNode.firstChildNode");
        int leftOffset = ((Number)((Pair)function1.invoke((Object)aSTNode.getStartOffset())).getSecond()).intValue();
        boolean bl = false;
        List binList = new ArrayList();
        this.searchBinaryExpression(wrongNode, binList);
        if (binList.size() == 1) {
            return LongLineFixableCases.None.INSTANCE;
        }
        return new LongLineFixableCases.Condition(configuration2.getLineLength(), leftOffset, binList);
    }

    /*
     * WARNING - void declaration
     */
    private final LongLineFixableCases checkProperty(ASTNode wrongNode, LineLengthConfiguration configuration2) {
        ASTNode newParent = wrongNode;
        while (AstNodeUtilsKt.hasChildOfType(newParent, ElementType.INSTANCE.getPARENTHESIZED())) {
            Intrinsics.checkNotNull((Object)wrongNode.findChildByType(ElementType.INSTANCE.getPARENTHESIZED()));
        }
        if (!AstNodeUtilsKt.hasChildOfType(newParent, ElementType.INSTANCE.getSTRING_TEMPLATE())) {
            if (AstNodeUtilsKt.hasChildOfType(newParent, ElementType.INSTANCE.getBINARY_EXPRESSION())) {
                Function1<? super Integer, Pair<Integer, Integer>> function1 = this.positionByOffset;
                if (function1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"positionByOffset");
                }
                ASTNode aSTNode = newParent.findChildByType(ElementType.INSTANCE.getBINARY_EXPRESSION());
                Intrinsics.checkNotNull((Object)aSTNode);
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"newParent.findChildByType(BINARY_EXPRESSION)!!");
                int leftOffset = ((Number)((Pair)function1.invoke((Object)aSTNode.getStartOffset())).getSecond()).intValue();
                boolean bl = false;
                List binList = new ArrayList();
                this.dfsForProperty(wrongNode, binList);
                if (binList.size() == 1) {
                    return LongLineFixableCases.None.INSTANCE;
                }
                return new LongLineFixableCases.Condition(configuration2.getLineLength(), leftOffset, binList);
            }
            return LongLineFixableCases.None.INSTANCE;
        }
        Function1<? super Integer, Pair<Integer, Integer>> function1 = this.positionByOffset;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"positionByOffset");
        }
        ASTNode aSTNode = newParent.findChildByType(ElementType.INSTANCE.getSTRING_TEMPLATE());
        Intrinsics.checkNotNull((Object)aSTNode);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"newParent.findChildByType(STRING_TEMPLATE)!!");
        int leftOffset = ((Number)((Pair)function1.invoke((Object)aSTNode.getStartOffset())).getSecond()).intValue();
        ASTNode aSTNode2 = newParent.findChildByType(ElementType.INSTANCE.getSTRING_TEMPLATE());
        Intrinsics.checkNotNull((Object)aSTNode2);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"newParent.findChildByType(STRING_TEMPLATE)!!");
        if (AstNodeUtilsKt.hasChildOfType(aSTNode2, ElementType.INSTANCE.getLONG_STRING_TEMPLATE_ENTRY())) {
            void $this$filterTo$iv$iv;
            ASTNode aSTNode3 = wrongNode.findChildByType(ElementType.INSTANCE.getSTRING_TEMPLATE());
            Intrinsics.checkNotNull((Object)aSTNode3);
            ASTNode[] aSTNodeArray = aSTNode3.getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"wrongNode.findChildByTyp\u2026LATE)!!.getChildren(null)");
            ASTNode[] $this$filter$iv = aSTNodeArray;
            boolean $i$f$filter = false;
            ASTNode[] aSTNodeArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var11_20 = $this$filterTo$iv$iv;
            int n = ((void)var11_20).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var11_20[i];
                boolean bl = false;
                void v7 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"it");
                if (!propertyList.contains(v7.getElementType())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List binList = (List)destination$iv$iv;
            if (binList.size() == 1) {
                return LongLineFixableCases.None.INSTANCE;
            }
            return new LongLineFixableCases.PropertyWithTemplateEntry(wrongNode, configuration2.getLineLength(), leftOffset, CollectionsKt.toMutableList((Collection)binList));
        }
        if ((long)leftOffset > configuration2.getLineLength() - (long)4) {
            return LongLineFixableCases.None.INSTANCE;
        }
        ASTNode aSTNode4 = wrongNode.findChildByType(ElementType.INSTANCE.getSTRING_TEMPLATE());
        Intrinsics.checkNotNull((Object)aSTNode4);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"wrongNode.findChildByType(STRING_TEMPLATE)!!");
        String string = aSTNode4.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrongNode.findChildByType(STRING_TEMPLATE)!!.text");
        String text = StringsKt.trim((String)string, (char[])new char[]{'\"'});
        int lastCharIndex = (int)configuration2.getLineLength() - leftOffset - 4;
        String string2 = text;
        int n = 0;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, lastCharIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        int indexLastSpace = StringsKt.lastIndexOf$default((CharSequence)string4, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (indexLastSpace == -1) {
            return LongLineFixableCases.None.INSTANCE;
        }
        return new LongLineFixableCases.Property(wrongNode, indexLastSpace, text);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isKdocValid(ASTNode node) {
        boolean bl;
        try {
            CharSequence charSequence;
            if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getKDOC_TEXT())) {
                Object element$iv;
                block8: {
                    String string = node.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
                    charSequence = string;
                    String string2 = "\\s";
                    int n = 0;
                    string2 = new Regex(string2);
                    n = 0;
                    boolean bl2 = false;
                    List $this$last$iv = string2.split(charSequence, n);
                    boolean $i$f$last = false;
                    ListIterator iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        element$iv = iterator$iv.previous();
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        CharSequence charSequence2 = it;
                        boolean bl4 = false;
                        if (!(charSequence2.length() > 0)) continue;
                        break block8;
                    }
                    throw (Throwable)new NoSuchElementException("List contains no element matching the predicate.");
                }
                Object e = element$iv;
                String string = (String)e;
                new URL(string);
            } else {
                int n;
                block9: {
                    String string = node.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
                    charSequence = string;
                    String string3 = node.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"node.text");
                    CharSequence $this$indexOfFirst$iv = string3;
                    boolean $i$f$indexOfFirst = false;
                    int element$iv = 0;
                    int n2 = $this$indexOfFirst$iv.length();
                    while (element$iv < n2) {
                        void index$iv;
                        char it = $this$indexOfFirst$iv.charAt((int)index$iv);
                        boolean bl5 = false;
                        if (it == ']') {
                            n = index$iv;
                            break block9;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
                int n3 = n;
                int $this$indexOfFirst$iv = n3 + 2;
                int n4 = node.getTextLength() - 1;
                boolean bl6 = false;
                CharSequence charSequence3 = charSequence;
                if (charSequence3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string = ((String)charSequence3).substring($this$indexOfFirst$iv, n4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string4 = string;
                new URL(string4);
            }
            bl = true;
        }
        catch (MalformedURLException e) {
            bl = false;
        }
        return bl;
    }

    private final void fixError(LongLineFixableCases fixableType) {
        LongLineFixableCases longLineFixableCases = fixableType;
        if (longLineFixableCases instanceof LongLineFixableCases.Fun) {
            ASTNode aSTNode = ((LongLineFixableCases.Fun)fixableType).getNode();
            ASTNode aSTNode2 = ((LongLineFixableCases.Fun)fixableType).getNode().findChildByType(ElementType.INSTANCE.getEQ());
            Intrinsics.checkNotNull((Object)aSTNode2);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"fixableType.node.findChildByType(EQ)!!");
            AstNodeUtilsKt.appendNewlineMergingWhiteSpace(aSTNode, null, aSTNode2.getTreeNext());
        } else if (longLineFixableCases instanceof LongLineFixableCases.Comment) {
            this.fixComment((LongLineFixableCases.Comment)fixableType);
        } else if (longLineFixableCases instanceof LongLineFixableCases.Condition) {
            this.fixLongBinaryExpression((LongLineFixableCases.Condition)fixableType);
        } else if (longLineFixableCases instanceof LongLineFixableCases.Property) {
            this.createSplitProperty((LongLineFixableCases.Property)fixableType);
        } else if (longLineFixableCases instanceof LongLineFixableCases.PropertyWithTemplateEntry) {
            this.fixLongString((LongLineFixableCases.PropertyWithTemplateEntry)fixableType);
        } else if (longLineFixableCases instanceof LongLineFixableCases.None) {
            return;
        }
    }

    private final void fixComment(LongLineFixableCases.Comment wrongComment) {
        ASTNode wrongNode = wrongComment.getNode();
        int indexLastSpace = wrongComment.getIndexLastSpace();
        StringBuilder stringBuilder = new StringBuilder().append("//");
        String string = wrongNode.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrongNode.text");
        String string2 = string;
        int n = wrongNode.getText().length();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(indexLastSpace, n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String nodeText = stringBuilder.append(string4).toString();
        string2 = wrongNode.getTreeParent();
        n = 0;
        bl = false;
        String $this$run = string2;
        boolean bl2 = false;
        IElementType iElementType = ElementType.INSTANCE.getEOL_COMMENT();
        String string5 = wrongNode.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"wrongNode.text");
        String string6 = string5;
        int n2 = 0;
        int n3 = indexLastSpace;
        boolean bl3 = false;
        String string7 = string6;
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(n2, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        $this$run.addChild((ASTNode)new LeafPsiElement(iElementType, (CharSequence)string8), wrongNode);
        $this$run.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), wrongNode);
        $this$run.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getEOL_COMMENT(), (CharSequence)nodeText), wrongNode);
        $this$run.removeChild(wrongNode);
    }

    /*
     * WARNING - void declaration
     */
    private final void fixLongBinaryExpression(LongLineFixableCases.Condition wrongBinaryExpression) {
        int leftOffset = wrongBinaryExpression.getLeftOffset();
        List<ASTNode> binList = wrongBinaryExpression.getBinList();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = "";
        Iterable $this$forEachIndexed$iv = binList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            ASTNode nextNode2;
            void astNode;
            void binaryText;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ASTNode aSTNode = (ASTNode)item$iv;
            int index = n;
            boolean bl2 = false;
            binaryText.element = (String)binaryText.element + this.findAllText((ASTNode)astNode);
            if ((long)(leftOffset + ((String)binaryText.element).length()) <= wrongBinaryExpression.getMaximumLineLength() || index == 0) continue;
            ASTNode aSTNode2 = PackageKt.parent$default((ASTNode)astNode, (Function1)((Function1)new Function1<ASTNode, Boolean>(index, this, (Ref.ObjectRef)binaryText, wrongBinaryExpression, leftOffset, binList){
                final /* synthetic */ int $index;
                final /* synthetic */ LineLength this$0;
                final /* synthetic */ Ref.ObjectRef $binaryText$inlined;
                final /* synthetic */ LongLineFixableCases.Condition $wrongBinaryExpression$inlined;
                final /* synthetic */ int $leftOffset$inlined;
                final /* synthetic */ List $binList$inlined;
                {
                    this.$index = n;
                    this.this$0 = lineLength;
                    this.$binaryText$inlined = objectRef;
                    this.$wrongBinaryExpression$inlined = condition;
                    this.$leftOffset$inlined = n2;
                    this.$binList$inlined = list;
                    super(1);
                }

                public final boolean invoke(@NotNull ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return SequencesKt.contains((Sequence)PsiUtilsKt.parents((ASTNode)((ASTNode)this.$binList$inlined.get(this.$index - 1))), (Object)it);
                }
            }), (boolean)false, (int)2, null);
            Intrinsics.checkNotNull((Object)aSTNode2);
            ASTNode commonParent = aSTNode2;
            ASTNode aSTNode3 = commonParent.findChildByType(ElementType.INSTANCE.getOPERATION_REFERENCE());
            Intrinsics.checkNotNull((Object)aSTNode3);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"commonParent.findChildBy\u2026pe(OPERATION_REFERENCE)!!");
            ASTNode aSTNode4 = nextNode2 = aSTNode3.getTreeNext();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"nextNode");
            String string = aSTNode4.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextNode.text");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                AstNodeUtilsKt.appendNewlineMergingWhiteSpace(commonParent, nextNode2, nextNode2);
            }
            return;
        }
    }

    private final String findAllText(ASTNode astNode) {
        ASTNode aSTNode;
        ASTNode node;
        String text;
        block11: {
            text = "";
            node = astNode;
            ASTNode prevNode = null;
            do {
                prevNode = node;
                Intrinsics.checkNotNullExpressionValue((Object)node.getTreeParent(), (String)"node.treeParent");
                if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPARENTHESIZED())) continue;
                text = text + this.getTextFromParenthesized(node);
            } while (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION()) ^ true);
            if (Intrinsics.areEqual((Object)node.getFirstChildNode(), (Object)prevNode)) {
                if (node.getTreePrev() != null) {
                    ASTNode aSTNode2 = node.getTreePrev();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.treePrev");
                    if (Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                        StringBuilder stringBuilder = new StringBuilder().append(text);
                        ASTNode aSTNode3 = node.getTreePrev();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"node.treePrev");
                        text = stringBuilder.append(aSTNode3.getText()).toString();
                    }
                }
            } else if (prevNode.getTreePrev() != null) {
                ASTNode aSTNode4 = prevNode.getTreePrev();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"prevNode.treePrev");
                if (Intrinsics.areEqual((Object)aSTNode4.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                    StringBuilder stringBuilder = new StringBuilder().append(text);
                    ASTNode aSTNode5 = prevNode.getTreePrev();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode5, (String)"prevNode.treePrev");
                    text = stringBuilder.append(aSTNode5.getText()).toString();
                }
            }
            while (true) {
                ASTNode aSTNode6 = node.getTreeParent();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode6, (String)"node.treeParent");
                if (!Intrinsics.areEqual((Object)aSTNode6.getElementType(), (Object)ElementType.INSTANCE.getPARENTHESIZED())) break;
                Intrinsics.checkNotNullExpressionValue((Object)node.getTreeParent(), (String)"node.treeParent");
                text = text + this.getBraceAndBeforeText(node, prevNode);
            }
            text = text + astNode.getText();
            ASTNode aSTNode7 = PackageKt.parent((ASTNode)astNode, (Function1)findAllText.1.INSTANCE, (boolean)false);
            if (aSTNode7 == null) {
                return text;
            }
            ASTNode $this$nextSibling$iv = node = aSTNode7;
            boolean $i$f$nextSibling = false;
            for (ASTNode n$iv = $this$nextSibling$iv.getTreeNext(); n$iv != null; n$iv = n$iv.getTreeNext()) {
                ASTNode it = n$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) continue;
                aSTNode = n$iv;
                break block11;
            }
            aSTNode = null;
        }
        Intrinsics.checkNotNull(aSTNode);
        node = aSTNode;
        ASTNode aSTNode8 = node.getTreePrev();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode8, (String)"node.treePrev");
        if (Intrinsics.areEqual((Object)aSTNode8.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
            StringBuilder stringBuilder = new StringBuilder().append(text);
            ASTNode aSTNode9 = node.getTreePrev();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode9, (String)"node.treePrev");
            text = stringBuilder.append(aSTNode9.getText()).toString();
        }
        text = text + node.getText();
        return text;
    }

    private final String getBraceAndBeforeText(ASTNode node, ASTNode prevNode) {
        IElementType iElementType;
        block8: {
            block7: {
                IElementType iElementType2;
                ASTNode it;
                ASTNode $this$prevSibling$iv;
                block6: {
                    $this$prevSibling$iv = prevNode;
                    boolean $i$f$prevSibling = false;
                    for (ASTNode n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                        it = n$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) continue;
                        iElementType2 = n$iv;
                        break block6;
                    }
                    iElementType2 = iElementType = null;
                }
                if (iElementType2 == null) break block7;
                $this$prevSibling$iv = iElementType;
                boolean bl = false;
                boolean bl2 = false;
                it = $this$prevSibling$iv;
                boolean bl3 = false;
                iElementType = ElementType.INSTANCE.getLPAR();
                if (iElementType != null) break block8;
            }
            iElementType = ElementType.INSTANCE.getRPAR();
        }
        IElementType par = iElementType;
        String text = "";
        ASTNode aSTNode = node.findChildByType(par);
        Intrinsics.checkNotNull((Object)aSTNode);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.findChildByType(par)!!");
        if (aSTNode.getTreePrev() != null) {
            ASTNode aSTNode2 = node.findChildByType(par);
            Intrinsics.checkNotNull((Object)aSTNode2);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.findChildByType(par)!!");
            ASTNode aSTNode3 = aSTNode2.getTreePrev();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"node.findChildByType(par)!!.treePrev");
            if (Intrinsics.areEqual((Object)aSTNode3.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                StringBuilder stringBuilder = new StringBuilder().append(text);
                ASTNode aSTNode4 = node.findChildByType(par);
                Intrinsics.checkNotNull((Object)aSTNode4);
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"node.findChildByType(par)!!");
                ASTNode aSTNode5 = aSTNode4.getTreePrev();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode5, (String)"node.findChildByType(par)!!.treePrev");
                text = stringBuilder.append(aSTNode5.getText()).toString();
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append(text);
        ASTNode aSTNode6 = node.findChildByType(par);
        Intrinsics.checkNotNull((Object)aSTNode6);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode6, (String)"node.findChildByType(par)!!");
        text = stringBuilder.append(aSTNode6.getText()).toString();
        return text;
    }

    private final String getTextFromParenthesized(ASTNode node) {
        String text = "";
        StringBuilder stringBuilder = new StringBuilder().append(text);
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getLPAR());
        Intrinsics.checkNotNull((Object)aSTNode);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.findChildByType(LPAR)!!");
        text = stringBuilder.append(aSTNode.getText()).toString();
        ASTNode aSTNode2 = node.findChildByType(ElementType.INSTANCE.getLPAR());
        Intrinsics.checkNotNull((Object)aSTNode2);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.findChildByType(LPAR)!!");
        ASTNode aSTNode3 = aSTNode2.getTreeNext();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"node.findChildByType(LPAR)!!.treeNext");
        if (Intrinsics.areEqual((Object)aSTNode3.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
            StringBuilder stringBuilder2 = new StringBuilder().append(text);
            ASTNode aSTNode4 = node.findChildByType(ElementType.INSTANCE.getLPAR());
            Intrinsics.checkNotNull((Object)aSTNode4);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"node.findChildByType(LPAR)!!");
            ASTNode aSTNode5 = aSTNode4.getTreeNext();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode5, (String)"node.findChildByType(LPAR)!!.treeNext");
            text = stringBuilder2.append(aSTNode5.getText()).toString();
        }
        ASTNode aSTNode6 = node.findChildByType(ElementType.INSTANCE.getRPAR());
        Intrinsics.checkNotNull((Object)aSTNode6);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode6, (String)"node.findChildByType(RPAR)!!");
        ASTNode aSTNode7 = aSTNode6.getTreePrev();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode7, (String)"node.findChildByType(RPAR)!!.treePrev");
        if (Intrinsics.areEqual((Object)aSTNode7.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
            StringBuilder stringBuilder3 = new StringBuilder().append(text);
            ASTNode aSTNode8 = node.findChildByType(ElementType.INSTANCE.getRPAR());
            Intrinsics.checkNotNull((Object)aSTNode8);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode8, (String)"node.findChildByType(RPAR)!!");
            ASTNode aSTNode9 = aSTNode8.getTreePrev();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode9, (String)"node.findChildByType(RPAR)!!.treePrev");
            text = stringBuilder3.append(aSTNode9.getText()).toString();
        }
        StringBuilder stringBuilder4 = new StringBuilder().append(text);
        ASTNode aSTNode10 = node.findChildByType(ElementType.INSTANCE.getRPAR());
        Intrinsics.checkNotNull((Object)aSTNode10);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode10, (String)"node.findChildByType(RPAR)!!");
        text = stringBuilder4.append(aSTNode10.getText()).toString();
        return text;
    }

    /*
     * WARNING - void declaration
     */
    private final void searchBinaryExpression(ASTNode node, List<ASTNode> binList) {
        if (AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getBINARY_EXPRESSION()) || AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getPARENTHESIZED()) || AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getPOSTFIX_EXPRESSION())) {
            void $this$filterTo$iv$iv;
            ASTNode[] aSTNodeArray = node.getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node.getChildren(null)");
            ASTNode[] $this$filter$iv = aSTNodeArray;
            boolean $i$f$filter = false;
            ASTNode[] aSTNodeArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var8_9 = $this$filterTo$iv$iv;
            int n = ((void)var8_9).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = var8_9[i];
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                if (!(Intrinsics.areEqual((Object)v1.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION()) || Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getPARENTHESIZED()) || Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getPOSTFIX_EXPRESSION()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                ASTNode aSTNode = it;
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it");
                this.searchBinaryExpression(aSTNode, binList);
            }
        } else {
            binList.add(node);
            ASTNode aSTNode = node.getTreeParent().findChildByType(ElementType.INSTANCE.getPREFIX_EXPRESSION());
            if (aSTNode == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent.findChil\u2026FIX_EXPRESSION) ?: return");
            binList.add(aSTNode);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void dfsForProperty(ASTNode node, List<ASTNode> binList) {
        v0 = node.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"node.getChildren(null)");
        $this$forEach$iv = v0;
        $i$f$forEach = false;
        var5_5 = $this$forEach$iv;
        var6_6 = var5_5.length;
        for (var7_7 = 0; var7_7 < var6_6; ++var7_7) {
            block3: {
                it = element$iv = var5_5[var7_7];
                $i$a$-forEach-LineLength$dfsForProperty$1 = false;
                v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                if (!LineLength.propertyList.contains(v1.getElementType())) break block3;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getREFERENCE_EXPRESSION())) ** GOTO lbl-1000
                v2 = it.getTreeParent();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it.treeParent");
                if (Intrinsics.areEqual((Object)v2.getElementType(), (Object)ElementType.INSTANCE.getCALL_EXPRESSION())) {
                    v3 = it.getTreeParent();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it.treeParent");
                    binList.add(v3);
                } else lbl-1000:
                // 2 sources

                {
                    binList.add(it);
                }
            }
            this.dfsForProperty(it, binList);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fixLongString(LongLineFixableCases.PropertyWithTemplateEntry wrongProperty) {
        ASTNode wrongNode = wrongProperty.getNode();
        int leftOffset = wrongProperty.getLeftOffset();
        long lineLength = wrongProperty.getMaximumLineLength();
        List<ASTNode> binList = wrongProperty.getBinList();
        String allText2 = CollectionsKt.joinToString$default((Iterable)binList, (CharSequence)"", null, null, (int)0, null, (Function1)fixLongString.allText.1.INSTANCE, (int)30, null);
        String binaryText = "";
        Iterable $this$forEachIndexed$iv = binList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void astNode;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ASTNode aSTNode = (ASTNode)item$iv;
            int index = n;
            boolean bl2 = false;
            if ((long)(4 + leftOffset + (binaryText = binaryText + astNode.getText()).length()) <= lineLength) continue;
            if (Intrinsics.areEqual((Object)astNode.getElementType(), (Object)ElementType.INSTANCE.getLITERAL_STRING_TEMPLATE_ENTRY())) {
                int lastCharIndex = (int)lineLength - leftOffset - 4;
                String string = allText2;
                int n2 = 0;
                boolean bl3 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n2, lastCharIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                int indexLastSpace = StringsKt.lastIndexOf$default((CharSequence)string3, (char)' ', (int)0, (boolean)false, (int)6, null);
                if (indexLastSpace == -1) {
                    return;
                }
                this.splitTextAndCreateNode(wrongNode, allText2, indexLastSpace);
                return;
            }
            if (index == 0) {
                return;
            }
            this.splitTextAndCreateNode(wrongNode, allText2, binaryText.length());
            return;
        }
    }

    private final void createSplitProperty(LongLineFixableCases.Property wrongProperty) {
        ASTNode node = wrongProperty.getNode();
        int indexLastSpace = wrongProperty.getIndexLastSpace();
        String text = wrongProperty.getText();
        this.splitTextAndCreateNode(node, text, indexLastSpace);
    }

    private final void splitTextAndCreateNode(ASTNode node, String text, int index) {
        StringBuilder stringBuilder = new StringBuilder().append('\"');
        String string = text;
        int n = 0;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, index);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        StringBuilder stringBuilder2 = stringBuilder.append(string3).append("\" +\n\"");
        string = text;
        n = 0;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(index);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String resultText = stringBuilder2.append(string5).append('\"').toString();
        ASTNode newNode = KotlinParser.createNode$default(new KotlinParser(), resultText, false, 2, null);
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getSTRING_TEMPLATE());
        Intrinsics.checkNotNull((Object)aSTNode);
        node.removeChild(aSTNode);
        CompositeElement prevExp = new CompositeElement(ElementType.INSTANCE.getBINARY_EXPRESSION());
        node.addChild((ASTNode)prevExp, null);
        prevExp.addChild(newNode, null);
    }

    public LineLength(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("line-length");
        this.configRules = configRules;
    }

    static {
        Companion = new Companion(null);
        propertyList = CollectionsKt.listOf((Object[])new IElementType[]{ElementType.INSTANCE.getINTEGER_CONSTANT(), ElementType.INSTANCE.getLITERAL_STRING_TEMPLATE_ENTRY(), ElementType.INSTANCE.getFLOAT_CONSTANT(), ElementType.INSTANCE.getCHARACTER_CONSTANT(), ElementType.INSTANCE.getREFERENCE_EXPRESSION(), ElementType.INSTANCE.getBOOLEAN_CONSTANT(), ElementType.INSTANCE.getLONG_STRING_TEMPLATE_ENTRY(), ElementType.INSTANCE.getSHORT_STRING_TEMPLATE_ENTRY()});
    }

    public static final /* synthetic */ void access$fixError(LineLength $this, LongLineFixableCases fixableType) {
        $this.fixError(fixableType);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/LineLength$LineLengthConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "lineLength", "", "getLineLength", "()J", "diktat-rules"})
    public static final class LineLengthConfiguration
    extends RuleConfiguration {
        private final long lineLength;

        public final long getLineLength() {
            return this.lineLength;
        }

        public LineLengthConfiguration(@NotNull Map<String, String> config) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            super(config);
            Object object = config.get("lineLength");
            this.lineLength = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 120L;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0006\u0003\u0004\u0005\u0006\u0007\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0006\t\n\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases;", "", "()V", "Comment", "Condition", "Fun", "None", "Property", "PropertyWithTemplateEntry", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$None;", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$Comment;", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$Condition;", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$Fun;", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$Property;", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$PropertyWithTemplateEntry;", "diktat-rules"})
    public static abstract class LongLineFixableCases {
        private LongLineFixableCases() {
        }

        public /* synthetic */ LongLineFixableCases(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$None;", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases;", "()V", "diktat-rules"})
        public static final class None
        extends LongLineFixableCases {
            @NotNull
            public static final None INSTANCE;

            private None() {
                super(null);
            }

            static {
                None none;
                INSTANCE = none = new None();
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$Comment;", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "indexLastSpace", "", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;I)V", "getIndexLastSpace", "()I", "getNode", "()Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "diktat-rules"})
        public static final class Comment
        extends LongLineFixableCases {
            @NotNull
            private final ASTNode node;
            private final int indexLastSpace;

            @NotNull
            public final ASTNode getNode() {
                return this.node;
            }

            public final int getIndexLastSpace() {
                return this.indexLastSpace;
            }

            public Comment(@NotNull ASTNode node, int indexLastSpace) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                super(null);
                this.node = node;
                this.indexLastSpace = indexLastSpace;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$Condition;", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases;", "maximumLineLength", "", "leftOffset", "", "binList", "", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "(JILjava/util/List;)V", "getBinList", "()Ljava/util/List;", "getLeftOffset", "()I", "getMaximumLineLength", "()J", "diktat-rules"})
        public static final class Condition
        extends LongLineFixableCases {
            private final long maximumLineLength;
            private final int leftOffset;
            @NotNull
            private final List<ASTNode> binList;

            public final long getMaximumLineLength() {
                return this.maximumLineLength;
            }

            public final int getLeftOffset() {
                return this.leftOffset;
            }

            @NotNull
            public final List<ASTNode> getBinList() {
                return this.binList;
            }

            public Condition(long maximumLineLength, int leftOffset, @NotNull List<ASTNode> binList) {
                Intrinsics.checkNotNullParameter(binList, (String)"binList");
                super(null);
                this.maximumLineLength = maximumLineLength;
                this.leftOffset = leftOffset;
                this.binList = binList;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$Fun;", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;)V", "getNode", "()Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "diktat-rules"})
        public static final class Fun
        extends LongLineFixableCases {
            @NotNull
            private final ASTNode node;

            @NotNull
            public final ASTNode getNode() {
                return this.node;
            }

            public Fun(@NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                super(null);
                this.node = node;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$Property;", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "indexLastSpace", "", "text", "", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;ILjava/lang/String;)V", "getIndexLastSpace", "()I", "getNode", "()Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "getText", "()Ljava/lang/String;", "diktat-rules"})
        public static final class Property
        extends LongLineFixableCases {
            @NotNull
            private final ASTNode node;
            private final int indexLastSpace;
            @NotNull
            private final String text;

            @NotNull
            public final ASTNode getNode() {
                return this.node;
            }

            public final int getIndexLastSpace() {
                return this.indexLastSpace;
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            public Property(@NotNull ASTNode node, int indexLastSpace, @NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                super(null);
                this.node = node;
                this.indexLastSpace = indexLastSpace;
                this.text = text;
            }
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\n\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\nR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases$PropertyWithTemplateEntry;", "Lorg/cqfn/diktat/ruleset/rules/LineLength$LongLineFixableCases;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "maximumLineLength", "", "leftOffset", "", "binList", "", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;JILjava/util/List;)V", "getBinList", "()Ljava/util/List;", "getLeftOffset", "()I", "getMaximumLineLength", "()J", "getNode", "()Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "diktat-rules"})
        public static final class PropertyWithTemplateEntry
        extends LongLineFixableCases {
            @NotNull
            private final ASTNode node;
            private final long maximumLineLength;
            private final int leftOffset;
            @NotNull
            private final List<ASTNode> binList;

            @NotNull
            public final ASTNode getNode() {
                return this.node;
            }

            public final long getMaximumLineLength() {
                return this.maximumLineLength;
            }

            public final int getLeftOffset() {
                return this.leftOffset;
            }

            @NotNull
            public final List<ASTNode> getBinList() {
                return this.binList;
            }

            public PropertyWithTemplateEntry(@NotNull ASTNode node, long maximumLineLength, int leftOffset, @NotNull List<ASTNode> binList) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(binList, (String)"binList");
                super(null);
                this.node = node;
                this.maximumLineLength = maximumLineLength;
                this.leftOffset = leftOffset;
                this.binList = binList;
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/LineLength$Companion;", "", "()V", "MAX_LENGTH", "", "STRING_PART_OFFSET", "", "propertyList", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

