/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.CommonConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.PackageNaming;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.KotlinParser;
import org.cqfn.diktat.ruleset.utils.StringUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 -2\u00020\u0001:\u0001-B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J,\u0010\u0018\u001a\u00020\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00032\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u001e\u0010\u001d\u001a\u00020\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00032\u0006\u0010\u001f\u001a\u00020\u001aH\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u001aH\u0002J\u0018\u0010!\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u0016\u0010#\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0003H\u0002J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002Ji\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u000f2O\u0010(\u001aK\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\tj\u0002`\u0012H\u0016J&\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u001a2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010,\u001a\u00020\u0007H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000RW\u0010\b\u001aK\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\tj\u0002`\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/cqfn/diktat/ruleset/rules/PackageNaming;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "domainName", "", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "areCorrectSymbolsUsed", "word", "calculateRealPackageName", "fileName", "checkFilePathMatchesWithPackageName", "packageNameParts", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "realNameParts", "packageDirective", "checkPackageName", "wordsInPackageName", "packageDirectiveNode", "correctPackageWordSeparatorsUsed", "insertNewPackageName", "packageName", "isDomainMatches", "isExceptionForUnderscore", "visit", "node", "autoCorrect", "emit", "warnAndFixMissingPackageName", "initialPackageDirectiveNode", "realPackageName", "filePath", "Companion", "diktat-rules"})
public final class PackageNaming
extends Rule {
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private String domainName;
    private final List<RulesConfig> configRules;
    private static final Logger log;
    @NotNull
    public static final String PACKAGE_PATH_ANCHOR = "src";
    @NotNull
    public static final String PACKAGE_SEPARATOR = ".";
    @NotNull
    private static AtomicInteger visitorCounter;
    private static final List<String> kmmTargets;
    @NotNull
    private static final List<String> languageDirNames;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        void it;
        Lazy configuration2;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.isFixMode = autoCorrect;
        this.emitWarn = emit;
        Object var5_4 = null;
        Object object = configuration2 = RulesConfigReaderKt.getCommonConfiguration(this.configRules);
        Object var7_7 = null;
        boolean bl = false;
        object = object.getValue();
        boolean bl2 = false;
        bl = false;
        CommonConfiguration commonConfiguration = (CommonConfiguration)object;
        PackageNaming packageNaming = this;
        boolean bl3 = false;
        if (it.isDefault() && visitorCounter.incrementAndGet() == 1) {
            log.error("Not able to find an external configuration for domain name in the common configuration (is it missing in yml config?)");
        }
        Unit unit = Unit.INSTANCE;
        packageNaming.domainName = ((CommonConfiguration)object).getDomainName();
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPACKAGE_DIRECTIVE())) {
            String filePath = AstNodeUtilsKt.getFilePath(AstNodeUtilsKt.getRootNode(node));
            List<String> realPackageName = this.calculateRealPackageName(filePath);
            if (PackageKt.isLeaf((ASTNode)node) && !StringUtilsKt.isKotlinScript(filePath)) {
                this.warnAndFixMissingPackageName(node, realPackageName, filePath);
                return;
            }
            List wordsInPackageName = AstNodeUtilsKt.findAllNodesWithSpecificType$default(node, ElementType.INSTANCE.getIDENTIFIER(), false, 2, null);
            this.checkPackageName(wordsInPackageName, node);
            this.checkFilePathMatchesWithPackageName(wordsInPackageName, realPackageName, node);
        }
    }

    private final void warnAndFixMissingPackageName(ASTNode initialPackageDirectiveNode, List<String> realPackageName, String filePath) {
        String string = File.Companion.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File.separator");
        String fileName = StringsKt.substringAfterLast$default((String)filePath, (String)string, null, (int)2, null);
        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
        if (function3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
        }
        Warnings.warnAndFix$default(Warnings.PACKAGE_NAME_MISSING, this.configRules, function3, this.isFixMode, fileName, initialPackageDirectiveNode.getStartOffset(), initialPackageDirectiveNode, false, (Function0)new Function0<Unit>(this, realPackageName, initialPackageDirectiveNode){
            final /* synthetic */ PackageNaming this$0;
            final /* synthetic */ List $realPackageName;
            final /* synthetic */ ASTNode $initialPackageDirectiveNode;

            public final void invoke() {
                Collection collection = this.$realPackageName;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    String newPackageDirectiveName = CollectionsKt.joinToString$default((Iterable)this.$realPackageName, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                    PackageNaming.access$insertNewPackageName(this.this$0, this.$initialPackageDirectiveNode, newPackageDirectiveName);
                }
            }
            {
                this.this$0 = packageNaming;
                this.$realPackageName = list;
                this.$initialPackageDirectiveNode = aSTNode;
                super(0);
            }
        }, 64, null);
    }

    private final List<String> calculateRealPackageName(String fileName) {
        List list;
        List<String> filePathParts = StringUtilsKt.splitPathToDirs(fileName);
        if (!filePathParts.contains(PACKAGE_PATH_ANCHOR)) {
            log.error("Not able to determine a path to a scanned file or src directory cannot be found in it's path. Will not be able to determine correct package name. It can happen due to missing <src> directory in the path");
            list = CollectionsKt.emptyList();
        } else {
            List list2;
            Iterable $this$dropWhile$iv = filePathParts.subList(filePathParts.lastIndexOf(PACKAGE_PATH_ANCHOR), filePathParts.size() - 1);
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                String it = (String)item$iv;
                boolean bl = false;
                if (languageDirNames.contains(it)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            List fileSubDir = list$iv;
            String string = CollectionsKt.joinToString$default((Iterable)fileSubDir, (CharSequence)PACKAGE_SEPARATOR, null, null, (int)0, null, null, (int)62, null);
            String string2 = this.domainName;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"domainName");
            }
            if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                String string3 = this.domainName;
                if (string3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"domainName");
                }
                list2 = StringsKt.split$default((CharSequence)string3, (String[])new String[]{PACKAGE_SEPARATOR}, (boolean)false, (int)0, (int)6, null);
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List domainPrefix = list2;
            list = CollectionsKt.plus((Collection)domainPrefix, (Iterable)fileSubDir);
        }
        return list;
    }

    private final void checkPackageName(List<? extends ASTNode> wordsInPackageName, ASTNode packageDirectiveNode) {
        ASTNode word;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = wordsInPackageName;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            word = (ASTNode)element$iv$iv;
            boolean bl = false;
            String string = word.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word.text");
            if (!StringUtilsKt.hasUppercaseLetter(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            Warnings.warnAndFix$default(Warnings.PACKAGE_NAME_INCORRECT_CASE, this.configRules, function3, this.isFixMode, string, it.getStartOffset(), it, false, (Function0)new Function0<Unit>(it){
                final /* synthetic */ ASTNode $it;

                public final void invoke() {
                    AstNodeUtilsKt.toLower(this.$it);
                }
                {
                    this.$it = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
        $this$forEach$iv = wordsInPackageName;
        $i$f$forEach = false;
        if (!$this$forEach$iv.isEmpty() && !this.isDomainMatches(wordsInPackageName)) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string = this.domainName;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"domainName");
            }
            Warnings.warnAndFix$default(Warnings.PACKAGE_NAME_INCORRECT_PREFIX, this.configRules, function3, this.isFixMode, string, wordsInPackageName.get(0).getStartOffset(), wordsInPackageName.get(0), false, (Function0)new Function0<Unit>(this, wordsInPackageName, packageDirectiveNode){
                final /* synthetic */ PackageNaming this$0;
                final /* synthetic */ List $wordsInPackageName;
                final /* synthetic */ ASTNode $packageDirectiveNode;

                public final void invoke() {
                    String oldPackageName2 = CollectionsKt.joinToString$default((Iterable)this.$wordsInPackageName, (CharSequence)".", null, null, (int)0, null, (Function1)checkPackageName.oldPackageName.1.INSTANCE, (int)30, null);
                    String newPackageName = PackageNaming.access$getDomainName$p(this.this$0) + '.' + oldPackageName2;
                    PackageNaming.access$insertNewPackageName(this.this$0, this.$packageDirectiveNode, newPackageName);
                }
                {
                    this.this$0 = packageNaming;
                    this.$wordsInPackageName = list;
                    this.$packageDirectiveNode = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
        $this$filter$iv = wordsInPackageName;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            word = (ASTNode)element$iv$iv;
            boolean bl2 = false;
            String string = word.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word.text");
            if (!(!this.areCorrectSymbolsUsed(string))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl3 = false;
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            Warnings.PACKAGE_NAME_INCORRECT_SYMBOLS.warn(this.configRules, function3, this.isFixMode, string, it.getStartOffset(), it);
        }
        $this$forEach$iv = wordsInPackageName;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl4 = false;
            this.correctPackageWordSeparatorsUsed(it);
        }
    }

    private final boolean areCorrectSymbolsUsed(String word) {
        String wordFromPackage = StringsKt.replace$default((String)word, (String)"_", (String)"", (boolean)false, (int)4, null);
        return StringUtilsKt.isASCIILettersAndDigits(wordFromPackage);
    }

    private final void correctPackageWordSeparatorsUsed(ASTNode word) {
        String string = word.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word.text");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"_", (boolean)false, (int)2, null)) {
            String string2 = word.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"word.text");
            if (!this.isExceptionForUnderscore(string2)) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                String string3 = word.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"word.text");
                Warnings.warnAndFix$default(Warnings.INCORRECT_PACKAGE_SEPARATOR, this.configRules, function3, this.isFixMode, string3, word.getStartOffset(), word, false, (Function0)new Function0<Unit>(word){
                    final /* synthetic */ ASTNode $word;

                    public final void invoke() {
                        ASTNode aSTNode = this.$word;
                        if (aSTNode == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                        }
                        LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                        String string = ((LeafPsiElement)this.$word).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word.text");
                        leafPsiElement.replaceWithText(StringsKt.replace$default((String)string, (String)"_", (String)"", (boolean)false, (int)4, null));
                    }
                    {
                        this.$word = aSTNode;
                        super(0);
                    }
                }, 64, null);
            }
        }
    }

    private final boolean isExceptionForUnderscore(String word) {
        String wordFromPackage = StringsKt.replace$default((String)word, (String)"_", (String)"", (boolean)false, (int)4, null);
        char c = wordFromPackage.charAt(0);
        boolean bl = false;
        return Character.isDigit(c) || StringUtilsKt.isKotlinKeyWord(wordFromPackage) || StringUtilsKt.isJavaKeyWord(wordFromPackage);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isDomainMatches(List<? extends ASTNode> packageNameParts) {
        String string = this.domainName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"domainName");
        }
        List packageNamePrefix = StringsKt.split$default((CharSequence)string, (String[])new String[]{PACKAGE_SEPARATOR}, (boolean)false, (int)0, (int)6, null);
        if (packageNameParts.size() < packageNamePrefix.size()) {
            return false;
        }
        int n = 0;
        int n2 = ((Collection)packageNamePrefix).size();
        while (n < n2) {
            void i;
            if (Intrinsics.areEqual((Object)packageNameParts.get((int)i).getText(), (Object)((String)packageNamePrefix.get((int)i))) ^ true) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final void insertNewPackageName(ASTNode packageDirectiveNode, String packageName) {
        ASTNode aSTNode = packageDirectiveNode.findChildByType(ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION());
        if (aSTNode == null) {
            aSTNode = packageDirectiveNode.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
        }
        ASTNode packageNameNode = aSTNode;
        ASTNode generatedPackageDirective = new KotlinParser().createNode(KtTokens.PACKAGE_KEYWORD + ' ' + packageName, true);
        ASTNode aSTNode2 = packageNameNode;
        if (aSTNode2 != null) {
            ASTNode aSTNode3 = aSTNode2;
            boolean bl = false;
            boolean bl2 = false;
            ASTNode it = aSTNode3;
            boolean bl3 = false;
            ASTNode aSTNode4 = AstNodeUtilsKt.findLeafWithSpecificType(generatedPackageDirective, ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION());
            Intrinsics.checkNotNull((Object)aSTNode4);
            packageDirectiveNode.replaceChild(packageNameNode, aSTNode4);
        } else {
            PackageNaming packageNaming = this;
            boolean bl = false;
            boolean bl4 = false;
            PackageNaming $this$run = packageNaming;
            boolean bl5 = false;
            ASTNode aSTNode5 = AstNodeUtilsKt.findLeafWithSpecificType(generatedPackageDirective, ElementType.INSTANCE.getPACKAGE_DIRECTIVE());
            Intrinsics.checkNotNull((Object)aSTNode5);
            ASTNode newPackageDirective = aSTNode5;
            packageDirectiveNode.getTreeParent().replaceChild(packageDirectiveNode, newPackageDirective);
            newPackageDirective.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n\n"), newPackageDirective.getTreeNext());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFilePathMatchesWithPackageName(List<? extends ASTNode> packageNameParts, List<String> realNameParts, ASTNode packageDirective) {
        Collection collection = realNameParts;
        boolean bl = false;
        if (!collection.isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = packageNameParts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void node;
                ASTNode aSTNode = (ASTNode)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                String string = node.getText();
                collection2.add(string);
            }
            if (Intrinsics.areEqual((Object)((List)destination$iv$iv), realNameParts) ^ true) {
                String realPackageNameStr = CollectionsKt.joinToString$default((Iterable)realNameParts, (CharSequence)PACKAGE_SEPARATOR, null, null, (int)0, null, null, (int)62, null);
                int offset2 = packageNameParts.get(0).getStartOffset();
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                Warnings.warnAndFix$default(Warnings.PACKAGE_NAME_INCORRECT_PATH, this.configRules, function3, this.isFixMode, realPackageNameStr, offset2, packageNameParts.get(0), false, (Function0)new Function0<Unit>(this, packageDirective, realPackageNameStr){
                    final /* synthetic */ PackageNaming this$0;
                    final /* synthetic */ ASTNode $packageDirective;
                    final /* synthetic */ String $realPackageNameStr;

                    public final void invoke() {
                        PackageNaming.access$insertNewPackageName(this.this$0, this.$packageDirective, this.$realPackageNameStr);
                    }
                    {
                        this.this$0 = packageNaming;
                        this.$packageDirective = aSTNode;
                        this.$realPackageNameStr = string;
                        super(0);
                    }
                }, 64, null);
            }
        }
    }

    public PackageNaming(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("package-naming");
        this.configRules = configRules;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_4;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(PackageNaming.class);
        visitorCounter = new AtomicInteger(0);
        kmmTargets = CollectionsKt.listOf((Object[])new String[]{"common", "jvm", "js", "android", "ios", "androidNativeArm32", "androidNativeArm64", "iosArm32", "iosArm64", "iosX64", "watchosArm32", "watchosArm64", "watchosX86", "tvosArm64", "tvosX64", "macosX64", "linuxArm64", "linuxArm32Hfp", "linuxMips32", "linuxMipsel32", "linuxX64", "mingwX64", "mingwX86", "wasm32"});
        Iterable iterable = kmmTargets;
        Collection collection = CollectionsKt.listOf((Object[])new String[]{PACKAGE_PATH_ANCHOR, "main", "test", "java", "kotlin"});
        boolean $i$f$flatMap = false;
        void var2_3 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])new String[]{it + "Main", it + "Test"});
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)var3_4;
        languageDirNames = CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    public static final /* synthetic */ void access$insertNewPackageName(PackageNaming $this, ASTNode packageDirectiveNode, String packageName) {
        $this.insertNewPackageName(packageDirectiveNode, packageName);
    }

    public static final /* synthetic */ String access$getDomainName$p(PackageNaming $this) {
        String string = $this.domainName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"domainName");
        }
        return string;
    }

    public static final /* synthetic */ void access$setDomainName$p(PackageNaming $this, String string) {
        $this.domainName = string;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/cqfn/diktat/ruleset/rules/PackageNaming$Companion;", "", "()V", "PACKAGE_PATH_ANCHOR", "", "PACKAGE_SEPARATOR", "kmmTargets", "", "languageDirNames", "getLanguageDirNames", "()Ljava/util/List;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "visitorCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getVisitorCounter", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setVisitorCounter", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "diktat-rules"})
    public static final class Companion {
        @NotNull
        public final AtomicInteger getVisitorCounter() {
            return visitorCounter;
        }

        public final void setVisitorCounter(@NotNull AtomicInteger atomicInteger) {
            Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
            visitorCounter = atomicInteger;
        }

        @NotNull
        public final List<String> getLanguageDirNames() {
            return languageDirNames;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

