/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002Ji\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000e2O\u0010\u001c\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/cqfn/diktat/ruleset/rules/StringConcatenationRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "detectStringConcatenation", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "detectStringConcatenationInExpression", "parentNode", "isPlusBinaryExpression", "isSingleLineStatement", "visit", "autoCorrect", "emit", "diktat-rules"})
public final class StringConcatenationRule
extends Rule {
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION()) && AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getBINARY_EXPRESSION()) == null && this.isSingleLineStatement(node)) {
            this.detectStringConcatenation(node);
        }
    }

    private final boolean isSingleLineStatement(ASTNode node) {
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
        return !StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null);
    }

    private final void detectStringConcatenation(ASTNode node) {
        Iterable iterable = AstNodeUtilsKt.findAllNodesWithSpecificType$default(node, ElementType.INSTANCE.getBINARY_EXPRESSION(), false, 2, null);
        boolean bl = false;
        Iterable iterable2 = iterable;
        boolean bl2 = false;
        for (Object t : iterable2) {
            ASTNode it = (ASTNode)t;
            boolean bl3 = false;
            if (!this.detectStringConcatenationInExpression(it, node)) continue;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean detectStringConcatenationInExpression(ASTNode node, ASTNode parentNode) {
        boolean bl = Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION());
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ASTNode firstChild = node.getFirstChildNode();
        if (!this.isPlusBinaryExpression(node)) return false;
        ASTNode aSTNode = firstChild;
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"firstChild");
        if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getSTRING_TEMPLATE())) return false;
        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
        if (function3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
        }
        String string = parentNode.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parentNode.text");
        Warnings.STRING_CONCATENATION.warn(this.configRules, function3, this.isFixMode, string, firstChild.getStartOffset(), firstChild);
        return true;
    }

    private final boolean isPlusBinaryExpression(ASTNode node) {
        ASTNode operationReference;
        boolean bl = Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION());
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ASTNode aSTNode = operationReference = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getOPERATION_REFERENCE());
        return (aSTNode != null ? AstNodeUtilsKt.getFirstChildWithType(aSTNode, ElementType.INSTANCE.getPLUS()) : null) != null;
    }

    public StringConcatenationRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("string-concatenation");
        this.configRules = configRules;
    }
}

