/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002Ji\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u000e2O\u0010\u001a\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/StringTemplateFormatRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "bracesCanBeOmitted", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "handleLongStringTemplate", "handleShortStringTemplate", "visit", "autoCorrect", "emit", "diktat-rules"})
public final class StringTemplateFormatRule
extends Rule {
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block1: {
            IElementType iElementType;
            block0: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter(emit, (String)"emit");
                this.emitWarn = emit;
                this.isFixMode = autoCorrect;
                iElementType = node.getElementType();
                if (!Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLONG_STRING_TEMPLATE_ENTRY())) break block0;
                this.handleLongStringTemplate(node);
                break block1;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSHORT_STRING_TEMPLATE_ENTRY())) break block1;
            this.handleShortStringTemplate(node);
        }
    }

    private final void handleLongStringTemplate(ASTNode node) {
        if (this.bracesCanBeOmitted(node)) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
            Warnings.warnAndFix$default(Warnings.STRING_TEMPLATE_CURLY_BRACES, this.configRules, function3, this.isFixMode, string, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, node){
                final /* synthetic */ StringTemplateFormatRule this$0;
                final /* synthetic */ ASTNode $node;

                public final void invoke() {
                    ASTNode identifierName;
                    ASTNode aSTNode = identifierName = this.$node.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
                    if (aSTNode != null) {
                        ASTNode aSTNode2 = aSTNode;
                        boolean bl = false;
                        boolean bl2 = false;
                        ASTNode it = aSTNode2;
                        boolean bl3 = false;
                        CompositeElement shortTemplate = new CompositeElement(ElementType.INSTANCE.getSHORT_STRING_TEMPLATE_ENTRY());
                        CompositeElement reference = new CompositeElement(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
                        this.$node.getTreeParent().addChild((ASTNode)shortTemplate, this.$node);
                        shortTemplate.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getSHORT_TEMPLATE_ENTRY_START(), (CharSequence)"$"), null);
                        shortTemplate.addChild((ASTNode)reference);
                        reference.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getIDENTIFIER(), (CharSequence)identifierName.getText()));
                        this.$node.getTreeParent().removeChild(this.$node);
                    } else {
                        StringTemplateFormatRule stringTemplateFormatRule = this.this$0;
                        boolean bl = false;
                        boolean bl4 = false;
                        StringTemplateFormatRule $this$run = stringTemplateFormatRule;
                        boolean bl5 = false;
                        ASTNode stringTemplate = this.$node.getTreeParent();
                        String string = this.$node.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
                        String appropriateText = StringsKt.trim((String)string, (char[])new char[]{'$', '{', '}'});
                        stringTemplate.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getLITERAL_STRING_TEMPLATE_ENTRY(), (CharSequence)appropriateText), this.$node);
                        stringTemplate.removeChild(this.$node);
                    }
                }
                {
                    this.this$0 = stringTemplateFormatRule;
                    this.$node = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
    }

    private final void handleShortStringTemplate(ASTNode node) {
        String identifierName;
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
        String string = identifierName = aSTNode != null ? aSTNode.getText() : null;
        if (identifierName != null) {
            ASTNode aSTNode2 = node.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.treeParent");
            String string2 = aSTNode2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.treeParent.text");
            if (Intrinsics.areEqual((Object)StringsKt.trim((String)string2, (char[])new char[]{'\"', '$'}), (Object)identifierName)) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                String string3 = node.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"node.text");
                Warnings.warnAndFix$default(Warnings.STRING_TEMPLATE_QUOTES, this.configRules, function3, this.isFixMode, string3, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                    final /* synthetic */ ASTNode $node;

                    public final void invoke() {
                        ASTNode aSTNode = this.$node.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
                        Intrinsics.checkNotNull((Object)aSTNode);
                        ASTNode identifier = aSTNode.copyElement();
                        ASTNode aSTNode2 = this.$node.getTreeParent();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.treeParent");
                        aSTNode2.getTreeParent().addChild(identifier, this.$node.getTreeParent());
                        ASTNode aSTNode3 = this.$node.getTreeParent();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"node.treeParent");
                        aSTNode3.getTreeParent().removeChild(this.$node.getTreeParent());
                    }
                    {
                        this.$node = aSTNode;
                        super(0);
                    }
                }, 64, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean bracesCanBeOmitted(ASTNode node) {
        ASTNode aSTNode = (ASTNode)CollectionsKt.singleOrNull((List)AstNodeUtilsKt.findAllNodesWithSpecificType$default(node, ElementType.INSTANCE.getREFERENCE_EXPRESSION(), false, 2, null));
        boolean onlyOneRefExpr = Intrinsics.areEqual((Object)(aSTNode != null && (aSTNode = aSTNode.getTreeParent()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getLONG_STRING_TEMPLATE_ENTRY());
        ASTNode aSTNode2 = (ASTNode)CollectionsKt.singleOrNull((List)AstNodeUtilsKt.findAllNodesWithSpecificType$default(node, ElementType.INSTANCE.getREFERENCE_EXPRESSION(), false, 2, null));
        boolean isArrayAccessExpression = Intrinsics.areEqual((Object)(aSTNode2 != null && (aSTNode2 = aSTNode2.getTreeParent()) != null ? aSTNode2.getElementType() : null), (Object)ElementType.INSTANCE.getARRAY_ACCESS_EXPRESSION());
        if (onlyOneRefExpr && !isArrayAccessExpression) {
            ASTNode aSTNode3 = node.getTreeNext();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"node.treeNext");
            String string = aSTNode3.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.treeNext.text");
            char c = StringsKt.first((CharSequence)string);
            boolean bl = false;
            if (!Character.isLetterOrDigit(c)) {
                ASTNode aSTNode4 = node.getTreeNext();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"node.treeNext");
                String string2 = aSTNode4.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.treeNext.text");
                if (!StringsKt.startsWith$default((String)string2, (String)"_", (boolean)false, (int)2, null)) return true;
            }
            ASTNode aSTNode5 = node.getTreeNext();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode5, (String)"node.treeNext");
            if (!Intrinsics.areEqual((Object)aSTNode5.getElementType(), (Object)ElementType.INSTANCE.getCLOSING_QUOTE())) return false;
            return true;
        }
        if (isArrayAccessExpression) return false;
        boolean bl = AstNodeUtilsKt.hasAnyChildOfTypes(node, ElementType.INSTANCE.getFLOAT_CONSTANT(), ElementType.INSTANCE.getINTEGER_CONSTANT());
        return bl;
    }

    public StringTemplateFormatRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("string-template-format");
        this.configRules = configRules;
    }
}

