/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.comments;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstConstantsKt;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\fH\u0002Ji\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000e2O\u0010\u001d\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011H\u0016J\f\u0010\u001e\u001a\u00020\f*\u00020\fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/cqfn/diktat/ruleset/rules/comments/HeaderCommentRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "checkCopyright", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "checkHeaderKdoc", "checkHeaderKdocPosition", "handleMultilineCopyright", "copyrightText", "makeCopyrightCorrectYear", "visit", "autoCorrect", "emit", "flatten", "Companion", "CopyrightConfiguration", "diktat-rules"})
public final class HeaderCommentRule
extends Rule {
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;
    @NotNull
    private static final Regex hyphenRegex;
    @NotNull
    private static final Regex afterCopyrightRegex;
    private static final int curYear;
    @NotNull
    public static final Companion Companion;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.isFixMode = autoCorrect;
        this.emitWarn = emit;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            this.checkCopyright(node);
            if (this.checkHeaderKdocPosition(node)) {
                this.checkHeaderKdoc(node);
            }
        }
    }

    private final void checkHeaderKdoc(ASTNode node) {
        ASTNode headerKdoc;
        ASTNode aSTNode = headerKdoc = AstNodeUtilsKt.findChildBefore(node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getKDOC());
        if (aSTNode != null) {
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv;
            ASTNode aSTNode2 = aSTNode;
            boolean bl = false;
            boolean bl2 = false;
            ASTNode it = aSTNode2;
            boolean bl3 = false;
            String string = headerKdoc.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"headerKdoc\n                .text");
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)string, (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                String it2 = (String)element$iv$iv;
                boolean bl4 = false;
                if (!StringsKt.contains$default((CharSequence)it2, (CharSequence)"@author", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it3 = (String)element$iv;
                boolean bl5 = false;
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                element$iv$iv = it3;
                boolean it2 = false;
                Object object = element$iv$iv;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                Warnings.HEADER_CONTAINS_DATE_OR_AUTHOR.warn(this.configRules, function3, this.isFixMode, ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString(), headerKdoc.getStartOffset(), headerKdoc);
            }
            if (headerKdoc.getTreeNext() != null) {
                ASTNode aSTNode3 = headerKdoc.getTreeNext();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"headerKdoc.treeNext");
                if (Intrinsics.areEqual((Object)aSTNode3.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                    ASTNode aSTNode4 = headerKdoc.getTreeNext();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"headerKdoc.treeNext");
                    String string2 = aSTNode4.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"headerKdoc.treeNext.text");
                    CharSequence $this$count$iv = string2;
                    boolean $i$f$count = false;
                    int count$iv = 0;
                    CharSequence charSequence = $this$count$iv;
                    for (int i = 0; i < charSequence.length(); ++i) {
                        char element$iv;
                        char it4 = element$iv = charSequence.charAt(i);
                        boolean bl6 = false;
                        if (!(it4 == '\n')) continue;
                        ++count$iv;
                    }
                    if (count$iv != 2) {
                        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                        if (function3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                        }
                        Warnings.warnAndFix$default(Warnings.HEADER_WRONG_FORMAT, this.configRules, function3, this.isFixMode, "header KDoc should have a new line after", headerKdoc.getStartOffset(), headerKdoc, false, (Function0)new Function0<Unit>(this, headerKdoc, node){
                            final /* synthetic */ HeaderCommentRule this$0;
                            final /* synthetic */ ASTNode $headerKdoc$inlined;
                            final /* synthetic */ ASTNode $node$inlined;
                            {
                                this.this$0 = headerCommentRule;
                                this.$headerKdoc$inlined = aSTNode;
                                this.$node$inlined = aSTNode2;
                                super(0);
                            }

                            public final void invoke() {
                                this.$node$inlined.replaceChild(this.$headerKdoc$inlined.getTreeNext(), (ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n\n"));
                            }
                        }, 64, null);
                    }
                }
            }
        } else {
            HeaderCommentRule headerCommentRule = this;
            boolean bl = false;
            boolean bl7 = false;
            HeaderCommentRule $this$run = headerCommentRule;
            boolean bl8 = false;
            int numDeclaredClassesAndObjects = AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getCLASS()).size() + AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getOBJECT_DECLARATION()).size();
            if (numDeclaredClassesAndObjects != 1) {
                List<RulesConfig> list = $this$run.configRules;
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = $this$run.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                Warnings.HEADER_MISSING_IN_NON_SINGLE_CLASS_FILE.warn(list, function3, $this$run.isFixMode, "there are " + numDeclaredClassesAndObjects + " declared classes and/or objects", node.getStartOffset(), node);
            }
        }
    }

    private final boolean checkHeaderKdocPosition(ASTNode node) {
        ASTNode firstKdoc = AstNodeUtilsKt.findChildAfter(node, ElementType.INSTANCE.getIMPORT_LIST(), ElementType.INSTANCE.getKDOC());
        if (AstNodeUtilsKt.findChildBefore(node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getKDOC()) == null && firstKdoc != null) {
            ASTNode aSTNode = firstKdoc.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"firstKdoc.treeParent");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                Warnings.warnAndFix$default(Warnings.HEADER_NOT_BEFORE_PACKAGE, this.configRules, function3, this.isFixMode, "header KDoc is located after package or imports", firstKdoc.getStartOffset(), firstKdoc, false, (Function0)new Function0<Unit>(node, firstKdoc){
                    final /* synthetic */ ASTNode $node;
                    final /* synthetic */ ASTNode $firstKdoc;

                    public final void invoke() {
                        block2: {
                            AstNodeUtilsKt.moveChildBefore(this.$node, this.$firstKdoc, AstNodeUtilsKt.getFirstChildWithType(this.$node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE()), true);
                            ASTNode aSTNode = AstNodeUtilsKt.findChildBefore(this.$node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getBLOCK_COMMENT());
                            if (aSTNode == null) break block2;
                            ASTNode aSTNode2 = aSTNode;
                            boolean bl = false;
                            boolean bl2 = false;
                            ASTNode $this$apply = aSTNode2;
                            boolean bl3 = false;
                            ASTNode aSTNode3 = $this$apply.getTreeNext();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"treeNext");
                            if (Intrinsics.areEqual((Object)aSTNode3.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                                this.$node.replaceChild($this$apply.getTreeNext(), (ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"));
                            } else {
                                this.$node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), $this$apply.getTreeNext());
                            }
                        }
                    }
                    {
                        this.$node = aSTNode;
                        this.$firstKdoc = aSTNode2;
                        super(0);
                    }
                }, 64, null);
                if (!this.isFixMode) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String makeCopyrightCorrectYear(String copyrightText) {
        MatchResult afterCopyrightYear;
        MatchResult hyphenYear;
        MatchResult matchResult = hyphenYear = Regex.find$default((Regex)hyphenRegex, (CharSequence)copyrightText, (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult matchResult2 = matchResult;
            boolean bl = false;
            boolean bl2 = false;
            MatchResult it = matchResult2;
            boolean bl3 = false;
            List copyrightYears = StringsKt.split$default((CharSequence)hyphenYear.getValue(), (String[])new String[]{"-"}, (boolean)false, (int)0, (int)6, null);
            String string = (String)copyrightYears.get(1);
            boolean bl4 = false;
            if (Integer.parseInt(string) != curYear) {
                String validYears = (String)copyrightYears.get(0) + '-' + curYear;
                CharSequence charSequence = copyrightText;
                Regex regex = hyphenRegex;
                return regex.replace(charSequence, validYears);
            }
        }
        MatchResult matchResult3 = afterCopyrightYear = Regex.find$default((Regex)afterCopyrightRegex, (CharSequence)copyrightText, (int)0, (int)2, null);
        Object object = matchResult3;
        if (matchResult3 == null) return "";
        String string = object.getValue();
        object = string;
        if (string == null) return "";
        List list = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{"(c)", "(C)", "\u00a9"}, (boolean)false, (int)0, (int)6, null);
        List copyrightYears = list;
        if (copyrightYears == null) return "";
        String string2 = (String)copyrightYears.get(1);
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string2 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        bl = false;
        if (Integer.parseInt(string2) == curYear) return "";
        String validYears = (String)copyrightYears.get(0) + '-' + curYear;
        CharSequence charSequence = copyrightText;
        Regex regex = afterCopyrightRegex;
        boolean bl5 = false;
        String string4 = regex.replace(charSequence, validYears);
        return string4;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkCopyright(ASTNode node) {
        block26: {
            block25: {
                block24: {
                    v0 /* !! */  = RulesConfigReaderKt.getRuleConfig(this.configRules, (org.cqfn.diktat.common.config.rules.Rule)Warnings.HEADER_MISSING_OR_WRONG_COPYRIGHT);
                    if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .getConfiguration()) == null) {
                        v0 /* !! */  = MapsKt.emptyMap();
                    }
                    configuration = new CopyrightConfiguration((Map<String, String>)v0 /* !! */ );
                    if (!configuration.isCopyrightMandatory() && !configuration.hasCopyrightText$diktat_rules()) {
                        return;
                    }
                    copyrightText = configuration.getCopyrightText();
                    headerComment = AstNodeUtilsKt.findChildBefore(node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getBLOCK_COMMENT());
                    if (headerComment == null) ** GOTO lbl-1000
                    v1 = headerComment.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"headerComment.text");
                    if (!StringsKt.contains$default((CharSequence)this.flatten(v1), (CharSequence)this.flatten(copyrightText), (boolean)false, (int)2, null)) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    isWrongCopyright = v2;
                    isMissingCopyright = headerComment == null && configuration.isCopyrightMandatory() != false;
                    $this$any$iv = CollectionsKt.plus((Collection)AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getKDOC()), (Iterable)AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getEOL_COMMENT()));
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v3 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            block23: {
                                commentNode = (ASTNode)element$iv;
                                $i$a$-any-HeaderCommentRule$checkCopyright$isCopyrightInsideKdoc$1 = false;
                                $this$any$iv = AstConstantsKt.getCopyrightWords();
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    v4 = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        it = (String)element$iv;
                                        $i$a$-any-HeaderCommentRule$checkCopyright$isCopyrightInsideKdoc$1$1 = false;
                                        v5 = commentNode.getText();
                                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"commentNode.text");
                                        if (!StringsKt.contains((CharSequence)v5, (CharSequence)it, (boolean)true)) continue;
                                        v4 = true;
                                        break block23;
                                    }
                                    v4 = false;
                                }
                            }
                            if (!v4) continue;
                            v3 = true;
                            break block24;
                        }
                        v3 = isCopyrightInsideKdoc = false;
                    }
                }
                if (isWrongCopyright || isMissingCopyright) break block25;
                if (!isCopyrightInsideKdoc) break block26;
            }
            if (isCopyrightInsideKdoc) {
                v6 = "copyright is placed inside KDoc, but should be inside a block comment";
            } else if (isWrongCopyright) {
                v6 = "copyright comment doesn't have correct copyright text";
            } else if (isMissingCopyright) {
                v6 = "copyright is mandatory, but is missing";
            } else {
                var9_9 = "Should never get to this point";
                var10_12 = false;
                throw (Throwable)new IllegalStateException(var9_9.toString());
            }
            freeText = v6;
            v7 = this.emitWarn;
            if (v7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.warnAndFix$default(Warnings.HEADER_MISSING_OR_WRONG_COPYRIGHT, this.configRules, v7, this.isFixMode, freeText, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, headerComment, node, copyrightText){
                final /* synthetic */ HeaderCommentRule this$0;
                final /* synthetic */ ASTNode $headerComment;
                final /* synthetic */ ASTNode $node;
                final /* synthetic */ String $copyrightText;

                public final void invoke() {
                    String string;
                    boolean bl;
                    ASTNode aSTNode = this.$headerComment;
                    if (aSTNode != null) {
                        ASTNode aSTNode2 = aSTNode;
                        boolean bl2 = false;
                        bl = false;
                        ASTNode it = aSTNode2;
                        boolean bl3 = false;
                        this.$node.removeChild(it);
                    }
                    ASTNode aSTNode3 = AstNodeUtilsKt.findChildBefore(this.$node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getKDOC());
                    if (aSTNode3 != null) {
                        ASTNode aSTNode4 = aSTNode3;
                        bl = false;
                        boolean bl4 = false;
                        ASTNode it = aSTNode4;
                        boolean bl5 = false;
                        string = "\n";
                    } else {
                        string = "\n\n";
                    }
                    String newLines = string;
                    this.$node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)newLines), this.$node.getFirstChildNode());
                    this.$node.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getBLOCK_COMMENT(), (CharSequence)StringsKt.trimMargin$default((String)("\n                        |/*\n                        |" + HeaderCommentRule.access$handleMultilineCopyright(this.this$0, this.$copyrightText) + "\n                        |*/\n                    "), null, (int)1, null)), this.$node.getFirstChildNode());
                }
                {
                    this.this$0 = headerCommentRule;
                    this.$headerComment = aSTNode;
                    this.$node = aSTNode2;
                    this.$copyrightText = string;
                    super(0);
                }
            }, 64, null);
        }
        copyrightWithCorrectYear = this.makeCopyrightCorrectYear(copyrightText);
        var9_10 = copyrightWithCorrectYear;
        var10_13 = false;
        if (var9_10.length() > 0) {
            v8 = this.emitWarn;
            if (v8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.warnAndFix$default(Warnings.WRONG_COPYRIGHT_YEAR, this.configRules, v8, this.isFixMode, "year should be " + HeaderCommentRule.curYear, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(headerComment, copyrightText, copyrightWithCorrectYear){
                final /* synthetic */ ASTNode $headerComment;
                final /* synthetic */ String $copyrightText;
                final /* synthetic */ String $copyrightWithCorrectYear;

                public final void invoke() {
                    ASTNode aSTNode = this.$headerComment;
                    if (aSTNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
                    }
                    LeafElement leafElement = (LeafElement)aSTNode;
                    String string = ((LeafElement)this.$headerComment).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"headerComment.text");
                    leafElement.replaceWithText(StringsKt.replace$default((String)string, (String)this.$copyrightText, (String)this.$copyrightWithCorrectYear, (boolean)false, (int)4, null));
                }
                {
                    this.$headerComment = aSTNode;
                    this.$copyrightText = string;
                    this.$copyrightWithCorrectYear = string2;
                    super(0);
                }
            }, 64, null);
        }
    }

    private final String flatten(String $this$flatten) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)$this$flatten, (String)"\n", (String)"", (boolean)false, (int)4, null), (String)" ", (String)"", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String handleMultilineCopyright(String copyrightText) {
        if (StringsKt.startsWith$default((String)copyrightText, (String)" ", (boolean)false, (int)2, null)) {
            Iterable $this$dropWhile$iv = StringsKt.lines((CharSequence)copyrightText);
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                String it = (String)item$iv;
                boolean bl = false;
                if (StringsKt.isBlank((CharSequence)it)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            Iterable $this$reduce$iv = list$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void nextLine;
                String string = (String)iterator$iv.next();
                String acc = (String)accumulator$iv;
                boolean bl = false;
                accumulator$iv = StringsKt.isBlank((CharSequence)((CharSequence)nextLine)) ? acc + '\n' : acc + '\n' + (String)nextLine;
            }
            return (String)accumulator$iv;
        }
        return "    " + copyrightText;
    }

    public HeaderCommentRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("header-comment");
        this.configRules = configRules;
    }

    static {
        Companion = new Companion(null);
        hyphenRegex = new Regex("\\b(\\d+-\\d+)\\b");
        afterCopyrightRegex = new Regex("((\u00a9|\\([cC]\\))+ *\\d+)");
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"LocalDate.now()");
        curYear = localDate.getYear();
    }

    public static final /* synthetic */ String access$handleMultilineCopyright(HeaderCommentRule $this, String copyrightText) {
        return $this.handleMultilineCopyright(copyrightText);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0004J\r\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0006\u0010\n\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/comments/HeaderCommentRule$CopyrightConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "getCopyrightText", "hasCopyrightText", "", "hasCopyrightText$diktat_rules", "isCopyrightMandatory", "diktat-rules"})
    public static final class CopyrightConfiguration
    extends RuleConfiguration {
        public final boolean isCopyrightMandatory() {
            boolean bl;
            String string = (String)this.getConfig().get("isCopyrightMandatory");
            if (string != null) {
                String string2 = string;
                boolean bl2 = false;
                bl = Boolean.parseBoolean(string2);
            } else {
                bl = false;
            }
            return bl;
        }

        public final boolean hasCopyrightText$diktat_rules() {
            return this.getConfig().keySet().contains("copyrightText");
        }

        @NotNull
        public final String getCopyrightText() {
            String string = (String)this.getConfig().get("copyrightText");
            if (string == null) {
                String string2 = "Copyright is not set in configuration";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return string;
        }

        public CopyrightConfiguration(@NotNull Map<String, String> config) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            super(config);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/cqfn/diktat/ruleset/rules/comments/HeaderCommentRule$Companion;", "", "()V", "afterCopyrightRegex", "Lkotlin/text/Regex;", "getAfterCopyrightRegex", "()Lkotlin/text/Regex;", "curYear", "", "getCurYear", "()I", "hyphenRegex", "getHyphenRegex", "diktat-rules"})
    public static final class Companion {
        @NotNull
        public final Regex getHyphenRegex() {
            return hyphenRegex;
        }

        @NotNull
        public final Regex getAfterCopyrightRegex() {
            return afterCopyrightRegex;
        }

        public final int getCurYear() {
            return curYear;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

