/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.files;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002Ji\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000e2O\u0010\u0019\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/cqfn/diktat/ruleset/rules/files/BlankLinesRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "handleBlankLine", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "handleTooManyBlankLines", "visit", "autoCorrect", "emit", "diktat-rules"})
public final class BlankLinesRule
extends Rule {
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
            if (AstNodeUtilsKt.numNewLines(node) == 2) {
                this.handleBlankLine(node);
            } else if (AstNodeUtilsKt.numNewLines(node) > 2) {
                this.handleTooManyBlankLines(node);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void handleBlankLine(ASTNode node) {
        block6: {
            ASTNode it;
            block5: {
                ASTNode aSTNode = node.getTreeParent();
                boolean bl = false;
                boolean bl2 = false;
                it = aSTNode;
                boolean bl3 = false;
                ASTNode aSTNode2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"it");
                if (!Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)ElementType.INSTANCE.getBLOCK())) break block5;
                ASTNode aSTNode3 = it.getTreeParent();
                if (Intrinsics.areEqual((Object)(aSTNode3 != null ? aSTNode3.getElementType() : null), (Object)ElementType.INSTANCE.getSCRIPT()) ^ true) break block6;
            }
            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getCLASS_BODY())) {
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL())) return;
            }
        }
        boolean bl = true;
        if (!bl) return;
        ASTNode aSTNode = node.getTreeNext();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeNext");
        boolean bl4 = Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getRBRACE());
        ASTNode aSTNode4 = node.getTreePrev();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"node.treePrev");
        if (!(bl4 ^ Intrinsics.areEqual((Object)aSTNode4.getElementType(), (Object)ElementType.INSTANCE.getLBRACE()))) return;
        StringBuilder stringBuilder = new StringBuilder().append("do not put newlines ");
        ASTNode aSTNode5 = node.getTreePrev();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode5, (String)"node.treePrev");
        String freeText = stringBuilder.append(Intrinsics.areEqual((Object)aSTNode5.getElementType(), (Object)ElementType.INSTANCE.getLBRACE()) ? "in the beginning" : "at the end").append(" of code blocks").toString();
        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
        if (function3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
        }
        Warnings.warnAndFix$default(Warnings.TOO_MANY_BLANK_LINES, this.configRules, function3, this.isFixMode, freeText, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
            final /* synthetic */ ASTNode $node;

            public final void invoke() {
                AstNodeUtilsKt.leaveOnlyOneNewLine(this.$node);
            }
            {
                this.$node = aSTNode;
                super(0);
            }
        }, 64, null);
    }

    private final void handleTooManyBlankLines(ASTNode node) {
        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
        if (function3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
        }
        Warnings.warnAndFix$default(Warnings.TOO_MANY_BLANK_LINES, this.configRules, function3, this.isFixMode, "do not use more than two consecutive blank lines", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
            final /* synthetic */ ASTNode $node;

            /*
             * Enabled aggressive block sorting
             */
            public final void invoke() {
                ASTNode aSTNode = this.$node.getTreeParent();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
                if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getFILE()) ^ true) {
                    ASTNode aSTNode2 = this.$node.getTreeParent();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.treeParent");
                    if (Intrinsics.areEqual((Object)AstNodeUtilsKt.getFirstChildWithType(aSTNode2, ElementType.INSTANCE.getWHITE_SPACE()), (Object)this.$node)) {
                        AstNodeUtilsKt.leaveExactlyNumNewLines(this.$node, 1);
                        return;
                    }
                }
                AstNodeUtilsKt.leaveExactlyNumNewLines(this.$node, 2);
            }
            {
                this.$node = aSTNode;
                super(0);
            }
        }, 64, null);
    }

    public BlankLinesRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("blank-lines");
        this.configRules = configRules;
    }
}

