/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.files;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.StringUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002Ji\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00142O\u0010 \u001aK\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\rj\u0002`\u0017H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tRW\u0010\f\u001aK\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\rj\u0002`\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/cqfn/diktat/ruleset/rules/files/FileSize;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "configuration", "Lorg/cqfn/diktat/ruleset/rules/files/FileSize$FileSizeConfiguration;", "getConfiguration", "()Lorg/cqfn/diktat/ruleset/rules/files/FileSize$FileSizeConfiguration;", "configuration$delegate", "Lkotlin/Lazy;", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "checkFileSize", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "maxSize", "", "visit", "autoCorrect", "emit", "Companion", "FileSizeConfiguration", "diktat-rules"})
public final class FileSize
extends Rule {
    private boolean isFixMode;
    private final Lazy configuration$delegate;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;
    private static final Logger log;
    @NotNull
    public static final String IGNORE_FOLDERS_SEPARATOR = ",";
    public static final long MAX_SIZE = 2000L;
    @NotNull
    public static final String SRC_PATH = "src";
    private static final List<String> ignoreFolder;
    @NotNull
    public static final Companion Companion;

    private final FileSizeConfiguration getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        FileSize fileSize = this;
        Object var3_3 = null;
        boolean bl = false;
        return (FileSizeConfiguration)((Object)lazy.getValue());
    }

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            List<String> filePathParts = StringUtilsKt.splitPathToDirs(AstNodeUtilsKt.getFilePath(node));
            if (!filePathParts.contains(SRC_PATH)) {
                log.error("src directory is not found in file path");
            } else {
                boolean bl;
                block7: {
                    Iterable $this$none$iv = this.getConfiguration().getIgnoreFolders();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!filePathParts.containsAll((Collection)StringUtilsKt.splitPathToDirs(it))) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    this.checkFileSize(node, this.getConfiguration().getMaxSize());
                }
            }
        }
    }

    private final void checkFileSize(ASTNode node, long maxSize) {
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node\n            .text");
        int size = StringsKt.split$default((CharSequence)string, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null).size();
        if ((long)size > maxSize) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.FILE_IS_TOO_LONG.warn(this.configRules, function3, this.isFixMode, String.valueOf(size), node.getStartOffset(), node);
        }
    }

    public FileSize(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("file-size");
        this.configRules = configRules;
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FileSizeConfiguration>(this){
            final /* synthetic */ FileSize this$0;

            @NotNull
            public final FileSizeConfiguration invoke() {
                Object object = RulesConfigReaderKt.getRuleConfig((List)FileSize.access$getConfigRules$p(this.this$0), (org.cqfn.diktat.common.config.rules.Rule)Warnings.FILE_IS_TOO_LONG);
                if (object == null || (object = object.getConfiguration()) == null) {
                    object = MapsKt.emptyMap();
                }
                return new FileSizeConfiguration((Map<String, String>)object);
            }
            {
                this.this$0 = fileSize;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(FileSize.class);
        ignoreFolder = CollectionsKt.emptyList();
    }

    public static final /* synthetic */ List access$getConfigRules$p(FileSize $this) {
        return $this.configRules;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/cqfn/diktat/ruleset/rules/files/FileSize$FileSizeConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "ignoreFolders", "", "getIgnoreFolders", "()Ljava/util/List;", "maxSize", "", "getMaxSize", "()J", "diktat-rules"})
    public static final class FileSizeConfiguration
    extends RuleConfiguration {
        private final long maxSize;
        @NotNull
        private final List<String> ignoreFolders;

        public final long getMaxSize() {
            return this.maxSize;
        }

        @NotNull
        public final List<String> getIgnoreFolders() {
            return this.ignoreFolders;
        }

        public FileSizeConfiguration(@NotNull Map<String, String> config) {
            Object object;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter(config, (String)"config");
                    super(config);
                    Object object2 = config.get("maxSize");
                    long l = this.maxSize = object2 != null && (object2 = StringsKt.toLongOrNull((String)object2)) != null ? (Long)object2 : 2000L;
                    object = config.get("ignoreFolders");
                    if (object == null) break block2;
                    CharSequence charSequence = (CharSequence)object;
                    String string = "\\s+";
                    boolean bl = false;
                    string = new Regex(string);
                    String string2 = "";
                    boolean bl2 = false;
                    object = string.replace(charSequence, string2);
                    if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{FileSize.IGNORE_FOLDERS_SEPARATOR}, (boolean)false, (int)0, (int)6, null)) != null) break block3;
                }
                object = ignoreFolder;
            }
            this.ignoreFolders = object;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/cqfn/diktat/ruleset/rules/files/FileSize$Companion;", "", "()V", "IGNORE_FOLDERS_SEPARATOR", "", "MAX_SIZE", "", "SRC_PATH", "ignoreFolder", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

