/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.files;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.files.NewlinesRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 D2\u00020\u0001:\u0002DEB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001f\u0010%\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002Ji\u0010)\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u00142O\u0010+\u001aK\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\rj\u0002`\u0017H\u0016J\u001e\u0010,\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0003*\u00020-2\b\b\u0002\u0010.\u001a\u00020\u0014H\u0002J\u0014\u0010/\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0003*\u00020\u001bH\u0002J\"\u00100\u001a\u00020\u0016*\u00020\u001b2\u0006\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001b04H\u0002J\u0012\u00105\u001a\b\u0012\u0004\u0012\u00020\u001b06*\u00020\u001bH\u0002J\u0013\u00107\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b8*\u00020\u001bH\u0002J\f\u00109\u001a\u00020\u0014*\u00020\u001bH\u0002J\f\u0010:\u001a\u00020\u0014*\u00020\u001bH\u0002J\f\u0010;\u001a\u00020\u0014*\u00020\u001bH\u0002J\f\u0010<\u001a\u00020\u0014*\u00020\u001bH\u0002J\u0014\u0010=\u001a\u00020\u0014*\u0002022\u0006\u0010>\u001a\u00020?H\u0002J\f\u0010@\u001a\u00020\u0014*\u00020\u001bH\u0002J\u001a\u0010A\u001a\u00020\u0014*\b\u0012\u0004\u0012\u00020\u001b0\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\f\u0010B\u001a\u00020\u0014*\u00020\u001bH\u0002J\f\u0010C\u001a\u00020\u001b*\u00020\u001bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tRW\u0010\f\u001aK\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\rj\u0002`\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/cqfn/diktat/ruleset/rules/files/NewlinesRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "configuration", "Lorg/cqfn/diktat/ruleset/rules/files/NewlinesRule$NewlinesRuleConfiguration;", "getConfiguration", "()Lorg/cqfn/diktat/ruleset/rules/files/NewlinesRule$NewlinesRuleConfiguration;", "configuration$delegate", "Lkotlin/Lazy;", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "handleComma", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "handleFirstValueParameter", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;)Lkotlin/Unit;", "handleLambdaBody", "handleList", "handleOpeningParentheses", "handleOperatorWithLineBreakAfter", "handleOperatorWithLineBreakBefore", "handleReturnStatement", "handleSemicolon", "handleValueParameterList", "entryType", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;Ljava/lang/String;)Lkotlin/Unit;", "isMultilineLambda", "visit", "autoCorrect", "emit", "dotCalls", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "right", "getCallChain", "getOrderedCallExpressions", "psi", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "result", "", "getParentExpressions", "Lkotlin/sequences/Sequence;", "getParentIdentifier", "Lorg/jetbrains/annotations/NotNull;", "isCallsChain", "isDotFromPackageOrImport", "isElvisCorrect", "isFirstCall", "isFirstChildElementType", "elementType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "isInfixCall", "isNotValidCalls", "isSingleDotStatementOnSingleLine", "selfOrOperationReferenceParent", "Companion", "NewlinesRuleConfiguration", "diktat-rules"})
public final class NewlinesRule
extends com.pinterest.ktlint.core.Rule {
    private final Lazy configuration$delegate;
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;
    public static final int MAX_CALLS_IN_ONE_LINE = 3;
    private static final TokenSet lineBreakAfterOperators;
    private static final TokenSet lineBreakBeforeOperators;
    private static final TokenSet expressionTypes;
    private static final TokenSet chainExpressionTypes;
    private static final TokenSet dropChainValues;
    @NotNull
    public static final Companion Companion;

    private final NewlinesRuleConfiguration getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        NewlinesRule newlinesRule = this;
        Object var3_3 = null;
        boolean bl = false;
        return (NewlinesRuleConfiguration)((Object)lazy.getValue());
    }

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        block1: {
            IElementType iElementType;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block3: {
                                block2: {
                                    block0: {
                                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                                        Intrinsics.checkNotNullParameter(emit, (String)"emit");
                                        this.isFixMode = autoCorrect;
                                        this.emitWarn = emit;
                                        iElementType = node.getElementType();
                                        if (!Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSEMICOLON())) break block0;
                                        this.handleSemicolon(node);
                                        break block1;
                                    }
                                    if (!Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getOPERATION_REFERENCE()) && !Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getEQ())) break block2;
                                    this.handleOperatorWithLineBreakAfter(node);
                                    break block1;
                                }
                                if (!lineBreakBeforeOperators.contains(iElementType)) break block3;
                                this.handleOperatorWithLineBreakBefore(node);
                                break block1;
                            }
                            if (!Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) break block4;
                            this.handleOpeningParentheses(node);
                            break block1;
                        }
                        if (!Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCOMMA())) break block5;
                        this.handleComma(node);
                        break block1;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getBLOCK())) break block6;
                    this.handleLambdaBody(node);
                    break block1;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRETURN())) break block7;
                this.handleReturnStatement(node);
                break block1;
            }
            if (!Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSUPER_TYPE_LIST()) && !Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST())) break block1;
            this.handleList(node);
        }
    }

    private final void handleSemicolon(ASTNode node) {
        if (AstNodeUtilsKt.isEol(node)) {
            ASTNode aSTNode = node.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getENUM_ENTRY()) ^ true) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                Warnings.warnAndFix$default(Warnings.REDUNDANT_SEMICOLON, this.configRules, function3, this.isFixMode, AstNodeUtilsKt.extractLineOfText(node), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                    final /* synthetic */ ASTNode $node;

                    public final void invoke() {
                        this.$node.getTreeParent().removeChild(this.$node);
                    }
                    {
                        this.$node = aSTNode;
                        super(0);
                    }
                }, 64, null);
            }
        }
    }

    private final void handleOperatorWithLineBreakAfter(ASTNode node) {
        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getEQ())) {
            ASTNode aSTNode = node.getFirstChildNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.firstChildNode");
            if (!lineBreakAfterOperators.contains(aSTNode.getElementType()) && !this.isInfixCall(node)) {
                return;
            }
        }
        ASTNode aSTNode = PackageKt.prevCodeSibling((ASTNode)node);
        if (aSTNode != null) {
            if (AstNodeUtilsKt.isFollowedByNewline(aSTNode)) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.configRules, function3, this.isFixMode, "should break a line after and not before " + node.getText(), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                    final /* synthetic */ ASTNode $node;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        ASTNode aSTNode = this.$node;
                        boolean bl = false;
                        boolean bl2 = false;
                        ASTNode $this$run = aSTNode;
                        boolean bl3 = false;
                        $this$run.getTreeParent().removeChild($this$run.getTreePrev());
                        if (!AstNodeUtilsKt.isFollowedByNewline($this$run)) {
                            void it;
                            ASTNode aSTNode2 = $this$run.getTreeParent();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"treeParent");
                            ASTNode aSTNode3 = $this$run.getTreeNext();
                            boolean bl4 = false;
                            boolean bl5 = false;
                            ASTNode aSTNode4 = aSTNode3;
                            ASTNode aSTNode5 = aSTNode2;
                            boolean bl6 = false;
                            void v1 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                            boolean bl7 = Intrinsics.areEqual((Object)v1.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE());
                            AstNodeUtilsKt.appendNewlineMergingWhiteSpace(aSTNode5, (ASTNode)(bl7 ? aSTNode3 : null), $this$run.getTreeNext());
                        }
                    }
                    {
                        this.$node = aSTNode;
                        super(0);
                    }
                }, 64, null);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void handleOperatorWithLineBreakBefore(ASTNode node) {
        block6: {
            block5: {
                if (this.isDotFromPackageOrImport(node)) {
                    return;
                }
                var3_2 = Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getELVIS()) != false ? node.getTreeParent() : node;
                var4_3 = false;
                var5_4 = false;
                $this$run = var3_2;
                $i$a$-run-NewlinesRule$handleOperatorWithLineBreakBefore$isIncorrect$1 = false;
                if (!this.isCallsChain($this$run)) break block5;
                v0 = PackageKt.parent((ASTNode)$this$run, (Function1)handleOperatorWithLineBreakBefore.isIncorrect.1.isSingleLineIfElse.1.INSTANCE, (boolean)true);
                v1 = isSingleLineIfElse = v0 != null ? AstNodeUtilsKt.isSingleLineIfElse(v0) : false;
                if (!AstNodeUtilsKt.isFollowedByNewline($this$run) && AstNodeUtilsKt.isBeginByNewline($this$run) || isSingleLineIfElse) ** GOTO lbl-1000
                if (!this.isFirstCall($this$run)) ** GOTO lbl-1000
                v2 = $this$run.getTreeParent();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"treeParent");
                if (!this.isMultilineLambda(v2)) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                break block6;
            }
            v3 = AstNodeUtilsKt.isFollowedByNewline($this$run) && !this.isSingleDotStatementOnSingleLine($this$run);
        }
        isIncorrect = v3;
        if (isIncorrect || this.isElvisCorrect(node)) {
            freeText = this.isCallsChain(node) != false || this.isElvisCorrect(node) != false ? "should follow functional style at " + node.getText() : "should break a line before and not after " + node.getText();
            v4 = this.emitWarn;
            if (v4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.configRules, v4, this.isFixMode, freeText, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, node){
                final /* synthetic */ NewlinesRule this$0;
                final /* synthetic */ ASTNode $node;

                public final void invoke() {
                    block2: {
                        ASTNode it;
                        boolean bl;
                        boolean bl2;
                        ASTNode aSTNode;
                        ASTNode aSTNode2 = NewlinesRule.access$selfOrOperationReferenceParent(this.this$0, this.$node);
                        boolean bl3 = false;
                        boolean bl4 = false;
                        ASTNode $this$run = aSTNode2;
                        boolean bl5 = false;
                        if (!AstNodeUtilsKt.isBeginByNewline($this$run)) {
                            ASTNode aSTNode3 = $this$run.getTreeParent();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"treeParent");
                            aSTNode = $this$run.getTreePrev();
                            bl2 = false;
                            bl = false;
                            ASTNode aSTNode4 = aSTNode;
                            ASTNode aSTNode5 = aSTNode3;
                            boolean bl6 = false;
                            ASTNode aSTNode6 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode6, (String)"it");
                            boolean bl7 = Intrinsics.areEqual((Object)aSTNode6.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE());
                            AstNodeUtilsKt.appendNewlineMergingWhiteSpace(aSTNode5, (ASTNode)(bl7 ? aSTNode : null), $this$run);
                        }
                        if (!AstNodeUtilsKt.isFollowedByNewline($this$run)) break block2;
                        ASTNode aSTNode7 = PackageKt.parent((ASTNode)$this$run, (Function1)handleOperatorWithLineBreakBefore.1.2.INSTANCE, (boolean)false);
                        if (aSTNode7 != null) {
                            aSTNode = aSTNode7;
                            bl2 = false;
                            bl = false;
                            it = aSTNode;
                            boolean bl8 = false;
                            it.getTreeParent().removeChild(it.getTreeNext());
                        }
                    }
                }
                {
                    this.this$0 = newlinesRule;
                    this.$node = aSTNode;
                    super(0);
                }
            }, 64, null);
        }
    }

    private final void handleOpeningParentheses(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        List list = CollectionsKt.listOf((Object[])new IElementType[]{ElementType.INSTANCE.getVALUE_ARGUMENT_LIST(), ElementType.INSTANCE.getVALUE_PARAMETER_LIST()});
        ASTNode aSTNode = parent;
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"parent");
        if (list.contains(aSTNode.getElementType())) {
            Object object;
            ASTNode aSTNode2 = PackageKt.parent((ASTNode)node, (Function1)handleOpeningParentheses.prevWhiteSpace.1.INSTANCE, (boolean)false);
            if (aSTNode2 != null && (aSTNode2 = aSTNode2.getTreePrev()) != null) {
                ASTNode aSTNode3 = aSTNode2;
                boolean bl = false;
                boolean bl2 = false;
                ASTNode it = aSTNode3;
                boolean bl3 = false;
                object = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) ? aSTNode3 : null;
            } else {
                object = null;
            }
            ASTNode prevWhiteSpace2 = object;
            List list2 = CollectionsKt.listOf((Object[])new IElementType[]{ElementType.INSTANCE.getCALL_EXPRESSION(), ElementType.INSTANCE.getPRIMARY_CONSTRUCTOR(), ElementType.INSTANCE.getSECONDARY_CONSTRUCTOR(), ElementType.INSTANCE.getFUN()});
            ASTNode aSTNode4 = parent.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"parent.treeParent");
            boolean isNotAnonymous = list2.contains(aSTNode4.getElementType());
            if (prevWhiteSpace2 != null && isNotAnonymous) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.configRules, function3, this.isFixMode, "opening parentheses should not be separated from constructor or function name", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(prevWhiteSpace2){
                    final /* synthetic */ ASTNode $prevWhiteSpace;

                    public final void invoke() {
                        this.$prevWhiteSpace.getTreeParent().removeChild(this.$prevWhiteSpace);
                    }
                    {
                        this.$prevWhiteSpace = aSTNode;
                        super(0);
                    }
                }, 64, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void handleComma(ASTNode node) {
        ASTNode prevNewLine2;
        ASTNode aSTNode2 = PackageKt.parent((ASTNode)node, (Function1)handleComma.prevNewLine.1.INSTANCE, (boolean)false);
        aSTNode2 = aSTNode2;
        if (aSTNode == null) return;
        ASTNode aSTNode2 = aSTNode2.getTreePrev();
        aSTNode2 = aSTNode2;
        if (aSTNode3 == null) return;
        ASTNode aSTNode4 = aSTNode2;
        boolean bl = false;
        boolean bl2 = false;
        ASTNode it = aSTNode4;
        boolean bl3 = false;
        if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) return;
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) return;
        boolean bl4 = true;
        if (!bl4) return;
        ASTNode aSTNode6 = aSTNode4;
        aSTNode6 = prevNewLine2 = aSTNode6;
        if (aSTNode6 == null) return;
        aSTNode4 = aSTNode6;
        bl = false;
        bl2 = false;
        it = aSTNode4;
        boolean bl5 = false;
        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
        if (function3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
        }
        Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.configRules, function3, this.isFixMode, "newline should be placed only after comma", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(it){
            final /* synthetic */ ASTNode $it;

            public final void invoke() {
                this.$it.getTreeParent().removeChild(this.$it);
            }
            {
                this.$it = aSTNode;
                super(0);
            }
        }, 64, null);
    }

    private final void handleLambdaBody(ASTNode node) {
        ASTNode aSTNode = node.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL())) {
            Object v3;
            boolean isSingleLineLambda;
            block9: {
                ASTNode aSTNode2 = node.getTreeParent();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.treeParent");
                String string = aSTNode2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.treeParent.text");
                isSingleLineLambda = StringsKt.lines((CharSequence)string).size() == 1;
                Sequence sequence = PsiUtilsKt.siblings((ASTNode)node, (boolean)false);
                boolean bl = false;
                Sequence sequence2 = sequence;
                boolean bl2 = false;
                for (Object e : sequence2) {
                    ASTNode it = (ASTNode)e;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getARROW())) continue;
                    v3 = e;
                    break block9;
                }
                v3 = null;
            }
            ASTNode arrowNode = v3;
            if (!isSingleLineLambda && arrowNode != null) {
                List newlinesBeforeArrow2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.siblings((ASTNode)arrowNode, (boolean)false), (Function1)handleLambdaBody.newlinesBeforeArrow.1.INSTANCE));
                Collection collection = newlinesBeforeArrow2;
                boolean bl = false;
                if (!collection.isEmpty() || !AstNodeUtilsKt.isFollowedByNewline(arrowNode)) {
                    Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                    if (function3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                    }
                    Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.configRules, function3, this.isFixMode, "in lambda with several lines in body newline should be placed after an arrow", arrowNode.getStartOffset(), arrowNode, false, (Function0)new Function0<Unit>(newlinesBeforeArrow2, arrowNode){
                        final /* synthetic */ List $newlinesBeforeArrow;
                        final /* synthetic */ ASTNode $arrowNode;

                        public final void invoke() {
                            block1: {
                                Iterable $this$forEach$iv = this.$newlinesBeforeArrow;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    ASTNode it = (ASTNode)element$iv;
                                    boolean bl = false;
                                    it.getTreeParent().replaceChild(it, (ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "));
                                }
                                ASTNode aSTNode = this.$arrowNode.getTreeNext();
                                boolean bl = false;
                                boolean bl2 = false;
                                ASTNode it = aSTNode;
                                boolean bl3 = false;
                                ASTNode aSTNode2 = it;
                                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"it");
                                Object object = Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) ? aSTNode : null;
                                if (object == null) break block1;
                                AstNodeUtilsKt.leaveOnlyOneNewLine(object);
                            }
                        }
                        {
                            this.$newlinesBeforeArrow = list;
                            this.$arrowNode = aSTNode;
                            super(0);
                        }
                    }, 64, null);
                }
            } else if (!isSingleLineLambda && arrowNode == null) {
                ASTNode lbraceNode;
                ASTNode aSTNode3 = node.getTreeParent();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"node.treeParent");
                ASTNode aSTNode4 = lbraceNode = aSTNode3.getFirstChildNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"lbraceNode");
                if (!AstNodeUtilsKt.isFollowedByNewline(aSTNode4)) {
                    Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                    if (function3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                    }
                    Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.configRules, function3, this.isFixMode, "in lambda with several lines in body newline should be placed after an opening brace", lbraceNode.getStartOffset(), lbraceNode, false, (Function0)new Function0<Unit>(lbraceNode){
                        final /* synthetic */ ASTNode $lbraceNode;

                        public final void invoke() {
                            ASTNode aSTNode = this.$lbraceNode;
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"lbraceNode");
                            ASTNode aSTNode2 = aSTNode.getTreeNext();
                            boolean bl = false;
                            boolean bl2 = false;
                            ASTNode it = aSTNode2;
                            boolean bl3 = false;
                            ASTNode aSTNode3 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"it");
                            if (Intrinsics.areEqual((Object)aSTNode3.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                                AstNodeUtilsKt.leaveOnlyOneNewLine(it);
                            } else {
                                it.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), it);
                            }
                        }
                        {
                            this.$lbraceNode = aSTNode;
                            super(0);
                        }
                    }, 64, null);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void handleReturnStatement(ASTNode node) {
        block4: {
            var3_2 = node.getTreeParent();
            var4_4 = false;
            var5_6 = false;
            it = var3_2;
            $i$a$-takeIf-NewlinesRule$handleReturnStatement$blockNode$1 = false;
            v0 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
            if (!Intrinsics.areEqual((Object)v0.getElementType(), (Object)ElementType.INSTANCE.getBLOCK())) ** GOTO lbl-1000
            v1 = it.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.treeParent");
            if (Intrinsics.areEqual((Object)v1.getElementType(), (Object)ElementType.INSTANCE.getFUN())) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            blockNode = v2 != false ? var3_2 : null;
            v3 = returnsUnit = SequencesKt.count((Sequence)PsiUtilsKt.children((ASTNode)node)) == 1;
            if (blockNode == null || returnsUnit) {
                return;
            }
            var4_5 = SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)PsiUtilsKt.children((ASTNode)blockNode), (Function1)handleReturnStatement.1.INSTANCE));
            var5_6 = false;
            var6_8 = false;
            it = var4_5;
            $i$a$-takeIf-NewlinesRule$handleReturnStatement$2 = false;
            v4 = it.size() == 1 != false ? var4_5 : null;
            if (v4 == null) break block4;
            var4_5 = v4;
            var5_6 = false;
            var6_8 = false;
            it = var4_5;
            $i$a$-also-NewlinesRule$handleReturnStatement$3 = false;
            v5 = this.emitWarn;
            if (v5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.configRules, v5, this.isFixMode, "functions with single return statement should be simplified to expression body", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, node, blockNode){
                final /* synthetic */ NewlinesRule this$0;
                final /* synthetic */ ASTNode $node$inlined;
                final /* synthetic */ ASTNode $blockNode$inlined;
                {
                    this.this$0 = newlinesRule;
                    this.$node$inlined = aSTNode;
                    this.$blockNode$inlined = aSTNode2;
                    super(0);
                }

                public final void invoke() {
                    ASTNode funNode = this.$blockNode$inlined.getTreeParent();
                    ASTNode aSTNode = funNode.findChildByType(ElementType.INSTANCE.getCOLON());
                    Intrinsics.checkNotNull((Object)aSTNode);
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"funNode.findChildByType(COLON)!!");
                    ASTNode colon = aSTNode;
                    ASTNode aSTNode2 = this.$node$inlined.findChildByType(ElementType.INSTANCE.getRETURN_KEYWORD());
                    Intrinsics.checkNotNull((Object)aSTNode2);
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.findChildByType(RETURN_KEYWORD)!!");
                    ASTNode aSTNode3 = PackageKt.nextCodeSibling((ASTNode)aSTNode2);
                    Intrinsics.checkNotNull((Object)aSTNode3);
                    ASTNode expression = aSTNode3;
                    ASTNode aSTNode4 = funNode;
                    boolean bl = false;
                    boolean bl2 = false;
                    ASTNode $this$apply = aSTNode4;
                    boolean bl3 = false;
                    ASTNode aSTNode5 = colon.getTreePrev();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode5, (String)"colon.treePrev");
                    $this$apply.removeRange(Intrinsics.areEqual((Object)aSTNode5.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) ? colon.getTreePrev() : colon, null);
                    $this$apply.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "), null);
                    $this$apply.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getEQ(), (CharSequence)"="), null);
                    $this$apply.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "), null);
                    Object object = expression.clone();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.lang.ASTNode");
                    }
                    $this$apply.addChild((ASTNode)object, null);
                }
            }, 64, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleList(ASTNode node) {
        void numEntries;
        Pair pair;
        IElementType iElementType;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST())) {
            ASTNode aSTNode = node.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
            IElementType iElementType2 = aSTNode.getElementType();
            boolean bl = false;
            boolean bl2 = false;
            IElementType it = iElementType2;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getFUNCTION_TYPE()) || Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getFUNCTION_TYPE_RECEIVER())) {
                return;
            }
        }
        if (Intrinsics.areEqual((Object)(iElementType = node.getElementType()), (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST())) {
            PsiElement psiElement = node.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameterList");
            }
            pair = TuplesKt.to((Object)((KtParameterList)psiElement).getParameters().size(), (Object)"value parameters");
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSUPER_TYPE_LIST())) {
            PsiElement psiElement = node.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSuperTypeList");
            }
            pair = TuplesKt.to((Object)((KtSuperTypeList)psiElement).getEntries().size(), (Object)"supertype list entries");
        } else {
            AstNodeUtilsKt.getLog().warn("Unexpected node element type " + node.getElementType());
            return;
        }
        Pair pair2 = pair;
        int n = ((Number)pair2.component1()).intValue();
        String entryType = (String)pair2.component2();
        if (numEntries > this.getConfiguration().getMaxParametersInOneLine()) {
            pair2 = node.getElementType();
            if (Intrinsics.areEqual((Object)pair2, (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST())) {
                this.handleFirstValueParameter(node);
            }
            this.handleValueParameterList(node, entryType);
        }
    }

    private final Unit handleFirstValueParameter(ASTNode node) {
        Unit unit;
        List list = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.children((ASTNode)node), (Function1)handleFirstValueParameter.1.INSTANCE), (Function1)handleFirstValueParameter.2.INSTANCE));
        boolean bl = false;
        boolean bl2 = false;
        List it = list;
        boolean bl3 = false;
        List list2 = it.size() > 1 ? list : null;
        if (list2 != null) {
            list = list2;
            bl = false;
            bl2 = false;
            it = list;
            boolean bl4 = false;
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.configRules, function3, this.isFixMode, "first parameter should be placed on a separate line " + "or all other parameters should be aligned with it in declaration of <" + this.getParentIdentifier(node) + '>', node.getStartOffset(), node, false, (Function0)new Function0<Unit>(it, this, node){
                final /* synthetic */ List $it;
                final /* synthetic */ NewlinesRule this$0;
                final /* synthetic */ ASTNode $node$inlined;
                {
                    this.$it = list;
                    this.this$0 = newlinesRule;
                    this.$node$inlined = aSTNode;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void it;
                    ASTNode aSTNode = ((ASTNode)CollectionsKt.first((List)this.$it)).getTreePrev();
                    boolean bl = false;
                    boolean bl2 = false;
                    ASTNode aSTNode2 = aSTNode;
                    ASTNode aSTNode3 = this.$node$inlined;
                    boolean bl3 = false;
                    void v0 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
                    boolean bl4 = Intrinsics.areEqual((Object)v0.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE());
                    AstNodeUtilsKt.appendNewlineMergingWhiteSpace(aSTNode3, (ASTNode)(bl4 ? aSTNode : null), (ASTNode)CollectionsKt.first((List)this.$it));
                }
            }, 64, null);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final Unit handleValueParameterList(ASTNode node, String entryType) {
        Unit unit;
        List list = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.children((ASTNode)node), (Function1)handleValueParameterList.1.INSTANCE));
        boolean bl = false;
        boolean bl2 = false;
        List it = list;
        boolean bl3 = false;
        Collection collection = it;
        boolean bl4 = false;
        List list2 = !collection.isEmpty() ? list : null;
        if (list2 != null) {
            list = list2;
            bl = false;
            bl2 = false;
            List invalidCommas = list;
            boolean bl5 = false;
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.configRules, function3, this.isFixMode, entryType + " should be placed on different lines in declaration of <" + this.getParentIdentifier(node) + '>', node.getStartOffset(), node, false, (Function0)new Function0<Unit>(invalidCommas){
                final /* synthetic */ List $invalidCommas;

                public final void invoke() {
                    Iterable $this$forEach$iv = this.$invalidCommas;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ASTNode comma = (ASTNode)element$iv;
                        boolean bl = false;
                        ASTNode aSTNode = comma.getTreeNext();
                        boolean bl2 = false;
                        boolean bl3 = false;
                        ASTNode it = aSTNode;
                        boolean bl4 = false;
                        ASTNode aSTNode2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"it");
                        Object nextWhiteSpace = Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) ? aSTNode : null;
                        ASTNode aSTNode3 = nextWhiteSpace;
                        if (aSTNode3 == null || (aSTNode3 = aSTNode3.getTreeNext()) == null) {
                            aSTNode3 = comma.getTreeNext();
                        }
                        AstNodeUtilsKt.appendNewlineMergingWhiteSpace(comma, nextWhiteSpace, aSTNode3);
                    }
                }
                {
                    this.$invalidCommas = list;
                    super(0);
                }
            }, 64, null);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final String getParentIdentifier(ASTNode $this$getParentIdentifier) {
        ASTNode aSTNode;
        ASTNode aSTNode2 = $this$getParentIdentifier.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"treeParent");
        IElementType iElementType = aSTNode2.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getPRIMARY_CONSTRUCTOR())) {
            ASTNode aSTNode3 = $this$getParentIdentifier.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"treeParent");
            aSTNode = aSTNode3.getTreeParent();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSECONDARY_CONSTRUCTOR())) {
            ASTNode aSTNode4 = PackageKt.parent$default((ASTNode)$this$getParentIdentifier, (IElementType)ElementType.INSTANCE.getCLASS(), (boolean)false, (int)2, null);
            aSTNode = aSTNode4;
            Intrinsics.checkNotNull((Object)aSTNode4);
        } else {
            aSTNode = $this$getParentIdentifier.getTreeParent();
        }
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"when (treeParent.element\u2026 else -> treeParent\n    }");
        ASTNode aSTNode5 = AstNodeUtilsKt.getIdentifierName(aSTNode);
        return aSTNode5 != null ? aSTNode5.getText() : null;
    }

    private final void getOrderedCallExpressions(ASTNode $this$getOrderedCallExpressions, PsiElement psi, List<ASTNode> result) {
        PsiElement[] psiElementArray = psi.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"psi.children");
        PsiElement[] psiElementArray2 = psiElementArray;
        boolean bl = false;
        PsiElement[] psiElementArray3 = psiElementArray2;
        boolean bl2 = false;
        if (!(psiElementArray3.length == 0) && !this.isFirstChildElementType(psi, ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION()) && !this.isFirstChildElementType(psi, ElementType.INSTANCE.getSAFE_ACCESS_EXPRESSION())) {
            PsiElement firstChild;
            PsiElement psiElement = firstChild = psi.getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"firstChild");
            if (this.isFirstChildElementType(psiElement, ElementType.INSTANCE.getPOSTFIX_EXPRESSION())) {
                if (this.isFirstChildElementType(firstChild, ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION()) || this.isFirstChildElementType(firstChild, ElementType.INSTANCE.getSAFE_ACCESS_EXPRESSION())) {
                    PsiElement psiElement2 = firstChild.getFirstChild();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"firstChild.firstChild");
                    this.getOrderedCallExpressions($this$getOrderedCallExpressions, psiElement2, result);
                }
                ASTNode aSTNode = firstChild.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"firstChild.node");
                result.add(aSTNode);
            }
            ASTNode aSTNode = firstChild.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"firstChild.node");
            result.add((ASTNode)SequencesKt.first((Sequence)SequencesKt.dropWhile((Sequence)PsiUtilsKt.siblings((ASTNode)aSTNode, (boolean)true), (Function1)getOrderedCallExpressions.1.INSTANCE)));
        } else {
            PsiElement[] psiElementArray4 = psi.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray4, (String)"psi.children");
            psiElementArray2 = psiElementArray4;
            bl = false;
            psiElementArray3 = psiElementArray2;
            bl2 = false;
            if (!(psiElementArray3.length == 0)) {
                PsiElement psiElement = psi.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi.firstChild");
                this.getOrderedCallExpressions($this$getOrderedCallExpressions, psiElement, result);
                PsiElement psiElement3 = psi.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"psi.firstChild");
                ASTNode aSTNode = psiElement3.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"psi.firstChild\n                .node");
                result.add((ASTNode)SequencesKt.first((Sequence)SequencesKt.dropWhile((Sequence)PsiUtilsKt.siblings((ASTNode)aSTNode, (boolean)true), (Function1)getOrderedCallExpressions.2.INSTANCE)));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final List<ASTNode> dotCalls(KtBinaryExpression $this$dotCalls, boolean right) {
        KtExpression ktExpression2 = right ? $this$dotCalls.getRight() : $this$dotCalls.getLeft();
        ktExpression2 = ktExpression2;
        if (ktExpression == null) return null;
        ASTNode aSTNode = ktExpression2.getNode();
        ktExpression2 = aSTNode;
        if (aSTNode == null) return null;
        KtExpression ktExpression3 = ktExpression2;
        boolean bl = false;
        boolean bl2 = false;
        KtExpression it = ktExpression3;
        boolean bl3 = false;
        if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION())) return null;
        KtExpression ktExpression2 = ktExpression3;
        ktExpression2 = ktExpression2;
        if (ktExpression4 == null) return null;
        ASTNode aSTNode2 = ktExpression2.findChildByType(ElementType.INSTANCE.getDOT());
        ktExpression2 = aSTNode2;
        if (aSTNode2 == null) return null;
        List<ASTNode> list = this.getCallChain((ASTNode)ktExpression2);
        return list;
    }

    static /* synthetic */ List dotCalls$default(NewlinesRule newlinesRule, KtBinaryExpression ktBinaryExpression, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return newlinesRule.dotCalls(ktBinaryExpression, bl);
    }

    private final boolean isElvisCorrect(ASTNode $this$isElvisCorrect) {
        if (Intrinsics.areEqual((Object)$this$isElvisCorrect.getElementType(), (Object)ElementType.INSTANCE.getELVIS()) ^ true) {
            return false;
        }
        ASTNode aSTNode = $this$isElvisCorrect.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"this.treeParent");
        ASTNode aSTNode2 = aSTNode.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"this.treeParent.treeParent");
        PsiElement psiElement = aSTNode2.getPsi();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtBinaryExpression binaryExpression = (KtBinaryExpression)psiElement;
        List<ASTNode> leftDotCalls = this.dotCalls(binaryExpression, false);
        List rightDotCalls = NewlinesRule.dotCalls$default(this, binaryExpression, false, 1, null);
        List<ASTNode> list = leftDotCalls;
        List list2 = rightDotCalls;
        return (list != null ? list.size() : 0) + (list2 != null ? list2.size() : 0) > this.getConfiguration().getMaxCallsInOneLine() && !AstNodeUtilsKt.isBeginByNewline($this$isElvisCorrect);
    }

    private final ASTNode selfOrOperationReferenceParent(ASTNode $this$selfOrOperationReferenceParent) {
        ASTNode aSTNode = $this$selfOrOperationReferenceParent.getTreeParent();
        boolean bl = false;
        boolean bl2 = false;
        ASTNode it = aSTNode;
        boolean bl3 = false;
        ASTNode aSTNode2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"it");
        Object object = Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE()) ? aSTNode : null;
        if (object == null) {
            object = $this$selfOrOperationReferenceParent;
        }
        return object;
    }

    private final boolean isSingleDotStatementOnSingleLine(ASTNode $this$isSingleDotStatementOnSingleLine) {
        boolean bl;
        ASTNode aSTNode = (ASTNode)SequencesKt.singleOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.parents((ASTNode)$this$isSingleDotStatementOnSingleLine), (Function1)isSingleDotStatementOnSingleLine.1.INSTANCE));
        if (aSTNode != null) {
            ASTNode aSTNode2 = aSTNode;
            boolean bl2 = false;
            boolean bl3 = false;
            ASTNode it = aSTNode2;
            boolean bl4 = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            Collection collection = StringsKt.lines((CharSequence)string);
            boolean bl5 = false;
            bl = collection.size() == 1;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isDotFromPackageOrImport(ASTNode $this$isDotFromPackageOrImport) {
        return Intrinsics.areEqual((Object)$this$isDotFromPackageOrImport.getElementType(), (Object)ElementType.INSTANCE.getDOT()) && PackageKt.parent((ASTNode)$this$isDotFromPackageOrImport, (Function1)isDotFromPackageOrImport.1.INSTANCE, (boolean)true) != null;
    }

    private final boolean isFirstChildElementType(PsiElement $this$isFirstChildElementType, IElementType elementType) {
        PsiElement psiElement = $this$isFirstChildElementType.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"this.firstChild");
        ASTNode aSTNode = psiElement.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"this.firstChild.node");
        return Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)elementType);
    }

    private final boolean isCallsChain(ASTNode $this$isCallsChain) {
        List<ASTNode> list = this.getCallChain($this$isCallsChain);
        return list != null ? this.isNotValidCalls(list, $this$isCallsChain) : false;
    }

    private final List<ASTNode> getCallChain(ASTNode $this$getCallChain) {
        List list;
        ASTNode aSTNode = (ASTNode)SequencesKt.lastOrNull(this.getParentExpressions($this$getCallChain));
        if (aSTNode != null) {
            ASTNode aSTNode2 = aSTNode;
            boolean bl = false;
            boolean bl2 = false;
            ASTNode $this$run = aSTNode2;
            boolean bl3 = false;
            boolean bl4 = false;
            List list2 = new ArrayList();
            boolean bl5 = false;
            boolean bl6 = false;
            List it = list2;
            boolean bl7 = false;
            PsiElement psiElement = $this$run.getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi");
            this.getOrderedCallExpressions($this$run, psiElement, it);
            Iterable $this$dropWhile$iv = list2;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                ASTNode it2 = (ASTNode)item$iv;
                boolean bl8 = false;
                if (!it2.getTreeParent().textContains('(') && !it2.getTreeParent().textContains('{')) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            list = list$iv;
        } else {
            list = null;
        }
        return list;
    }

    private final boolean isNotValidCalls(List<? extends ASTNode> $this$isNotValidCalls, ASTNode node) {
        Object v3;
        block6: {
            if ($this$isNotValidCalls.size() == 1) {
                return false;
            }
            boolean bl = false;
            List callsByNewLine = new ArrayList();
            boolean bl2 = false;
            List callsInOneNewLine = new ArrayList();
            Iterable $this$forEach$iv = $this$isNotValidCalls;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl3 = false;
                ASTNode aSTNode = it.getTreePrev();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.treePrev");
                if (AstNodeUtilsKt.isFollowedByNewline(aSTNode) || PackageKt.isWhiteSpaceWithNewline((ASTNode)it.getTreePrev())) {
                    callsByNewLine.add(callsInOneNewLine);
                    boolean bl4 = false;
                    callsInOneNewLine = new ArrayList();
                    callsInOneNewLine.add(it);
                } else {
                    callsInOneNewLine.add(it);
                }
                ASTNode aSTNode2 = it.getTreePrev();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"it.treePrev");
                if (!Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)ElementType.INSTANCE.getPOSTFIX_EXPRESSION())) continue;
                ASTNode aSTNode3 = it.getTreePrev();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"it.treePrev");
                if (AstNodeUtilsKt.isFollowedByNewline(aSTNode3) || this.getConfiguration().getMaxCallsInOneLine() != 1) continue;
                return true;
            }
            callsByNewLine.add(callsInOneNewLine);
            Iterable iterable = callsByNewLine;
            boolean bl5 = false;
            Iterable iterable2 = iterable;
            boolean bl6 = false;
            Iterator iterator = iterable2.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                List it = (List)t;
                boolean bl7 = false;
                if (!it.contains(node)) continue;
                v3 = t;
                break block6;
            }
            v3 = null;
        }
        List list = v3;
        if (list == null) {
            return false;
        }
        return list.indexOf(node) + 1 > this.getConfiguration().getMaxCallsInOneLine();
    }

    private final Sequence<ASTNode> getParentExpressions(ASTNode $this$getParentExpressions) {
        return SequencesKt.takeWhile((Sequence)PsiUtilsKt.parents((ASTNode)$this$getParentExpressions), (Function1)getParentExpressions.1.INSTANCE);
    }

    private final boolean isMultilineLambda(ASTNode node) {
        int n;
        Object object = (ASTNode)CollectionsKt.firstOrNull((List)AstNodeUtilsKt.findAllNodesWithSpecificType$default(node, ElementType.INSTANCE.getLAMBDA_ARGUMENT(), false, 2, null));
        if (object != null && (object = object.getText()) != null) {
            CharSequence $this$count$iv = (CharSequence)object;
            boolean $i$f$count = false;
            int count$iv = 0;
            CharSequence charSequence = $this$count$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            n = count$iv;
        } else {
            n = -1;
        }
        return n > 0;
    }

    private final boolean isFirstCall(ASTNode $this$isFirstCall) {
        boolean bl;
        ASTNode aSTNode = (ASTNode)SequencesKt.lastOrNull(this.getParentExpressions($this$isFirstCall));
        if (aSTNode != null) {
            ASTNode aSTNode2 = aSTNode;
            boolean bl2 = false;
            boolean bl3 = false;
            ASTNode $this$run = aSTNode2;
            boolean bl4 = false;
            boolean bl5 = false;
            List list = new ArrayList();
            boolean bl6 = false;
            boolean bl7 = false;
            List it = list;
            boolean bl8 = false;
            PsiElement psiElement = $this$run.getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi");
            this.getOrderedCallExpressions($this$run, psiElement, it);
            ASTNode firstCallee = (ASTNode)CollectionsKt.first((List)list);
            IElementType iElementType = firstCallee.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"firstCallee.elementType");
            bl = (ASTNode)CollectionsKt.first(AstNodeUtilsKt.findAllNodesWithSpecificType($this$run, iElementType, false)) == $this$isFirstCall;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInfixCall(ASTNode $this$isInfixCall) {
        if (!Intrinsics.areEqual((Object)$this$isInfixCall.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) return false;
        ASTNode aSTNode = $this$isInfixCall.getFirstChildNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"firstChildNode");
        if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getIDENTIFIER())) return false;
        ASTNode aSTNode2 = $this$isInfixCall.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"treeParent");
        if (!Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION())) return false;
        return true;
    }

    public NewlinesRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("newlines");
        this.configRules = configRules;
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NewlinesRuleConfiguration>(this){
            final /* synthetic */ NewlinesRule this$0;

            @NotNull
            public final NewlinesRuleConfiguration invoke() {
                Object object = RulesConfigReaderKt.getRuleConfig((List)NewlinesRule.access$getConfigRules$p(this.this$0), (Rule)Warnings.WRONG_NEWLINES);
                if (object == null || (object = object.getConfiguration()) == null) {
                    object = MapsKt.emptyMap();
                }
                return new NewlinesRuleConfiguration((Map<String, String>)object);
            }
            {
                this.this$0 = newlinesRule;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{ElementType.INSTANCE.getANDAND(), ElementType.INSTANCE.getOROR(), ElementType.INSTANCE.getPLUS(), ElementType.INSTANCE.getPLUSEQ(), ElementType.INSTANCE.getMINUS(), ElementType.INSTANCE.getMINUSEQ(), ElementType.INSTANCE.getMUL(), ElementType.INSTANCE.getMULTEQ(), ElementType.INSTANCE.getDIV(), ElementType.INSTANCE.getDIVEQ()});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(ANDAND, \u2026 MUL, MULTEQ, DIV, DIVEQ)");
        lineBreakAfterOperators = tokenSet;
        TokenSet tokenSet2 = TokenSet.create((IElementType[])new IElementType[]{ElementType.INSTANCE.getDOT(), ElementType.INSTANCE.getSAFE_ACCESS(), ElementType.INSTANCE.getELVIS(), ElementType.INSTANCE.getCOLONCOLON()});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"TokenSet.create(DOT, SAF\u2026CCESS, ELVIS, COLONCOLON)");
        lineBreakBeforeOperators = tokenSet2;
        TokenSet tokenSet3 = TokenSet.create((IElementType[])new IElementType[]{ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION(), ElementType.INSTANCE.getSAFE_ACCESS_EXPRESSION(), ElementType.INSTANCE.getCALLABLE_REFERENCE_EXPRESSION(), ElementType.INSTANCE.getBINARY_EXPRESSION()});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"TokenSet.create(DOT_QUAL\u2026SSION, BINARY_EXPRESSION)");
        expressionTypes = tokenSet3;
        TokenSet tokenSet4 = TokenSet.create((IElementType[])new IElementType[]{ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION(), ElementType.INSTANCE.getSAFE_ACCESS_EXPRESSION()});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet4, (String)"TokenSet.create(DOT_QUAL\u2026, SAFE_ACCESS_EXPRESSION)");
        chainExpressionTypes = tokenSet4;
        TokenSet tokenSet5 = TokenSet.create((IElementType[])new IElementType[]{ElementType.INSTANCE.getEOL_COMMENT(), ElementType.INSTANCE.getWHITE_SPACE(), ElementType.INSTANCE.getBLOCK_COMMENT(), ElementType.INSTANCE.getKDOC()});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet5, (String)"TokenSet.create(EOL_COMM\u2026ACE, BLOCK_COMMENT, KDOC)");
        dropChainValues = tokenSet5;
    }

    public static final /* synthetic */ ASTNode access$selfOrOperationReferenceParent(NewlinesRule $this, ASTNode $this$access_u24selfOrOperationReferenceParent) {
        return $this.selfOrOperationReferenceParent($this$access_u24selfOrOperationReferenceParent);
    }

    public static final /* synthetic */ TokenSet access$getDropChainValues$cp() {
        return dropChainValues;
    }

    public static final /* synthetic */ TokenSet access$getExpressionTypes$cp() {
        return expressionTypes;
    }

    public static final /* synthetic */ TokenSet access$getChainExpressionTypes$cp() {
        return chainExpressionTypes;
    }

    public static final /* synthetic */ List access$getConfigRules$p(NewlinesRule $this) {
        return $this.configRules;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/files/NewlinesRule$NewlinesRuleConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "maxCallsInOneLine", "", "getMaxCallsInOneLine", "()I", "maxParametersInOneLine", "getMaxParametersInOneLine", "diktat-rules"})
    private static final class NewlinesRuleConfiguration
    extends RuleConfiguration {
        private final int maxParametersInOneLine;
        private final int maxCallsInOneLine;

        public final int getMaxParametersInOneLine() {
            return this.maxParametersInOneLine;
        }

        public final int getMaxCallsInOneLine() {
            return this.maxCallsInOneLine;
        }

        public NewlinesRuleConfiguration(@NotNull Map<String, String> config) {
            int n;
            int n2;
            boolean bl;
            String string;
            Intrinsics.checkNotNullParameter(config, (String)"config");
            super(config);
            String string2 = config.get("maxParametersInOneLine");
            if (string2 != null) {
                string = string2;
                bl = false;
                n2 = Integer.parseInt(string);
            } else {
                n2 = 2;
            }
            this.maxParametersInOneLine = n2;
            String string3 = config.get("maxCallsInOneLine");
            if (string3 != null) {
                string = string3;
                bl = false;
                n = Integer.parseInt(string);
            } else {
                n = 3;
            }
            this.maxCallsInOneLine = n;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/files/NewlinesRule$Companion;", "", "()V", "MAX_CALLS_IN_ONE_LINE", "", "chainExpressionTypes", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "dropChainValues", "expressionTypes", "lineBreakAfterOperators", "lineBreakBeforeOperators", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

