/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.constants;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.ChaptersKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b{\b\u0086\u0001\u0018\u0000 \u0099\u00012\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0002\u0099\u0001B\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ5\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0082\bJ\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0085\u0001\u0010\u0007\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102O\u0010\u0018\u001aK\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0003\u0012\u0004\u0012\u00020\u000e0\u0019j\u0002`\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014J\u009d\u0001\u0010\"\u001a\u00020\u000e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102O\u0010\u0018\u001aK\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0003\u0012\u0004\u0012\u00020\u000e0\u0019j\u0002`\u001f2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0003\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016J\u0006\u0010%\u001a\u00020\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?j\u0002\b@j\u0002\bAj\u0002\bBj\u0002\bCj\u0002\bDj\u0002\bEj\u0002\bFj\u0002\bGj\u0002\bHj\u0002\bIj\u0002\bJj\u0002\bKj\u0002\bLj\u0002\bMj\u0002\bNj\u0002\bOj\u0002\bPj\u0002\bQj\u0002\bRj\u0002\bSj\u0002\bTj\u0002\bUj\u0002\bVj\u0002\bWj\u0002\bXj\u0002\bYj\u0002\bZj\u0002\b[j\u0002\b\\j\u0002\b]j\u0002\b^j\u0002\b_j\u0002\b`j\u0002\baj\u0002\bbj\u0002\bcj\u0002\bdj\u0002\bej\u0002\bfj\u0002\bgj\u0002\bhj\u0002\bij\u0002\bjj\u0002\bkj\u0002\blj\u0002\bmj\u0002\bnj\u0002\boj\u0002\bpj\u0002\bqj\u0002\brj\u0002\bsj\u0002\btj\u0002\buj\u0002\bvj\u0002\bwj\u0002\bxj\u0002\byj\u0002\bzj\u0002\b{j\u0002\b|j\u0002\b}j\u0002\b~j\u0002\b\u007fj\u0003\b\u0080\u0001j\u0003\b\u0081\u0001j\u0003\b\u0082\u0001j\u0003\b\u0083\u0001j\u0003\b\u0084\u0001j\u0003\b\u0085\u0001j\u0003\b\u0086\u0001j\u0003\b\u0087\u0001j\u0003\b\u0088\u0001j\u0003\b\u0089\u0001j\u0003\b\u008a\u0001j\u0003\b\u008b\u0001j\u0003\b\u008c\u0001j\u0003\b\u008d\u0001j\u0003\b\u008e\u0001j\u0003\b\u008f\u0001j\u0003\b\u0090\u0001j\u0003\b\u0091\u0001j\u0003\b\u0092\u0001j\u0003\b\u0093\u0001j\u0003\b\u0094\u0001j\u0003\b\u0095\u0001j\u0003\b\u0096\u0001j\u0003\b\u0097\u0001j\u0003\b\u0098\u0001\u00a8\u0006\u009a\u0001"}, d2={"Lorg/cqfn/diktat/ruleset/constants/Warnings;", "", "Lorg/cqfn/diktat/common/config/rules/Rule;", "canBeAutoCorrected", "", "ruleId", "", "warn", "(Ljava/lang/String;IZLjava/lang/String;Ljava/lang/String;)V", "getCanBeAutoCorrected", "()Z", "getRuleId", "()Ljava/lang/String;", "fix", "", "configs", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "isFix", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoFix", "Lkotlin/Function0;", "ruleName", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "autoCorrected", "freeText", "warnAndFix", "configRules", "isFixMode", "warnText", "PACKAGE_NAME_MISSING", "PACKAGE_NAME_INCORRECT_CASE", "PACKAGE_NAME_INCORRECT_PREFIX", "PACKAGE_NAME_INCORRECT_SYMBOLS", "PACKAGE_NAME_INCORRECT_PATH", "INCORRECT_PACKAGE_SEPARATOR", "CLASS_NAME_INCORRECT", "OBJECT_NAME_INCORRECT", "VARIABLE_NAME_INCORRECT_FORMAT", "VARIABLE_NAME_INCORRECT", "CONSTANT_UPPERCASE", "VARIABLE_HAS_PREFIX", "IDENTIFIER_LENGTH", "ENUM_VALUE", "GENERIC_NAME", "BACKTICKS_PROHIBITED", "FUNCTION_NAME_INCORRECT_CASE", "FUNCTION_BOOLEAN_PREFIX", "FILE_NAME_INCORRECT", "EXCEPTION_SUFFIX", "CONFUSING_IDENTIFIER_NAMING", "MISSING_KDOC_TOP_LEVEL", "MISSING_KDOC_CLASS_ELEMENTS", "MISSING_KDOC_ON_FUNCTION", "KDOC_TRIVIAL_KDOC_ON_FUNCTION", "KDOC_WITHOUT_PARAM_TAG", "KDOC_WITHOUT_RETURN_TAG", "KDOC_WITHOUT_THROWS_TAG", "KDOC_EMPTY_KDOC", "KDOC_WRONG_SPACES_AFTER_TAG", "KDOC_WRONG_TAGS_ORDER", "KDOC_NEWLINES_BEFORE_BASIC_TAGS", "KDOC_NO_NEWLINES_BETWEEN_BASIC_TAGS", "KDOC_NO_NEWLINE_AFTER_SPECIAL_TAGS", "KDOC_NO_EMPTY_TAGS", "KDOC_NO_DEPRECATED_TAG", "KDOC_NO_CONSTRUCTOR_PROPERTY", "KDOC_EXTRA_PROPERTY", "KDOC_NO_CONSTRUCTOR_PROPERTY_WITH_COMMENT", "KDOC_CONTAINS_DATE_OR_AUTHOR", "HEADER_WRONG_FORMAT", "HEADER_MISSING_OR_WRONG_COPYRIGHT", "WRONG_COPYRIGHT_YEAR", "HEADER_MISSING_IN_NON_SINGLE_CLASS_FILE", "HEADER_NOT_BEFORE_PACKAGE", "COMMENTED_OUT_CODE", "WRONG_NEWLINES_AROUND_KDOC", "FIRST_COMMENT_NO_SPACES", "COMMENT_WHITE_SPACE", "IF_ELSE_COMMENTS", "FILE_IS_TOO_LONG", "FILE_CONTAINS_ONLY_COMMENTS", "FILE_INCORRECT_BLOCKS_ORDER", "FILE_NO_BLANK_LINE_BETWEEN_BLOCKS", "FILE_UNORDERED_IMPORTS", "FILE_WILDCARD_IMPORTS", "UNUSED_IMPORT", "NO_BRACES_IN_CONDITIONALS_AND_LOOPS", "WRONG_ORDER_IN_CLASS_LIKE_STRUCTURES", "BLANK_LINE_BETWEEN_PROPERTIES", "BRACES_BLOCK_STRUCTURE_ERROR", "WRONG_INDENTATION", "EMPTY_BLOCK_STRUCTURE_ERROR", "MORE_THAN_ONE_STATEMENT_PER_LINE", "LONG_LINE", "REDUNDANT_SEMICOLON", "WRONG_NEWLINES", "COMPLEX_EXPRESSION", "STRING_CONCATENATION", "TOO_MANY_BLANK_LINES", "WRONG_WHITESPACE", "TOO_MANY_CONSECUTIVE_SPACES", "ANNOTATION_NEW_LINE", "ENUMS_SEPARATED", "WHEN_WITHOUT_ELSE", "LONG_NUMERICAL_VALUES_SEPARATED", "WRONG_DECLARATIONS_ORDER", "WRONG_MULTIPLE_MODIFIERS_ORDER", "LOCAL_VARIABLE_EARLY_DECLARATION", "STRING_TEMPLATE_CURLY_BRACES", "STRING_TEMPLATE_QUOTES", "FILE_NAME_MATCH_CLASS", "NULLABLE_PROPERTY_TYPE", "TYPE_ALIAS", "SMART_CAST_NEEDED", "SAY_NO_TO_VAR", "GENERIC_VARIABLE_WRONG_DECLARATION", "FLOAT_IN_ACCURATE_CALCULATIONS", "AVOID_NULL_CHECKS", "TOO_LONG_FUNCTION", "AVOID_NESTED_FUNCTIONS", "LAMBDA_IS_NOT_LAST_PARAMETER", "TOO_MANY_PARAMETERS", "NESTED_BLOCK", "WRONG_OVERLOADING_FUNCTION_ARGUMENTS", "RUN_BLOCKING_INSIDE_ASYNC", "TOO_MANY_LINES_IN_LAMBDA", "CUSTOM_LABEL", "INVERSE_FUNCTION_PREFERRED", "SINGLE_CONSTRUCTOR_SHOULD_BE_PRIMARY", "USE_DATA_CLASS", "WRONG_NAME_OF_VARIABLE_INSIDE_ACCESSOR", "MULTIPLE_INIT_BLOCKS", "CLASS_SHOULD_NOT_BE_ABSTRACT", "CUSTOM_GETTERS_SETTERS", "COMPACT_OBJECT_INITIALIZATION", "USELESS_SUPERTYPE", "TRIVIAL_ACCESSORS_ARE_NOT_RECOMMENDED", "EXTENSION_FUNCTION_SAME_SIGNATURE", "EMPTY_PRIMARY_CONSTRUCTOR", "NO_CORRESPONDING_PROPERTY", "AVOID_USING_UTILITY_CLASS", "OBJECT_IS_PREFERRED", "INLINE_CLASS_CAN_BE_USED", "EXTENSION_FUNCTION_WITH_CLASS", "Companion", "diktat-rules"})
public final class Warnings
extends Enum<Warnings>
implements Rule {
    public static final /* enum */ Warnings PACKAGE_NAME_MISSING;
    public static final /* enum */ Warnings PACKAGE_NAME_INCORRECT_CASE;
    public static final /* enum */ Warnings PACKAGE_NAME_INCORRECT_PREFIX;
    public static final /* enum */ Warnings PACKAGE_NAME_INCORRECT_SYMBOLS;
    public static final /* enum */ Warnings PACKAGE_NAME_INCORRECT_PATH;
    public static final /* enum */ Warnings INCORRECT_PACKAGE_SEPARATOR;
    public static final /* enum */ Warnings CLASS_NAME_INCORRECT;
    public static final /* enum */ Warnings OBJECT_NAME_INCORRECT;
    public static final /* enum */ Warnings VARIABLE_NAME_INCORRECT_FORMAT;
    public static final /* enum */ Warnings VARIABLE_NAME_INCORRECT;
    public static final /* enum */ Warnings CONSTANT_UPPERCASE;
    public static final /* enum */ Warnings VARIABLE_HAS_PREFIX;
    public static final /* enum */ Warnings IDENTIFIER_LENGTH;
    public static final /* enum */ Warnings ENUM_VALUE;
    public static final /* enum */ Warnings GENERIC_NAME;
    public static final /* enum */ Warnings BACKTICKS_PROHIBITED;
    public static final /* enum */ Warnings FUNCTION_NAME_INCORRECT_CASE;
    public static final /* enum */ Warnings FUNCTION_BOOLEAN_PREFIX;
    public static final /* enum */ Warnings FILE_NAME_INCORRECT;
    public static final /* enum */ Warnings EXCEPTION_SUFFIX;
    public static final /* enum */ Warnings CONFUSING_IDENTIFIER_NAMING;
    public static final /* enum */ Warnings MISSING_KDOC_TOP_LEVEL;
    public static final /* enum */ Warnings MISSING_KDOC_CLASS_ELEMENTS;
    public static final /* enum */ Warnings MISSING_KDOC_ON_FUNCTION;
    public static final /* enum */ Warnings KDOC_TRIVIAL_KDOC_ON_FUNCTION;
    public static final /* enum */ Warnings KDOC_WITHOUT_PARAM_TAG;
    public static final /* enum */ Warnings KDOC_WITHOUT_RETURN_TAG;
    public static final /* enum */ Warnings KDOC_WITHOUT_THROWS_TAG;
    public static final /* enum */ Warnings KDOC_EMPTY_KDOC;
    public static final /* enum */ Warnings KDOC_WRONG_SPACES_AFTER_TAG;
    public static final /* enum */ Warnings KDOC_WRONG_TAGS_ORDER;
    public static final /* enum */ Warnings KDOC_NEWLINES_BEFORE_BASIC_TAGS;
    public static final /* enum */ Warnings KDOC_NO_NEWLINES_BETWEEN_BASIC_TAGS;
    public static final /* enum */ Warnings KDOC_NO_NEWLINE_AFTER_SPECIAL_TAGS;
    public static final /* enum */ Warnings KDOC_NO_EMPTY_TAGS;
    public static final /* enum */ Warnings KDOC_NO_DEPRECATED_TAG;
    public static final /* enum */ Warnings KDOC_NO_CONSTRUCTOR_PROPERTY;
    public static final /* enum */ Warnings KDOC_EXTRA_PROPERTY;
    public static final /* enum */ Warnings KDOC_NO_CONSTRUCTOR_PROPERTY_WITH_COMMENT;
    public static final /* enum */ Warnings KDOC_CONTAINS_DATE_OR_AUTHOR;
    public static final /* enum */ Warnings HEADER_WRONG_FORMAT;
    public static final /* enum */ Warnings HEADER_MISSING_OR_WRONG_COPYRIGHT;
    public static final /* enum */ Warnings WRONG_COPYRIGHT_YEAR;
    public static final /* enum */ Warnings HEADER_MISSING_IN_NON_SINGLE_CLASS_FILE;
    public static final /* enum */ Warnings HEADER_NOT_BEFORE_PACKAGE;
    public static final /* enum */ Warnings COMMENTED_OUT_CODE;
    public static final /* enum */ Warnings WRONG_NEWLINES_AROUND_KDOC;
    public static final /* enum */ Warnings FIRST_COMMENT_NO_SPACES;
    public static final /* enum */ Warnings COMMENT_WHITE_SPACE;
    public static final /* enum */ Warnings IF_ELSE_COMMENTS;
    public static final /* enum */ Warnings FILE_IS_TOO_LONG;
    public static final /* enum */ Warnings FILE_CONTAINS_ONLY_COMMENTS;
    public static final /* enum */ Warnings FILE_INCORRECT_BLOCKS_ORDER;
    public static final /* enum */ Warnings FILE_NO_BLANK_LINE_BETWEEN_BLOCKS;
    public static final /* enum */ Warnings FILE_UNORDERED_IMPORTS;
    public static final /* enum */ Warnings FILE_WILDCARD_IMPORTS;
    public static final /* enum */ Warnings UNUSED_IMPORT;
    public static final /* enum */ Warnings NO_BRACES_IN_CONDITIONALS_AND_LOOPS;
    public static final /* enum */ Warnings WRONG_ORDER_IN_CLASS_LIKE_STRUCTURES;
    public static final /* enum */ Warnings BLANK_LINE_BETWEEN_PROPERTIES;
    public static final /* enum */ Warnings BRACES_BLOCK_STRUCTURE_ERROR;
    public static final /* enum */ Warnings WRONG_INDENTATION;
    public static final /* enum */ Warnings EMPTY_BLOCK_STRUCTURE_ERROR;
    public static final /* enum */ Warnings MORE_THAN_ONE_STATEMENT_PER_LINE;
    public static final /* enum */ Warnings LONG_LINE;
    public static final /* enum */ Warnings REDUNDANT_SEMICOLON;
    public static final /* enum */ Warnings WRONG_NEWLINES;
    public static final /* enum */ Warnings COMPLEX_EXPRESSION;
    public static final /* enum */ Warnings STRING_CONCATENATION;
    public static final /* enum */ Warnings TOO_MANY_BLANK_LINES;
    public static final /* enum */ Warnings WRONG_WHITESPACE;
    public static final /* enum */ Warnings TOO_MANY_CONSECUTIVE_SPACES;
    public static final /* enum */ Warnings ANNOTATION_NEW_LINE;
    public static final /* enum */ Warnings ENUMS_SEPARATED;
    public static final /* enum */ Warnings WHEN_WITHOUT_ELSE;
    public static final /* enum */ Warnings LONG_NUMERICAL_VALUES_SEPARATED;
    public static final /* enum */ Warnings WRONG_DECLARATIONS_ORDER;
    public static final /* enum */ Warnings WRONG_MULTIPLE_MODIFIERS_ORDER;
    public static final /* enum */ Warnings LOCAL_VARIABLE_EARLY_DECLARATION;
    public static final /* enum */ Warnings STRING_TEMPLATE_CURLY_BRACES;
    public static final /* enum */ Warnings STRING_TEMPLATE_QUOTES;
    public static final /* enum */ Warnings FILE_NAME_MATCH_CLASS;
    public static final /* enum */ Warnings NULLABLE_PROPERTY_TYPE;
    public static final /* enum */ Warnings TYPE_ALIAS;
    public static final /* enum */ Warnings SMART_CAST_NEEDED;
    public static final /* enum */ Warnings SAY_NO_TO_VAR;
    public static final /* enum */ Warnings GENERIC_VARIABLE_WRONG_DECLARATION;
    public static final /* enum */ Warnings FLOAT_IN_ACCURATE_CALCULATIONS;
    public static final /* enum */ Warnings AVOID_NULL_CHECKS;
    public static final /* enum */ Warnings TOO_LONG_FUNCTION;
    public static final /* enum */ Warnings AVOID_NESTED_FUNCTIONS;
    public static final /* enum */ Warnings LAMBDA_IS_NOT_LAST_PARAMETER;
    public static final /* enum */ Warnings TOO_MANY_PARAMETERS;
    public static final /* enum */ Warnings NESTED_BLOCK;
    public static final /* enum */ Warnings WRONG_OVERLOADING_FUNCTION_ARGUMENTS;
    public static final /* enum */ Warnings RUN_BLOCKING_INSIDE_ASYNC;
    public static final /* enum */ Warnings TOO_MANY_LINES_IN_LAMBDA;
    public static final /* enum */ Warnings CUSTOM_LABEL;
    public static final /* enum */ Warnings INVERSE_FUNCTION_PREFERRED;
    public static final /* enum */ Warnings SINGLE_CONSTRUCTOR_SHOULD_BE_PRIMARY;
    public static final /* enum */ Warnings USE_DATA_CLASS;
    public static final /* enum */ Warnings WRONG_NAME_OF_VARIABLE_INSIDE_ACCESSOR;
    public static final /* enum */ Warnings MULTIPLE_INIT_BLOCKS;
    public static final /* enum */ Warnings CLASS_SHOULD_NOT_BE_ABSTRACT;
    public static final /* enum */ Warnings CUSTOM_GETTERS_SETTERS;
    public static final /* enum */ Warnings COMPACT_OBJECT_INITIALIZATION;
    public static final /* enum */ Warnings USELESS_SUPERTYPE;
    public static final /* enum */ Warnings TRIVIAL_ACCESSORS_ARE_NOT_RECOMMENDED;
    public static final /* enum */ Warnings EXTENSION_FUNCTION_SAME_SIGNATURE;
    public static final /* enum */ Warnings EMPTY_PRIMARY_CONSTRUCTOR;
    public static final /* enum */ Warnings NO_CORRESPONDING_PROPERTY;
    public static final /* enum */ Warnings AVOID_USING_UTILITY_CLASS;
    public static final /* enum */ Warnings OBJECT_IS_PREFERRED;
    public static final /* enum */ Warnings INLINE_CLASS_CAN_BE_USED;
    public static final /* enum */ Warnings EXTENSION_FUNCTION_WITH_CLASS;
    private static final /* synthetic */ Warnings[] $VALUES;
    private final boolean canBeAutoCorrected;
    @NotNull
    private final String ruleId;
    private final String warn;
    @NotNull
    private static final Lazy names$delegate;
    @NotNull
    public static final Companion Companion;

    static {
        Warnings[] warningsArray = new Warnings[115];
        Warnings[] warningsArray2 = warningsArray;
        warningsArray[0] = PACKAGE_NAME_MISSING = new Warnings(true, "1.2.1", "no package name declared in a file");
        warningsArray[1] = PACKAGE_NAME_INCORRECT_CASE = new Warnings(true, "1.2.1", "package name should be completely in a lower case");
        warningsArray[2] = PACKAGE_NAME_INCORRECT_PREFIX = new Warnings(true, "1.2.1", "package name should start from company's domain");
        warningsArray[3] = PACKAGE_NAME_INCORRECT_SYMBOLS = new Warnings(false, "1.2.1", "package name should contain only latin (ASCII) letters or numbers. For separation of words use dot");
        warningsArray[4] = PACKAGE_NAME_INCORRECT_PATH = new Warnings(true, "1.2.1", "package name does not match the directory hierarchy for this file, the real package name should be");
        warningsArray[5] = INCORRECT_PACKAGE_SEPARATOR = new Warnings(true, "1.2.1", "package name parts should be separated only by dots - there should be no other symbols like underscores (_)");
        warningsArray[6] = CLASS_NAME_INCORRECT = new Warnings(true, "1.3.1", "class/enum/interface name should be in PascalCase and should contain only latin (ASCII) letters or numbers");
        warningsArray[7] = OBJECT_NAME_INCORRECT = new Warnings(true, "1.3.1", "object structure name should be in PascalCase and should contain only latin (ASCII) letters or numbers");
        warningsArray[8] = VARIABLE_NAME_INCORRECT_FORMAT = new Warnings(true, "1.6.1", "variable name should be in lowerCamelCase and should contain only latin (ASCII) letters or numbers and should start from lower letter");
        warningsArray[9] = VARIABLE_NAME_INCORRECT = new Warnings(false, "1.1.1", "variable name should contain more than one letter");
        warningsArray[10] = CONSTANT_UPPERCASE = new Warnings(true, "1.5.1", "<val> properties from companion object or on file level mostly in all cases are constants - please use upper snake case for them");
        warningsArray[11] = VARIABLE_HAS_PREFIX = new Warnings(true, "1.1.1", "variable has prefix (like mVariable or M_VARIABLE), generally it is a bad code style (Android - is the only exception)");
        warningsArray[12] = IDENTIFIER_LENGTH = new Warnings(false, "1.1.1", "identifier's length is incorrect, it should be in range of [2, 64] symbols");
        warningsArray[13] = ENUM_VALUE = new Warnings(true, "1.3.1", "enum values should be in selected UPPER_CASE snake/PascalCase format");
        warningsArray[14] = GENERIC_NAME = new Warnings(true, "1.1.1", "generic name should contain only one single capital letter, it can be followed by a number");
        warningsArray[15] = BACKTICKS_PROHIBITED = new Warnings(false, "1.1.1", "backticks should not be used in identifier's naming. The only exception test methods marked with @Test annotation");
        warningsArray[16] = FUNCTION_NAME_INCORRECT_CASE = new Warnings(true, "1.4.1", "function/method name should be in lowerCamelCase");
        warningsArray[17] = FUNCTION_BOOLEAN_PREFIX = new Warnings(true, "1.6.2", "functions that return the value of Boolean type should have <is> or <has> prefix");
        warningsArray[18] = FILE_NAME_INCORRECT = new Warnings(true, "1.1.1", "file name is incorrect - it should end with .kt extension and be in PascalCase");
        warningsArray[19] = EXCEPTION_SUFFIX = new Warnings(true, "1.1.1", "all exception classes should have \"Exception\" suffix");
        warningsArray[20] = CONFUSING_IDENTIFIER_NAMING = new Warnings(false, "1.1.1", "it's a bad name for identifier");
        warningsArray[21] = MISSING_KDOC_TOP_LEVEL = new Warnings(false, "2.1.1", "all public and internal top-level classes and functions should have Kdoc");
        warningsArray[22] = MISSING_KDOC_CLASS_ELEMENTS = new Warnings(false, "2.1.1", "all public, internal and protected classes, functions and variables inside the class should have Kdoc");
        warningsArray[23] = MISSING_KDOC_ON_FUNCTION = new Warnings(true, "2.1.1", "all public, internal and protected functions should have Kdoc with proper tags");
        warningsArray[24] = KDOC_TRIVIAL_KDOC_ON_FUNCTION = new Warnings(false, "2.3.1", "KDocs should not be trivial (e.g. method getX should not de documented as 'returns X')");
        warningsArray[25] = KDOC_WITHOUT_PARAM_TAG = new Warnings(true, "2.1.2", "all methods which take arguments should have @param tags in KDoc");
        warningsArray[26] = KDOC_WITHOUT_RETURN_TAG = new Warnings(true, "2.1.2", "all methods which return values should have @return tag in KDoc");
        warningsArray[27] = KDOC_WITHOUT_THROWS_TAG = new Warnings(true, "2.1.2", "all methods which throw exceptions should have @throws tag in KDoc");
        warningsArray[28] = KDOC_EMPTY_KDOC = new Warnings(false, "2.1.3", "KDoc should never be empty");
        warningsArray[29] = KDOC_WRONG_SPACES_AFTER_TAG = new Warnings(true, "2.1.3", "there should be exactly one white space after tag name in KDoc");
        warningsArray[30] = KDOC_WRONG_TAGS_ORDER = new Warnings(true, "2.1.3", "in KDoc standard tags are arranged in order @param, @return, @throws, but are");
        warningsArray[31] = KDOC_NEWLINES_BEFORE_BASIC_TAGS = new Warnings(true, "2.1.3", "in KDoc block of standard tags @param, @return, @throws should contain newline before only if there is other content before it");
        warningsArray[32] = KDOC_NO_NEWLINES_BETWEEN_BASIC_TAGS = new Warnings(true, "2.1.3", "in KDoc standard tags @param, @return, @throws should not containt newline between them, but these tags do");
        warningsArray[33] = KDOC_NO_NEWLINE_AFTER_SPECIAL_TAGS = new Warnings(true, "2.1.3", "in KDoc there should be exactly one empty line after special tags");
        warningsArray[34] = KDOC_NO_EMPTY_TAGS = new Warnings(false, "2.2.1", "no empty descriptions in tag blocks are allowed");
        warningsArray[35] = KDOC_NO_DEPRECATED_TAG = new Warnings(true, "2.1.3", "KDoc doesn't support @deprecated tag, use @Deprecated annotation instead");
        warningsArray[36] = KDOC_NO_CONSTRUCTOR_PROPERTY = new Warnings(true, "2.1.1", "all properties from the primary constructor should be documented in a @property tag in KDoc");
        warningsArray[37] = KDOC_EXTRA_PROPERTY = new Warnings(false, "2.1.1", "There is property in KDoc which is not present in the class");
        warningsArray[38] = KDOC_NO_CONSTRUCTOR_PROPERTY_WITH_COMMENT = new Warnings(true, "2.1.1", "replace comment before property with @property tag in class KDoc");
        warningsArray[39] = KDOC_CONTAINS_DATE_OR_AUTHOR = new Warnings(false, "2.1.3", "KDoc should not contain creation date and author name");
        warningsArray[40] = HEADER_WRONG_FORMAT = new Warnings(true, "2.2.1", "file header comments should be properly formatted");
        warningsArray[41] = HEADER_MISSING_OR_WRONG_COPYRIGHT = new Warnings(true, "2.2.1", "file header comment must include copyright information inside a block comment");
        warningsArray[42] = WRONG_COPYRIGHT_YEAR = new Warnings(true, "2.2.1", "year defined in copyright and current year are different");
        warningsArray[43] = HEADER_MISSING_IN_NON_SINGLE_CLASS_FILE = new Warnings(false, "2.2.1", "files that contain multiple or no classes should contain description of what is inside of this file");
        warningsArray[44] = HEADER_NOT_BEFORE_PACKAGE = new Warnings(true, "2.2.1", "header KDoc should be placed before package and imports");
        warningsArray[45] = COMMENTED_OUT_CODE = new Warnings(false, "2.4.2", "you should not comment out code, use VCS to save it in history and delete this block");
        warningsArray[46] = WRONG_NEWLINES_AROUND_KDOC = new Warnings(true, "2.4.1", "there should be a blank line above the kDoc and there should not be no blank lines after kDoc");
        warningsArray[47] = FIRST_COMMENT_NO_SPACES = new Warnings(true, "2.4.1", "there should not be any spaces before first comment");
        warningsArray[48] = COMMENT_WHITE_SPACE = new Warnings(true, "2.4.1", "there should be a white space between code and comment also between code start token and comment text");
        warningsArray[49] = IF_ELSE_COMMENTS = new Warnings(true, "2.4.1", "invalid comments structure. Comment should be inside the block");
        warningsArray[50] = FILE_IS_TOO_LONG = new Warnings(false, "3.1.1", "file has more number of lines than expected");
        warningsArray[51] = FILE_CONTAINS_ONLY_COMMENTS = new Warnings(false, "3.1.2", "empty files or files that contain only comments should be avoided");
        warningsArray[52] = FILE_INCORRECT_BLOCKS_ORDER = new Warnings(true, "3.1.2", "general structure of kotlin source file is wrong, parts are in incorrect order");
        warningsArray[53] = FILE_NO_BLANK_LINE_BETWEEN_BLOCKS = new Warnings(true, "3.1.2", "general structure of kotlin source file is wrong, general code blocks sohuld be separated by empty lines");
        warningsArray[54] = FILE_UNORDERED_IMPORTS = new Warnings(true, "3.1.2", "imports should be ordered alphabetically and shouldn't be separated by newlines");
        warningsArray[55] = FILE_WILDCARD_IMPORTS = new Warnings(false, "3.1.2", "wildcard imports should not be used");
        warningsArray[56] = UNUSED_IMPORT = new Warnings(true, "3.1.2", "unused imports should be removed");
        warningsArray[57] = NO_BRACES_IN_CONDITIONALS_AND_LOOPS = new Warnings(true, "3.2.1", "in if, else, when, for, do, and while statements braces should be used. Exception: single line if statement.");
        warningsArray[58] = WRONG_ORDER_IN_CLASS_LIKE_STRUCTURES = new Warnings(true, "3.1.4", "the declaration part of a class-like code structures (class/interface/etc.) should be in the proper order");
        warningsArray[59] = BLANK_LINE_BETWEEN_PROPERTIES = new Warnings(true, "3.1.4", "there should be no blank lines between properties without comments; comment or KDoc on property should have blank line before");
        warningsArray[60] = BRACES_BLOCK_STRUCTURE_ERROR = new Warnings(true, "3.2.2", "braces should follow 1TBS style");
        warningsArray[61] = WRONG_INDENTATION = new Warnings(true, "3.3.1", "only spaces are allowed for indentation and each indentation should equal to 4 spaces (tabs are not allowed)");
        warningsArray[62] = EMPTY_BLOCK_STRUCTURE_ERROR = new Warnings(true, "3.4.1", "incorrect format of empty block");
        warningsArray[63] = MORE_THAN_ONE_STATEMENT_PER_LINE = new Warnings(true, "3.6.1", "there should not be more than one code statement in one line");
        warningsArray[64] = LONG_LINE = new Warnings(true, "3.5.1", "this line is longer than allowed");
        warningsArray[65] = REDUNDANT_SEMICOLON = new Warnings(true, "3.6.2", "there should be no redundant semicolon at the end of lines");
        warningsArray[66] = WRONG_NEWLINES = new Warnings(true, "3.6.2", "incorrect line breaking");
        warningsArray[67] = COMPLEX_EXPRESSION = new Warnings(false, "3.6.3", "complex dot qualified expression should be replaced with variable");
        warningsArray[68] = STRING_CONCATENATION = new Warnings(false, "3.15.1", "strings should not be concatenated using plus operator - use string templates instead if the statement fits one line");
        warningsArray[69] = TOO_MANY_BLANK_LINES = new Warnings(true, "3.7.1", "too many consecutive blank lines");
        warningsArray[70] = WRONG_WHITESPACE = new Warnings(true, "3.8.1", "incorrect usage of whitespaces for code separation");
        warningsArray[71] = TOO_MANY_CONSECUTIVE_SPACES = new Warnings(true, "3.8.1", "too many consecutive spaces");
        warningsArray[72] = ANNOTATION_NEW_LINE = new Warnings(true, "3.12.1", "annotations must be on new line");
        warningsArray[73] = ENUMS_SEPARATED = new Warnings(true, "3.9.1", "enum is incorrectly formatted");
        warningsArray[74] = WHEN_WITHOUT_ELSE = new Warnings(true, "3.11.1", "each 'when' statement must have else at the end");
        warningsArray[75] = LONG_NUMERICAL_VALUES_SEPARATED = new Warnings(true, "3.14.2", "long numerical values should be separated with underscore");
        warningsArray[76] = WRONG_DECLARATIONS_ORDER = new Warnings(true, "3.1.4", "declarations of constants and enum members should be sorted alphabetically");
        warningsArray[77] = WRONG_MULTIPLE_MODIFIERS_ORDER = new Warnings(true, "3.14.1", "sequence of modifier-keywords is incorrect");
        warningsArray[78] = LOCAL_VARIABLE_EARLY_DECLARATION = new Warnings(false, "3.10.2", "local variables should be declared close to the line where they are first used");
        warningsArray[79] = STRING_TEMPLATE_CURLY_BRACES = new Warnings(true, "3.15.2", "string template has redundant curly braces");
        warningsArray[80] = STRING_TEMPLATE_QUOTES = new Warnings(true, "3.15.2", "string template has redundant quotes");
        warningsArray[81] = FILE_NAME_MATCH_CLASS = new Warnings(true, "3.1.2", "file name is incorrect - it should match with the class described in it if there is the only one class declared");
        warningsArray[82] = NULLABLE_PROPERTY_TYPE = new Warnings(true, "4.3.1", "try to avoid use of nullable types");
        warningsArray[83] = TYPE_ALIAS = new Warnings(false, "4.2.2", "variable's type is too complex and should be replaced with typealias");
        warningsArray[84] = SMART_CAST_NEEDED = new Warnings(true, "4.2.1", "you can omit explicit casting");
        warningsArray[85] = SAY_NO_TO_VAR = new Warnings(false, "4.1.3", "Usage of a mutable variables with [var] modifier - is a bad style, use [val] instead");
        warningsArray[86] = GENERIC_VARIABLE_WRONG_DECLARATION = new Warnings(true, "4.3.2", "variable should have explicit type declaration");
        warningsArray[87] = FLOAT_IN_ACCURATE_CALCULATIONS = new Warnings(false, "4.1.1", "floating-point values shouldn't be used in accurate calculations");
        warningsArray[88] = AVOID_NULL_CHECKS = new Warnings(false, "4.3.3", "Try to avoid explicit null-checks");
        warningsArray[89] = TOO_LONG_FUNCTION = new Warnings(false, "5.1.1", "function is too long: split it or make more primitive");
        warningsArray[90] = AVOID_NESTED_FUNCTIONS = new Warnings(true, "5.1.3", "try to avoid using nested functions");
        warningsArray[91] = LAMBDA_IS_NOT_LAST_PARAMETER = new Warnings(false, "5.2.1", "lambda inside function parameters should be in the end");
        warningsArray[92] = TOO_MANY_PARAMETERS = new Warnings(false, "5.2.2", "function has too many parameters");
        warningsArray[93] = NESTED_BLOCK = new Warnings(false, "5.1.2", "function has too many nested blocks and should be simplified");
        warningsArray[94] = WRONG_OVERLOADING_FUNCTION_ARGUMENTS = new Warnings(false, "5.2.3", "use default argument instead of function overloading");
        warningsArray[95] = RUN_BLOCKING_INSIDE_ASYNC = new Warnings(false, "5.2.4", "avoid using runBlocking in asynchronous code");
        warningsArray[96] = TOO_MANY_LINES_IN_LAMBDA = new Warnings(false, "5.2.5", "long lambdas should have a parameter name instead of it");
        warningsArray[97] = CUSTOM_LABEL = new Warnings(false, "5.2.6", "avoid using expression with custom label");
        warningsArray[98] = INVERSE_FUNCTION_PREFERRED = new Warnings(true, "5.1.4", "it is better to use inverse function");
        warningsArray[99] = SINGLE_CONSTRUCTOR_SHOULD_BE_PRIMARY = new Warnings(true, "6.1.1", "if a class has single constructor, it should be converted to a primary constructor");
        warningsArray[100] = USE_DATA_CLASS = new Warnings(false, "6.1.2", "this class can be converted to a data class");
        warningsArray[101] = WRONG_NAME_OF_VARIABLE_INSIDE_ACCESSOR = new Warnings(false, "6.1.9", "use `field` keyword instead of property name inside property accessors");
        warningsArray[102] = MULTIPLE_INIT_BLOCKS = new Warnings(true, "6.1.4", "avoid using multiple `init` blocks, this logic can be moved to constructors or properties declarations");
        warningsArray[103] = CLASS_SHOULD_NOT_BE_ABSTRACT = new Warnings(true, "6.1.6", "class should not be abstract, because it has no abstract functions");
        warningsArray[104] = CUSTOM_GETTERS_SETTERS = new Warnings(false, "6.1.8", "custom getters and setters are not recommended, use class methods instead");
        warningsArray[105] = COMPACT_OBJECT_INITIALIZATION = new Warnings(true, "6.1.11", "class instance can be initialized in `apply` block");
        warningsArray[106] = USELESS_SUPERTYPE = new Warnings(true, "6.1.5", "unnecessary supertype specification");
        warningsArray[107] = TRIVIAL_ACCESSORS_ARE_NOT_RECOMMENDED = new Warnings(true, "6.1.10", "trivial property accessors are not recommended");
        warningsArray[108] = EXTENSION_FUNCTION_SAME_SIGNATURE = new Warnings(false, "6.2.2", "extension functions should not have same signature if their receiver classes are related");
        warningsArray[109] = EMPTY_PRIMARY_CONSTRUCTOR = new Warnings(true, "6.1.3", "avoid empty primary constructor");
        warningsArray[110] = NO_CORRESPONDING_PROPERTY = new Warnings(false, "6.1.7", "backing property should have the same name, but there is no corresponding property");
        warningsArray[111] = AVOID_USING_UTILITY_CLASS = new Warnings(false, "6.4.1", "avoid using utility classes/objects, use extensions functions");
        warningsArray[112] = OBJECT_IS_PREFERRED = new Warnings(true, "6.4.2", "it is better to use object for stateless classes");
        warningsArray[113] = INLINE_CLASS_CAN_BE_USED = new Warnings(true, "6.1.12", "inline class can be used");
        warningsArray[114] = EXTENSION_FUNCTION_WITH_CLASS = new Warnings(false, "6.2.3", "do not use extension functions for the class defined in the same file");
        $VALUES = warningsArray;
        Companion = new Companion(null);
        names$delegate = LazyKt.lazy((Function0)Companion.names.2.INSTANCE);
    }

    @NotNull
    public String ruleName() {
        return this.name();
    }

    @NotNull
    public final String warnText() {
        return '[' + this.ruleName() + "] " + this.warn + ':';
    }

    public final void warnAndFix(@NotNull List<RulesConfig> configRules, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean isFixMode, @NotNull String freeText, int offset2, @NotNull ASTNode node, boolean canBeAutoCorrected, @NotNull Function0<Unit> autoFix) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        Intrinsics.checkNotNullParameter((Object)freeText, (String)"freeText");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(autoFix, (String)"autoFix");
        this.warn(configRules, emit, canBeAutoCorrected, freeText, offset2, node);
        Warnings this_$iv = this;
        boolean $i$f$fix = false;
        if (ChaptersKt.isRuleFromActiveChapter(this_$iv, configRules) && RulesConfigReaderKt.isRuleEnabled(configRules, (Rule)this_$iv) && isFixMode && !AstNodeUtilsKt.hasSuppress(node, this_$iv.name())) {
            autoFix.invoke();
        }
    }

    public static /* synthetic */ void warnAndFix$default(Warnings warnings, List list, Function3 function3, boolean bl, String string, int n, ASTNode aSTNode, boolean bl2, Function0 function0, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            bl2 = warnings.canBeAutoCorrected;
        }
        warnings.warnAndFix(list, (Function3<? super Integer, ? super String, ? super Boolean, Unit>)function3, bl, string, n, aSTNode, bl2, (Function0<Unit>)function0);
    }

    public final void warn(@NotNull List<RulesConfig> configs, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean autoCorrected, @NotNull String freeText, int offset2, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(configs, (String)"configs");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        Intrinsics.checkNotNullParameter((Object)freeText, (String)"freeText");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (ChaptersKt.isRuleFromActiveChapter(this, configs) && RulesConfigReaderKt.isRuleEnabled(configs, (Rule)this) && !AstNodeUtilsKt.hasSuppress(node, this.name())) {
            List list = StringsKt.lines((CharSequence)freeText);
            boolean bl = false;
            boolean bl2 = false;
            List $this$run = list;
            boolean bl3 = false;
            String trimmedFreeText = $this$run.size() > 1 ? (String)CollectionsKt.first((List)$this$run) + "..." : (String)CollectionsKt.first((List)$this$run);
            emit.invoke((Object)offset2, (Object)(this.warnText() + ' ' + trimmedFreeText), (Object)autoCorrected);
        }
    }

    private final void fix(List<RulesConfig> configs, boolean isFix, ASTNode node, Function0<Unit> autoFix) {
        int $i$f$fix = 0;
        if (ChaptersKt.isRuleFromActiveChapter(this, configs) && RulesConfigReaderKt.isRuleEnabled(configs, (Rule)this) && isFix && !AstNodeUtilsKt.hasSuppress(node, this.name())) {
            autoFix.invoke();
        }
    }

    public final boolean getCanBeAutoCorrected() {
        return this.canBeAutoCorrected;
    }

    @NotNull
    public final String getRuleId() {
        return this.ruleId;
    }

    private Warnings(boolean canBeAutoCorrected, String ruleId, String warn) {
        this.canBeAutoCorrected = canBeAutoCorrected;
        this.ruleId = ruleId;
        this.warn = warn;
    }

    public static Warnings[] values() {
        return (Warnings[])$VALUES.clone();
    }

    public static Warnings valueOf(String string) {
        return Enum.valueOf(Warnings.class, string);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/constants/Warnings$Companion;", "", "()V", "names", "", "", "getNames", "()Ljava/util/List;", "names$delegate", "Lkotlin/Lazy;", "diktat-rules"})
    public static final class Companion {
        @NotNull
        public final List<String> getNames() {
            Lazy lazy = names$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (List)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

