/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter1;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.chapter1.FileNaming;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.StringCaseUtilsKt;
import org.cqfn.diktat.ruleset.utils.StringUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u001b\u001a\u00020\fH\u0002Ji\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000e2O\u0010\u001e\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter1/FileNaming;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "filePath", "isFixMode", "checkClassNameMatchesWithFile", "fileLevelNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "checkFileNaming", "node", "getFileParts", "Lkotlin/Pair;", "fileName", "visit", "autoCorrect", "emit", "Companion", "diktat-rules"})
public final class FileNaming
extends Rule {
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private String filePath;
    private final List<RulesConfig> configRules;
    @NotNull
    private static final List<String> validExtensions;
    @NotNull
    public static final Companion Companion;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            String string = this.filePath = AstNodeUtilsKt.getFilePath(node);
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filePath");
            }
            if (!StringUtilsKt.isKotlinScript(string)) {
                this.checkFileNaming(node);
                this.checkClassNameMatchesWithFile(node);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFileNaming(ASTNode node) {
        void name;
        String string = this.filePath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filePath");
        }
        Pair<String, String> pair = this.getFileParts(string);
        String string2 = (String)pair.component1();
        String extension = (String)pair.component2();
        if (!StringCaseUtilsKt.isPascalCase((String)name) || !validExtensions.contains(extension)) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.warnAndFix$default(Warnings.FILE_NAME_INCORRECT, this.configRules, function3, this.isFixMode, (String)name + extension, 0, node, false, checkFileNaming.1.INSTANCE, 64, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkClassNameMatchesWithFile(ASTNode fileLevelNode) {
        String string = this.filePath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filePath");
        }
        Pair<String, String> pair = this.getFileParts(string);
        String string2 = (String)pair.component1();
        String fileNameSuffix = (String)pair.component2();
        List<ASTNode> classes = AstNodeUtilsKt.getAllChildrenWithType(fileLevelNode, ElementType.INSTANCE.getCLASS());
        if (classes.size() == 1) {
            void fileNameWithoutSuffix;
            ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(classes.get(0), ElementType.INSTANCE.getIDENTIFIER());
            Intrinsics.checkNotNull((Object)aSTNode);
            String string3 = aSTNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"classes[0].getFirstChild\u2026thType(IDENTIFIER)!!.text");
            String className = string3;
            if (Intrinsics.areEqual((Object)className, (Object)fileNameWithoutSuffix) ^ true) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                Warnings.warnAndFix$default(Warnings.FILE_NAME_MATCH_CLASS, this.configRules, function3, this.isFixMode, (String)fileNameWithoutSuffix + fileNameSuffix + " vs " + className, 0, fileLevelNode, false, checkClassNameMatchesWithFile.1.INSTANCE, 64, null);
            }
        }
    }

    private final Pair<String, String> getFileParts(String fileName) {
        File file = new File(fileName);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        CharSequence charSequence = string;
        Regex regex = new Regex("\\..*");
        String string2 = "";
        boolean bl = false;
        String fileNameWithoutSuffix = regex.replace(charSequence, string2);
        String string3 = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.name");
        String fileNameSuffix = StringsKt.replace$default((String)string3, (String)fileNameWithoutSuffix, (String)"", (boolean)false, (int)4, null);
        return new Pair((Object)fileNameWithoutSuffix, (Object)fileNameSuffix);
    }

    public FileNaming(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("file-naming");
        this.configRules = configRules;
    }

    static {
        Companion = new Companion(null);
        validExtensions = CollectionsKt.listOf((Object[])new String[]{".kt", ".kts"});
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter1/FileNaming$Companion;", "", "()V", "validExtensions", "", "", "getValidExtensions", "()Ljava/util/List;", "diktat-rules"})
    public static final class Companion {
        @NotNull
        public final List<String> getValidExtensions() {
            return validExtensions;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

