/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.StringCaseUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001dB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002Ji\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000e2O\u0010\u001c\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/EmptyBlock;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "checkEmptyBlock", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter3/EmptyBlock$EmptyBlockStyleConfiguration;", "isAnonymousSamClass", "searchNode", "visit", "autoCorrect", "emit", "EmptyBlockStyleConfiguration", "diktat-rules"})
public final class EmptyBlock
extends Rule {
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        Object object = RulesConfigReaderKt.getRuleConfig(this.configRules, (org.cqfn.diktat.common.config.rules.Rule)Warnings.EMPTY_BLOCK_STRUCTURE_ERROR);
        if (object == null || (object = object.getConfiguration()) == null) {
            object = MapsKt.emptyMap();
        }
        EmptyBlockStyleConfiguration configuration2 = new EmptyBlockStyleConfiguration((Map<String, String>)object);
        this.searchNode(node, configuration2);
    }

    private final void searchNode(ASTNode node, EmptyBlockStyleConfiguration configuration2) {
        ASTNode aSTNode = AstNodeUtilsKt.findLBrace(node);
        if (aSTNode == null || (aSTNode = aSTNode.getTreeParent()) == null) {
            return;
        }
        ASTNode newNode = aSTNode;
        this.checkEmptyBlock(newNode, configuration2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void checkEmptyBlock(ASTNode node, EmptyBlockStyleConfiguration configuration2) {
        ASTNode aSTNode = node.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
        if (AstNodeUtilsKt.isOverridden(aSTNode)) return;
        if (this.isAnonymousSamClass(node)) {
            return;
        }
        if (!AstNodeUtilsKt.isBlockEmpty(node)) return;
        if (!configuration2.getEmptyBlockExist()) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            Warnings.EMPTY_BLOCK_STRUCTURE_ERROR.warn(this.configRules, function3, this.isFixMode, "empty blocks are forbidden unless it is function with override keyword", node.getStartOffset(), node);
            return;
        }
        ASTNode aSTNode2 = node.findChildByType(ElementType.INSTANCE.getRBRACE());
        Intrinsics.checkNotNull((Object)aSTNode2);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.findChildByType(RBRACE)!!");
        ASTNode space = aSTNode2.getTreePrev();
        if (configuration2.getEmptyBlockNewline()) {
            ASTNode aSTNode3 = space;
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"space");
            String string = aSTNode3.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"space.text");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                Warnings.warnAndFix$default(Warnings.EMPTY_BLOCK_STRUCTURE_ERROR, this.configRules, function3, this.isFixMode, "different style for empty block", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(space, node){
                    final /* synthetic */ ASTNode $space;
                    final /* synthetic */ ASTNode $node;

                    public final void invoke() {
                        ASTNode aSTNode = this.$space;
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"space");
                        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                            ASTNode aSTNode2 = this.$space;
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"space");
                            ASTNode aSTNode3 = aSTNode2.getTreeNext();
                            if (aSTNode3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)((LeafPsiElement)aSTNode3).replaceWithText("\n"), (String)"(space.treeNext as LeafP\u2026nt).replaceWithText(\"\\n\")");
                        } else {
                            ASTNode aSTNode4 = (ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n");
                            ASTNode aSTNode5 = this.$space;
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode5, (String)"space");
                            this.$node.addChild(aSTNode4, aSTNode5.getTreeNext());
                        }
                    }
                    {
                        this.$space = aSTNode;
                        this.$node = aSTNode2;
                        super(0);
                    }
                }, 64, null);
                return;
            }
        }
        if (configuration2.getEmptyBlockNewline()) return;
        ASTNode aSTNode4 = space;
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"space");
        String string = aSTNode4.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"space.text");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) return;
        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
        if (function3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
        }
        Warnings.warnAndFix$default(Warnings.EMPTY_BLOCK_STRUCTURE_ERROR, this.configRules, function3, this.isFixMode, "different style for empty block", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node, space){
            final /* synthetic */ ASTNode $node;
            final /* synthetic */ ASTNode $space;

            public final void invoke() {
                this.$node.removeChild(this.$space);
            }
            {
                this.$node = aSTNode;
                this.$space = aSTNode2;
                super(0);
            }
        }, 64, null);
    }

    private final boolean isAnonymousSamClass(ASTNode node) {
        boolean bl;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL()) && AstNodeUtilsKt.hasParent(node, ElementType.INSTANCE.getCALL_EXPRESSION())) {
            ASTNode aSTNode = AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getCALL_EXPRESSION());
            Intrinsics.checkNotNull((Object)aSTNode);
            ASTNode valueArgument = aSTNode;
            Object object = AstNodeUtilsKt.findLeafWithSpecificType(valueArgument, ElementType.INSTANCE.getIDENTIFIER());
            bl = object != null && (object = object.getText()) != null ? StringCaseUtilsKt.isPascalCase((String)object) : false;
        } else {
            bl = false;
        }
        return bl;
    }

    public EmptyBlock(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("empty-block-structure");
        this.configRules = configRules;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/EmptyBlock$EmptyBlockStyleConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "emptyBlockExist", "", "getEmptyBlockExist", "()Z", "emptyBlockNewline", "getEmptyBlockNewline", "diktat-rules"})
    public static final class EmptyBlockStyleConfiguration
    extends RuleConfiguration {
        private final boolean emptyBlockExist;
        private final boolean emptyBlockNewline;

        public final boolean getEmptyBlockExist() {
            return this.emptyBlockExist;
        }

        public final boolean getEmptyBlockNewline() {
            return this.emptyBlockNewline;
        }

        public EmptyBlockStyleConfiguration(@NotNull Map<String, String> config) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            String string;
            Intrinsics.checkNotNullParameter(config, (String)"config");
            super(config);
            String string2 = config.get("allowEmptyBlocks");
            if (string2 != null) {
                string = string2;
                bl3 = false;
                bl2 = Boolean.parseBoolean(string);
            } else {
                bl2 = false;
            }
            this.emptyBlockExist = bl2;
            String string3 = config.get("styleEmptyBlockWithNewline");
            if (string3 != null) {
                string = string3;
                bl3 = false;
                bl = Boolean.parseBoolean(string);
            } else {
                bl = true;
            }
            this.emptyBlockNewline = bl;
        }
    }
}

