/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.KotlinParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J(\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\fH\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\fH\u0002J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002Ji\u0010$\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u000e2O\u0010&\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/NullableTypeRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "checkProperty", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "findFixableForCollectionParam", "Lorg/cqfn/diktat/ruleset/rules/chapter3/NullableTypeRule$FixedParam;", "referenceText", "findFixableParam", "findSubstitution", "fixedParam", "replaceValue", "insertConstantType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "insertType", "textNode", "replaceValueByText", "nodeText", "replaceValueForString", "visit", "autoCorrect", "emit", "Companion", "FixedParam", "diktat-rules"})
public final class NullableTypeRule
extends Rule {
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;
    private static final List<String> allowExpression;
    @NotNull
    public static final Companion Companion;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.isFixMode = autoCorrect;
        this.emitWarn = emit;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY())) {
            this.checkProperty(node);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void checkProperty(ASTNode node) {
        block5: {
            block6: {
                if (!AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getVAL_KEYWORD())) return;
                if (!AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getEQ())) return;
                if (!AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getTYPE_REFERENCE())) return;
                ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getTYPE_REFERENCE());
                Intrinsics.checkNotNull((Object)aSTNode);
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.findChildByType(TYPE_REFERENCE)!!");
                ASTNode typeReferenceNode = aSTNode;
                if (AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getNULL()) || !AstNodeUtilsKt.findAllNodesWithSpecificType$default(node, ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION(), false, 2, null).isEmpty() || !AstNodeUtilsKt.hasChildOfType(typeReferenceNode, ElementType.INSTANCE.getNULLABLE_TYPE())) break block5;
                ASTNode aSTNode2 = typeReferenceNode.findChildByType(ElementType.INSTANCE.getNULLABLE_TYPE());
                Intrinsics.checkNotNull((Object)aSTNode2);
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"typeReferenceNode.findChildByType(NULLABLE_TYPE)!!");
                if (!AstNodeUtilsKt.hasChildOfType(aSTNode2, ElementType.INSTANCE.getQUEST())) break block5;
                ASTNode aSTNode3 = node.findChildByType(ElementType.INSTANCE.getCALL_EXPRESSION());
                if ((aSTNode3 != null ? aSTNode3.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION()) : null) == null) break block6;
                ASTNode aSTNode4 = node.findChildByType(ElementType.INSTANCE.getCALL_EXPRESSION());
                Intrinsics.checkNotNull((Object)aSTNode4);
                ASTNode aSTNode5 = aSTNode4.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
                Intrinsics.checkNotNull((Object)aSTNode5);
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode5, (String)"node.findChildByType(CAL\u2026e(REFERENCE_EXPRESSION)!!");
                if (!allowExpression.contains(aSTNode5.getText())) break block5;
            }
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getTYPE_REFERENCE());
            Intrinsics.checkNotNull((Object)aSTNode);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.findChildByType(TYPE_REFERENCE)!!");
            Warnings.NULLABLE_PROPERTY_TYPE.warn(this.configRules, function3, this.isFixMode, "don't use nullable type", aSTNode.getStartOffset(), node);
            return;
        }
        if (!AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getNULL())) return;
        FixedParam fixedParam = this.findFixableParam(node);
        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
        if (function3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
        }
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getNULL());
        Intrinsics.checkNotNull((Object)aSTNode);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.findChildByType(NULL)!!");
        Warnings.NULLABLE_PROPERTY_TYPE.warnAndFix(this.configRules, function3, this.isFixMode, "initialize explicitly", aSTNode.getStartOffset(), node, fixedParam != null, (Function0<Unit>)((Function0)new Function0<Unit>(this, fixedParam, node){
            final /* synthetic */ NullableTypeRule this$0;
            final /* synthetic */ FixedParam $fixedParam;
            final /* synthetic */ ASTNode $node;

            public final void invoke() {
                block0: {
                    FixedParam fixedParam = this.$fixedParam;
                    if (fixedParam == null) break block0;
                    FixedParam fixedParam2 = fixedParam;
                    boolean bl = false;
                    boolean bl2 = false;
                    FixedParam it = fixedParam2;
                    boolean bl3 = false;
                    NullableTypeRule.access$findSubstitution(this.this$0, this.$node, this.$fixedParam);
                }
            }
            {
                this.this$0 = nullableTypeRule;
                this.$fixedParam = fixedParam;
                this.$node = aSTNode;
                super(0);
            }
        }));
    }

    private final FixedParam findFixableParam(ASTNode node) {
        FixedParam fixedParam;
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getTYPE_REFERENCE());
        Intrinsics.checkNotNull((Object)aSTNode);
        ASTNode aSTNode2 = aSTNode.findChildByType(ElementType.INSTANCE.getNULLABLE_TYPE());
        Intrinsics.checkNotNull((Object)aSTNode2);
        ASTNode aSTNode3 = aSTNode2.findChildByType(ElementType.INSTANCE.getUSER_TYPE());
        if (aSTNode3 == null || (aSTNode3 = aSTNode3.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION())) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"node.findChildByType(TYP\u2026           ?: return null");
        ASTNode reference = aSTNode3;
        switch (reference.getText()) {
            case "Boolean": {
                fixedParam = new FixedParam(ElementType.INSTANCE.getBOOLEAN_CONSTANT(), ElementType.INSTANCE.getTRUE_KEYWORD(), "true", false, 8, null);
                break;
            }
            case "Byte": 
            case "Int": 
            case "Short": {
                fixedParam = new FixedParam(ElementType.INSTANCE.getINTEGER_CONSTANT(), ElementType.INSTANCE.getINTEGER_LITERAL(), "0", false, 8, null);
                break;
            }
            case "Double": {
                fixedParam = new FixedParam(ElementType.INSTANCE.getFLOAT_CONSTANT(), ElementType.INSTANCE.getFLOAT_LITERAL(), "0.0", false, 8, null);
                break;
            }
            case "Float": {
                fixedParam = new FixedParam(ElementType.INSTANCE.getFLOAT_CONSTANT(), ElementType.INSTANCE.getFLOAT_LITERAL(), "0.0F", false, 8, null);
                break;
            }
            case "Long": {
                fixedParam = new FixedParam(ElementType.INSTANCE.getINTEGER_CONSTANT(), ElementType.INSTANCE.getINTEGER_LITERAL(), "0L", false, 8, null);
                break;
            }
            case "Char": {
                fixedParam = new FixedParam(ElementType.INSTANCE.getCHARACTER_CONSTANT(), ElementType.INSTANCE.getCHARACTER_LITERAL(), "''", false, 8, null);
                break;
            }
            case "String": {
                fixedParam = new FixedParam(null, null, "", true);
                break;
            }
            default: {
                String string = reference.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reference.text");
                fixedParam = this.findFixableForCollectionParam(string);
            }
        }
        return fixedParam;
    }

    private final FixedParam findFixableForCollectionParam(String referenceText) {
        FixedParam fixedParam;
        switch (referenceText) {
            case "Iterable": 
            case "List": {
                fixedParam = new FixedParam(null, null, "emptyList()", false, 8, null);
                break;
            }
            case "Map": {
                fixedParam = new FixedParam(null, null, "emptyMap()", false, 8, null);
                break;
            }
            case "Array": {
                fixedParam = new FixedParam(null, null, "emptyArray()", false, 8, null);
                break;
            }
            case "Set": {
                fixedParam = new FixedParam(null, null, "emptySet()", false, 8, null);
                break;
            }
            case "Sequence": {
                fixedParam = new FixedParam(null, null, "emptySequence()", false, 8, null);
                break;
            }
            case "Queue": {
                fixedParam = new FixedParam(null, null, "LinkedList()", false, 8, null);
                break;
            }
            case "MutableList": {
                fixedParam = new FixedParam(null, null, "mutableListOf()", false, 8, null);
                break;
            }
            case "MutableMap": {
                fixedParam = new FixedParam(null, null, "mutableMapOf()", false, 8, null);
                break;
            }
            case "MutableSet": {
                fixedParam = new FixedParam(null, null, "mutableSetOf()", false, 8, null);
                break;
            }
            case "LinkedList": {
                fixedParam = new FixedParam(null, null, "LinkedList()", false, 8, null);
                break;
            }
            case "LinkedHashMap": {
                fixedParam = new FixedParam(null, null, "LinkedHashMap()", false, 8, null);
                break;
            }
            case "LinkedHashSet": {
                fixedParam = new FixedParam(null, null, "LinkedHashSet()", false, 8, null);
                break;
            }
            default: {
                fixedParam = null;
            }
        }
        return fixedParam;
    }

    private final void findSubstitution(ASTNode node, FixedParam fixedParam) {
        if (fixedParam.isString()) {
            this.replaceValueForString(node);
        } else if (fixedParam.getInsertConstantType() != null && fixedParam.getInsertType() != null) {
            this.replaceValue(node, fixedParam.getInsertConstantType(), fixedParam.getInsertType(), fixedParam.getTextNode());
        } else {
            this.replaceValueByText(node, fixedParam.getTextNode());
        }
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getTYPE_REFERENCE());
        Intrinsics.checkNotNull((Object)aSTNode);
        ASTNode aSTNode2 = aSTNode.findChildByType(ElementType.INSTANCE.getNULLABLE_TYPE());
        Intrinsics.checkNotNull((Object)aSTNode2);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.findChildByType(TYP\u2026ldByType(NULLABLE_TYPE)!!");
        ASTNode nullableNode = aSTNode2;
        ASTNode userTypeNode = nullableNode.getFirstChildNode();
        ASTNode aSTNode3 = node.findChildByType(ElementType.INSTANCE.getTYPE_REFERENCE());
        Intrinsics.checkNotNull((Object)aSTNode3);
        aSTNode3.replaceChild(nullableNode, userTypeNode);
    }

    private final void replaceValueByText(ASTNode node, String nodeText) {
        ASTNode newNode = KotlinParser.createNode$default(new KotlinParser(), nodeText, false, 2, null);
        if (Intrinsics.areEqual((Object)newNode.getElementType(), (Object)ElementType.INSTANCE.getCALL_EXPRESSION())) {
            ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getNULL());
            Intrinsics.checkNotNull((Object)aSTNode);
            node.replaceChild(aSTNode, newNode);
        }
    }

    private final void replaceValue(ASTNode node, IElementType insertConstantType, IElementType insertType, String textNode) {
        CompositeElement value = new CompositeElement(insertConstantType);
        ASTNode aSTNode = (ASTNode)value;
        ASTNode aSTNode2 = node.findChildByType(ElementType.INSTANCE.getNULL());
        Intrinsics.checkNotNull((Object)aSTNode2);
        node.addChild(aSTNode, aSTNode2);
        ASTNode aSTNode3 = node.findChildByType(ElementType.INSTANCE.getNULL());
        Intrinsics.checkNotNull((Object)aSTNode3);
        node.removeChild(aSTNode3);
        value.addChild((ASTNode)new LeafPsiElement(insertType, (CharSequence)textNode));
    }

    private final void replaceValueForString(ASTNode node) {
        CompositeElement value = new CompositeElement(ElementType.INSTANCE.getSTRING_TEMPLATE());
        ASTNode aSTNode = (ASTNode)value;
        ASTNode aSTNode2 = node.findChildByType(ElementType.INSTANCE.getNULL());
        Intrinsics.checkNotNull((Object)aSTNode2);
        node.addChild(aSTNode, aSTNode2);
        ASTNode aSTNode3 = node.findChildByType(ElementType.INSTANCE.getNULL());
        Intrinsics.checkNotNull((Object)aSTNode3);
        node.removeChild(aSTNode3);
        value.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getOPEN_QUOTE(), (CharSequence)""));
        value.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getCLOSING_QUOTE(), (CharSequence)""));
    }

    public NullableTypeRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("nullable-type");
        this.configRules = configRules;
    }

    static {
        Companion = new Companion(null);
        allowExpression = CollectionsKt.listOf((Object[])new String[]{"emptyList", "emptySequence", "emptyArray", "emptyMap", "emptySet", "listOf", "mapOf", "arrayOf", "sequenceOf", "setOf"});
    }

    public static final /* synthetic */ void access$findSubstitution(NullableTypeRule $this, ASTNode node, FixedParam fixedParam) {
        $this.findSubstitution(node, fixedParam);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J5\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/NullableTypeRule$FixedParam;", "", "insertConstantType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "insertType", "textNode", "", "isString", "", "(Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;Ljava/lang/String;Z)V", "getInsertConstantType", "()Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "getInsertType", "()Z", "getTextNode", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "diktat-rules"})
    private static final class FixedParam {
        @Nullable
        private final IElementType insertConstantType;
        @Nullable
        private final IElementType insertType;
        @NotNull
        private final String textNode;
        private final boolean isString;

        @Nullable
        public final IElementType getInsertConstantType() {
            return this.insertConstantType;
        }

        @Nullable
        public final IElementType getInsertType() {
            return this.insertType;
        }

        @NotNull
        public final String getTextNode() {
            return this.textNode;
        }

        public final boolean isString() {
            return this.isString;
        }

        public FixedParam(@Nullable IElementType insertConstantType, @Nullable IElementType insertType, @NotNull String textNode, boolean isString) {
            Intrinsics.checkNotNullParameter((Object)textNode, (String)"textNode");
            this.insertConstantType = insertConstantType;
            this.insertType = insertType;
            this.textNode = textNode;
            this.isString = isString;
        }

        public /* synthetic */ FixedParam(IElementType iElementType, IElementType iElementType2, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = false;
            }
            this(iElementType, iElementType2, string, bl);
        }

        @Nullable
        public final IElementType component1() {
            return this.insertConstantType;
        }

        @Nullable
        public final IElementType component2() {
            return this.insertType;
        }

        @NotNull
        public final String component3() {
            return this.textNode;
        }

        public final boolean component4() {
            return this.isString;
        }

        @NotNull
        public final FixedParam copy(@Nullable IElementType insertConstantType, @Nullable IElementType insertType, @NotNull String textNode, boolean isString) {
            Intrinsics.checkNotNullParameter((Object)textNode, (String)"textNode");
            return new FixedParam(insertConstantType, insertType, textNode, isString);
        }

        public static /* synthetic */ FixedParam copy$default(FixedParam fixedParam, IElementType iElementType, IElementType iElementType2, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                iElementType = fixedParam.insertConstantType;
            }
            if ((n & 2) != 0) {
                iElementType2 = fixedParam.insertType;
            }
            if ((n & 4) != 0) {
                string = fixedParam.textNode;
            }
            if ((n & 8) != 0) {
                bl = fixedParam.isString;
            }
            return fixedParam.copy(iElementType, iElementType2, string, bl);
        }

        @NotNull
        public String toString() {
            return "FixedParam(insertConstantType=" + this.insertConstantType + ", insertType=" + this.insertType + ", textNode=" + this.textNode + ", isString=" + this.isString + ")";
        }

        public int hashCode() {
            IElementType iElementType = this.insertConstantType;
            IElementType iElementType2 = this.insertType;
            String string = this.textNode;
            int n = (((iElementType != null ? iElementType.hashCode() : 0) * 31 + (iElementType2 != null ? iElementType2.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31;
            int n2 = this.isString ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FixedParam)) break block3;
                    FixedParam fixedParam = (FixedParam)object;
                    if (!Intrinsics.areEqual((Object)this.insertConstantType, (Object)fixedParam.insertConstantType) || !Intrinsics.areEqual((Object)this.insertType, (Object)fixedParam.insertType) || !Intrinsics.areEqual((Object)this.textNode, (Object)fixedParam.textNode) || this.isString != fixedParam.isString) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/NullableTypeRule$Companion;", "", "()V", "allowExpression", "", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

