/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3.files;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.chapter3.files.IndentationError;
import org.cqfn.diktat.ruleset.rules.chapter3.files.IndentationRule;
import org.cqfn.diktat.ruleset.rules.chapter3.files.IndentationRuleKt;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.indentation.CheckResult;
import org.cqfn.diktat.ruleset.utils.indentation.CustomIndentationChecker;
import org.cqfn.diktat.ruleset.utils.indentation.IndentationConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u00020\u0001:\u0002/0B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0010H\u0002J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0010H\u0002Ji\u0010&\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00162O\u0010(\u001aK\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u000fj\u0002`\u0019H\u0016J\u0018\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020,H\u0002J\u0014\u0010-\u001a\n .*\u0004\u0018\u00010\u001e0\u001e*\u00020\u001eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u0082.\u00a2\u0006\u0002\n\u0000RW\u0010\u000e\u001aK\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u000fj\u0002`\u0019X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "configuration", "Lorg/cqfn/diktat/ruleset/utils/indentation/IndentationConfig;", "getConfiguration", "()Lorg/cqfn/diktat/ruleset/utils/indentation/IndentationConfig;", "configuration$delegate", "Lkotlin/Lazy;", "customIndentationCheckers", "Lorg/cqfn/diktat/ruleset/utils/indentation/CustomIndentationChecker;", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "filePath", "isFixMode", "checkIndentation", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "checkIsIndentedWithSpaces", "checkNewlineAtEnd", "checkStringLiteral", "whiteSpace", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiWhiteSpace;", "expectedIndent", "fixStringLiteral", "visit", "autoCorrect", "emit", "visitWhiteSpace", "astNode", "context", "Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationRule$IndentContext;", "getExceptionalIndentInitiator", "kotlin.jvm.PlatformType", "Companion", "IndentContext", "diktat-rules"})
public final class IndentationRule
extends com.pinterest.ktlint.core.Rule {
    private boolean isFixMode;
    private final Lazy configuration$delegate;
    private String filePath;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private List<? extends CustomIndentationChecker> customIndentationCheckers;
    private final List<RulesConfig> configRules;
    public static final int INDENT_SIZE = 4;
    private static final List<IElementType> increasingTokens;
    private static final List<IElementType> decreasingTokens;
    private static final List<Pair<IElementType, IElementType>> matchingTokens;
    @NotNull
    public static final Companion Companion;

    private final IndentationConfig getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        IndentationRule indentationRule = this;
        Object var3_3 = null;
        boolean bl = false;
        return (IndentationConfig)((Object)lazy.getValue());
    }

    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.isFixMode = autoCorrect;
        this.emitWarn = emit;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            Collection<CustomIndentationChecker> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.filePath = AstNodeUtilsKt.getFilePath(node);
            Iterable iterable = CollectionsKt.listOf((Object[])new KFunction[]{visit.1.INSTANCE, visit.2.INSTANCE, visit.3.INSTANCE, visit.4.INSTANCE, visit.5.INSTANCE, visit.6.INSTANCE, visit.7.INSTANCE, visit.8.INSTANCE, visit.9.INSTANCE});
            IndentationRule indentationRule = this;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KFunction kFunction = (KFunction)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                CustomIndentationChecker customIndentationChecker = (CustomIndentationChecker)((Function1)it).invoke((Object)this.getConfiguration());
                collection.add(customIndentationChecker);
            }
            collection = (List)destination$iv$iv;
            indentationRule.customIndentationCheckers = collection;
            if (this.checkIsIndentedWithSpaces(node)) {
                this.checkIndentation(node);
            } else {
                AstNodeUtilsKt.getLog().warn("Not going to check indentation because there are tabs");
            }
            this.checkNewlineAtEnd(node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkIsIndentedWithSpaces(ASTNode node) {
        void $this$filterTo$iv$iv;
        boolean bl = false;
        List whiteSpaceNodes = new ArrayList();
        AstNodeUtilsKt.getAllLeafsWithSpecificType(node, ElementType.INSTANCE.getWHITE_SPACE(), whiteSpaceNodes);
        Iterable $this$filter$iv = whiteSpaceNodes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl2 = false;
            if (!it.textContains('\t')) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        boolean bl3 = false;
        Iterable $this$apply = $this$filter$iv;
        boolean bl4 = false;
        if ($this$apply.isEmpty()) {
            return true;
        }
        Iterable $this$forEach$iv = $this$filter$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl5 = false;
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            int n = it.getStartOffset();
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            Warnings.warnAndFix$default(Warnings.WRONG_INDENTATION, this.configRules, function3, this.isFixMode, "tabs are not allowed for indentation", n + StringsKt.indexOf$default((CharSequence)string, (char)'\t', (int)0, (boolean)false, (int)6, null), it, false, (Function0)new Function0<Unit>(it, this){
                final /* synthetic */ ASTNode $it;
                final /* synthetic */ IndentationRule this$0;
                {
                    this.$it = aSTNode;
                    this.this$0 = indentationRule;
                    super(0);
                }

                public final void invoke() {
                    ASTNode aSTNode = this.$it;
                    if (aSTNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
                    String string = ((LeafPsiElement)this.$it).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                    leafPsiElement.replaceWithText(StringsKt.replace$default((String)string, (String)"\t", (String)StringsKt.repeat((CharSequence)" ", (int)IndentationRule.access$getConfiguration$p(this.this$0).getIndentationSize()), (boolean)false, (int)4, null));
                }
            }, 64, null);
        }
        return this.isFixMode;
    }

    private final void checkNewlineAtEnd(ASTNode node) {
        if (this.getConfiguration().getNewlineAtEnd()) {
            ASTNode lastChild;
            ASTNode aSTNode = lastChild = node.getLastChildNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"lastChild");
            String string = aSTNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lastChild.text");
            CharSequence $this$count$iv = string;
            boolean $i$f$count = false;
            int count$iv = 0;
            CharSequence charSequence = $this$count$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv;
                char it = element$iv = charSequence.charAt(i);
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            int numBlankLinesAfter = count$iv;
            if (Intrinsics.areEqual((Object)lastChild.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) ^ true || numBlankLinesAfter != 1) {
                String warnText = Intrinsics.areEqual((Object)lastChild.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) ^ true || numBlankLinesAfter == 0 ? "no newline" : "too many blank lines";
                String string2 = this.filePath;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"filePath");
                }
                String string3 = File.Companion.getSeparator();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"File.separator");
                String fileName = StringsKt.substringAfterLast$default((String)string2, (String)string3, null, (int)2, null);
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                Warnings.warnAndFix$default(Warnings.WRONG_INDENTATION, this.configRules, function3, this.isFixMode, warnText + " at the end of file " + fileName, node.getStartOffset() + node.getTextLength(), node, false, (Function0)new Function0<Unit>(lastChild, node){
                    final /* synthetic */ ASTNode $lastChild;
                    final /* synthetic */ ASTNode $node;

                    public final void invoke() {
                        ASTNode aSTNode = this.$lastChild;
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"lastChild");
                        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) ^ true) {
                            this.$node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), null);
                        } else {
                            ASTNode aSTNode2 = this.$lastChild;
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"lastChild");
                            AstNodeUtilsKt.leaveOnlyOneNewLine(aSTNode2);
                        }
                    }
                    {
                        this.$lastChild = aSTNode;
                        this.$node = aSTNode2;
                        super(0);
                    }
                }, 64, null);
            }
        }
    }

    private final void checkIndentation(ASTNode node) {
        IndentContext context = new IndentContext(this.getConfiguration());
        PackageKt.visit((ASTNode)node, (Function1)((Function1)new Function1<ASTNode, Unit>(this, context){
            final /* synthetic */ IndentationRule this$0;
            final /* synthetic */ IndentContext $context;

            /*
             * Enabled aggressive block sorting
             */
            public final void invoke(@NotNull ASTNode astNode) {
                Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
                this.$context.checkAndReset(astNode);
                if (IndentationRule.access$getIncreasingTokens$cp().contains(astNode.getElementType())) {
                    IElementType iElementType = astNode.getElementType();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"astNode.elementType");
                    this.$context.storeIncrementingToken(iElementType);
                    return;
                }
                if (IndentationRule.access$getDecreasingTokens$cp().contains(astNode.getElementType())) {
                    ASTNode aSTNode = astNode.getTreePrev();
                    boolean bl = false;
                    boolean bl2 = false;
                    ASTNode it = aSTNode;
                    boolean bl3 = false;
                    ASTNode aSTNode2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"it");
                    if (!(Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && it.textContains('\n'))) {
                        IElementType iElementType = astNode.getElementType();
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"astNode.elementType");
                        this.$context.dec(iElementType);
                        return;
                    }
                }
                if (!Intrinsics.areEqual((Object)astNode.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) return;
                if (!astNode.textContains('\n')) return;
                if (astNode.getTreeNext() == null) return;
                IndentationRule.access$visitWhiteSpace(this.this$0, astNode, this.$context);
            }
            {
                this.this$0 = indentationRule;
                this.$context = indentContext;
                super(1);
            }
        }));
    }

    private final void visitWhiteSpace(ASTNode astNode, IndentContext context) {
        CheckResult checkResult;
        CheckResult checkResult2;
        IndentationError indentError;
        PsiWhiteSpace whiteSpace;
        block9: {
            context.maybeIncrement();
            PsiElement psiElement = astNode.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace");
            }
            whiteSpace = (PsiWhiteSpace)psiElement;
            ASTNode aSTNode = astNode.getTreeNext();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"astNode.treeNext");
            if (decreasingTokens.contains(aSTNode.getElementType())) {
                ASTNode aSTNode2 = astNode.getTreeNext();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"astNode.treeNext");
                IElementType iElementType = aSTNode2.getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"astNode.treeNext.elementType");
                context.dec(iElementType);
            }
            int n = context.indent();
            String string = astNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"astNode.text");
            indentError = new IndentationError(n, IndentationRuleKt.lastIndent(string));
            List<? extends CustomIndentationChecker> list = this.customIndentationCheckers;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customIndentationCheckers");
            }
            Iterable $this$firstNotNullResult$iv = list;
            boolean $i$f$firstNotNullResult = false;
            for (Object element$iv : $this$firstNotNullResult$iv) {
                CustomIndentationChecker it = (CustomIndentationChecker)element$iv;
                boolean bl = false;
                CheckResult result$iv = it.checkNode(whiteSpace, indentError);
                if (result$iv == null) continue;
                checkResult2 = result$iv;
                break block9;
            }
            checkResult2 = null;
        }
        CheckResult checkResult3 = checkResult = checkResult2;
        int expectedIndent2 = checkResult3 != null ? checkResult3.getExpectedIndent() : indentError.getExpected();
        CheckResult checkResult4 = checkResult;
        if (checkResult4 != null) {
            if (checkResult4.getAdjustNext()) {
                ASTNode exceptionInitiatorNode;
                ASTNode aSTNode = exceptionInitiatorNode = this.getExceptionalIndentInitiator(astNode);
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"exceptionInitiatorNode");
                context.addException(aSTNode, expectedIndent2 - indentError.getExpected(), checkResult.getIncludeLastChild());
            }
        }
        CheckResult checkResult5 = checkResult;
        if (checkResult5 == null || !checkResult5.isCorrect()) {
            if (expectedIndent2 != indentError.getActual()) {
                Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
                if (function3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
                }
                String string = "expected " + expectedIndent2 + " but was " + indentError.getActual();
                int n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)whiteSpace));
                String string2 = whiteSpace.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"whiteSpace.text");
                int n2 = n + StringsKt.lastIndexOf$default((CharSequence)string2, (char)'\n', (int)0, (boolean)false, (int)6, null) + 1;
                ASTNode aSTNode = whiteSpace.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"whiteSpace.node");
                Warnings.warnAndFix$default(Warnings.WRONG_INDENTATION, this.configRules, function3, this.isFixMode, string, n2, aSTNode, false, (Function0)new Function0<Unit>(this, whiteSpace, expectedIndent2){
                    final /* synthetic */ IndentationRule this$0;
                    final /* synthetic */ PsiWhiteSpace $whiteSpace;
                    final /* synthetic */ int $expectedIndent;

                    public final void invoke() {
                        IndentationRule.access$checkStringLiteral(this.this$0, this.$whiteSpace, this.$expectedIndent);
                        ASTNode aSTNode = this.$whiteSpace.getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"whiteSpace.node");
                        AstNodeUtilsKt.indentBy(aSTNode, this.$expectedIndent);
                    }
                    {
                        this.this$0 = indentationRule;
                        this.$whiteSpace = psiWhiteSpace;
                        this.$expectedIndent = n;
                        super(0);
                    }
                }, 64, null);
            }
        }
    }

    private final void checkStringLiteral(PsiWhiteSpace whiteSpace, int expectedIndent2) {
        ASTNode aSTNode = whiteSpace.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"whiteSpace.node");
        ASTNode nextNode2 = aSTNode.getTreeNext();
        if (nextNode2 != null && Intrinsics.areEqual((Object)nextNode2.getElementType(), (Object)ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION())) {
            ASTNode aSTNode2 = nextNode2.getFirstChildNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"nextNode.firstChildNode");
            if (Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)ElementType.INSTANCE.getSTRING_TEMPLATE())) {
                ASTNode aSTNode3 = nextNode2.getFirstChildNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"nextNode.firstChildNode");
                String string = aSTNode3.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextNode.firstChildNode.text");
                if (StringsKt.startsWith$default((String)string, (String)"\"\"\"", (boolean)false, (int)2, null)) {
                    Object object = nextNode2.findChildByType(ElementType.INSTANCE.getCALL_EXPRESSION());
                    if (object != null && (object = object.getText()) != null) {
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        if (Intrinsics.areEqual((Object)it, (Object)"trimIndent()") || Intrinsics.areEqual((Object)it, (Object)"trimMargin()")) {
                            this.fixStringLiteral(whiteSpace, expectedIndent2);
                        }
                    }
                }
            }
        }
    }

    private final void fixStringLiteral(PsiWhiteSpace whiteSpace, int expectedIndent2) {
        String textIndent = StringsKt.repeat((CharSequence)" ", (int)(expectedIndent2 + 4));
        ASTNode aSTNode = whiteSpace.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"whiteSpace.node");
        ASTNode aSTNode2 = aSTNode.getTreeNext();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"whiteSpace.node.treeNext");
        ASTNode aSTNode3 = aSTNode2.getFirstChildNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"whiteSpace.node.treeNext.firstChildNode");
        List<ASTNode> templateEntries = AstNodeUtilsKt.getAllChildrenWithType(aSTNode3, ElementType.INSTANCE.getLITERAL_STRING_TEMPLATE_ENTRY());
        Iterable $this$forEach$iv = templateEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) continue;
            String string2 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.text");
            CharSequence charSequence = string2;
            boolean bl2 = false;
            if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
            ASTNode aSTNode4 = it.getFirstChildNode();
            if (aSTNode4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
            }
            LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode4;
            StringBuilder stringBuilder = new StringBuilder().append(textIndent);
            ASTNode aSTNode5 = it.getFirstChildNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode5, (String)"it.firstChildNode");
            String string3 = aSTNode5.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.firstChildNode.text");
            charSequence = string3;
            bl2 = false;
            CharSequence charSequence2 = charSequence;
            if (charSequence2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            leafPsiElement.rawReplaceWithText(stringBuilder.append(((Object)StringsKt.trim((CharSequence)charSequence2)).toString()).toString());
        }
        ASTNode aSTNode6 = ((ASTNode)CollectionsKt.last(templateEntries)).getFirstChildNode();
        if (aSTNode6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
        }
        LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode6;
        StringBuilder stringBuilder = new StringBuilder().append(StringsKt.repeat((CharSequence)" ", (int)expectedIndent2));
        ASTNode aSTNode7 = ((ASTNode)CollectionsKt.last(templateEntries)).getFirstChildNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode7, (String)"templateEntries\n        \u2026          .firstChildNode");
        String string = aSTNode7.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"templateEntries\n        \u2026ode\n                .text");
        String string4 = string;
        boolean bl = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        leafPsiElement.rawReplaceWithText(stringBuilder.append(((Object)StringsKt.trim((CharSequence)string5)).toString()).toString());
    }

    private final ASTNode getExceptionalIndentInitiator(ASTNode $this$getExceptionalIndentInitiator) {
        ASTNode aSTNode;
        ASTNode aSTNode2 = $this$getExceptionalIndentInitiator.getTreeParent();
        boolean bl = false;
        boolean bl2 = false;
        ASTNode parent = aSTNode2;
        boolean bl3 = false;
        ASTNode aSTNode3 = parent;
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"parent");
        PsiElement psiElement = aSTNode3.getPsi();
        if (psiElement instanceof KtDotQualifiedExpression) {
            aSTNode = (ASTNode)SequencesKt.last((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.parents((ASTNode)$this$getExceptionalIndentInitiator), (Function1)getExceptionalIndentInitiator.1.1.INSTANCE));
        } else if (psiElement instanceof KtIfExpression) {
            ASTNode aSTNode4 = parent.findChildByType(ElementType.INSTANCE.getTHEN());
            if (aSTNode4 == null) {
                aSTNode4 = aSTNode = parent.findChildByType(ElementType.INSTANCE.getELSE());
            }
            if (aSTNode4 == null) {
                aSTNode = parent;
            }
        } else if (psiElement instanceof KtLoopExpression) {
            PsiElement psiElement2 = parent.getPsi();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLoopExpression");
            }
            aSTNode = ((KtLoopExpression)psiElement2).getBody();
            if (aSTNode == null || (aSTNode = aSTNode.getNode()) == null) {
                aSTNode = parent;
            }
        } else {
            aSTNode = parent;
        }
        return aSTNode;
    }

    public IndentationRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("indentation");
        this.configRules = configRules;
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IndentationConfig>(this){
            final /* synthetic */ IndentationRule this$0;

            @NotNull
            public final IndentationConfig invoke() {
                Object object = RulesConfigReaderKt.getRuleConfig((List)IndentationRule.access$getConfigRules$p(this.this$0), (Rule)Warnings.WRONG_INDENTATION);
                if (object == null || (object = object.getConfiguration()) == null) {
                    object = MapsKt.emptyMap();
                }
                return new IndentationConfig((Map<String, String>)object);
            }
            {
                this.this$0 = indentationRule;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        increasingTokens = CollectionsKt.listOf((Object[])new IElementType[]{ElementType.INSTANCE.getLPAR(), ElementType.INSTANCE.getLBRACE(), ElementType.INSTANCE.getLBRACKET()});
        decreasingTokens = CollectionsKt.listOf((Object[])new IElementType[]{ElementType.INSTANCE.getRPAR(), ElementType.INSTANCE.getRBRACE(), ElementType.INSTANCE.getRBRACKET()});
        matchingTokens = CollectionsKt.zip((Iterable)increasingTokens, (Iterable)decreasingTokens);
    }

    public static final /* synthetic */ IndentationConfig access$getConfiguration$p(IndentationRule $this) {
        return $this.getConfiguration();
    }

    public static final /* synthetic */ List access$getDecreasingTokens$cp() {
        return decreasingTokens;
    }

    public static final /* synthetic */ void access$visitWhiteSpace(IndentationRule $this, ASTNode astNode, IndentContext context) {
        $this.visitWhiteSpace(astNode, context);
    }

    public static final /* synthetic */ void access$checkStringLiteral(IndentationRule $this, PsiWhiteSpace whiteSpace, int expectedIndent2) {
        $this.checkStringLiteral(whiteSpace, expectedIndent2);
    }

    public static final /* synthetic */ List access$getConfigRules$p(IndentationRule $this) {
        return $this.configRules;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\fJ\u0006\u0010\u0018\u001a\u00020\u0016J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationRule$IndentContext;", "", "config", "Lorg/cqfn/diktat/ruleset/utils/indentation/IndentationConfig;", "(Lorg/cqfn/diktat/ruleset/utils/indentation/IndentationConfig;)V", "activeTokens", "Lorg/jetbrains/kotlin/com/intellij/util/containers/Stack;", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "exceptionalIndents", "", "Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationRule$IndentContext$ExceptionalIndent;", "regularIndent", "", "addException", "", "initiator", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "indent", "includeLastChild", "checkAndReset", "astNode", "dec", "", "token", "maybeIncrement", "storeIncrementingToken", "ExceptionalIndent", "diktat-rules"})
    private static final class IndentContext {
        private int regularIndent;
        private final List<ExceptionalIndent> exceptionalIndents;
        private final Stack<IElementType> activeTokens;
        private final IndentationConfig config;

        public final void storeIncrementingToken(@NotNull IElementType token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            IElementType iElementType = token;
            boolean bl = false;
            boolean bl2 = false;
            IElementType it = iElementType;
            boolean bl3 = false;
            boolean bl4 = increasingTokens.contains(it);
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "Only tokens that increase indentation should be passed to this method";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Stack<IElementType> stack = this.activeTokens;
            bl2 = false;
            boolean bl8 = false;
            IElementType p1 = iElementType;
            boolean bl9 = false;
            stack.push((Object)p1);
        }

        public final void maybeIncrement() {
            Collection collection = (Collection)this.activeTokens;
            boolean bl = false;
            if (!collection.isEmpty() && Intrinsics.areEqual((Object)((IElementType)this.activeTokens.peek()), (Object)ElementType.INSTANCE.getWHITE_SPACE()) ^ true) {
                this.regularIndent += this.config.getIndentationSize();
                this.activeTokens.push((Object)ElementType.INSTANCE.getWHITE_SPACE());
            }
        }

        public final void dec(@NotNull IElementType token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            if (Intrinsics.areEqual((Object)((IElementType)this.activeTokens.peek()), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                while (Intrinsics.areEqual((Object)((IElementType)this.activeTokens.peek()), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                    this.activeTokens.pop();
                }
                this.regularIndent -= this.config.getIndentationSize();
            }
            Iterable iterable = (Collection)this.activeTokens;
            boolean bl = false;
            if (!iterable.isEmpty()) {
                Object v0;
                IElementType iElementType;
                block5: {
                    iterable = matchingTokens;
                    iElementType = (IElementType)this.activeTokens.peek();
                    bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (Object e : iterable2) {
                        Pair it = (Pair)e;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)((IElementType)it.getSecond()), (Object)token)) continue;
                        v0 = e;
                        break block5;
                    }
                    v0 = null;
                }
                Object var11_11 = v0;
                Pair pair = var11_11;
                if (Intrinsics.areEqual((Object)iElementType, (Object)(pair != null ? (IElementType)pair.getFirst() : null))) {
                    this.activeTokens.pop();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final int indent() {
            void var3_4;
            int n;
            void $this$sumBy$iv;
            Iterable iterable = this.exceptionalIndents;
            int n2 = this.regularIndent;
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv) {
                void it;
                ExceptionalIndent exceptionalIndent = (ExceptionalIndent)element$iv;
                n = sum$iv;
                boolean bl = false;
                int n3 = it.getIndent();
                sum$iv = n + n3;
            }
            n = var3_4;
            return n2 + n;
        }

        public final boolean addException(@NotNull ASTNode initiator, int indent, boolean includeLastChild) {
            Intrinsics.checkNotNullParameter((Object)initiator, (String)"initiator");
            return this.exceptionalIndents.add(new ExceptionalIndent(initiator, indent, includeLastChild));
        }

        public final boolean checkAndReset(@NotNull ASTNode astNode) {
            Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
            return CollectionsKt.retainAll(this.exceptionalIndents, (Function1)((Function1)new Function1<ExceptionalIndent, Boolean>(astNode){
                final /* synthetic */ ASTNode $astNode;

                public final boolean invoke(@NotNull ExceptionalIndent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.isActive(this.$astNode);
                }
                {
                    this.$astNode = aSTNode;
                    super(1);
                }
            }));
        }

        public IndentContext(@NotNull IndentationConfig config) {
            Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
            this.config = config;
            boolean bl = false;
            this.exceptionalIndents = new ArrayList();
            this.activeTokens = new Stack();
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationRule$IndentContext$ExceptionalIndent;", "", "initiator", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "indent", "", "includeLastChild", "", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;IZ)V", "getIncludeLastChild", "()Z", "getIndent", "()I", "getInitiator", "()Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "isActive", "currentNode", "toString", "", "diktat-rules"})
        private static final class ExceptionalIndent {
            @NotNull
            private final ASTNode initiator;
            private final int indent;
            private final boolean includeLastChild;

            public final boolean isActive(@NotNull ASTNode currentNode) {
                boolean bl;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)currentNode, (String)"currentNode");
                    PsiElement psiElement = currentNode.getPsi();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"currentNode.psi");
                    Sequence $this$any$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)psiElement);
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getNode(), (Object)this.initiator)) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl && (this.includeLastChild || Intrinsics.areEqual((Object)currentNode.getTreeNext(), (Object)this.initiator.getLastChildNode()) ^ true);
            }

            @NotNull
            public final ASTNode getInitiator() {
                return this.initiator;
            }

            public final int getIndent() {
                return this.indent;
            }

            public final boolean getIncludeLastChild() {
                return this.includeLastChild;
            }

            public ExceptionalIndent(@NotNull ASTNode initiator, int indent, boolean includeLastChild) {
                Intrinsics.checkNotNullParameter((Object)initiator, (String)"initiator");
                this.initiator = initiator;
                this.indent = indent;
                this.includeLastChild = includeLastChild;
            }

            public /* synthetic */ ExceptionalIndent(ASTNode aSTNode, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 4) != 0) {
                    bl = true;
                }
                this(aSTNode, n, bl);
            }

            @NotNull
            public final ASTNode component1() {
                return this.initiator;
            }

            public final int component2() {
                return this.indent;
            }

            public final boolean component3() {
                return this.includeLastChild;
            }

            @NotNull
            public final ExceptionalIndent copy(@NotNull ASTNode initiator, int indent, boolean includeLastChild) {
                Intrinsics.checkNotNullParameter((Object)initiator, (String)"initiator");
                return new ExceptionalIndent(initiator, indent, includeLastChild);
            }

            public static /* synthetic */ ExceptionalIndent copy$default(ExceptionalIndent exceptionalIndent, ASTNode aSTNode, int n, boolean bl, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    aSTNode = exceptionalIndent.initiator;
                }
                if ((n2 & 2) != 0) {
                    n = exceptionalIndent.indent;
                }
                if ((n2 & 4) != 0) {
                    bl = exceptionalIndent.includeLastChild;
                }
                return exceptionalIndent.copy(aSTNode, n, bl);
            }

            @NotNull
            public String toString() {
                return "ExceptionalIndent(initiator=" + this.initiator + ", indent=" + this.indent + ", includeLastChild=" + this.includeLastChild + ")";
            }

            public int hashCode() {
                ASTNode aSTNode = this.initiator;
                int n = ((aSTNode != null ? aSTNode.hashCode() : 0) * 31 + Integer.hashCode(this.indent)) * 31;
                int n2 = this.includeLastChild ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                return n + n2;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ExceptionalIndent)) break block3;
                        ExceptionalIndent exceptionalIndent = (ExceptionalIndent)object;
                        if (!Intrinsics.areEqual((Object)this.initiator, (Object)exceptionalIndent.initiator) || this.indent != exceptionalIndent.indent || this.includeLastChild != exceptionalIndent.includeLastChild) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationRule$Companion;", "", "()V", "INDENT_SIZE", "", "decreasingTokens", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "increasingTokens", "matchingTokens", "Lkotlin/Pair;", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

