/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter5;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002Ji\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00142O\u0010 \u001aK\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\rj\u0002`\u0017H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tRW\u0010\f\u001aK\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00160\rj\u0002`\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionArgumentsSize;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionArgumentsSize$FunctionArgumentsSizeConfiguration;", "getConfiguration", "()Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionArgumentsSize$FunctionArgumentsSizeConfiguration;", "configuration$delegate", "Lkotlin/Lazy;", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "checkFun", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "maxParameterSize", "", "visit", "autoCorrect", "emit", "Companion", "FunctionArgumentsSizeConfiguration", "diktat-rules"})
public final class FunctionArgumentsSize
extends Rule {
    private boolean isFixMode;
    private final Lazy configuration$delegate;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRules;
    public static final long MAX_DEFAULT_PARAMETER_SIZE = 5L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final FunctionArgumentsSizeConfiguration getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        FunctionArgumentsSize functionArgumentsSize = this;
        Object var3_3 = null;
        boolean bl = false;
        return (FunctionArgumentsSizeConfiguration)((Object)lazy.getValue());
    }

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFUN())) {
            this.checkFun(node, this.getConfiguration().getMaxParameterSize());
        }
    }

    private final void checkFun(ASTNode node, long maxParameterSize) {
        PsiElement psiElement = node.getPsi();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        int parameterListSize = ((KtFunction)psiElement).getValueParameters().size();
        if ((long)parameterListSize > maxParameterSize) {
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            StringBuilder stringBuilder = new StringBuilder();
            ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
            Intrinsics.checkNotNull((Object)aSTNode);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.findChildByType(IDENTIFIER)!!");
            Warnings.TOO_MANY_PARAMETERS.warn(this.configRules, function3, this.isFixMode, stringBuilder.append(aSTNode.getText()).append(" has ").append(parameterListSize).append(", but allowed ").append(maxParameterSize).toString(), node.getStartOffset(), node);
        }
    }

    public FunctionArgumentsSize(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("argument-size");
        this.configRules = configRules;
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FunctionArgumentsSizeConfiguration>(this){
            final /* synthetic */ FunctionArgumentsSize this$0;

            @NotNull
            public final FunctionArgumentsSizeConfiguration invoke() {
                Object object = RulesConfigReaderKt.getRuleConfig((List)FunctionArgumentsSize.access$getConfigRules$p(this.this$0), (org.cqfn.diktat.common.config.rules.Rule)Warnings.TOO_MANY_PARAMETERS);
                if (object == null || (object = object.getConfiguration()) == null) {
                    object = MapsKt.emptyMap();
                }
                return new FunctionArgumentsSizeConfiguration((Map<String, String>)object);
            }
            {
                this.this$0 = functionArgumentsSize;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ List access$getConfigRules$p(FunctionArgumentsSize $this) {
        return $this.configRules;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionArgumentsSize$FunctionArgumentsSizeConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "maxParameterSize", "", "getMaxParameterSize", "()J", "diktat-rules"})
    public static final class FunctionArgumentsSizeConfiguration
    extends RuleConfiguration {
        private final long maxParameterSize;

        public final long getMaxParameterSize() {
            return this.maxParameterSize;
        }

        public FunctionArgumentsSizeConfiguration(@NotNull Map<String, String> config) {
            Intrinsics.checkNotNullParameter(config, (String)"config");
            super(config);
            Object object = config.get("maxParameterListSize");
            this.maxParameterSize = object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 5L;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionArgumentsSize$Companion;", "", "()V", "MAX_DEFAULT_PARAMETER_SIZE", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

