/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter6.classes;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.CommonConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002Ji\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u000e2O\u0010\u001c\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/classes/InlineClassesRule;", "Lcom/pinterest/ktlint/core/Rule;", "configRule", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "handleClasses", "classPsi", "Lorg/jetbrains/kotlin/psi/KtClass;", "hasValidProperties", "isExtendingClass", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "visit", "autoCorrect", "emit", "Companion", "diktat-rules"})
public final class InlineClassesRule
extends Rule {
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    private final List<RulesConfig> configRule;
    @NotNull
    private static final KotlinVersion ktVersion;
    @NotNull
    private static final List<IElementType> goodModifiers;
    @NotNull
    public static final Companion Companion;

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.emitWarn = emit;
        this.isFixMode = autoCorrect;
        Object var5_4 = null;
        Lazy configuration2 = RulesConfigReaderKt.getCommonConfiguration(this.configRule);
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getCLASS())) {
            Lazy lazy = configuration2;
            Object var7_7 = null;
            boolean bl = false;
            if (((CommonConfiguration)lazy.getValue()).getKotlinVersion().compareTo(ktVersion) >= 0) {
                PsiElement psiElement = node.getPsi();
                if (psiElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
                }
                this.handleClasses((KtClass)psiElement);
            }
        }
    }

    private final void handleClasses(KtClass classPsi) {
        block6: {
            block7: {
                boolean bl;
                block5: {
                    if (!this.hasValidProperties(classPsi)) break block6;
                    ASTNode aSTNode = classPsi.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"classPsi.node");
                    if (this.isExtendingClass(aSTNode)) break block6;
                    ASTNode aSTNode2 = classPsi.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"classPsi.node");
                    ASTNode[] aSTNodeArray = AstNodeUtilsKt.getFirstChildWithType(aSTNode2, ElementType.INSTANCE.getMODIFIER_LIST());
                    if (aSTNodeArray == null || (aSTNodeArray = aSTNodeArray.getChildren(null)) == null) break block7;
                    ASTNode[] $this$all$iv = aSTNodeArray;
                    boolean $i$f$all = false;
                    ASTNode[] aSTNodeArray2 = $this$all$iv;
                    int n = aSTNodeArray2.length;
                    for (int i = 0; i < n; ++i) {
                        ASTNode element$iv;
                        ASTNode it = element$iv = aSTNodeArray2[i];
                        boolean bl2 = false;
                        ASTNode aSTNode3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"it");
                        if (goodModifiers.contains(aSTNode3.getElementType())) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
                if (!bl) break block6;
            }
            Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
            if (function3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            }
            String string = "class " + classPsi.getName();
            ASTNode aSTNode = classPsi.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"classPsi.node");
            int n = aSTNode.getStartOffset();
            ASTNode aSTNode4 = classPsi.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode4, (String)"classPsi.node");
            Warnings.INLINE_CLASS_CAN_BE_USED.warn(this.configRule, function3, this.isFixMode, string, n, aSTNode4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasValidProperties(KtClass classPsi) {
        if (classPsi.getProperties().size() == 1 && !classPsi.hasExplicitPrimaryConstructor()) {
            if (((KtProperty)CollectionsKt.single((List)classPsi.getProperties())).isVar()) return false;
            return true;
        }
        if (!classPsi.getProperties().isEmpty()) return false;
        if (!classPsi.hasExplicitPrimaryConstructor()) return false;
        if (classPsi.getPrimaryConstructorParameters().size() != 1) return false;
        ASTNode aSTNode = ((KtParameter)CollectionsKt.first((List)classPsi.getPrimaryConstructorParameters())).getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"classPsi.primaryConstructorParameters.first().node");
        if (AstNodeUtilsKt.hasChildOfType(aSTNode, ElementType.INSTANCE.getVAR_KEYWORD())) return false;
        KtPrimaryConstructor ktPrimaryConstructor = classPsi.getPrimaryConstructor();
        Object object = ktPrimaryConstructor;
        if (ktPrimaryConstructor == null) return true;
        KtModifierKeywordToken ktModifierKeywordToken = KtPsiUtilKt.visibilityModifierType((KtModifierListOwner)((KtModifierListOwner)object));
        object = ktModifierKeywordToken;
        if (ktModifierKeywordToken == null) return true;
        String string = object.getValue();
        object = string;
        if (string == null) return true;
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        boolean bl4 = Intrinsics.areEqual((Object)object3, (Object)"public");
        if (!bl4) return false;
        return true;
    }

    private final boolean isExtendingClass(ASTNode node) {
        boolean bl;
        block3: {
            ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getSUPER_TYPE_LIST());
            if (aSTNode != null && (aSTNode = PackageKt.children((ASTNode)aSTNode)) != null) {
                ASTNode $this$any$iv = aSTNode;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl2 = false;
                    if (!AstNodeUtilsKt.hasChildOfType(it, ElementType.INSTANCE.getCONSTRUCTOR_CALLEE())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public InlineClassesRule(@NotNull List<RulesConfig> configRule) {
        Intrinsics.checkNotNullParameter(configRule, (String)"configRule");
        super("inline-classes");
        this.configRule = configRule;
    }

    static {
        Companion = new Companion(null);
        ktVersion = new KotlinVersion(1, 3);
        goodModifiers = CollectionsKt.listOf((Object[])new IElementType[]{ElementType.INSTANCE.getPUBLIC_KEYWORD(), ElementType.INSTANCE.getPRIVATE_KEYWORD(), ElementType.INSTANCE.getFINAL_KEYWORD(), ElementType.INSTANCE.getPROTECTED_KEYWORD(), ElementType.INSTANCE.getINTERNAL_KEYWORD()});
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/classes/InlineClassesRule$Companion;", "", "()V", "goodModifiers", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "getGoodModifiers", "()Ljava/util/List;", "ktVersion", "Lkotlin/KotlinVersion;", "getKtVersion", "()Lkotlin/KotlinVersion;", "diktat-rules"})
    public static final class Companion {
        @NotNull
        public final KotlinVersion getKtVersion() {
            return ktVersion;
        }

        @NotNull
        public final List<IElementType> getGoodModifiers() {
            return goodModifiers;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

