/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.utils.indentation;

import com.pinterest.ktlint.core.ast.ElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.ruleset.rules.chapter3.files.IndentationError;
import org.cqfn.diktat.ruleset.utils.indentation.CheckResult;
import org.cqfn.diktat.ruleset.utils.indentation.CheckersKt;
import org.cqfn.diktat.ruleset.utils.indentation.CustomIndentationChecker;
import org.cqfn.diktat.ruleset.utils.indentation.IndentationConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/cqfn/diktat/ruleset/utils/indentation/ExpressionIndentationChecker;", "Lorg/cqfn/diktat/ruleset/utils/indentation/CustomIndentationChecker;", "configuration", "Lorg/cqfn/diktat/ruleset/utils/indentation/IndentationConfig;", "(Lorg/cqfn/diktat/ruleset/utils/indentation/IndentationConfig;)V", "checkNode", "Lorg/cqfn/diktat/ruleset/utils/indentation/CheckResult;", "whiteSpace", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiWhiteSpace;", "indentError", "Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationError;", "diktat-rules"})
public final class ExpressionIndentationChecker
extends CustomIndentationChecker {
    @Override
    @Nullable
    public CheckResult checkNode(@NotNull PsiWhiteSpace whiteSpace, @NotNull IndentationError indentError) {
        Intrinsics.checkNotNullParameter((Object)whiteSpace, (String)"whiteSpace");
        Intrinsics.checkNotNullParameter((Object)indentError, (String)"indentError");
        PsiElement psiElement = whiteSpace.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"whiteSpace.parent");
        ASTNode aSTNode = psiElement.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"whiteSpace.parent.node");
        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION())) {
            PsiElement psiElement2 = whiteSpace.getPrevSibling();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"whiteSpace.prevSibling");
            ASTNode aSTNode2 = psiElement2.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"whiteSpace.prevSibling.node");
            if (Intrinsics.areEqual((Object)aSTNode2.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) {
                Integer n = CheckersKt.parentIndent((PsiElement)whiteSpace);
                int expectedIndent2 = (n != null ? n.intValue() : indentError.getExpected()) + (this.getConfiguration().getExtendedIndentAfterOperators() ? 2 : 1) * this.getConfiguration().getIndentationSize();
                return CheckResult.Companion.from$default(CheckResult.Companion, indentError.getActual(), expectedIndent2, true, false, 8, null);
            }
        }
        return null;
    }

    public ExpressionIndentationChecker(@NotNull IndentationConfig configuration2) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration2), (String)"configuration");
        super(configuration2);
    }
}

