/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.utils.indentation;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.ruleset.rules.chapter3.files.IndentationError;
import org.cqfn.diktat.ruleset.utils.indentation.CheckResult;
import org.cqfn.diktat.ruleset.utils.indentation.CustomIndentationChecker;
import org.cqfn.diktat.ruleset.utils.indentation.IndentationConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/cqfn/diktat/ruleset/utils/indentation/KdocIndentationChecker;", "Lorg/cqfn/diktat/ruleset/utils/indentation/CustomIndentationChecker;", "config", "Lorg/cqfn/diktat/ruleset/utils/indentation/IndentationConfig;", "(Lorg/cqfn/diktat/ruleset/utils/indentation/IndentationConfig;)V", "checkNode", "Lorg/cqfn/diktat/ruleset/utils/indentation/CheckResult;", "whiteSpace", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiWhiteSpace;", "indentError", "Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationError;", "diktat-rules"})
public final class KdocIndentationChecker
extends CustomIndentationChecker {
    @Override
    @Nullable
    public CheckResult checkNode(@NotNull PsiWhiteSpace whiteSpace, @NotNull IndentationError indentError) {
        Intrinsics.checkNotNullParameter((Object)whiteSpace, (String)"whiteSpace");
        Intrinsics.checkNotNullParameter((Object)indentError, (String)"indentError");
        List list = CollectionsKt.listOf((Object[])new IElementType[]{ElementType.INSTANCE.getKDOC_LEADING_ASTERISK(), ElementType.INSTANCE.getKDOC_END(), ElementType.INSTANCE.getKDOC_SECTION()});
        PsiElement psiElement = whiteSpace.getNextSibling();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"whiteSpace.nextSibling");
        ASTNode aSTNode = psiElement.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"whiteSpace.nextSibling.node");
        if (list.contains(aSTNode.getElementType())) {
            int expectedIndent2 = indentError.getExpected() + 1;
            return CheckResult.Companion.from$default(CheckResult.Companion, indentError.getActual(), expectedIndent2, false, false, 12, null);
        }
        return null;
    }

    public KdocIndentationChecker(@NotNull IndentationConfig config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        super(config);
    }
}

