/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.constants;

import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.ChaptersKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0003\b\u0087\u0001\b\u0086\u0001\u0018\u0000 \u00a5\u00012\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0002\u00a5\u0001B\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ5\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016H\u0082\bJ\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0085\u0001\u0010\u0007\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102O\u0010\u0018\u001aK\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0003\u0012\u0004\u0012\u00020\u000e0\u0019j\u0002`\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014J\u009d\u0001\u0010\"\u001a\u00020\u000e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102O\u0010\u0018\u001aK\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u0003\u0012\u0004\u0012\u00020\u000e0\u0019j\u0002`\u001f2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0003\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016J\u0006\u0010%\u001a\u00020\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?j\u0002\b@j\u0002\bAj\u0002\bBj\u0002\bCj\u0002\bDj\u0002\bEj\u0002\bFj\u0002\bGj\u0002\bHj\u0002\bIj\u0002\bJj\u0002\bKj\u0002\bLj\u0002\bMj\u0002\bNj\u0002\bOj\u0002\bPj\u0002\bQj\u0002\bRj\u0002\bSj\u0002\bTj\u0002\bUj\u0002\bVj\u0002\bWj\u0002\bXj\u0002\bYj\u0002\bZj\u0002\b[j\u0002\b\\j\u0002\b]j\u0002\b^j\u0002\b_j\u0002\b`j\u0002\baj\u0002\bbj\u0002\bcj\u0002\bdj\u0002\bej\u0002\bfj\u0002\bgj\u0002\bhj\u0002\bij\u0002\bjj\u0002\bkj\u0002\blj\u0002\bmj\u0002\bnj\u0002\boj\u0002\bpj\u0002\bqj\u0002\brj\u0002\bsj\u0002\btj\u0002\buj\u0002\bvj\u0002\bwj\u0002\bxj\u0002\byj\u0002\bzj\u0002\b{j\u0002\b|j\u0002\b}j\u0002\b~j\u0002\b\u007fj\u0003\b\u0080\u0001j\u0003\b\u0081\u0001j\u0003\b\u0082\u0001j\u0003\b\u0083\u0001j\u0003\b\u0084\u0001j\u0003\b\u0085\u0001j\u0003\b\u0086\u0001j\u0003\b\u0087\u0001j\u0003\b\u0088\u0001j\u0003\b\u0089\u0001j\u0003\b\u008a\u0001j\u0003\b\u008b\u0001j\u0003\b\u008c\u0001j\u0003\b\u008d\u0001j\u0003\b\u008e\u0001j\u0003\b\u008f\u0001j\u0003\b\u0090\u0001j\u0003\b\u0091\u0001j\u0003\b\u0092\u0001j\u0003\b\u0093\u0001j\u0003\b\u0094\u0001j\u0003\b\u0095\u0001j\u0003\b\u0096\u0001j\u0003\b\u0097\u0001j\u0003\b\u0098\u0001j\u0003\b\u0099\u0001j\u0003\b\u009a\u0001j\u0003\b\u009b\u0001j\u0003\b\u009c\u0001j\u0003\b\u009d\u0001j\u0003\b\u009e\u0001j\u0003\b\u009f\u0001j\u0003\b\u00a0\u0001j\u0003\b\u00a1\u0001j\u0003\b\u00a2\u0001j\u0003\b\u00a3\u0001j\u0003\b\u00a4\u0001\u00a8\u0006\u00a6\u0001"}, d2={"Lorg/cqfn/diktat/ruleset/constants/Warnings;", "", "Lorg/cqfn/diktat/common/config/rules/Rule;", "canBeAutoCorrected", "", "ruleId", "", "warn", "(Ljava/lang/String;IZLjava/lang/String;Ljava/lang/String;)V", "getCanBeAutoCorrected", "()Z", "getRuleId", "()Ljava/lang/String;", "fix", "", "configs", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "isFix", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoFix", "Lkotlin/Function0;", "ruleName", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "errorMessage", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "autoCorrected", "freeText", "warnAndFix", "configRules", "isFixMode", "warnText", "DUMMY_TEST_WARNING", "PACKAGE_NAME_MISSING", "PACKAGE_NAME_INCORRECT_CASE", "PACKAGE_NAME_INCORRECT_PREFIX", "PACKAGE_NAME_INCORRECT_SYMBOLS", "PACKAGE_NAME_INCORRECT_PATH", "INCORRECT_PACKAGE_SEPARATOR", "CLASS_NAME_INCORRECT", "OBJECT_NAME_INCORRECT", "VARIABLE_NAME_INCORRECT_FORMAT", "VARIABLE_NAME_INCORRECT", "CONSTANT_UPPERCASE", "VARIABLE_HAS_PREFIX", "IDENTIFIER_LENGTH", "ENUM_VALUE", "GENERIC_NAME", "BACKTICKS_PROHIBITED", "FUNCTION_NAME_INCORRECT_CASE", "TYPEALIAS_NAME_INCORRECT_CASE", "FUNCTION_BOOLEAN_PREFIX", "FILE_NAME_INCORRECT", "EXCEPTION_SUFFIX", "CONFUSING_IDENTIFIER_NAMING", "MISSING_KDOC_TOP_LEVEL", "MISSING_KDOC_CLASS_ELEMENTS", "MISSING_KDOC_ON_FUNCTION", "KDOC_TRIVIAL_KDOC_ON_FUNCTION", "KDOC_WITHOUT_PARAM_TAG", "KDOC_WITHOUT_RETURN_TAG", "KDOC_WITHOUT_THROWS_TAG", "KDOC_EMPTY_KDOC", "KDOC_WRONG_SPACES_AFTER_TAG", "KDOC_WRONG_TAGS_ORDER", "KDOC_NEWLINES_BEFORE_BASIC_TAGS", "KDOC_NO_NEWLINES_BETWEEN_BASIC_TAGS", "KDOC_NO_NEWLINE_AFTER_SPECIAL_TAGS", "KDOC_NO_EMPTY_TAGS", "KDOC_NO_DEPRECATED_TAG", "KDOC_NO_CONSTRUCTOR_PROPERTY", "KDOC_NO_CLASS_BODY_PROPERTIES_IN_HEADER", "KDOC_EXTRA_PROPERTY", "KDOC_NO_CONSTRUCTOR_PROPERTY_WITH_COMMENT", "KDOC_CONTAINS_DATE_OR_AUTHOR", "HEADER_WRONG_FORMAT", "HEADER_MISSING_OR_WRONG_COPYRIGHT", "WRONG_COPYRIGHT_YEAR", "HEADER_MISSING_IN_NON_SINGLE_CLASS_FILE", "HEADER_NOT_BEFORE_PACKAGE", "COMMENTED_OUT_CODE", "WRONG_NEWLINES_AROUND_KDOC", "FIRST_COMMENT_NO_BLANK_LINE", "COMMENT_WHITE_SPACE", "IF_ELSE_COMMENTS", "FILE_IS_TOO_LONG", "FILE_CONTAINS_ONLY_COMMENTS", "FILE_INCORRECT_BLOCKS_ORDER", "FILE_NO_BLANK_LINE_BETWEEN_BLOCKS", "FILE_UNORDERED_IMPORTS", "FILE_WILDCARD_IMPORTS", "UNUSED_IMPORT", "NO_BRACES_IN_CONDITIONALS_AND_LOOPS", "WRONG_ORDER_IN_CLASS_LIKE_STRUCTURES", "BLANK_LINE_BETWEEN_PROPERTIES", "TOP_LEVEL_ORDER", "BRACES_BLOCK_STRUCTURE_ERROR", "WRONG_INDENTATION", "EMPTY_BLOCK_STRUCTURE_ERROR", "MORE_THAN_ONE_STATEMENT_PER_LINE", "LONG_LINE", "REDUNDANT_SEMICOLON", "WRONG_NEWLINES", "TRAILING_COMMA", "COMPLEX_EXPRESSION", "COMPLEX_BOOLEAN_EXPRESSION", "STRING_CONCATENATION", "TOO_MANY_BLANK_LINES", "WRONG_WHITESPACE", "TOO_MANY_CONSECUTIVE_SPACES", "ANNOTATION_NEW_LINE", "ENUMS_SEPARATED", "WHEN_WITHOUT_ELSE", "LONG_NUMERICAL_VALUES_SEPARATED", "MAGIC_NUMBER", "WRONG_DECLARATIONS_ORDER", "WRONG_MULTIPLE_MODIFIERS_ORDER", "LOCAL_VARIABLE_EARLY_DECLARATION", "STRING_TEMPLATE_CURLY_BRACES", "STRING_TEMPLATE_QUOTES", "FILE_NAME_MATCH_CLASS", "COLLAPSE_IF_STATEMENTS", "CONVENTIONAL_RANGE", "NULLABLE_PROPERTY_TYPE", "TYPE_ALIAS", "SMART_CAST_NEEDED", "SAY_NO_TO_VAR", "GENERIC_VARIABLE_WRONG_DECLARATION", "FLOAT_IN_ACCURATE_CALCULATIONS", "AVOID_NULL_CHECKS", "TOO_LONG_FUNCTION", "AVOID_NESTED_FUNCTIONS", "LAMBDA_IS_NOT_LAST_PARAMETER", "TOO_MANY_PARAMETERS", "NESTED_BLOCK", "WRONG_OVERLOADING_FUNCTION_ARGUMENTS", "RUN_BLOCKING_INSIDE_ASYNC", "TOO_MANY_LINES_IN_LAMBDA", "CUSTOM_LABEL", "PARAMETER_NAME_IN_OUTER_LAMBDA", "INVERSE_FUNCTION_PREFERRED", "SINGLE_CONSTRUCTOR_SHOULD_BE_PRIMARY", "USE_DATA_CLASS", "WRONG_NAME_OF_VARIABLE_INSIDE_ACCESSOR", "MULTIPLE_INIT_BLOCKS", "CLASS_SHOULD_NOT_BE_ABSTRACT", "CUSTOM_GETTERS_SETTERS", "COMPACT_OBJECT_INITIALIZATION", "USELESS_SUPERTYPE", "TRIVIAL_ACCESSORS_ARE_NOT_RECOMMENDED", "EXTENSION_FUNCTION_SAME_SIGNATURE", "EMPTY_PRIMARY_CONSTRUCTOR", "NO_CORRESPONDING_PROPERTY", "AVOID_USING_UTILITY_CLASS", "OBJECT_IS_PREFERRED", "INLINE_CLASS_CAN_BE_USED", "EXTENSION_FUNCTION_WITH_CLASS", "RUN_IN_SCRIPT", "USE_LAST_INDEX", "Companion", "diktat-rules"})
public final class Warnings
extends Enum<Warnings>
implements Rule {
    @NotNull
    public static final Companion Companion;
    private final boolean canBeAutoCorrected;
    @NotNull
    private final String ruleId;
    @NotNull
    private final String warn;
    @NotNull
    private static final Lazy<List<String>> names$delegate;
    public static final /* enum */ Warnings DUMMY_TEST_WARNING;
    public static final /* enum */ Warnings PACKAGE_NAME_MISSING;
    public static final /* enum */ Warnings PACKAGE_NAME_INCORRECT_CASE;
    public static final /* enum */ Warnings PACKAGE_NAME_INCORRECT_PREFIX;
    public static final /* enum */ Warnings PACKAGE_NAME_INCORRECT_SYMBOLS;
    public static final /* enum */ Warnings PACKAGE_NAME_INCORRECT_PATH;
    public static final /* enum */ Warnings INCORRECT_PACKAGE_SEPARATOR;
    public static final /* enum */ Warnings CLASS_NAME_INCORRECT;
    public static final /* enum */ Warnings OBJECT_NAME_INCORRECT;
    public static final /* enum */ Warnings VARIABLE_NAME_INCORRECT_FORMAT;
    public static final /* enum */ Warnings VARIABLE_NAME_INCORRECT;
    public static final /* enum */ Warnings CONSTANT_UPPERCASE;
    public static final /* enum */ Warnings VARIABLE_HAS_PREFIX;
    public static final /* enum */ Warnings IDENTIFIER_LENGTH;
    public static final /* enum */ Warnings ENUM_VALUE;
    public static final /* enum */ Warnings GENERIC_NAME;
    public static final /* enum */ Warnings BACKTICKS_PROHIBITED;
    public static final /* enum */ Warnings FUNCTION_NAME_INCORRECT_CASE;
    public static final /* enum */ Warnings TYPEALIAS_NAME_INCORRECT_CASE;
    public static final /* enum */ Warnings FUNCTION_BOOLEAN_PREFIX;
    public static final /* enum */ Warnings FILE_NAME_INCORRECT;
    public static final /* enum */ Warnings EXCEPTION_SUFFIX;
    public static final /* enum */ Warnings CONFUSING_IDENTIFIER_NAMING;
    public static final /* enum */ Warnings MISSING_KDOC_TOP_LEVEL;
    public static final /* enum */ Warnings MISSING_KDOC_CLASS_ELEMENTS;
    public static final /* enum */ Warnings MISSING_KDOC_ON_FUNCTION;
    public static final /* enum */ Warnings KDOC_TRIVIAL_KDOC_ON_FUNCTION;
    public static final /* enum */ Warnings KDOC_WITHOUT_PARAM_TAG;
    public static final /* enum */ Warnings KDOC_WITHOUT_RETURN_TAG;
    public static final /* enum */ Warnings KDOC_WITHOUT_THROWS_TAG;
    public static final /* enum */ Warnings KDOC_EMPTY_KDOC;
    public static final /* enum */ Warnings KDOC_WRONG_SPACES_AFTER_TAG;
    public static final /* enum */ Warnings KDOC_WRONG_TAGS_ORDER;
    public static final /* enum */ Warnings KDOC_NEWLINES_BEFORE_BASIC_TAGS;
    public static final /* enum */ Warnings KDOC_NO_NEWLINES_BETWEEN_BASIC_TAGS;
    public static final /* enum */ Warnings KDOC_NO_NEWLINE_AFTER_SPECIAL_TAGS;
    public static final /* enum */ Warnings KDOC_NO_EMPTY_TAGS;
    public static final /* enum */ Warnings KDOC_NO_DEPRECATED_TAG;
    public static final /* enum */ Warnings KDOC_NO_CONSTRUCTOR_PROPERTY;
    public static final /* enum */ Warnings KDOC_NO_CLASS_BODY_PROPERTIES_IN_HEADER;
    public static final /* enum */ Warnings KDOC_EXTRA_PROPERTY;
    public static final /* enum */ Warnings KDOC_NO_CONSTRUCTOR_PROPERTY_WITH_COMMENT;
    public static final /* enum */ Warnings KDOC_CONTAINS_DATE_OR_AUTHOR;
    public static final /* enum */ Warnings HEADER_WRONG_FORMAT;
    public static final /* enum */ Warnings HEADER_MISSING_OR_WRONG_COPYRIGHT;
    public static final /* enum */ Warnings WRONG_COPYRIGHT_YEAR;
    public static final /* enum */ Warnings HEADER_MISSING_IN_NON_SINGLE_CLASS_FILE;
    public static final /* enum */ Warnings HEADER_NOT_BEFORE_PACKAGE;
    public static final /* enum */ Warnings COMMENTED_OUT_CODE;
    public static final /* enum */ Warnings WRONG_NEWLINES_AROUND_KDOC;
    public static final /* enum */ Warnings FIRST_COMMENT_NO_BLANK_LINE;
    public static final /* enum */ Warnings COMMENT_WHITE_SPACE;
    public static final /* enum */ Warnings IF_ELSE_COMMENTS;
    public static final /* enum */ Warnings FILE_IS_TOO_LONG;
    public static final /* enum */ Warnings FILE_CONTAINS_ONLY_COMMENTS;
    public static final /* enum */ Warnings FILE_INCORRECT_BLOCKS_ORDER;
    public static final /* enum */ Warnings FILE_NO_BLANK_LINE_BETWEEN_BLOCKS;
    public static final /* enum */ Warnings FILE_UNORDERED_IMPORTS;
    public static final /* enum */ Warnings FILE_WILDCARD_IMPORTS;
    public static final /* enum */ Warnings UNUSED_IMPORT;
    public static final /* enum */ Warnings NO_BRACES_IN_CONDITIONALS_AND_LOOPS;
    public static final /* enum */ Warnings WRONG_ORDER_IN_CLASS_LIKE_STRUCTURES;
    public static final /* enum */ Warnings BLANK_LINE_BETWEEN_PROPERTIES;
    public static final /* enum */ Warnings TOP_LEVEL_ORDER;
    public static final /* enum */ Warnings BRACES_BLOCK_STRUCTURE_ERROR;
    public static final /* enum */ Warnings WRONG_INDENTATION;
    public static final /* enum */ Warnings EMPTY_BLOCK_STRUCTURE_ERROR;
    public static final /* enum */ Warnings MORE_THAN_ONE_STATEMENT_PER_LINE;
    public static final /* enum */ Warnings LONG_LINE;
    public static final /* enum */ Warnings REDUNDANT_SEMICOLON;
    public static final /* enum */ Warnings WRONG_NEWLINES;
    public static final /* enum */ Warnings TRAILING_COMMA;
    public static final /* enum */ Warnings COMPLEX_EXPRESSION;
    public static final /* enum */ Warnings COMPLEX_BOOLEAN_EXPRESSION;
    public static final /* enum */ Warnings STRING_CONCATENATION;
    public static final /* enum */ Warnings TOO_MANY_BLANK_LINES;
    public static final /* enum */ Warnings WRONG_WHITESPACE;
    public static final /* enum */ Warnings TOO_MANY_CONSECUTIVE_SPACES;
    public static final /* enum */ Warnings ANNOTATION_NEW_LINE;
    public static final /* enum */ Warnings ENUMS_SEPARATED;
    public static final /* enum */ Warnings WHEN_WITHOUT_ELSE;
    public static final /* enum */ Warnings LONG_NUMERICAL_VALUES_SEPARATED;
    public static final /* enum */ Warnings MAGIC_NUMBER;
    public static final /* enum */ Warnings WRONG_DECLARATIONS_ORDER;
    public static final /* enum */ Warnings WRONG_MULTIPLE_MODIFIERS_ORDER;
    public static final /* enum */ Warnings LOCAL_VARIABLE_EARLY_DECLARATION;
    public static final /* enum */ Warnings STRING_TEMPLATE_CURLY_BRACES;
    public static final /* enum */ Warnings STRING_TEMPLATE_QUOTES;
    public static final /* enum */ Warnings FILE_NAME_MATCH_CLASS;
    public static final /* enum */ Warnings COLLAPSE_IF_STATEMENTS;
    public static final /* enum */ Warnings CONVENTIONAL_RANGE;
    public static final /* enum */ Warnings NULLABLE_PROPERTY_TYPE;
    public static final /* enum */ Warnings TYPE_ALIAS;
    public static final /* enum */ Warnings SMART_CAST_NEEDED;
    public static final /* enum */ Warnings SAY_NO_TO_VAR;
    public static final /* enum */ Warnings GENERIC_VARIABLE_WRONG_DECLARATION;
    public static final /* enum */ Warnings FLOAT_IN_ACCURATE_CALCULATIONS;
    public static final /* enum */ Warnings AVOID_NULL_CHECKS;
    public static final /* enum */ Warnings TOO_LONG_FUNCTION;
    public static final /* enum */ Warnings AVOID_NESTED_FUNCTIONS;
    public static final /* enum */ Warnings LAMBDA_IS_NOT_LAST_PARAMETER;
    public static final /* enum */ Warnings TOO_MANY_PARAMETERS;
    public static final /* enum */ Warnings NESTED_BLOCK;
    public static final /* enum */ Warnings WRONG_OVERLOADING_FUNCTION_ARGUMENTS;
    public static final /* enum */ Warnings RUN_BLOCKING_INSIDE_ASYNC;
    public static final /* enum */ Warnings TOO_MANY_LINES_IN_LAMBDA;
    public static final /* enum */ Warnings CUSTOM_LABEL;
    public static final /* enum */ Warnings PARAMETER_NAME_IN_OUTER_LAMBDA;
    public static final /* enum */ Warnings INVERSE_FUNCTION_PREFERRED;
    public static final /* enum */ Warnings SINGLE_CONSTRUCTOR_SHOULD_BE_PRIMARY;
    public static final /* enum */ Warnings USE_DATA_CLASS;
    public static final /* enum */ Warnings WRONG_NAME_OF_VARIABLE_INSIDE_ACCESSOR;
    public static final /* enum */ Warnings MULTIPLE_INIT_BLOCKS;
    public static final /* enum */ Warnings CLASS_SHOULD_NOT_BE_ABSTRACT;
    public static final /* enum */ Warnings CUSTOM_GETTERS_SETTERS;
    public static final /* enum */ Warnings COMPACT_OBJECT_INITIALIZATION;
    public static final /* enum */ Warnings USELESS_SUPERTYPE;
    public static final /* enum */ Warnings TRIVIAL_ACCESSORS_ARE_NOT_RECOMMENDED;
    public static final /* enum */ Warnings EXTENSION_FUNCTION_SAME_SIGNATURE;
    public static final /* enum */ Warnings EMPTY_PRIMARY_CONSTRUCTOR;
    public static final /* enum */ Warnings NO_CORRESPONDING_PROPERTY;
    public static final /* enum */ Warnings AVOID_USING_UTILITY_CLASS;
    public static final /* enum */ Warnings OBJECT_IS_PREFERRED;
    public static final /* enum */ Warnings INLINE_CLASS_CAN_BE_USED;
    public static final /* enum */ Warnings EXTENSION_FUNCTION_WITH_CLASS;
    public static final /* enum */ Warnings RUN_IN_SCRIPT;
    public static final /* enum */ Warnings USE_LAST_INDEX;
    private static final /* synthetic */ Warnings[] $VALUES;

    private Warnings(boolean canBeAutoCorrected, String ruleId, String warn) {
        this.canBeAutoCorrected = canBeAutoCorrected;
        this.ruleId = ruleId;
        this.warn = warn;
    }

    public final boolean getCanBeAutoCorrected() {
        return this.canBeAutoCorrected;
    }

    @NotNull
    public final String getRuleId() {
        return this.ruleId;
    }

    @NotNull
    public String ruleName() {
        return this.name();
    }

    @NotNull
    public final String warnText() {
        return '[' + this.ruleName() + "] " + this.warn + ':';
    }

    public final void warnAndFix(@NotNull List<RulesConfig> configRules, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean isFixMode, @NotNull String freeText, int offset2, @NotNull ASTNode node, boolean canBeAutoCorrected, @NotNull Function0<Unit> autoFix) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        Intrinsics.checkNotNullParameter((Object)freeText, (String)"freeText");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(autoFix, (String)"autoFix");
        this.warn(configRules, emit, canBeAutoCorrected, freeText, offset2, node);
        if (canBeAutoCorrected) {
            Warnings this_$iv = this;
            boolean $i$f$fix = false;
            if (ChaptersKt.isRuleFromActiveChapter(this_$iv, configRules) && RulesConfigReaderKt.isRuleEnabled(configRules, (Rule)this_$iv) && isFixMode && !AstNodeUtilsKt.hasSuppress(node, this_$iv.name())) {
                autoFix.invoke();
            }
        }
    }

    public static /* synthetic */ void warnAndFix$default(Warnings warnings, List list, Function3 function3, boolean bl, String string, int n, ASTNode aSTNode, boolean bl2, Function0 function0, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: warnAndFix");
        }
        if ((n2 & 0x40) != 0) {
            bl2 = warnings.canBeAutoCorrected;
        }
        warnings.warnAndFix(list, (Function3<? super Integer, ? super String, ? super Boolean, Unit>)function3, bl, string, n, aSTNode, bl2, (Function0<Unit>)function0);
    }

    public final void warn(@NotNull List<RulesConfig> configs, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit, boolean autoCorrected, @NotNull String freeText, int offset2, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(configs, (String)"configs");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        Intrinsics.checkNotNullParameter((Object)freeText, (String)"freeText");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (ChaptersKt.isRuleFromActiveChapter(this, configs) && RulesConfigReaderKt.isRuleEnabled(configs, (Rule)this) && !AstNodeUtilsKt.hasSuppress(node, this.name())) {
            List $this$warn_u24lambda_u2d0 = StringsKt.lines((CharSequence)freeText);
            boolean bl = false;
            String trimmedFreeText = $this$warn_u24lambda_u2d0.size() > 1 ? Intrinsics.stringPlus((String)((String)CollectionsKt.first((List)$this$warn_u24lambda_u2d0)), (Object)"...") : (String)CollectionsKt.first((List)$this$warn_u24lambda_u2d0);
            emit.invoke((Object)offset2, (Object)(this.warnText() + ' ' + trimmedFreeText), (Object)autoCorrected);
        }
    }

    private final void fix(List<RulesConfig> configs, boolean isFix, ASTNode node, Function0<Unit> autoFix) {
        boolean $i$f$fix = false;
        if (ChaptersKt.isRuleFromActiveChapter(this, configs) && RulesConfigReaderKt.isRuleEnabled(configs, (Rule)this) && isFix && !AstNodeUtilsKt.hasSuppress(node, this.name())) {
            autoFix.invoke();
        }
    }

    public static Warnings[] values() {
        return (Warnings[])$VALUES.clone();
    }

    public static Warnings valueOf(String value) {
        return Enum.valueOf(Warnings.class, value);
    }

    static {
        DUMMY_TEST_WARNING = new Warnings(true, "0.0.0", "this is a dummy warning that can be used for manual testing of fixer/checker");
        PACKAGE_NAME_MISSING = new Warnings(true, "1.2.1", "no package name declared in a file");
        PACKAGE_NAME_INCORRECT_CASE = new Warnings(true, "1.2.1", "package name should be completely in a lower case");
        PACKAGE_NAME_INCORRECT_PREFIX = new Warnings(true, "1.2.1", "package name should start from company's domain");
        PACKAGE_NAME_INCORRECT_SYMBOLS = new Warnings(false, "1.2.1", "package name should contain only latin (ASCII) letters or numbers. For separation of words use dot");
        PACKAGE_NAME_INCORRECT_PATH = new Warnings(true, "1.2.1", "package name does not match the directory hierarchy for this file, the real package name should be");
        INCORRECT_PACKAGE_SEPARATOR = new Warnings(true, "1.2.1", "package name parts should be separated only by dots - there should be no other symbols like underscores (_)");
        CLASS_NAME_INCORRECT = new Warnings(true, "1.3.1", "class/enum/interface name should be in PascalCase and should contain only latin (ASCII) letters or numbers");
        OBJECT_NAME_INCORRECT = new Warnings(true, "1.3.1", "object structure name should be in PascalCase and should contain only latin (ASCII) letters or numbers");
        VARIABLE_NAME_INCORRECT_FORMAT = new Warnings(true, "1.6.1", "variable name should be in lowerCamelCase and should contain only latin (ASCII) letters or numbers and should start from lower letter");
        VARIABLE_NAME_INCORRECT = new Warnings(false, "1.1.1", "variable name should contain more than one letter");
        CONSTANT_UPPERCASE = new Warnings(true, "1.5.1", "<val> properties from companion object or on file level mostly in all cases are constants - please use upper snake case for them");
        VARIABLE_HAS_PREFIX = new Warnings(true, "1.1.1", "variable has prefix (like mVariable or M_VARIABLE), generally it is a bad code style (Android - is the only exception)");
        IDENTIFIER_LENGTH = new Warnings(false, "1.1.1", "identifier's length is incorrect, it should be in range of [2, 64] symbols");
        ENUM_VALUE = new Warnings(true, "1.3.1", "enum values should be in selected UPPER_CASE snake/PascalCase format");
        GENERIC_NAME = new Warnings(true, "1.1.1", "generic name should contain only one single capital letter, it can be followed by a number");
        BACKTICKS_PROHIBITED = new Warnings(false, "1.1.1", "backticks should not be used in identifier's naming. The only exception test methods marked with @Test annotation");
        FUNCTION_NAME_INCORRECT_CASE = new Warnings(true, "1.4.1", "function/method name should be in lowerCamelCase");
        TYPEALIAS_NAME_INCORRECT_CASE = new Warnings(true, "1.3.1", "typealias name should be in pascalCase");
        FUNCTION_BOOLEAN_PREFIX = new Warnings(true, "1.6.2", "functions that return the value of Boolean type should have <is> or <has> prefix");
        FILE_NAME_INCORRECT = new Warnings(true, "1.1.1", "file name is incorrect - it should end with .kt extension and be in PascalCase");
        EXCEPTION_SUFFIX = new Warnings(true, "1.1.1", "all exception classes should have \"Exception\" suffix");
        CONFUSING_IDENTIFIER_NAMING = new Warnings(false, "1.1.1", "it's a bad name for identifier");
        MISSING_KDOC_TOP_LEVEL = new Warnings(false, "2.1.1", "all public and internal top-level classes and functions should have Kdoc");
        MISSING_KDOC_CLASS_ELEMENTS = new Warnings(false, "2.1.1", "all public, internal and protected classes, functions and variables inside the class should have Kdoc");
        MISSING_KDOC_ON_FUNCTION = new Warnings(true, "2.1.1", "all public, internal and protected functions should have Kdoc with proper tags");
        KDOC_TRIVIAL_KDOC_ON_FUNCTION = new Warnings(false, "2.3.1", "KDocs should not be trivial (e.g. method getX should not de documented as 'returns X')");
        KDOC_WITHOUT_PARAM_TAG = new Warnings(true, "2.1.2", "all methods which take arguments should have @param tags in KDoc");
        KDOC_WITHOUT_RETURN_TAG = new Warnings(true, "2.1.2", "all methods which return values should have @return tag in KDoc");
        KDOC_WITHOUT_THROWS_TAG = new Warnings(true, "2.1.2", "all methods which throw exceptions should have @throws tag in KDoc");
        KDOC_EMPTY_KDOC = new Warnings(false, "2.1.3", "KDoc should never be empty");
        KDOC_WRONG_SPACES_AFTER_TAG = new Warnings(true, "2.1.3", "there should be exactly one white space after tag name in KDoc");
        KDOC_WRONG_TAGS_ORDER = new Warnings(true, "2.1.3", "in KDoc standard tags are arranged in order @param, @return, @throws, but are");
        KDOC_NEWLINES_BEFORE_BASIC_TAGS = new Warnings(true, "2.1.3", "in KDoc block of standard tags @param, @return, @throws should contain newline before only if there is other content before it");
        KDOC_NO_NEWLINES_BETWEEN_BASIC_TAGS = new Warnings(true, "2.1.3", "in KDoc standard tags @param, @return, @throws should not containt newline between them, but these tags do");
        KDOC_NO_NEWLINE_AFTER_SPECIAL_TAGS = new Warnings(true, "2.1.3", "in KDoc there should be exactly one empty line after special tags");
        KDOC_NO_EMPTY_TAGS = new Warnings(false, "2.2.1", "no empty descriptions in tag blocks are allowed");
        KDOC_NO_DEPRECATED_TAG = new Warnings(true, "2.1.3", "KDoc doesn't support @deprecated tag, use @Deprecated annotation instead");
        KDOC_NO_CONSTRUCTOR_PROPERTY = new Warnings(true, "2.1.1", "all properties from the primary constructor should be documented in a @property tag in KDoc");
        KDOC_NO_CLASS_BODY_PROPERTIES_IN_HEADER = new Warnings(true, "2.1.1", "only properties from the primary constructor should be documented in a @property tag in class KDoc");
        KDOC_EXTRA_PROPERTY = new Warnings(false, "2.1.1", "There is property in KDoc which is not present in the class");
        KDOC_NO_CONSTRUCTOR_PROPERTY_WITH_COMMENT = new Warnings(true, "2.1.1", "replace comment before property with @property tag in class KDoc");
        KDOC_CONTAINS_DATE_OR_AUTHOR = new Warnings(false, "2.1.3", "KDoc should not contain creation date and author name");
        HEADER_WRONG_FORMAT = new Warnings(true, "2.2.1", "file header comments should be properly formatted");
        HEADER_MISSING_OR_WRONG_COPYRIGHT = new Warnings(true, "2.2.1", "file header comment must include copyright information inside a block comment");
        WRONG_COPYRIGHT_YEAR = new Warnings(true, "2.2.1", "year defined in copyright and current year are different");
        HEADER_MISSING_IN_NON_SINGLE_CLASS_FILE = new Warnings(false, "2.2.1", "files that contain multiple or no classes should contain description of what is inside of this file");
        HEADER_NOT_BEFORE_PACKAGE = new Warnings(true, "2.2.1", "header KDoc should be placed before package and imports");
        COMMENTED_OUT_CODE = new Warnings(false, "2.4.2", "you should not comment out code, use VCS to save it in history and delete this block");
        WRONG_NEWLINES_AROUND_KDOC = new Warnings(true, "2.4.1", "there should be a blank line above the kDoc and there should not be no blank lines after kDoc");
        FIRST_COMMENT_NO_BLANK_LINE = new Warnings(true, "2.4.1", "there should not be any blank lines before first comment");
        COMMENT_WHITE_SPACE = new Warnings(true, "2.4.1", "there should be a white space between code and comment also between code start token and comment text");
        IF_ELSE_COMMENTS = new Warnings(true, "2.4.1", "invalid comments structure. Comment should be inside the block");
        FILE_IS_TOO_LONG = new Warnings(false, "3.1.1", "file has more number of lines than expected");
        FILE_CONTAINS_ONLY_COMMENTS = new Warnings(false, "3.1.2", "empty files or files that contain only comments should be avoided");
        FILE_INCORRECT_BLOCKS_ORDER = new Warnings(true, "3.1.2", "general structure of kotlin source file is wrong, parts are in incorrect order");
        FILE_NO_BLANK_LINE_BETWEEN_BLOCKS = new Warnings(true, "3.1.2", "general structure of kotlin source file is wrong, general code blocks should be separated by empty lines");
        FILE_UNORDERED_IMPORTS = new Warnings(true, "3.1.2", "imports should be ordered alphabetically and shouldn't be separated by newlines");
        FILE_WILDCARD_IMPORTS = new Warnings(false, "3.1.2", "wildcard imports should not be used");
        UNUSED_IMPORT = new Warnings(true, "3.1.2", "unused imports should be removed");
        NO_BRACES_IN_CONDITIONALS_AND_LOOPS = new Warnings(true, "3.2.1", "in if, else, when, for, do, and while statements braces should be used. Exception: single line if statement.");
        WRONG_ORDER_IN_CLASS_LIKE_STRUCTURES = new Warnings(true, "3.1.4", "the declaration part of a class-like code structures (class/interface/etc.) should be in the proper order");
        BLANK_LINE_BETWEEN_PROPERTIES = new Warnings(true, "3.1.4", "there should be no blank lines between properties without comments; comment, KDoc or annotation on property should have blank line before");
        TOP_LEVEL_ORDER = new Warnings(true, "3.1.5", "the declaration part of a top level elements should be in the proper order");
        BRACES_BLOCK_STRUCTURE_ERROR = new Warnings(true, "3.2.2", "braces should follow 1TBS style");
        WRONG_INDENTATION = new Warnings(true, "3.3.1", "only spaces are allowed for indentation and each indentation should equal to 4 spaces (tabs are not allowed)");
        EMPTY_BLOCK_STRUCTURE_ERROR = new Warnings(true, "3.4.1", "incorrect format of empty block");
        MORE_THAN_ONE_STATEMENT_PER_LINE = new Warnings(true, "3.6.1", "there should not be more than one code statement in one line");
        LONG_LINE = new Warnings(true, "3.5.1", "this line is longer than allowed");
        REDUNDANT_SEMICOLON = new Warnings(true, "3.6.2", "there should be no redundant semicolon at the end of lines");
        WRONG_NEWLINES = new Warnings(true, "3.6.2", "incorrect line breaking");
        TRAILING_COMMA = new Warnings(true, "3.6.2", "use trailing comma");
        COMPLEX_EXPRESSION = new Warnings(false, "3.6.3", "complex dot qualified expression should be replaced with variable");
        COMPLEX_BOOLEAN_EXPRESSION = new Warnings(true, "3.6.4", "simplification could be produced for the too complex boolean expression");
        STRING_CONCATENATION = new Warnings(true, "3.15.1", "strings should not be concatenated using plus operator - use string templates instead if the statement fits one line");
        TOO_MANY_BLANK_LINES = new Warnings(true, "3.7.1", "too many consecutive blank lines");
        WRONG_WHITESPACE = new Warnings(true, "3.8.1", "incorrect usage of whitespaces for code separation");
        TOO_MANY_CONSECUTIVE_SPACES = new Warnings(true, "3.8.1", "too many consecutive spaces");
        ANNOTATION_NEW_LINE = new Warnings(true, "3.12.1", "annotations must be on new line");
        ENUMS_SEPARATED = new Warnings(true, "3.9.1", "enum is incorrectly formatted");
        WHEN_WITHOUT_ELSE = new Warnings(true, "3.11.1", "each 'when' statement must have else at the end");
        LONG_NUMERICAL_VALUES_SEPARATED = new Warnings(true, "3.14.2", "long numerical values should be separated with underscore");
        MAGIC_NUMBER = new Warnings(false, "3.14.3", "avoid using magic numbers, instead define constants with clear names describing what the magic number means");
        WRONG_DECLARATIONS_ORDER = new Warnings(true, "3.1.4", "declarations of constants and enum members should be sorted alphabetically");
        WRONG_MULTIPLE_MODIFIERS_ORDER = new Warnings(true, "3.14.1", "sequence of modifier-keywords is incorrect");
        LOCAL_VARIABLE_EARLY_DECLARATION = new Warnings(false, "3.10.2", "local variables should be declared close to the line where they are first used");
        STRING_TEMPLATE_CURLY_BRACES = new Warnings(true, "3.15.2", "string template has redundant curly braces");
        STRING_TEMPLATE_QUOTES = new Warnings(true, "3.15.2", "string template has redundant quotes");
        FILE_NAME_MATCH_CLASS = new Warnings(true, "3.1.2", "file name is incorrect - it should match with the class described in it if there is the only one class declared");
        COLLAPSE_IF_STATEMENTS = new Warnings(true, "3.16.1", "avoid using redundant nested if-statements, which could be collapsed into a single one");
        CONVENTIONAL_RANGE = new Warnings(true, "3.17.1", "use conventional rule for range case");
        NULLABLE_PROPERTY_TYPE = new Warnings(true, "4.3.1", "try to avoid use of nullable types");
        TYPE_ALIAS = new Warnings(false, "4.2.2", "variable's type is too complex and should be replaced with typealias");
        SMART_CAST_NEEDED = new Warnings(true, "4.2.1", "you can omit explicit casting");
        SAY_NO_TO_VAR = new Warnings(false, "4.1.3", "Usage of a mutable variables with [var] modifier - is a bad style, use [val] instead");
        GENERIC_VARIABLE_WRONG_DECLARATION = new Warnings(true, "4.3.2", "variable should have explicit type declaration");
        FLOAT_IN_ACCURATE_CALCULATIONS = new Warnings(false, "4.1.1", "floating-point values shouldn't be used in accurate calculations");
        AVOID_NULL_CHECKS = new Warnings(false, "4.3.3", "Try to avoid explicit null-checks");
        TOO_LONG_FUNCTION = new Warnings(false, "5.1.1", "function is too long: split it or make more primitive");
        AVOID_NESTED_FUNCTIONS = new Warnings(true, "5.1.3", "try to avoid using nested functions");
        LAMBDA_IS_NOT_LAST_PARAMETER = new Warnings(false, "5.2.1", "lambda inside function parameters should be in the end");
        TOO_MANY_PARAMETERS = new Warnings(false, "5.2.2", "function has too many parameters");
        NESTED_BLOCK = new Warnings(false, "5.1.2", "function has too many nested blocks and should be simplified");
        WRONG_OVERLOADING_FUNCTION_ARGUMENTS = new Warnings(false, "5.2.3", "use default argument instead of function overloading");
        RUN_BLOCKING_INSIDE_ASYNC = new Warnings(false, "5.2.4", "avoid using runBlocking in asynchronous code");
        TOO_MANY_LINES_IN_LAMBDA = new Warnings(false, "5.2.5", "long lambdas should have a parameter name instead of it");
        CUSTOM_LABEL = new Warnings(false, "5.2.6", "avoid using expression with custom label");
        PARAMETER_NAME_IN_OUTER_LAMBDA = new Warnings(false, "5.2.7", "outer lambdas should have a parameter name instead of `it`");
        INVERSE_FUNCTION_PREFERRED = new Warnings(true, "5.1.4", "it is better to use inverse function");
        SINGLE_CONSTRUCTOR_SHOULD_BE_PRIMARY = new Warnings(true, "6.1.1", "if a class has single constructor, it should be converted to a primary constructor");
        USE_DATA_CLASS = new Warnings(false, "6.1.2", "this class can be converted to a data class");
        WRONG_NAME_OF_VARIABLE_INSIDE_ACCESSOR = new Warnings(false, "6.1.9", "use `field` keyword instead of property name inside property accessors");
        MULTIPLE_INIT_BLOCKS = new Warnings(true, "6.1.4", "avoid using multiple `init` blocks, this logic can be moved to constructors or properties declarations");
        CLASS_SHOULD_NOT_BE_ABSTRACT = new Warnings(true, "6.1.6", "class should not be abstract, because it has no abstract functions");
        CUSTOM_GETTERS_SETTERS = new Warnings(false, "6.1.8", "custom getters and setters are not recommended, use class methods instead");
        COMPACT_OBJECT_INITIALIZATION = new Warnings(true, "6.1.11", "class instance can be initialized in `apply` block");
        USELESS_SUPERTYPE = new Warnings(true, "6.1.5", "unnecessary supertype specification");
        TRIVIAL_ACCESSORS_ARE_NOT_RECOMMENDED = new Warnings(true, "6.1.10", "trivial property accessors are not recommended");
        EXTENSION_FUNCTION_SAME_SIGNATURE = new Warnings(false, "6.2.2", "extension functions should not have same signature if their receiver classes are related");
        EMPTY_PRIMARY_CONSTRUCTOR = new Warnings(true, "6.1.3", "avoid empty primary constructor");
        NO_CORRESPONDING_PROPERTY = new Warnings(false, "6.1.7", "backing property should have the same name, but there is no corresponding property");
        AVOID_USING_UTILITY_CLASS = new Warnings(false, "6.4.1", "avoid using utility classes/objects, use extension functions instead");
        OBJECT_IS_PREFERRED = new Warnings(true, "6.4.2", "it is better to use object for stateless classes");
        INLINE_CLASS_CAN_BE_USED = new Warnings(true, "6.1.12", "inline class can be used");
        EXTENSION_FUNCTION_WITH_CLASS = new Warnings(false, "6.2.3", "do not use extension functions for the class defined in the same file");
        RUN_IN_SCRIPT = new Warnings(true, "6.5.1", "wrap blocks of code in top-level scope functions like `run`");
        USE_LAST_INDEX = new Warnings(true, "6.2.4", "Instead of \"length - 1\" need to use built-in \"lastIndex\" operation");
        $VALUES = warningsArray = new Warnings[]{Warnings.DUMMY_TEST_WARNING, Warnings.PACKAGE_NAME_MISSING, Warnings.PACKAGE_NAME_INCORRECT_CASE, Warnings.PACKAGE_NAME_INCORRECT_PREFIX, Warnings.PACKAGE_NAME_INCORRECT_SYMBOLS, Warnings.PACKAGE_NAME_INCORRECT_PATH, Warnings.INCORRECT_PACKAGE_SEPARATOR, Warnings.CLASS_NAME_INCORRECT, Warnings.OBJECT_NAME_INCORRECT, Warnings.VARIABLE_NAME_INCORRECT_FORMAT, Warnings.VARIABLE_NAME_INCORRECT, Warnings.CONSTANT_UPPERCASE, Warnings.VARIABLE_HAS_PREFIX, Warnings.IDENTIFIER_LENGTH, Warnings.ENUM_VALUE, Warnings.GENERIC_NAME, Warnings.BACKTICKS_PROHIBITED, Warnings.FUNCTION_NAME_INCORRECT_CASE, Warnings.TYPEALIAS_NAME_INCORRECT_CASE, Warnings.FUNCTION_BOOLEAN_PREFIX, Warnings.FILE_NAME_INCORRECT, Warnings.EXCEPTION_SUFFIX, Warnings.CONFUSING_IDENTIFIER_NAMING, Warnings.MISSING_KDOC_TOP_LEVEL, Warnings.MISSING_KDOC_CLASS_ELEMENTS, Warnings.MISSING_KDOC_ON_FUNCTION, Warnings.KDOC_TRIVIAL_KDOC_ON_FUNCTION, Warnings.KDOC_WITHOUT_PARAM_TAG, Warnings.KDOC_WITHOUT_RETURN_TAG, Warnings.KDOC_WITHOUT_THROWS_TAG, Warnings.KDOC_EMPTY_KDOC, Warnings.KDOC_WRONG_SPACES_AFTER_TAG, Warnings.KDOC_WRONG_TAGS_ORDER, Warnings.KDOC_NEWLINES_BEFORE_BASIC_TAGS, Warnings.KDOC_NO_NEWLINES_BETWEEN_BASIC_TAGS, Warnings.KDOC_NO_NEWLINE_AFTER_SPECIAL_TAGS, Warnings.KDOC_NO_EMPTY_TAGS, Warnings.KDOC_NO_DEPRECATED_TAG, Warnings.KDOC_NO_CONSTRUCTOR_PROPERTY, Warnings.KDOC_NO_CLASS_BODY_PROPERTIES_IN_HEADER, Warnings.KDOC_EXTRA_PROPERTY, Warnings.KDOC_NO_CONSTRUCTOR_PROPERTY_WITH_COMMENT, Warnings.KDOC_CONTAINS_DATE_OR_AUTHOR, Warnings.HEADER_WRONG_FORMAT, Warnings.HEADER_MISSING_OR_WRONG_COPYRIGHT, Warnings.WRONG_COPYRIGHT_YEAR, Warnings.HEADER_MISSING_IN_NON_SINGLE_CLASS_FILE, Warnings.HEADER_NOT_BEFORE_PACKAGE, Warnings.COMMENTED_OUT_CODE, Warnings.WRONG_NEWLINES_AROUND_KDOC, Warnings.FIRST_COMMENT_NO_BLANK_LINE, Warnings.COMMENT_WHITE_SPACE, Warnings.IF_ELSE_COMMENTS, Warnings.FILE_IS_TOO_LONG, Warnings.FILE_CONTAINS_ONLY_COMMENTS, Warnings.FILE_INCORRECT_BLOCKS_ORDER, Warnings.FILE_NO_BLANK_LINE_BETWEEN_BLOCKS, Warnings.FILE_UNORDERED_IMPORTS, Warnings.FILE_WILDCARD_IMPORTS, Warnings.UNUSED_IMPORT, Warnings.NO_BRACES_IN_CONDITIONALS_AND_LOOPS, Warnings.WRONG_ORDER_IN_CLASS_LIKE_STRUCTURES, Warnings.BLANK_LINE_BETWEEN_PROPERTIES, Warnings.TOP_LEVEL_ORDER, Warnings.BRACES_BLOCK_STRUCTURE_ERROR, Warnings.WRONG_INDENTATION, Warnings.EMPTY_BLOCK_STRUCTURE_ERROR, Warnings.MORE_THAN_ONE_STATEMENT_PER_LINE, Warnings.LONG_LINE, Warnings.REDUNDANT_SEMICOLON, Warnings.WRONG_NEWLINES, Warnings.TRAILING_COMMA, Warnings.COMPLEX_EXPRESSION, Warnings.COMPLEX_BOOLEAN_EXPRESSION, Warnings.STRING_CONCATENATION, Warnings.TOO_MANY_BLANK_LINES, Warnings.WRONG_WHITESPACE, Warnings.TOO_MANY_CONSECUTIVE_SPACES, Warnings.ANNOTATION_NEW_LINE, Warnings.ENUMS_SEPARATED, Warnings.WHEN_WITHOUT_ELSE, Warnings.LONG_NUMERICAL_VALUES_SEPARATED, Warnings.MAGIC_NUMBER, Warnings.WRONG_DECLARATIONS_ORDER, Warnings.WRONG_MULTIPLE_MODIFIERS_ORDER, Warnings.LOCAL_VARIABLE_EARLY_DECLARATION, Warnings.STRING_TEMPLATE_CURLY_BRACES, Warnings.STRING_TEMPLATE_QUOTES, Warnings.FILE_NAME_MATCH_CLASS, Warnings.COLLAPSE_IF_STATEMENTS, Warnings.CONVENTIONAL_RANGE, Warnings.NULLABLE_PROPERTY_TYPE, Warnings.TYPE_ALIAS, Warnings.SMART_CAST_NEEDED, Warnings.SAY_NO_TO_VAR, Warnings.GENERIC_VARIABLE_WRONG_DECLARATION, Warnings.FLOAT_IN_ACCURATE_CALCULATIONS, Warnings.AVOID_NULL_CHECKS, Warnings.TOO_LONG_FUNCTION, Warnings.AVOID_NESTED_FUNCTIONS, Warnings.LAMBDA_IS_NOT_LAST_PARAMETER, Warnings.TOO_MANY_PARAMETERS, Warnings.NESTED_BLOCK, Warnings.WRONG_OVERLOADING_FUNCTION_ARGUMENTS, Warnings.RUN_BLOCKING_INSIDE_ASYNC, Warnings.TOO_MANY_LINES_IN_LAMBDA, Warnings.CUSTOM_LABEL, Warnings.PARAMETER_NAME_IN_OUTER_LAMBDA, Warnings.INVERSE_FUNCTION_PREFERRED, Warnings.SINGLE_CONSTRUCTOR_SHOULD_BE_PRIMARY, Warnings.USE_DATA_CLASS, Warnings.WRONG_NAME_OF_VARIABLE_INSIDE_ACCESSOR, Warnings.MULTIPLE_INIT_BLOCKS, Warnings.CLASS_SHOULD_NOT_BE_ABSTRACT, Warnings.CUSTOM_GETTERS_SETTERS, Warnings.COMPACT_OBJECT_INITIALIZATION, Warnings.USELESS_SUPERTYPE, Warnings.TRIVIAL_ACCESSORS_ARE_NOT_RECOMMENDED, Warnings.EXTENSION_FUNCTION_SAME_SIGNATURE, Warnings.EMPTY_PRIMARY_CONSTRUCTOR, Warnings.NO_CORRESPONDING_PROPERTY, Warnings.AVOID_USING_UTILITY_CLASS, Warnings.OBJECT_IS_PREFERRED, Warnings.INLINE_CLASS_CAN_BE_USED, Warnings.EXTENSION_FUNCTION_WITH_CLASS, Warnings.RUN_IN_SCRIPT, Warnings.USE_LAST_INDEX};
        Companion = new Companion(null);
        names$delegate = LazyKt.lazy((Function0)Companion.names.2.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/constants/Warnings$Companion;", "", "()V", "names", "", "", "getNames", "()Ljava/util/List;", "names$delegate", "Lkotlin/Lazy;", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getNames() {
            Lazy lazy = names$delegate;
            return (List)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

