/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.RuleSet;
import com.pinterest.ktlint.core.RuleSetProvider;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReader;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRuleSetProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.org.jline.utils.Levenshtein;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0003H\u0002J\n\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\u000b\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/cqfn/diktat/ruleset/rules/DiktatRuleSetProvider;", "Lcom/pinterest/ktlint/core/RuleSetProvider;", "diktatConfigFile", "", "(Ljava/lang/String;)V", "possibleConfigs", "Lkotlin/sequences/Sequence;", "get", "Lcom/pinterest/ktlint/core/RuleSet;", "resolveConfigFileFromJarLocation", "resolveConfigFileFromSystemProperty", "resolveDefaultConfig", "validate", "", "config", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "Companion", "diktat-rules"})
public final class DiktatRuleSetProvider
implements RuleSetProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String diktatConfigFile;
    @NotNull
    private final Sequence<String> possibleConfigs;
    private static final Logger log = LoggerFactory.getLogger(DiktatRuleSetProvider.class);

    public DiktatRuleSetProvider(@NotNull String diktatConfigFile) {
        Intrinsics.checkNotNullParameter((Object)diktatConfigFile, (String)"diktatConfigFile");
        this.diktatConfigFile = diktatConfigFile;
        this.possibleConfigs = SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DiktatRuleSetProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v0 = $this$sequence.yield((Object)DiktatRuleSetProvider.access$resolveDefaultConfig(this.this$0), (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.label = 2;
                        v1 = $this$sequence.yield((Object)DiktatRuleSetProvider.access$resolveConfigFileFromJarLocation(this.this$0), (Continuation)this);
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl26
                    }
                    case 2: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl26:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 3;
                        v2 = $this$sequence.yield((Object)DiktatRuleSetProvider.access$resolveConfigFileFromSystemProperty(this.this$0), (Continuation)this);
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl35
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl35:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super String> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public /* synthetic */ DiktatRuleSetProvider(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "diktat-analysis.yml";
        }
        this(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public RuleSet get() {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        List list;
        String string;
        Object possibleConfigsList;
        Object object;
        Object v0;
        block8: {
            log.debug("Will run diktat-ruleset with " + this.diktatConfigFile + " (it can be placed to the run directory or the default file from resources will be used)");
            Sequence<String> $this$firstOrNull$iv = this.possibleConfigs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!(it != null && new File(it).exists())) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        String configPath = v0;
        DiktatRuleSetProvider diktatRuleSetProvider = this;
        if (configPath == null) {
            void $this$get_u24lambda_u2d1;
            DiktatRuleSetProvider $i$f$firstOrNull = this;
            object = diktatRuleSetProvider;
            boolean bl = false;
            possibleConfigsList = SequencesKt.toList($this$get_u24lambda_u2d1.possibleConfigs);
            log.warn("Configuration file not found in directory where diktat is run (" + possibleConfigsList.get(0) + ") or in the directory where diktat.jar is stored (" + possibleConfigsList.get(1) + ") or in system property <diktat.config.path> (" + possibleConfigsList.get(2) + "), the default file included in jar will be used. Some configuration options will be disabled or substituted with defaults. Custom configuration file should be placed in diktat working directory if run from CLI or provided as configuration options in plugins.");
            string = $this$get_u24lambda_u2d1.diktatConfigFile;
            diktatRuleSetProvider = object;
        } else {
            string = configPath;
        }
        diktatRuleSetProvider.diktatConfigFile = string;
        possibleConfigsList = this.getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)possibleConfigsList, (String)"javaClass.classLoader");
        Object bl = (Object[])new RulesConfigReader((ClassLoader)possibleConfigsList).readResource(this.diktatConfigFile);
        if (bl == null) {
            list = null;
        } else {
            void $this$onEach$iv;
            void bl2;
            possibleConfigsList = (Iterable)bl;
            boolean $i$f$onEach = false;
            void $this$onEach_u24lambda_u2d16$iv = bl2 = $this$onEach$iv;
            boolean bl3 = false;
            for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
                RulesConfig p0 = (RulesConfig)element$iv;
                boolean bl4 = false;
                this.validate(p0);
            }
            list = (List)bl2;
        }
        List $this$get_u24lambda_u2d1 = list;
        List configRules = $this$get_u24lambda_u2d1 == null ? CollectionsKt.emptyList() : $this$get_u24lambda_u2d1;
        bl = new KFunction[]{(KFunction)get.rules.1.INSTANCE, (KFunction)get.rules.2.INSTANCE, (KFunction)get.rules.3.INSTANCE, (KFunction)get.rules.4.INSTANCE, (KFunction)get.rules.5.INSTANCE, (KFunction)get.rules.6.INSTANCE, (KFunction)get.rules.7.INSTANCE, (KFunction)get.rules.8.INSTANCE, (KFunction)get.rules.9.INSTANCE, (KFunction)get.rules.10.INSTANCE, (KFunction)get.rules.11.INSTANCE, (KFunction)get.rules.12.INSTANCE, (KFunction)get.rules.13.INSTANCE, (KFunction)get.rules.14.INSTANCE, (KFunction)get.rules.15.INSTANCE, (KFunction)get.rules.16.INSTANCE, (KFunction)get.rules.17.INSTANCE, (KFunction)get.rules.18.INSTANCE, (KFunction)get.rules.19.INSTANCE, (KFunction)get.rules.20.INSTANCE, (KFunction)get.rules.21.INSTANCE, (KFunction)get.rules.22.INSTANCE, (KFunction)get.rules.23.INSTANCE, (KFunction)get.rules.24.INSTANCE, (KFunction)get.rules.25.INSTANCE, (KFunction)get.rules.26.INSTANCE, (KFunction)get.rules.27.INSTANCE, (KFunction)get.rules.28.INSTANCE, (KFunction)get.rules.29.INSTANCE, (KFunction)get.rules.30.INSTANCE, (KFunction)get.rules.31.INSTANCE, (KFunction)get.rules.32.INSTANCE, (KFunction)get.rules.33.INSTANCE, (KFunction)get.rules.34.INSTANCE, (KFunction)get.rules.35.INSTANCE, (KFunction)get.rules.36.INSTANCE, (KFunction)get.rules.37.INSTANCE, (KFunction)get.rules.38.INSTANCE, (KFunction)get.rules.39.INSTANCE, (KFunction)get.rules.40.INSTANCE, (KFunction)get.rules.41.INSTANCE, (KFunction)get.rules.42.INSTANCE, (KFunction)get.rules.43.INSTANCE, (KFunction)get.rules.44.INSTANCE, (KFunction)get.rules.45.INSTANCE, (KFunction)get.rules.46.INSTANCE, (KFunction)get.rules.47.INSTANCE, (KFunction)get.rules.48.INSTANCE, (KFunction)get.rules.49.INSTANCE, (KFunction)get.rules.50.INSTANCE, (KFunction)get.rules.51.INSTANCE, (KFunction)get.rules.52.INSTANCE, (KFunction)get.rules.53.INSTANCE, (KFunction)get.rules.54.INSTANCE, (KFunction)get.rules.55.INSTANCE, (KFunction)get.rules.56.INSTANCE, (KFunction)get.rules.57.INSTANCE, (KFunction)get.rules.58.INSTANCE, (KFunction)get.rules.59.INSTANCE, (KFunction)get.rules.60.INSTANCE, (KFunction)get.rules.61.INSTANCE, (KFunction)get.rules.62.INSTANCE, (KFunction)get.rules.63.INSTANCE, (KFunction)get.rules.64.INSTANCE, (KFunction)get.rules.65.INSTANCE, (KFunction)get.rules.66.INSTANCE, (KFunction)get.rules.67.INSTANCE, (KFunction)get.rules.68.INSTANCE, (KFunction)get.rules.69.INSTANCE, (KFunction)get.rules.70.INSTANCE, (KFunction)get.rules.71.INSTANCE, (KFunction)get.rules.72.INSTANCE, (KFunction)get.rules.73.INSTANCE, (KFunction)get.rules.74.INSTANCE};
        bl = CollectionsKt.listOf((Object[])bl);
        boolean $i$f$map = false;
        void $i$f$onEach = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object element$iv;
            element$iv = (KFunction)item$iv$iv;
            object = destination$iv$iv;
            boolean bl5 = false;
            object.add((Rule)((Function1)it).invoke((Object)configRules));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Rule[] ruleArray = thisCollection$iv.toArray(new Rule[0]);
        if (ruleArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        Rule[] rules2 = ruleArray;
        return new RuleSet("diktat-ruleset", Arrays.copyOf(rules2, rules2.length));
    }

    private final void validate(RulesConfig config2) {
        if (!(Intrinsics.areEqual((Object)config2.getName(), (Object)"DIKTAT_COMMON") || Warnings.Companion.getNames().contains(config2.getName()))) {
            Object v0;
            boolean bl = false;
            Iterable $this$minByOrNull$iv = Warnings.Companion.getNames();
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = minElem$iv;
                } else {
                    String it = (String)minElem$iv;
                    boolean bl2 = false;
                    int minValue$iv = Levenshtein.distance((CharSequence)it, (CharSequence)config2.getName());
                    do {
                        Object e$iv = iterator$iv.next();
                        String it2 = (String)e$iv;
                        $i$a$-minByOrNull-DiktatRuleSetProvider$validate$1$closestMatch$1 = false;
                        int v$iv = Levenshtein.distance((CharSequence)it2, (CharSequence)config2.getName());
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = minElem$iv;
                }
            }
            String closestMatch = v0;
            String string = "Warning name <" + config2.getName() + "> in configuration file is invalid, did you mean <" + closestMatch + ">?";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final String resolveDefaultConfig() {
        return this.diktatConfigFile;
    }

    private final String resolveConfigFileFromJarLocation() {
        String string;
        URI ruleSetProviderPath = DiktatRuleSetProvider.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        String configPathWithFileName = new File(ruleSetProviderPath).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)configPathWithFileName, (String)"configPathWithFileName");
        CharSequence charSequence = configPathWithFileName;
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        int indexOfName = StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null);
        if (indexOfName > -1) {
            String string3 = configPathWithFileName;
            int n = 0;
            String string4 = string3.substring(n, indexOfName);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = string4;
        } else {
            string = configPathWithFileName;
        }
        String configPath = string;
        return configPath + File.separator + this.diktatConfigFile;
    }

    private final String resolveConfigFileFromSystemProperty() {
        return System.getProperty("diktat.config.path");
    }

    public DiktatRuleSetProvider() {
        this(null, 1, null);
    }

    public static final /* synthetic */ String access$resolveDefaultConfig(DiktatRuleSetProvider $this) {
        return $this.resolveDefaultConfig();
    }

    public static final /* synthetic */ String access$resolveConfigFileFromJarLocation(DiktatRuleSetProvider $this) {
        return $this.resolveConfigFileFromJarLocation();
    }

    public static final /* synthetic */ String access$resolveConfigFileFromSystemProperty(DiktatRuleSetProvider $this) {
        return $this.resolveConfigFileFromSystemProperty();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/cqfn/diktat/ruleset/rules/DiktatRuleSetProvider$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

