/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter1;

import com.pinterest.ktlint.core.ast.ElementType;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter1.FileNaming;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.FileUtilsKt;
import org.cqfn.diktat.ruleset.utils.StringCaseUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter1/FileNaming;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "filePath", "", "checkClassNameMatchesWithFile", "", "fileLevelNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "checkFileNaming", "node", "getFileParts", "Lkotlin/Pair;", "fileName", "logic", "Companion", "diktat-rules"})
public final class FileNaming
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private String filePath;
    @NotNull
    public static final String NAME_ID = "aag-file-naming";
    @NotNull
    private static final List<String> validExtensions;

    public FileNaming(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        Warnings[] warningsArray = new Warnings[]{Warnings.FILE_NAME_INCORRECT, Warnings.FILE_NAME_MATCH_CLASS};
        super(NAME_ID, configRules, CollectionsKt.listOf((Object[])warningsArray), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            this.filePath = AstNodeUtilsKt.getFilePath(node);
            String string = this.filePath;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"filePath");
                string = null;
            }
            if (!FileUtilsKt.isKotlinScript(string)) {
                this.checkFileNaming(node);
                this.checkClassNameMatchesWithFile(node);
            }
        }
    }

    private final void checkFileNaming(ASTNode node) {
        String string = this.filePath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filePath");
            string = null;
        }
        Pair<String, String> pair = this.getFileParts(string);
        String name = (String)pair.component1();
        String extension = (String)pair.component2();
        if (!StringCaseUtilsKt.isPascalCase(name) || !validExtensions.contains(extension)) {
            Warnings.warnAndFix$default(Warnings.FILE_NAME_INCORRECT, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), Intrinsics.stringPlus((String)name, (Object)extension), 0, node, false, checkFileNaming.1.INSTANCE, 64, null);
        }
    }

    private final void checkClassNameMatchesWithFile(ASTNode fileLevelNode) {
        String string = this.filePath;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"filePath");
            string = null;
        }
        Pair<String, String> pair = this.getFileParts(string);
        String fileNameWithoutSuffix = (String)pair.component1();
        String fileNameSuffix = (String)pair.component2();
        List<ASTNode> classes = AstNodeUtilsKt.getAllChildrenWithType(fileLevelNode, ElementType.INSTANCE.getCLASS());
        if (classes.size() == 1) {
            ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(classes.get(0), ElementType.INSTANCE.getIDENTIFIER());
            Intrinsics.checkNotNull((Object)aSTNode);
            String string2 = aSTNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classes[0].getFirstChild\u2026thType(IDENTIFIER)!!.text");
            String className = string2;
            if (!Intrinsics.areEqual((Object)className, (Object)fileNameWithoutSuffix)) {
                Warnings.warnAndFix$default(Warnings.FILE_NAME_MATCH_CLASS, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), fileNameWithoutSuffix + fileNameSuffix + " vs " + className, 0, fileLevelNode, false, checkClassNameMatchesWithFile.1.INSTANCE, 64, null);
            }
        }
    }

    private final Pair<String, String> getFileParts(String fileName) {
        File file = new File(fileName);
        CharSequence charSequence = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"file.name");
        charSequence = charSequence;
        Object object = new Regex("\\..*");
        String string = "";
        String fileNameWithoutSuffix = object.replace(charSequence, string);
        object = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.name");
        String fileNameSuffix = StringsKt.replace$default((String)object, (String)fileNameWithoutSuffix, (String)"", (boolean)false, (int)4, null);
        return new Pair((Object)fileNameWithoutSuffix, (Object)fileNameSuffix);
    }

    static {
        Object[] objectArray = new String[]{".kt", ".kts"};
        validExtensions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter1/FileNaming$Companion;", "", "()V", "NAME_ID", "", "validExtensions", "", "getValidExtensions", "()Ljava/util/List;", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getValidExtensions() {
            return validExtensions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

