/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter1;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter1.IdentifierNaming;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.KdocUtilsKt;
import org.cqfn.diktat.ruleset.utils.StringCaseUtilsKt;
import org.cqfn.diktat.ruleset.utils.StringUtilsKt;
import org.cqfn.diktat.ruleset.utils.Style;
import org.cqfn.diktat.ruleset.utils.search.VariablesWithUsagesSearchKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u0000 +2\u00020\u0001:\u0003*+,B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u001e\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u00032\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u0013H\u0002J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0013H\u0002R!\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter1/IdentifierNaming;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "allMethodPrefixes", "", "", "getAllMethodPrefixes", "()Ljava/util/Set;", "allMethodPrefixes$delegate", "Lkotlin/Lazy;", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter1/IdentifierNaming$BooleanFunctionsConfiguration;", "getConfiguration", "()Lorg/cqfn/diktat/ruleset/rules/chapter1/IdentifierNaming$BooleanFunctionsConfiguration;", "configuration$delegate", "checkClassNamings", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "node", "checkEnumValues", "checkExceptionSuffix", "", "checkFunctionName", "checkIdentifierLength", "nodes", "isVariable", "", "checkObjectNaming", "checkTypeAliases", "checkVariableName", "extractVariableIdentifiers", "hasExceptionSuffix", "text", "isIdentifierWithBackticks", "isValidCatchIdentifier", "logic", "validGenericTypeName", "generic", "warnConfusingName", "variableName", "BooleanFunctionsConfiguration", "Companion", "IdentifierNamingConfiguration", "diktat-rules"})
public final class IdentifierNaming
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy allMethodPrefixes$delegate;
    @NotNull
    private final Lazy configuration$delegate;
    public static final int MAX_IDENTIFIER_LENGTH = 64;
    public static final int MIN_IDENTIFIER_LENGTH = 2;
    @NotNull
    public static final String NAME_ID = "aai-identifier-naming";
    @NotNull
    private static final Set<String> oneCharIdentifiers;
    @NotNull
    private static final Set<String> booleanMethodPrefixes;
    @NotNull
    private static final Set<String> confusingIdentifierNames;

    public IdentifierNaming(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        Warnings[] warningsArray = new Warnings[]{Warnings.BACKTICKS_PROHIBITED, Warnings.VARIABLE_NAME_INCORRECT, Warnings.VARIABLE_NAME_INCORRECT_FORMAT, Warnings.CONSTANT_UPPERCASE, Warnings.VARIABLE_HAS_PREFIX, Warnings.CONFUSING_IDENTIFIER_NAMING, Warnings.GENERIC_NAME, Warnings.CLASS_NAME_INCORRECT, Warnings.ENUM_VALUE, Warnings.EXCEPTION_SUFFIX, Warnings.FUNCTION_BOOLEAN_PREFIX, Warnings.FUNCTION_NAME_INCORRECT_CASE, Warnings.IDENTIFIER_LENGTH, Warnings.OBJECT_NAME_INCORRECT, Warnings.TYPEALIAS_NAME_INCORRECT_CASE};
        super(NAME_ID, configRules, CollectionsKt.listOf((Object[])warningsArray), null, 8, null);
        this.allMethodPrefixes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ IdentifierNaming this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<String> invoke() {
                Set set;
                if (this.this$0.getConfiguration().getAllowedBooleanPrefixes().isEmpty()) {
                    set = IdentifierNaming.Companion.getBooleanMethodPrefixes();
                } else {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable = this.this$0.getConfiguration().getAllowedBooleanPrefixes();
                    Set<String> set2 = IdentifierNaming.Companion.getBooleanMethodPrefixes();
                    boolean $i$f$filter = false;
                    void var3_4 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)it).length() > 0;
                        if (!bl2) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    set = SetsKt.plus(set2, (Iterable)((List)destination$iv$iv));
                }
                return set;
            }
        }));
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BooleanFunctionsConfiguration>(this){
            final /* synthetic */ IdentifierNaming this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BooleanFunctionsConfiguration invoke() {
                RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.this$0.getConfigRules(), (Rule)Warnings.FUNCTION_BOOLEAN_PREFIX);
                Map<K, V> map = rulesConfig == null ? null : rulesConfig.getConfiguration();
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                return new BooleanFunctionsConfiguration(map);
            }
        }));
    }

    private final Set<String> getAllMethodPrefixes() {
        Lazy lazy = this.allMethodPrefixes$delegate;
        return (Set)lazy.getValue();
    }

    @NotNull
    public final BooleanFunctionsConfiguration getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        return (BooleanFunctionsConfiguration)((Object)lazy.getValue());
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.isIdentifierWithBackticks(node)) {
            return;
        }
        IElementType iElementType = node.getElementType();
        Pair pair = Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCLASS()) ? new Pair(this.checkClassNamings(node), (Object)false) : (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getOBJECT_DECLARATION()) ? new Pair(this.checkObjectNaming(node), (Object)false) : ((Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getPROPERTY()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_PARAMETER())) ? new Pair(this.checkVariableName(node), (Object)true) : (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getENUM_ENTRY()) ? new Pair(this.checkEnumValues(node), (Object)false) : (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getFUN()) ? new Pair(this.checkFunctionName(node), (Object)false) : (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getTYPEALIAS()) ? new Pair(this.checkTypeAliases(node), (Object)false) : new Pair(null, (Object)false))))));
        List identifierNodes = (List)pair.component1();
        boolean isVariable = (Boolean)pair.component2();
        List list = identifierNodes;
        if (list != null) {
            List it = list;
            boolean bl = false;
            this.checkIdentifierLength(it, isVariable);
        }
    }

    private final boolean isIdentifierWithBackticks(ASTNode node) {
        ASTNode identifier = AstNodeUtilsKt.getIdentifierName(node);
        if (identifier != null && !Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getREFERENCE_EXPRESSION())) {
            String string = identifier.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"identifier.text");
            String identifierText = string;
            if (StringsKt.startsWith$default((CharSequence)identifierText, (char)'`', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)identifierText, (char)'`', (boolean)false, (int)2, null)) {
                boolean isTestFun;
                boolean bl = isTestFun = Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFUN()) && AstNodeUtilsKt.hasTestAnnotation(node);
                if (!isTestFun) {
                    Warnings.BACKTICKS_PROHIBITED.warn(this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), identifierText, identifier.getStartOffset(), identifier);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final List<ASTNode> checkVariableName(ASTNode node) {
        block13: {
            block12: {
                namesOfVariables = this.extractVariableIdentifiers(node);
                if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY())) {
                    v0 = node.getPsi();
                    if (v0 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                    }
                    $this$checkVariableName_u24lambda_u2d1 = (KtProperty)v0;
                    $i$a$-run-IdentifierNaming$checkVariableName$isPublicOrNonLocalProperty$1 = false;
                    v1 = !$this$checkVariableName_u24lambda_u2d1.isLocal() && !KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)$this$checkVariableName_u24lambda_u2d1));
                } else {
                    v1 = false;
                }
                isPublicOrNonLocalProperty = v1;
                $i$a$-run-IdentifierNaming$checkVariableName$isPublicOrNonLocalProperty$1 = node.getPsi();
                v2 = $this$checkVariableName_u24lambda_u2d1 = $i$a$-run-IdentifierNaming$checkVariableName$isPublicOrNonLocalProperty$1 instanceof KtParameter != false ? (KtParameter)$i$a$-run-IdentifierNaming$checkVariableName$isPublicOrNonLocalProperty$1 : null;
                if ($this$checkVariableName_u24lambda_u2d1 != null) break block12;
                v3 = false;
                break block13;
            }
            $this$checkVariableName_u24lambda_u2d2 = $this$checkVariableName_u24lambda_u2d1;
            $i$a$-run-IdentifierNaming$checkVariableName$isNonPrivatePrimaryConstructorParameter$1 = false;
            if (!$this$checkVariableName_u24lambda_u2d2.hasValOrVar()) ** GOTO lbl-1000
            var10_14 = (PsiElement)$this$checkVariableName_u24lambda_u2d2;
            strict$iv = true;
            $i$f$getParentOfType = false;
            v4 = (KtPrimaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtPrimaryConstructor.class, (boolean)strict$iv);
            if (v4 == null) {
                v5 = false;
            } else {
                v6 = v4.getValueParameters();
                v5 = v6 == null ? false : v6.contains($this$checkVariableName_u24lambda_u2d2) == true;
            }
            if (v5 && !KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)$this$checkVariableName_u24lambda_u2d2))) {
                v7 = true;
            } else lbl-1000:
            // 2 sources

            {
                v7 = false;
            }
            v3 = $i$a$-run-IdentifierNaming$checkVariableName$isPublicOrNonLocalProperty$1 = v7;
        }
        isNonPrivatePrimaryConstructorParameter = v3;
        isFix = this.isFixMode() != false && isPublicOrNonLocalProperty == false && isNonPrivatePrimaryConstructorParameter == false;
        $i$a$-run-IdentifierNaming$checkVariableName$isPublicOrNonLocalProperty$1 = namesOfVariables;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            variableName = (ASTNode)element$iv;
            $i$a$-forEach-IdentifierNaming$checkVariableName$1 = false;
            var12_17 = variableName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)var12_17, (String)"variableName.text");
            if (StringUtilsKt.containsOneLetterOrZero(var12_17) && variableName.getText().length() > 1) {
                v8 = this.getConfigRules();
                v9 = this.getEmitWarn();
                v10 = this.isFixMode();
                var12_17 = variableName.getText();
                Intrinsics.checkNotNullExpressionValue((Object)var12_17, (String)"variableName.text");
                Warnings.VARIABLE_NAME_INCORRECT.warn(v8, v9, v10, var12_17, variableName.getStartOffset(), node);
            }
            if (IdentifierNaming.confusingIdentifierNames.contains(variableName.getText()) && !this.isValidCatchIdentifier(variableName) && Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY())) {
                this.warnConfusingName(variableName);
            }
            if (AstNodeUtilsKt.isConstant(node)) {
                var12_17 = variableName.getText();
                Intrinsics.checkNotNullExpressionValue((Object)var12_17, (String)"variableName.text");
                if (StringCaseUtilsKt.isUpperSnakeCase(var12_17) || variableName.getText().length() <= 1) continue;
                v11 = this.getConfigRules();
                v12 = this.getEmitWarn();
                var12_17 = variableName.getText();
                Intrinsics.checkNotNullExpressionValue((Object)var12_17, (String)"variableName.text");
                Warnings.warnAndFix$default(Warnings.CONSTANT_UPPERCASE, v11, v12, isFix, var12_17, variableName.getStartOffset(), node, false, (Function0)new Function0<Unit>(variableName){
                    final /* synthetic */ ASTNode $variableName;
                    {
                        this.$variableName = $variableName;
                        super(0);
                    }

                    public final void invoke() {
                        LeafPsiElement leafPsiElement = (LeafPsiElement)this.$variableName;
                        String string = ((LeafPsiElement)this.$variableName).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variableName.text");
                        leafPsiElement.rawReplaceWithText(StringCaseUtilsKt.toUpperSnakeCase(string));
                    }
                }, 64, null);
                continue;
            }
            if (Intrinsics.areEqual((Object)variableName.getText(), (Object)"_")) continue;
            var12_17 = variableName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)var12_17, (String)"variableName.text");
            if (StringCaseUtilsKt.isLowerCamelCase(var12_17)) continue;
            v13 = this.getConfigRules();
            v14 = this.getEmitWarn();
            var12_17 = variableName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)var12_17, (String)"variableName.text");
            Warnings.warnAndFix$default(Warnings.VARIABLE_NAME_INCORRECT_FORMAT, v13, v14, isFix, var12_17, variableName.getStartOffset(), node, false, (Function0)new Function0<Unit>(variableName){
                final /* synthetic */ ASTNode $variableName;
                {
                    this.$variableName = $variableName;
                    super(0);
                }

                /*
                 * Unable to fully structure code
                 */
                public final void invoke() {
                    var2_1 = this.$variableName.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)var2_1, (String)"variableName.text");
                    correctVariableName = StringCaseUtilsKt.toLowerCamelCase(var2_1);
                    var2_1 = PackageKt.parent$default((ASTNode)this.$variableName, (Function1)checkVariableName.1.1.INSTANCE, (boolean)false, (int)2, null);
                    if (var2_1 != null && (var3_3 = VariablesWithUsagesSearchKt.findAllVariablesWithUsages((ASTNode)var2_1, (Function1<? super KtProperty, Boolean>)((Function1)new Function1<KtProperty, Boolean>(this.$variableName){
                        final /* synthetic */ ASTNode $variableName;
                        {
                            this.$variableName = $variableName;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull KtProperty it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return Intrinsics.areEqual((Object)it.getName(), (Object)this.$variableName.getText());
                        }
                    }))) != null) {
                        var5_4 = var3_3;
                        $i$f$flatMap = false;
                        var7_7 = $this$flatMap$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$flatMapTo = false;
                        var10_15 = $this$flatMapTo$iv$iv.entrySet().iterator();
                        while (var10_15.hasNext()) {
                            it = element$iv$iv = var10_15.next();
                            $i$a$-flatMap-IdentifierNaming$checkVariableName$1$2$3 = false;
                            list$iv$iv = CollectionsKt.toList((Iterable)((Iterable)it.getValue()));
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        var4_22 = (List)destination$iv$iv;
                        $this$flatMap$iv = var4_22;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (KtNameReferenceExpression)element$iv;
                            $i$a$-forEach-IdentifierNaming$checkVariableName$1$2$4 = false;
                            v0 = it.getNode().getFirstChildNode();
                            if (v0 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                            }
                            ((LeafPsiElement)v0).rawReplaceWithText(correctVariableName);
                        }
                    }
                    $this$invoke_u24lambda_u2d2 = this.$variableName.getTreeParent().getPsi();
                    $i$a$-run-IdentifierNaming$checkVariableName$1$2$5 = false;
                    if ($this$invoke_u24lambda_u2d2 instanceof KtProperty && ((KtProperty)$this$invoke_u24lambda_u2d2).isMember()) ** GOTO lbl-1000
                    if ($this$invoke_u24lambda_u2d2 instanceof KtParameter) {
                        $this$forEach$iv = $this$invoke_u24lambda_u2d2;
                        strict$iv = true;
                        $i$f$getParentOfType = false;
                        v1 = (KtPrimaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtPrimaryConstructor.class, (boolean)strict$iv);
                        if (v1 == null) {
                            v2 = false;
                        } else {
                            v3 = v1.getValueParameters();
                            v2 = v3 == null ? false : v3.contains($this$invoke_u24lambda_u2d2) == true;
                        }
                        ** if (!v2) goto lbl-1000
                    }
                    ** GOTO lbl-1000
lbl-1000:
                    // 2 sources

                    {
                        v4 = true;
                        ** GOTO lbl53
                    }
lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
lbl53:
                    // 2 sources

                    if (v4) {
                        v5 = PackageKt.parent$default((ASTNode)this.$variableName, (IElementType)ElementType.INSTANCE.getCLASS(), (boolean)false, (int)2, null);
                        if (v5 == null) {
                            v5 = PackageKt.parent$default((ASTNode)this.$variableName, (IElementType)ElementType.INSTANCE.getOBJECT_DECLARATION(), (boolean)false, (int)2, null);
                        }
                        if ((var2_1 = v5) != null && (var3_3 = var2_1.findChildByType(ElementType.INSTANCE.getKDOC())) != null && (var4_24 = KdocUtilsKt.kDocTags(var3_3)) != null) {
                            block14: {
                                strict$iv = var4_24;
                                $i$f$getParentOfType = this.$variableName;
                                $i$f$firstOrNull = false;
                                for (T element$iv : $this$firstOrNull$iv) {
                                    it = (KDocTag)element$iv;
                                    $i$a$-firstOrNull-IdentifierNaming$checkVariableName$1$2$6 = false;
                                    if (!(it.getKnownTag() == KDocKnownTag.PROPERTY && Intrinsics.areEqual((Object)it.getSubjectName(), (Object)$i$f$getParentOfType.getText()) != false)) continue;
                                    v6 = element$iv;
                                    break block14;
                                }
                                v6 = null;
                            }
                            var5_4 = v6;
                            if (var5_4 != null) {
                                $this$invoke_u24lambda_u2d4 = var5_4;
                                $i$a$-run-IdentifierNaming$checkVariableName$1$2$7 = false;
                                v7 = $this$invoke_u24lambda_u2d4.getSubjectLink();
                                Intrinsics.checkNotNull((Object)v7);
                                var9_14 = v7.getNode();
                                Intrinsics.checkNotNullExpressionValue((Object)var9_14, (String)"getSubjectLink()!!.node");
                                ((LeafPsiElement)CollectionsKt.single((List)AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(var9_14, ElementType.INSTANCE.getIDENTIFIER(), false, 2, null))).rawReplaceWithText(correctVariableName);
                            }
                        }
                    }
                    ((LeafPsiElement)this.$variableName).rawReplaceWithText(correctVariableName);
                }
            }, 64, null);
        }
        namesOfVariables = this.extractVariableIdentifiers(node);
        $this$forEach$iv = namesOfVariables;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            variableName = (ASTNode)element$iv;
            $i$a$-forEach-IdentifierNaming$checkVariableName$2 = false;
            var12_18 = variableName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)var12_18, (String)"variableName.text");
            if (!StringUtilsKt.hasPrefix(var12_18)) continue;
            v15 = this.getConfigRules();
            v16 = this.getEmitWarn();
            v17 = this.isFixMode();
            var12_18 = variableName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)var12_18, (String)"variableName.text");
            Warnings.warnAndFix$default(Warnings.VARIABLE_HAS_PREFIX, v15, v16, v17, var12_18, variableName.getStartOffset(), node, false, (Function0)new Function0<Unit>(variableName){
                final /* synthetic */ ASTNode $variableName;
                {
                    this.$variableName = $variableName;
                    super(0);
                }

                public final void invoke() {
                    LeafPsiElement leafPsiElement = (LeafPsiElement)this.$variableName;
                    String string = ((LeafPsiElement)this.$variableName).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variableName.text");
                    leafPsiElement.rawReplaceWithText(StringUtilsKt.removePrefix(string));
                }
            }, 64, null);
        }
        return namesOfVariables;
    }

    private final void warnConfusingName(ASTNode variableName) {
        String string;
        switch (variableName.getText()) {
            case "D": 
            case "O": {
                string = "better name is: obj, dgt";
                break;
            }
            case "I": 
            case "l": {
                string = "better name is: it, ln, line";
                break;
            }
            case "Z": {
                string = "better name is: n1, n2";
                break;
            }
            case "S": {
                string = "better name is: xs, str";
                break;
            }
            case "e": {
                string = "better name is: ex, elm";
                break;
            }
            case "B": {
                string = "better name is: bt, nxt";
                break;
            }
            case "h": 
            case "n": {
                string = "better name is: nr, head, height";
                break;
            }
            case "rn": 
            case "m": {
                string = "better name is: mbr, item";
                break;
            }
            default: {
                string = "";
            }
        }
        String warnText = string;
        Warnings.CONFUSING_IDENTIFIER_NAMING.warn(this.getConfigRules(), this.getEmitWarn(), false, warnText, variableName.getStartOffset(), variableName);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ASTNode> extractVariableIdentifiers(ASTNode node) {
        void $this$filterNotTo$iv$iv;
        List list;
        ASTNode it;
        Iterable $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        ASTNode destructingDeclaration = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getDESTRUCTURING_DECLARATION());
        if (destructingDeclaration != null) {
            void $this$map$iv;
            Iterable iterable = AstNodeUtilsKt.getAllChildrenWithType(destructingDeclaration, ElementType.INSTANCE.getDESTRUCTURING_DECLARATION_ENTRY());
            boolean $i$f$map = false;
            void var6_5 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ASTNode aSTNode = (ASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ASTNode aSTNode2 = AstNodeUtilsKt.getIdentifierName(it);
                Intrinsics.checkNotNull((Object)aSTNode2);
                collection.add(aSTNode2);
            }
            list = (List)destination$iv$iv;
        } else if (SequencesKt.count((Sequence)PsiUtilsKt.parents((ASTNode)node)) > 1 && Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST()) && Intrinsics.areEqual((Object)node.getTreeParent().getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_TYPE())) {
            list = CollectionsKt.listOfNotNull((Object)AstNodeUtilsKt.getIdentifierName(node));
        } else {
            ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(node);
            Intrinsics.checkNotNull((Object)aSTNode);
            list = CollectionsKt.listOf((Object)aSTNode);
        }
        List result = list;
        Iterable $this$filterNot$iv = result;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (oneCharIdentifiers.contains(it.getText())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<ASTNode> checkClassNamings(ASTNode node) {
        ASTNode genericType = AstNodeUtilsKt.getTypeParameterList(node);
        if (genericType != null && !this.validGenericTypeName(genericType)) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            String string = genericType.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"genericType.text");
            Warnings.warnAndFix$default(Warnings.GENERIC_NAME, list, function3, bl, string, genericType.getStartOffset(), genericType, false, checkClassNamings.1.INSTANCE, 64, null);
        }
        ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(node);
        if (aSTNode == null) {
            return CollectionsKt.emptyList();
        }
        ASTNode className = aSTNode;
        String string = className.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.text");
        if (!StringCaseUtilsKt.isPascalCase(string)) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            string = className.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.text");
            Warnings.warnAndFix$default(Warnings.CLASS_NAME_INCORRECT, list, function3, bl, string, className.getStartOffset(), className, false, (Function0)new Function0<Unit>(className){
                final /* synthetic */ ASTNode $className;
                {
                    this.$className = $className;
                    super(0);
                }

                public final void invoke() {
                    LeafPsiElement leafPsiElement = (LeafPsiElement)this.$className;
                    String string = ((LeafPsiElement)this.$className).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className.text");
                    leafPsiElement.rawReplaceWithText(StringCaseUtilsKt.toPascalCase(string));
                }
            }, 64, null);
        }
        this.checkExceptionSuffix(node);
        return CollectionsKt.listOf((Object)className);
    }

    private final void checkExceptionSuffix(ASTNode node) {
        ASTNode aSTNode;
        String superClassName;
        ASTNode aSTNode2 = AstNodeUtilsKt.getIdentifierName(node);
        if (aSTNode2 == null) {
            return;
        }
        ASTNode classNameNode = aSTNode2;
        Object object = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getSUPER_TYPE_LIST());
        String string = object == null ? null : (superClassName = (aSTNode = AstNodeUtilsKt.findLeafWithSpecificType(object, ElementType.INSTANCE.getTYPE_REFERENCE())) == null ? null : aSTNode.getText());
        if (superClassName != null && this.hasExceptionSuffix(superClassName)) {
            object = classNameNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classNameNode.text");
            if (!this.hasExceptionSuffix((String)object)) {
                List<RulesConfig> list = this.getConfigRules();
                Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                boolean bl = this.isFixMode();
                object = classNameNode.getText();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classNameNode.text");
                Warnings.warnAndFix$default(Warnings.EXCEPTION_SUFFIX, list, function3, bl, (String)object, classNameNode.getStartOffset(), classNameNode, false, (Function0)new Function0<Unit>(classNameNode){
                    final /* synthetic */ ASTNode $classNameNode;
                    {
                        this.$classNameNode = $classNameNode;
                        super(0);
                    }

                    public final void invoke() {
                        ((LeafPsiElement)this.$classNameNode).rawReplaceWithText(Intrinsics.stringPlus((String)((LeafPsiElement)this.$classNameNode).getText(), (Object)"Exception"));
                    }
                }, 64, null);
            }
        }
    }

    private final boolean hasExceptionSuffix(String text) {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string = text.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
        return StringsKt.endsWith$default((String)string, (String)"exception", (boolean)false, (int)2, null);
    }

    private final List<ASTNode> checkObjectNaming(ASTNode node) {
        ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(node);
        if (aSTNode == null) {
            return CollectionsKt.emptyList();
        }
        ASTNode objectName = aSTNode;
        String string = objectName.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectName.text");
        if (!StringCaseUtilsKt.isPascalCase(string)) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            string = objectName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectName.text");
            Warnings.warnAndFix$default(Warnings.OBJECT_NAME_INCORRECT, list, function3, bl, string, objectName.getStartOffset(), objectName, false, (Function0)new Function0<Unit>(objectName){
                final /* synthetic */ ASTNode $objectName;
                {
                    this.$objectName = $objectName;
                    super(0);
                }

                public final void invoke() {
                    LeafPsiElement leafPsiElement = (LeafPsiElement)this.$objectName;
                    String string = ((LeafPsiElement)this.$objectName).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"objectName.text");
                    leafPsiElement.rawReplaceWithText(StringCaseUtilsKt.toPascalCase(string));
                }
            }, 64, null);
        }
        return CollectionsKt.listOf((Object)objectName);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ASTNode> checkEnumValues(ASTNode node) {
        void $this$filterTo$iv$iv;
        ASTNode[] aSTNodeArray = node.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node.getChildren(null)");
        Object[] $this$filter$iv = aSTNodeArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getIDENTIFIER())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enumValues = (List)destination$iv$iv;
        Iterable $this$forEach$iv = enumValues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KFunction kFunction;
            KFunction kFunction2;
            ASTNode value = (ASTNode)element$iv;
            boolean bl = false;
            RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.getConfigRules(), (Rule)Warnings.ENUM_VALUE);
            Map map = rulesConfig == null ? null : rulesConfig.getConfiguration();
            IdentifierNamingConfiguration configuration2 = new IdentifierNamingConfiguration(map == null ? MapsKt.emptyMap() : map);
            switch (WhenMappings.$EnumSwitchMapping$0[configuration2.getEnumStyle().ordinal()]) {
                case 1: {
                    kFunction2 = (KFunction)checkEnumValues.1.validator.1.INSTANCE;
                    break;
                }
                case 2: {
                    kFunction2 = (KFunction)checkEnumValues.1.validator.2.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KFunction validator2 = kFunction2;
            switch (WhenMappings.$EnumSwitchMapping$0[configuration2.getEnumStyle().ordinal()]) {
                case 1: {
                    kFunction = (KFunction)checkEnumValues.1.autofix.1.INSTANCE;
                    break;
                }
                case 2: {
                    kFunction = (KFunction)checkEnumValues.1.autofix.2.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KFunction autofix2 = kFunction;
            Function1 function1 = (Function1)validator2;
            String string = value.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.text");
            if (!((Boolean)function1.invoke((Object)string)).booleanValue()) {
                List<RulesConfig> list = this.getConfigRules();
                Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                boolean bl2 = this.isFixMode();
                string = value.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.text");
                Warnings.warnAndFix$default(Warnings.ENUM_VALUE, list, function3, bl2, string, value.getStartOffset(), value, false, (Function0)new Function0<Unit>(value, (KFunction<String>)autofix2){
                    final /* synthetic */ ASTNode $value;
                    final /* synthetic */ KFunction<String> $autofix;
                    {
                        this.$value = $value;
                        this.$autofix = $autofix;
                        super(0);
                    }

                    public final void invoke() {
                        LeafPsiElement leafPsiElement = (LeafPsiElement)this.$value;
                        Function1 function1 = (Function1)this.$autofix;
                        String string = ((LeafPsiElement)this.$value).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.text");
                        leafPsiElement.rawReplaceWithText((String)function1.invoke((Object)string));
                    }
                }, 64, null);
            }
            if (!confusingIdentifierNames.contains(value.getText())) continue;
            this.warnConfusingName(value);
        }
        return enumValues;
    }

    private final List<ASTNode> checkFunctionName(ASTNode node) {
        String functionReturnType;
        ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(node);
        Intrinsics.checkNotNull((Object)aSTNode);
        ASTNode functionName = aSTNode;
        String string = functionName.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"functionName.text");
        if (!StringCaseUtilsKt.isLowerCamelCase(string)) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            string = functionName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"functionName.text");
            Warnings.warnAndFix$default(Warnings.FUNCTION_NAME_INCORRECT_CASE, list, function3, bl, string, functionName.getStartOffset(), functionName, false, (Function0)new Function0<Unit>(functionName){
                final /* synthetic */ ASTNode $functionName;
                {
                    this.$functionName = $functionName;
                    super(0);
                }

                public final void invoke() {
                    LeafPsiElement leafPsiElement = (LeafPsiElement)this.$functionName;
                    String string = ((LeafPsiElement)this.$functionName).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"functionName.text");
                    leafPsiElement.rawReplaceWithText(StringCaseUtilsKt.toLowerCamelCase(string));
                }
            }, 64, null);
        }
        ASTNode aSTNode2 = AstNodeUtilsKt.findChildAfter(node, ElementType.INSTANCE.getVALUE_PARAMETER_LIST(), ElementType.INSTANCE.getTYPE_REFERENCE());
        String string2 = functionReturnType = aSTNode2 == null ? null : aSTNode2.getText();
        if (!AstNodeUtilsKt.isOverridden(node) && functionReturnType != null && Intrinsics.areEqual((Object)functionReturnType, (Object)PrimitiveType.BOOLEAN.getTypeName().asString())) {
            boolean bl;
            block6: {
                Iterable $this$none$iv = this.getAllMethodPrefixes();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        String string3 = functionName.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"functionName.text");
                        if (!StringsKt.startsWith$default((String)string3, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                List<RulesConfig> list = this.getConfigRules();
                Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                boolean bl3 = this.isFixMode();
                String string4 = functionName.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"functionName.text");
                Warnings.warnAndFix$default(Warnings.FUNCTION_BOOLEAN_PREFIX, list, function3, bl3, string4, functionName.getStartOffset(), functionName, false, checkFunctionName.3.INSTANCE, 64, null);
            }
        }
        return CollectionsKt.listOf((Object)functionName);
    }

    private final List<ASTNode> checkTypeAliases(ASTNode node) {
        ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(node);
        Intrinsics.checkNotNull((Object)aSTNode);
        ASTNode aliasName = aSTNode;
        String string = aliasName.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aliasName.text");
        if (!StringCaseUtilsKt.isPascalCase(string)) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            string = aliasName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aliasName.text");
            Warnings.warnAndFix$default(Warnings.TYPEALIAS_NAME_INCORRECT_CASE, list, function3, bl, string, aliasName.getStartOffset(), aliasName, false, (Function0)new Function0<Unit>(aliasName){
                final /* synthetic */ ASTNode $aliasName;
                {
                    this.$aliasName = $aliasName;
                    super(0);
                }

                public final void invoke() {
                    LeafPsiElement leafPsiElement = (LeafPsiElement)this.$aliasName;
                    String string = ((LeafPsiElement)this.$aliasName).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aliasName.text");
                    leafPsiElement.rawReplaceWithText(StringCaseUtilsKt.toPascalCase(string));
                }
            }, 64, null);
        }
        return CollectionsKt.listOf((Object)aliasName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validGenericTypeName(ASTNode generic) {
        boolean bl;
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getTYPE_PARAMETER()};
        ASTNode[] aSTNodeArray = generic.getChildren(TokenSet.create((IElementType[])iElementTypeArray));
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"generic.getChildren(Toke\u2026t.create(TYPE_PARAMETER))");
        Object[] $this$all$iv = aSTNodeArray;
        boolean $i$f$all = false;
        Object[] objectArray = $this$all$iv;
        int n = 0;
        int n2 = objectArray.length;
        do {
            if (n >= n2) return true;
            Object element$iv = objectArray[n];
            ++n;
            ASTNode it = (ASTNode)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            ASTNode aSTNode = AstNodeUtilsKt.getIdentifierName(it);
            if (aSTNode == null) {
                return false;
            }
            String string = aSTNode.getText();
            if (string == null) {
                return false;
            }
            String typeText = string;
            char c = typeText.charAt(0);
            if ('A' > c) return false;
            if (c >= '[') return false;
            boolean bl3 = true;
            if (!bl3) return false;
            if (typeText.length() != 1) {
                String string2 = typeText.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                if (!StringUtilsKt.isDigits(string2)) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    private final void checkIdentifierLength(List<? extends ASTNode> nodes, boolean isVariable) {
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean isValidOneCharVariable;
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            boolean bl2 = isValidOneCharVariable = oneCharIdentifiers.contains(it.getText()) && isVariable;
            if (Intrinsics.areEqual((Object)it.getText(), (Object)"_") || AstNodeUtilsKt.isTextLengthInRange(it, new IntRange(2, 64)) || isValidOneCharVariable || this.isValidCatchIdentifier(it)) continue;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl3 = this.isFixMode();
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            Warnings.IDENTIFIER_LENGTH.warn(list, function3, bl3, string, it.getStartOffset(), it);
        }
    }

    private final boolean isValidCatchIdentifier(ASTNode node) {
        Object object;
        ASTNode parentValueParamList;
        ASTNode aSTNode = parentValueParamList = AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getVALUE_PARAMETER_LIST());
        if (aSTNode == null) {
            object = null;
        } else {
            ASTNode aSTNode2 = PackageKt.prevCodeSibling((ASTNode)aSTNode);
            object = aSTNode2 == null ? null : aSTNode2.getElementType();
        }
        boolean prevCatchKeyWord = Intrinsics.areEqual((Object)object, (Object)ElementType.INSTANCE.getCATCH_KEYWORD());
        return Intrinsics.areEqual((Object)node.getText(), (Object)"e") && AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getCATCH()) != null && prevCatchKeyWord;
    }

    static {
        Object[] objectArray = new String[]{"i", "j", "k", "x", "y", "z"};
        oneCharIdentifiers = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"has", "is", "are", "have", "should", "can"};
        booleanMethodPrefixes = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"O", "D", "I", "l", "Z", "S", "e", "B", "h", "n", "m", "rn"};
        confusingIdentifierNames = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b*\u00020\u00078BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter1/IdentifierNaming$IdentifierNamingConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "enumStyle", "Lorg/cqfn/diktat/ruleset/utils/Style;", "getEnumStyle", "()Lorg/cqfn/diktat/ruleset/utils/Style;", "isEnumStyle", "", "isEnumStyle$annotations", "(Lorg/cqfn/diktat/ruleset/utils/Style;)V", "(Lorg/cqfn/diktat/ruleset/utils/Style;)Z", "diktat-rules"})
    public static final class IdentifierNamingConfiguration
    extends RuleConfiguration {
        @NotNull
        private final Style enumStyle;

        /*
         * WARNING - void declaration
         */
        public IdentifierNamingConfiguration(@NotNull Map<String, String> config2) {
            Style style;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            IdentifierNamingConfiguration identifierNamingConfiguration = this;
            String string = config2.get("enumStyle");
            if (string == null) {
                style = null;
            } else {
                Style style2;
                void styleString;
                IdentifierNamingConfiguration identifierNamingConfiguration2;
                block4: {
                    Style style3;
                    String string2 = string;
                    identifierNamingConfiguration2 = identifierNamingConfiguration;
                    boolean bl = false;
                    Style[] $this$firstOrNull$iv = Style.values();
                    boolean $i$f$firstOrNull = false;
                    for (Style element$iv : $this$firstOrNull$iv) {
                        Style it = element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)StringCaseUtilsKt.toUpperSnakeCase((String)styleString))) continue;
                        style3 = element$iv;
                        break block4;
                    }
                    style3 = style2 = null;
                }
                if (style2 == null || !this.isEnumStyle(style2)) {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)styleString, (Object)" is unsupported for enum style").toString());
                }
                style = style2;
                identifierNamingConfiguration = identifierNamingConfiguration2;
            }
            Style style4 = style;
            identifierNamingConfiguration.enumStyle = style4 == null ? Style.SNAKE_CASE : style4;
        }

        private final boolean isEnumStyle(Style $this$isEnumStyle) {
            Style[] styleArray = new Style[]{Style.PASCAL_CASE, Style.SNAKE_CASE};
            return CollectionsKt.listOf((Object[])styleArray).contains((Object)$this$isEnumStyle);
        }

        private static /* synthetic */ void isEnumStyle$annotations(Style style) {
        }

        @NotNull
        public final Style getEnumStyle() {
            return this.enumStyle;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter1/IdentifierNaming$BooleanFunctionsConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "allowedBooleanPrefixes", "", "getAllowedBooleanPrefixes", "()Ljava/util/List;", "diktat-rules"})
    public static final class BooleanFunctionsConfiguration
    extends RuleConfiguration {
        @NotNull
        private final List<String> allowedBooleanPrefixes;

        /*
         * WARNING - void declaration
         */
        public BooleanFunctionsConfiguration(@NotNull Map<String, String> config2) {
            List list;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            BooleanFunctionsConfiguration booleanFunctionsConfiguration = this;
            String string = config2.get("allowedPrefixes");
            if (string == null) {
                list = null;
            } else {
                Object object = new String[]{","};
                List list2 = StringsKt.split$default((CharSequence)string, (String[])object, (boolean)false, (int)0, (int)6, null);
                if (list2 == null) {
                    list = null;
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    object = list2;
                    BooleanFunctionsConfiguration booleanFunctionsConfiguration2 = booleanFunctionsConfiguration;
                    boolean $i$f$map = false;
                    void var4_5 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                    }
                    list = (List)destination$iv$iv;
                    booleanFunctionsConfiguration = booleanFunctionsConfiguration2;
                }
            }
            List list3 = list;
            if (list == null) {
                list3 = CollectionsKt.emptyList();
            }
            booleanFunctionsConfiguration.allowedBooleanPrefixes = list3;
        }

        @NotNull
        public final List<String> getAllowedBooleanPrefixes() {
            return this.allowedBooleanPrefixes;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter1/IdentifierNaming$Companion;", "", "()V", "MAX_IDENTIFIER_LENGTH", "", "MIN_IDENTIFIER_LENGTH", "NAME_ID", "", "booleanMethodPrefixes", "", "getBooleanMethodPrefixes", "()Ljava/util/Set;", "confusingIdentifierNames", "getConfusingIdentifierNames", "oneCharIdentifiers", "getOneCharIdentifiers", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getOneCharIdentifiers() {
            return oneCharIdentifiers;
        }

        @NotNull
        public final Set<String> getBooleanMethodPrefixes() {
            return booleanMethodPrefixes;
        }

        @NotNull
        public final Set<String> getConfusingIdentifierNames() {
            return confusingIdentifierNames;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Style.values().length];
            nArray[Style.PASCAL_CASE.ordinal()] = 1;
            nArray[Style.SNAKE_CASE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

