/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter1;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.CommonConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter1.PackageNaming;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.FileUtilsKt;
import org.cqfn.diktat.ruleset.utils.KotlinParser;
import org.cqfn.diktat.ruleset.utils.StringUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 #2\u00020\u0001:\u0001#B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u001e\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0016\u0010\u001b\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0012H\u0016J&\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\"\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter1/PackageNaming;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "domainName", "", "areCorrectSymbolsUsed", "", "word", "calculateRealPackageName", "fileName", "configuration", "Lorg/cqfn/diktat/common/config/rules/CommonConfiguration;", "checkFilePathMatchesWithPackageName", "", "packageNameParts", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "realNameParts", "packageDirective", "checkPackageName", "wordsInPackageName", "packageDirectiveNode", "correctPackageWordSeparatorsUsed", "insertNewPackageName", "packageName", "isDomainMatches", "isExceptionForUnderscore", "logic", "node", "warnAndFixMissingPackageName", "initialPackageDirectiveNode", "realPackageName", "filePath", "Companion", "diktat-rules"})
public final class PackageNaming
extends DiktatRule {
    @NotNull
    public static final Companion Companion;
    private String domainName;
    private static final Logger log;
    @NotNull
    public static final String NAME_ID = "aah-package-naming";
    @NotNull
    public static final String PACKAGE_PATH_ANCHOR = "src";
    @NotNull
    public static final String PACKAGE_SEPARATOR = ".";
    @NotNull
    private static AtomicInteger visitorCounter;
    @NotNull
    private static final List<String> kmmTargets;
    @NotNull
    private static final List<String> languageDirNames;

    public PackageNaming(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        Warnings[] warningsArray = new Warnings[]{Warnings.INCORRECT_PACKAGE_SEPARATOR, Warnings.PACKAGE_NAME_INCORRECT_CASE, Warnings.PACKAGE_NAME_MISSING, Warnings.PACKAGE_NAME_INCORRECT_PATH, Warnings.PACKAGE_NAME_INCORRECT_PREFIX, Warnings.PACKAGE_NAME_INCORRECT_SYMBOLS};
        super(NAME_ID, configRules, CollectionsKt.listOf((Object[])warningsArray), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        block5: {
            Unit unit;
            Unit unit2;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            CommonConfiguration configuration2 = RulesConfigReaderKt.getCommonConfiguration(this.getConfigRules());
            String string = configuration2.getDomainName();
            if (string == null) {
                unit2 = null;
            } else {
                String it = string;
                boolean bl = false;
                this.domainName = it;
                if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPACKAGE_DIRECTIVE())) {
                    String filePath = AstNodeUtilsKt.getFilePath(node);
                    List wordsInPackageName = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getIDENTIFIER(), false, 2, null);
                    if (wordsInPackageName.isEmpty() && FileUtilsKt.isKotlinScript(filePath)) {
                        return;
                    }
                    List<String> realPackageName = this.calculateRealPackageName(filePath, configuration2);
                    if (PackageKt.isLeaf((ASTNode)node) && !FileUtilsKt.isKotlinScript(filePath)) {
                        this.warnAndFixMissingPackageName(node, realPackageName, filePath);
                        return;
                    }
                    this.checkPackageName(wordsInPackageName, node);
                    this.checkFilePathMatchesWithPackageName(wordsInPackageName, realPackageName, node);
                }
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit != null || visitorCounter.incrementAndGet() != 1) break block5;
            log.error("Not able to find an external configuration for domain name in the common configuration (is it missing in yml config?)");
        }
    }

    private final void warnAndFixMissingPackageName(ASTNode initialPackageDirectiveNode, List<String> realPackageName, String filePath) {
        String string = File.Companion.getSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File.separator");
        String fileName = StringsKt.substringAfterLast$default((String)filePath, (String)string, null, (int)2, null);
        boolean isBuildSrcPath = StringsKt.contains$default((CharSequence)filePath, (CharSequence)"buildSrc", (boolean)false, (int)2, null);
        if (!isBuildSrcPath) {
            Warnings.warnAndFix$default(Warnings.PACKAGE_NAME_MISSING, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), fileName, initialPackageDirectiveNode.getStartOffset(), initialPackageDirectiveNode, false, (Function0)new Function0<Unit>(realPackageName, this, initialPackageDirectiveNode){
                final /* synthetic */ List<String> $realPackageName;
                final /* synthetic */ PackageNaming this$0;
                final /* synthetic */ ASTNode $initialPackageDirectiveNode;
                {
                    this.$realPackageName = $realPackageName;
                    this.this$0 = $receiver;
                    this.$initialPackageDirectiveNode = $initialPackageDirectiveNode;
                    super(0);
                }

                public final void invoke() {
                    if (!((Collection)this.$realPackageName).isEmpty()) {
                        String newPackageDirectiveName = CollectionsKt.joinToString$default((Iterable)this.$realPackageName, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
                        PackageNaming.access$insertNewPackageName(this.this$0, this.$initialPackageDirectiveNode, newPackageDirectiveName);
                    }
                }
            }, 64, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> calculateRealPackageName(String fileName, CommonConfiguration configuration2) {
        List list;
        Iterable $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = CollectionsKt.dropLast(FileUtilsKt.splitPathToDirs(fileName), (int)1);
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{PACKAGE_SEPARATOR};
            Iterable list$iv$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List filePathParts = (List)destination$iv$iv;
        if (!filePathParts.contains(PACKAGE_PATH_ANCHOR)) {
            log.error("Not able to determine a path to a scanned file or \"src\" directory cannot be found in it's path. Will not be able to determine correct package name. It can happen due to missing <src> directory in the path");
            list = CollectionsKt.emptyList();
        } else {
            List list2;
            void $this$dropWhile$iv;
            List allDirs = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)languageDirNames, (Iterable)configuration2.getSrcDirectories()), (Iterable)configuration2.getTestAnchors());
            $this$flatMapTo$iv$iv = filePathParts.subList(filePathParts.lastIndexOf(PACKAGE_PATH_ANCHOR), filePathParts.size());
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                String it = (String)item$iv;
                boolean bl = false;
                if (allDirs.contains(it)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            List fileSubDir = list$iv;
            String string = CollectionsKt.joinToString$default((Iterable)fileSubDir, (CharSequence)PACKAGE_SEPARATOR, null, null, (int)0, null, null, (int)62, null);
            String string2 = this.domainName;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"domainName");
                string2 = null;
            }
            if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
                String string3 = this.domainName;
                if (string3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"domainName");
                    string3 = null;
                }
                String[] stringArray = new String[]{PACKAGE_SEPARATOR};
                list2 = StringsKt.split$default((CharSequence)string3, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List domainPrefix = list2;
            list = CollectionsKt.plus((Collection)domainPrefix, (Iterable)fileSubDir);
        }
        return list;
    }

    private final void checkPackageName(List<? extends ASTNode> wordsInPackageName, ASTNode packageDirectiveNode) {
        String string;
        ASTNode word;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = wordsInPackageName;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            word = (ASTNode)element$iv$iv;
            boolean bl = false;
            string = word.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word.text");
            if (!StringUtilsKt.hasUppercaseLetter(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl2 = this.isFixMode();
            element$iv$iv = it.getText();
            Intrinsics.checkNotNullExpressionValue(element$iv$iv, (String)"it.text");
            Warnings.warnAndFix$default(Warnings.PACKAGE_NAME_INCORRECT_CASE, list, function3, bl2, element$iv$iv, it.getStartOffset(), it, false, (Function0)new Function0<Unit>(it){
                final /* synthetic */ ASTNode $it;
                {
                    this.$it = $it;
                    super(0);
                }

                public final void invoke() {
                    AstNodeUtilsKt.toLower(this.$it);
                }
            }, 64, null);
        }
        if (!this.isDomainMatches(wordsInPackageName)) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            String string2 = this.domainName;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"domainName");
                string2 = null;
            }
            Warnings.warnAndFix$default(Warnings.PACKAGE_NAME_INCORRECT_PREFIX, list, function3, bl, string2, wordsInPackageName.get(0).getStartOffset(), wordsInPackageName.get(0), false, (Function0)new Function0<Unit>(wordsInPackageName, this, packageDirectiveNode){
                final /* synthetic */ List<ASTNode> $wordsInPackageName;
                final /* synthetic */ PackageNaming this$0;
                final /* synthetic */ ASTNode $packageDirectiveNode;
                {
                    this.$wordsInPackageName = $wordsInPackageName;
                    this.this$0 = $receiver;
                    this.$packageDirectiveNode = $packageDirectiveNode;
                    super(0);
                }

                public final void invoke() {
                    String oldPackageName2 = CollectionsKt.joinToString$default((Iterable)this.$wordsInPackageName, (CharSequence)".", null, null, (int)0, null, (Function1)checkPackageName.oldPackageName.1.INSTANCE, (int)30, null);
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = PackageNaming.access$getDomainName$p(this.this$0);
                    if (string == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"domainName");
                        string = null;
                    }
                    String newPackageName = stringBuilder.append(string).append('.').append(oldPackageName2).toString();
                    PackageNaming.access$insertNewPackageName(this.this$0, this.$packageDirectiveNode, newPackageName);
                }
            }, 64, null);
        }
        $this$filter$iv = wordsInPackageName;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            word = (ASTNode)element$iv$iv;
            boolean bl3 = false;
            string = word.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word.text");
            if (!(!this.areCorrectSymbolsUsed(string))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl4 = false;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl5 = this.isFixMode();
            String string3 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.text");
            Warnings.PACKAGE_NAME_INCORRECT_SYMBOLS.warn(list, function3, bl5, string3, it.getStartOffset(), it);
        }
        $this$forEach$iv = wordsInPackageName;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl6 = false;
            this.correctPackageWordSeparatorsUsed(it);
        }
    }

    private final boolean areCorrectSymbolsUsed(String word) {
        String wordFromPackage = StringsKt.replace$default((String)word, (String)"_", (String)"", (boolean)false, (int)4, null);
        return StringUtilsKt.isASCIILettersAndDigits(wordFromPackage);
    }

    private final void correctPackageWordSeparatorsUsed(ASTNode word) {
        String string = word.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word.text");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"_", (boolean)false, (int)2, null)) {
            string = word.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word.text");
            if (!this.isExceptionForUnderscore(string)) {
                List<RulesConfig> list = this.getConfigRules();
                Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                boolean bl = this.isFixMode();
                string = word.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word.text");
                Warnings.warnAndFix$default(Warnings.INCORRECT_PACKAGE_SEPARATOR, list, function3, bl, string, word.getStartOffset(), word, false, (Function0)new Function0<Unit>(word){
                    final /* synthetic */ ASTNode $word;
                    {
                        this.$word = $word;
                        super(0);
                    }

                    public final void invoke() {
                        LeafPsiElement leafPsiElement = (LeafPsiElement)this.$word;
                        String string = ((LeafPsiElement)this.$word).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word.text");
                        leafPsiElement.rawReplaceWithText(StringsKt.replace$default((String)string, (String)"_", (String)"", (boolean)false, (int)4, null));
                    }
                }, 64, null);
            }
        }
    }

    private final boolean isExceptionForUnderscore(String word) {
        String wordFromPackage = StringsKt.replace$default((String)word, (String)"_", (String)"", (boolean)false, (int)4, null);
        return Character.isDigit(wordFromPackage.charAt(0)) || StringUtilsKt.isKotlinKeyWord(wordFromPackage) || StringUtilsKt.isJavaKeyWord(wordFromPackage);
    }

    private final boolean isDomainMatches(List<? extends ASTNode> packageNameParts) {
        String string = this.domainName;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"domainName");
            string = null;
        }
        String[] stringArray = new String[]{PACKAGE_SEPARATOR};
        List packageNamePrefix = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (packageNameParts.size() < packageNamePrefix.size()) {
            return false;
        }
        int n = 0;
        int n2 = packageNamePrefix.size();
        while (n < n2) {
            int i;
            if (Intrinsics.areEqual((Object)packageNameParts.get(i = n++).getText(), packageNamePrefix.get(i))) continue;
            return false;
        }
        return true;
    }

    private final void insertNewPackageName(ASTNode packageDirectiveNode, String packageName) {
        block8: {
            Unit unit;
            Unit unit2;
            ASTNode aSTNode = packageDirectiveNode.findChildByType(ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION());
            ASTNode packageNameNode = aSTNode == null ? packageDirectiveNode.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION()) : aSTNode;
            ASTNode generatedPackageDirective = new KotlinParser().createNode(KtTokens.PACKAGE_KEYWORD + ' ' + packageName, true);
            ASTNode aSTNode2 = packageNameNode;
            if (aSTNode2 == null) {
                unit2 = null;
            } else {
                ASTNode it = aSTNode2;
                boolean bl = false;
                ASTNode aSTNode3 = AstNodeUtilsKt.findLeafWithSpecificType(generatedPackageDirective, ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION());
                Intrinsics.checkNotNull((Object)aSTNode3);
                packageDirectiveNode.replaceChild(packageNameNode, aSTNode3);
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit != null) break block8;
            PackageNaming $this$insertNewPackageName_u24lambda_u2d10 = this;
            boolean bl = false;
            ASTNode aSTNode4 = AstNodeUtilsKt.findLeafWithSpecificType(generatedPackageDirective, ElementType.INSTANCE.getPACKAGE_DIRECTIVE());
            Intrinsics.checkNotNull((Object)aSTNode4);
            ASTNode newPackageDirective = aSTNode4;
            ASTNode packageDirectiveParent = packageDirectiveNode.getTreeParent();
            if (!Intrinsics.areEqual((Object)packageDirectiveNode, (Object)packageDirectiveParent.getFirstChildNode())) {
                Object element$iv2;
                block7: {
                    Object[] objectArray = new IElementType[]{ElementType.INSTANCE.getWHITE_SPACE(), ElementType.INSTANCE.getEOL_COMMENT(), ElementType.INSTANCE.getBLOCK_COMMENT(), ElementType.INSTANCE.getKDOC(), ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getFILE_ANNOTATION_LIST()};
                    List possibleTypesBeforePackageDirective = CollectionsKt.listOf((Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)packageDirectiveParent, (String)"packageDirectiveParent");
                    Sequence $this$first$iv = PackageKt.children((ASTNode)packageDirectiveParent);
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        ASTNode it = (ASTNode)element$iv2;
                        boolean bl2 = false;
                        if (!(!possibleTypesBeforePackageDirective.contains(it.getElementType()))) continue;
                        break block7;
                    }
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                ASTNode addBefore = (ASTNode)element$iv2;
                packageDirectiveParent.removeChild(packageDirectiveNode);
                packageDirectiveParent.addChild(newPackageDirective, addBefore);
                if (!Intrinsics.areEqual((Object)newPackageDirective.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                    packageDirectiveParent.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), newPackageDirective);
                }
            } else {
                packageDirectiveParent.replaceChild(packageDirectiveNode, newPackageDirective);
            }
            if (!Intrinsics.areEqual((Object)newPackageDirective.getTreeNext().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                packageDirectiveParent.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), newPackageDirective.getTreeNext());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFilePathMatchesWithPackageName(List<? extends ASTNode> packageNameParts, List<String> realNameParts, ASTNode packageDirective) {
        if (!((Collection)realNameParts).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = packageNameParts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void node;
                ASTNode aSTNode = (ASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(node.getText());
            }
            if (!Intrinsics.areEqual((Object)((List)destination$iv$iv), realNameParts)) {
                String realPackageNameStr = CollectionsKt.joinToString$default((Iterable)realNameParts, (CharSequence)PACKAGE_SEPARATOR, null, null, (int)0, null, null, (int)62, null);
                int offset2 = packageNameParts.get(0).getStartOffset();
                Warnings.warnAndFix$default(Warnings.PACKAGE_NAME_INCORRECT_PATH, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), realPackageNameStr, offset2, packageNameParts.get(0), false, (Function0)new Function0<Unit>(this, packageDirective, realPackageNameStr){
                    final /* synthetic */ PackageNaming this$0;
                    final /* synthetic */ ASTNode $packageDirective;
                    final /* synthetic */ String $realPackageNameStr;
                    {
                        this.this$0 = $receiver;
                        this.$packageDirective = $packageDirective;
                        this.$realPackageNameStr = $realPackageNameStr;
                        super(0);
                    }

                    public final void invoke() {
                        PackageNaming.access$insertNewPackageName(this.this$0, this.$packageDirective, this.$realPackageNameStr);
                    }
                }, 64, null);
            }
        }
    }

    public static final /* synthetic */ void access$insertNewPackageName(PackageNaming $this, ASTNode packageDirectiveNode, String packageName) {
        $this.insertNewPackageName(packageDirectiveNode, packageName);
    }

    public static final /* synthetic */ String access$getDomainName$p(PackageNaming $this) {
        return $this.domainName;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_4;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(PackageNaming.class);
        visitorCounter = new AtomicInteger(0);
        Object object = new String[]{"common", "jvm", "js", "android", "ios", "androidNativeArm32", "androidNativeArm64", "iosArm32", "iosArm64", "iosX64", "watchosArm32", "watchosArm64", "watchosX86", "tvosArm64", "tvosX64", "macosX64", "linuxArm64", "linuxArm32Hfp", "linuxMips32", "linuxMipsel32", "linuxX64", "mingwX64", "mingwX86", "wasm32"};
        kmmTargets = CollectionsKt.listOf((Object[])object);
        object = new String[]{PACKAGE_PATH_ANCHOR, "java", "kotlin"};
        Collection collection = CollectionsKt.listOf((Object[])object);
        object = kmmTargets;
        Collection collection2 = collection;
        boolean $i$f$flatMap = false;
        void var2_3 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{Intrinsics.stringPlus((String)it, (Object)"Main"), Intrinsics.stringPlus((String)it, (Object)"Test")};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        languageDirNames = CollectionsKt.plus((Collection)collection2, (Iterable)((List)var3_4));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter1/PackageNaming$Companion;", "", "()V", "NAME_ID", "", "PACKAGE_PATH_ANCHOR", "PACKAGE_SEPARATOR", "kmmTargets", "", "languageDirNames", "getLanguageDirNames", "()Ljava/util/List;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "visitorCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getVisitorCounter", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setVisitorCounter", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicInteger getVisitorCounter() {
            return visitorCounter;
        }

        public final void setVisitorCounter(@NotNull AtomicInteger atomicInteger) {
            Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
            visitorCounter = atomicInteger;
        }

        @NotNull
        public final List<String> getLanguageDirNames() {
            return languageDirNames;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

