/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter2.comments;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter2.comments.CommentsRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J@\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\u00032\u0006\u0010\n\u001a\u00020\u000b2\u001c\u0010\u0010\u001a\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\r0\u0011j\u0002`\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\u0018\u001a\u00020\u0014*\u00020\u000fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter2/comments/CommentsRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "ktPsiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "checkCommentedCode", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "getOffsetsToTextBlocksFromEolComments", "Lkotlin/Pair;", "", "", "errorNodesWithText", "", "Lorg/cqfn/diktat/ruleset/constants/ListOfPairs;", "isCodeAfterCommentStart", "", "text", "isContainingRequiredPartOfCode", "logic", "isPossibleImport", "Companion", "diktat-rules"})
public final class CommentsRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private KtPsiFactory ktPsiFactory;
    private static final Logger logger = LoggerFactory.getLogger(CommentsRule.class);
    @NotNull
    public static final String NAME_ID = "aaa-comments";
    @NotNull
    private static final String importKeywordWithSpace = Intrinsics.stringPlus((String)KtTokens.IMPORT_KEYWORD.getValue(), (Object)" ");
    @NotNull
    private static final String packageKeywordWithSpace = Intrinsics.stringPlus((String)KtTokens.PACKAGE_KEYWORD.getValue(), (Object)" ");
    @NotNull
    private static final Regex importOrPackage = new Regex('(' + importKeywordWithSpace + '|' + packageKeywordWithSpace + ')');
    @NotNull
    private static final Regex classRegex = new Regex("^\\s*(public|private|protected)*\\s*(internal)*\\s*(open|data|sealed)*\\s*(internal)*\\s*(class|object)\\s+(\\w+)(\\(.*\\))*(\\s*:\\s*\\w+(\\(.*\\))*)?\\s*\\{*$");
    @NotNull
    private static final Regex importOrPackageRegex = new Regex("^(import|package)?\\s+([a-zA-Z.])+;*$");
    @NotNull
    private static final Regex functionRegex = new Regex("^(public|private|protected)*\\s*(override|abstract|actual|expect)*\\s?fun\\s+\\w+(\\(.*\\))?(\\s*:\\s*\\w+)?\\s*[{=]$");
    @NotNull
    private static final Regex rightBraceRegex = new Regex("^\\s*}$");
    @NotNull
    private static final Regex valOrVarRegex = new Regex("val |var ");
    @NotNull
    private static final List<Regex> codeFileStartCases;
    @NotNull
    private static final Regex eolCommentStart;

    public CommentsRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.COMMENTED_OUT_CODE)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Project project2 = node.getPsi().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"node.psi.project");
        this.ktPsiFactory = new KtPsiFactory(project2, false);
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            this.checkCommentedCode(node);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkCommentedCode(ASTNode node) {
        errorNodesWithText = new ArrayList<E>();
        eolCommentsOffsetToText = this.getOffsetsToTextBlocksFromEolComments(node, errorNodesWithText);
        var5_4 = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getBLOCK_COMMENT(), false, 2, null);
        $i$f$map = false;
        var7_6 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var12_16 = (ASTNode)item$iv$iv;
            var30_26 = destination$iv$iv;
            $i$a$-map-CommentsRule$checkCommentedCode$blockCommentsOffsetToText$1 = false;
            var14_20 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)var14_20, (String)"it.text");
            errorNodesWithText.add(TuplesKt.to((Object)it, (Object)StringsKt.removeSurrounding((String)StringsKt.trim((CharSequence)var14_20).toString(), (CharSequence)"/*", (CharSequence)"*/")));
            v0 = it.getStartOffset();
            var14_20 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)var14_20, (String)"it.text");
            var30_26.add(TuplesKt.to((Object)v0, (Object)StringsKt.removeSurrounding((String)StringsKt.trim((CharSequence)var14_20).toString(), (CharSequence)"/*", (CharSequence)"*/")));
        }
        blockCommentsOffsetToText = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.plus((Collection)eolCommentsOffsetToText, (Iterable)blockCommentsOffsetToText);
        $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            $dstr$offset$text = (Pair)element$iv$iv;
            $i$a$-flatMap-CommentsRule$checkCommentedCode$1 = false;
            offset = ((Number)$dstr$offset$text.component1()).intValue();
            text = (String)$dstr$offset$text.component2();
            $this$partition$iv = StringsKt.lines((CharSequence)text);
            $i$f$partition = false;
            first$iv = new ArrayList<T>();
            second$iv = new ArrayList<T>();
            for (T element$iv : $this$partition$iv) {
                it = (String)element$iv /* !! */ ;
                $i$a$-partition-CommentsRule$checkCommentedCode$1$1 = false;
                var24_50 = it;
                if (CommentsRule.importOrPackage.containsMatchIn(var24_50)) {
                    first$iv.add(element$iv /* !! */ );
                    continue;
                }
                second$iv.add(element$iv /* !! */ );
            }
            var26_54 = new Pair(first$iv, second$iv);
            singleLines = (List)var26_54.component1();
            blockLines = (List)var26_54.component2();
            block = ((Collection)blockLines).isEmpty() == false != false ? CollectionsKt.listOf((Object)CollectionsKt.joinToString$default((Iterable)blockLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)) : CollectionsKt.emptyList();
            $this$map$iv = CollectionsKt.plus((Collection)singleLines, (Iterable)block);
            $i$f$map = false;
            element$iv /* !! */  = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (E item$iv$iv : $this$mapTo$iv$iv) {
                var27_55 = (String)item$iv$iv;
                var28_56 = destination$iv$iv;
                $i$a$-map-CommentsRule$checkCommentedCode$1$2 = false;
                var28_56.add(TuplesKt.to((Object)offset, (Object)it));
            }
            list$iv$iv /* !! */  = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv /* !! */ );
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv /* !! */  = (Pair)item$iv$iv;
            var30_26 = destination$iv$iv;
            $i$a$-map-CommentsRule$checkCommentedCode$2 = false;
            offset = ((Number)$dstr$offset$text.component1()).intValue();
            text = (String)$dstr$offset$text.component2();
            var30_26.add(TuplesKt.to((Object)offset, (Object)StringsKt.trim((CharSequence)text).toString()));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        $dstr$offset$text = $this$forEach$iv$iv$iv.iterator();
        while ($dstr$offset$text.hasNext()) {
            element$iv$iv = element$iv$iv$iv = $dstr$offset$text.next();
            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
            $dstr$offset$text = (Pair)element$iv$iv;
            $i$a$-mapNotNull-CommentsRule$checkCommentedCode$3 = false;
            offset = ((Number)$dstr$offset$text.component1()).intValue();
            text = (String)$dstr$offset$text.component2();
            if (this.isPossibleImport(text)) {
                v1 = offset;
                v2 = this.ktPsiFactory;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"ktPsiFactory");
                    v2 = null;
                }
                v3 = TuplesKt.to((Object)v1, (Object)v2.createImportDirective(ImportPath.Companion.fromString(StringsKt.substringAfter((String)text, (String)CommentsRule.importKeywordWithSpace, (String)""))).getNode());
            } else if (StringsKt.startsWith$default((String)StringsKt.trimStart((CharSequence)text).toString(), (String)CommentsRule.packageKeywordWithSpace, (boolean)false, (int)2, null)) {
                v4 = offset;
                v5 = this.ktPsiFactory;
                if (v5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"ktPsiFactory");
                    v5 = null;
                }
                v3 = TuplesKt.to((Object)v4, (Object)v5.createPackageDirective(new FqName(StringsKt.substringAfter((String)text, (String)CommentsRule.packageKeywordWithSpace, (String)""))).getNode());
            } else if (this.isContainingRequiredPartOfCode(text)) {
                v6 = offset;
                v7 = this.ktPsiFactory;
                if (v7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"ktPsiFactory");
                    v7 = null;
                }
                v3 = TuplesKt.to((Object)v6, (Object)v7.createBlockCodeFragment(text, null).getNode());
            } else {
                v3 = null;
            }
            if (v3 == null) continue;
            it$iv$iv = v3;
            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            $dstr$_u24__u24$parsedNode = (Pair)element$iv$iv;
            $i$a$-filter-CommentsRule$checkCommentedCode$4 = false;
            parsedNode = (ASTNode)$dstr$_u24__u24$parsedNode.component2();
            Intrinsics.checkNotNullExpressionValue((Object)parsedNode, (String)"parsedNode");
            var15_30 = TokenType.ERROR_ELEMENT;
            Intrinsics.checkNotNullExpressionValue((Object)var15_30, (String)"ERROR_ELEMENT");
            if (!AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(parsedNode, var15_30, false, 2, null).isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block22: {
                $dstr$offset$parsedNode = (Pair)element$iv;
                $i$a$-forEach-CommentsRule$checkCommentedCode$5 = false;
                offset = ((Number)$dstr$offset$parsedNode.component1()).intValue();
                parsedNode = (ASTNode)$dstr$offset$parsedNode.component2();
                for (T var16_32 : (Iterable)errorNodesWithText) {
                    it = (Pair)var16_32;
                    $i$a$-find-CommentsRule$checkCommentedCode$5$invalidNode$1 = false;
                    v8 = StringsKt.trim((CharSequence)((String)it.getSecond())).toString();
                    var19_41 = parsedNode.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)var19_41, (String)"parsedNode.text");
                    if (StringsKt.contains((CharSequence)v8, (CharSequence)var19_41, (boolean)false)) ** GOTO lbl-1000
                    var19_41 = parsedNode.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)var19_41, (String)"parsedNode.text");
                    if (StringsKt.contains((CharSequence)var19_41, (CharSequence)StringsKt.trim((CharSequence)((String)it.getSecond())).toString(), (boolean)false)) lbl-1000:
                    // 2 sources

                    {
                        v9 = true;
                    } else {
                        v9 = false;
                    }
                    if (!v9) continue;
                    v10 = var16_32;
                    break block22;
                }
                v10 = null;
            }
            var20_44 /* !! */  = v10;
            v11 = invalidNode = var20_44 /* !! */  == null ? null : (ASTNode)var20_44 /* !! */ .getFirst();
            if (invalidNode == null) {
                CommentsRule.logger.warn("Text [" + parsedNode.getText() + "] is a piece of code, created from comment; but no matching text in comments has been found in the file " + AstNodeUtilsKt.getFilePath(node));
                continue;
            }
            v12 = this.getConfigRules();
            v13 = this.getEmitWarn();
            v14 = this.isFixMode();
            var20_44 /* !! */  = parsedNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)var20_44 /* !! */ , (String)"parsedNode.text");
            Warnings.COMMENTED_OUT_CODE.warn(v12, v13, v14, StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)var20_44 /* !! */ , (String)"\n", null, (int)2, null)).toString(), offset, invalidNode);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final List<Pair<Integer, String>> getOffsetsToTextBlocksFromEolComments(ASTNode node, List<Pair<ASTNode, String>> errorNodesWithText) {
        var4_3 = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getEOL_COMMENT(), false, 2, null);
        $i$f$filter = false;
        var6_6 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (ASTNode)element$iv$iv /* !! */ ;
            $i$a$-filter-CommentsRule$getOffsetsToTextBlocksFromEolComments$comments$1 = false;
            var13_17 /* !! */  = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)var13_17 /* !! */ , (String)"it.text");
            var13_17 /* !! */  = var13_17 /* !! */ ;
            if (!CommentsRule.eolCommentStart.containsMatchIn((CharSequence)var13_17 /* !! */ )) ** GOTO lbl-1000
            var13_17 /* !! */  = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)var13_17 /* !! */ , (String)"it.text");
            if (this.isCodeAfterCommentStart(var13_17 /* !! */ )) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            if (!v0) continue;
            destination$iv$iv.add(element$iv$iv /* !! */ );
        }
        comments = (List)destination$iv$iv;
        if (((Collection)comments).isEmpty() == false) {
            $i$f$filter /* !! */  = new List[1];
            $this$filterTo$iv$iv = new ASTNode[]{(ASTNode)CollectionsKt.first((List)comments)};
            $i$f$filter /* !! */ [0] = CollectionsKt.mutableListOf((Object[])$this$filterTo$iv$iv);
            result = CollectionsKt.mutableListOf((Object[])$i$f$filter /* !! */ );
            $i$f$filter /* !! */  = CollectionsKt.drop((Iterable)comments, (int)1);
            $i$f$fold = false;
            accumulator$iv = result;
            for (T element$iv : $this$fold$iv) {
                block11: {
                    element$iv$iv /* !! */  = (ASTNode)element$iv;
                    acc = accumulator$iv;
                    $i$a$-fold-CommentsRule$getOffsetsToTextBlocksFromEolComments$1 = false;
                    var13_17 /* !! */  = astNode.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)var13_17 /* !! */ , (String)"astNode.text");
                    var13_17 /* !! */  = var13_17 /* !! */ ;
                    isImportOrPackage = CommentsRule.importOrPackage.containsMatchIn((CharSequence)var13_17 /* !! */ );
                    $this$prevSibling$iv = astNode;
                    $i$f$prevSibling = false;
                    for (n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                        it = n$iv;
                        $i$a$-prevSibling-CommentsRule$getOffsetsToTextBlocksFromEolComments$1$previousNonWhiteSpaceNode$1 = false;
                        if (!(Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) == false)) continue;
                        v1 = n$iv;
                        break block11;
                    }
                    v1 = previousNonWhiteSpaceNode = null;
                }
                if (!isImportOrPackage && CollectionsKt.contains((Iterable)((Iterable)CollectionsKt.last((List)acc)), previousNonWhiteSpaceNode)) {
                    ((List)CollectionsKt.last((List)acc)).add(astNode);
                } else {
                    $this$prevSibling$iv = new ASTNode[]{astNode};
                    acc.add(CollectionsKt.mutableListOf((Object[])$this$prevSibling$iv));
                }
                accumulator$iv = acc;
            }
            $this$fold$iv = accumulator$iv;
            $i$f$map = false;
            accumulator$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                $i$a$-fold-CommentsRule$getOffsetsToTextBlocksFromEolComments$1 = (List)item$iv$iv;
                var21_29 = destination$iv$iv;
                $i$a$-map-CommentsRule$getOffsetsToTextBlocksFromEolComments$2 = false;
                $this$forEach$iv = (Iterable)list;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (ASTNode)element$iv;
                    $i$a$-forEach-CommentsRule$getOffsetsToTextBlocksFromEolComments$2$1 = false;
                    var20_28 = it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)var20_28, (String)"it.text");
                    errorNodesWithText.add((Pair<ASTNode, String>)TuplesKt.to((Object)it, (Object)StringsKt.removePrefix((String)var20_28, (CharSequence)"//")));
                }
                var21_29.add(TuplesKt.to((Object)((ASTNode)CollectionsKt.first((List)list)).getStartOffset(), (Object)CollectionsKt.joinToString$default((Iterable)((Iterable)list), (CharSequence)"\n", null, null, (int)0, null, (Function1)getOffsetsToTextBlocksFromEolComments.2.2.INSTANCE, (int)30, null)));
            }
            v2 = (List)destination$iv$iv;
        } else {
            v2 = CollectionsKt.emptyList();
        }
        return v2;
    }

    private final boolean isCodeAfterCommentStart(String text) {
        boolean bl;
        block3: {
            String textWithoutCommentStartToken = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)text, (CharSequence)"//"))).toString();
            Iterable $this$any$iv = codeFileStartCases;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    CharSequence charSequence = textWithoutCommentStartToken;
                    if (!it.containsMatchIn(charSequence)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isContainingRequiredPartOfCode(String text) {
        return StringsKt.contains((CharSequence)text, (CharSequence)"val ", (boolean)true) || StringsKt.contains((CharSequence)text, (CharSequence)"var ", (boolean)true) || StringsKt.contains((CharSequence)text, (CharSequence)"=", (boolean)true) || StringsKt.contains((CharSequence)text, (CharSequence)"{", (boolean)true) && StringsKt.contains((CharSequence)StringsKt.substringAfter$default((String)text, (String)"{", null, (int)2, null), (CharSequence)"}", (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPossibleImport(String $this$isPossibleImport) {
        if (!StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)$this$isPossibleImport)).toString(), (String)importKeywordWithSpace, (boolean)false, (int)2, null)) return false;
        String $this$isPossibleImport_u24lambda_u2d15 = StringsKt.substringAfter((String)$this$isPossibleImport, (String)importKeywordWithSpace, (String)"");
        boolean bl = false;
        if (StringsKt.startsWith$default((CharSequence)$this$isPossibleImport_u24lambda_u2d15, (char)'`', (boolean)false, (int)2, null)) {
            if (StringsKt.endsWith$default((CharSequence)$this$isPossibleImport_u24lambda_u2d15, (char)'`', (boolean)false, (int)2, null)) return true;
        }
        if (StringsKt.contains$default((CharSequence)$this$isPossibleImport_u24lambda_u2d15, (char)' ', (boolean)false, (int)2, null)) return false;
        return true;
    }

    static {
        Object[] objectArray = new Regex[]{classRegex, importOrPackageRegex, functionRegex, rightBraceRegex, valOrVarRegex};
        codeFileStartCases = CollectionsKt.listOf((Object[])objectArray);
        eolCommentStart = new Regex("// \\S");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter2/comments/CommentsRule$Companion;", "", "()V", "NAME_ID", "", "classRegex", "Lkotlin/text/Regex;", "codeFileStartCases", "", "eolCommentStart", "functionRegex", "importKeywordWithSpace", "importOrPackage", "importOrPackageRegex", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "packageKeywordWithSpace", "rightBraceRegex", "valOrVarRegex", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

