/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter2.comments;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstConstantsKt;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.FileUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001a\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\f\u0010\u0018\u001a\u00020\u000e*\u00020\u000eH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter2/comments/HeaderCommentRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkCopyright", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "checkHeaderKdoc", "checkHeaderKdocPosition", "", "handleMultilineCopyright", "", "copyrightText", "isCopyRightTextMatchesPattern", "copyrightNode", "copyrightPattern", "isHeaderCommentContainText", "headerComment", "text", "logic", "makeCopyrightCorrectYear", "flatten", "Companion", "CopyrightConfiguration", "diktat-rules"})
public final class HeaderCommentRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(HeaderCommentRule.class);
    @NotNull
    public static final String CURR_YEAR_PATTERN = ";@currYear;";
    @NotNull
    public static final String NAME_ID = "acp-header-comment";
    @NotNull
    private static final Regex hyphenRegex = new Regex("\\d+-\\d+");
    @NotNull
    private static final Regex afterCopyrightRegex = new Regex("((\u00a9|\\([cC]\\))+ *\\d+)");
    private static final int curYear = LocalDate.now().getYear();

    public HeaderCommentRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        Warnings[] warningsArray = new Warnings[]{Warnings.HEADER_MISSING_IN_NON_SINGLE_CLASS_FILE, Warnings.HEADER_MISSING_OR_WRONG_COPYRIGHT, Warnings.HEADER_NOT_BEFORE_PACKAGE, Warnings.HEADER_NOT_BEFORE_PACKAGE, Warnings.HEADER_WRONG_FORMAT, Warnings.WRONG_COPYRIGHT_YEAR};
        super(NAME_ID, configRules, CollectionsKt.listOf((Object[])warningsArray), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE()) && !FileUtilsKt.isGradleScript(AstNodeUtilsKt.getFilePath(node))) {
            this.checkCopyright(node);
            if (this.checkHeaderKdocPosition(node)) {
                this.checkHeaderKdoc(node);
            }
        }
    }

    private final void checkHeaderKdoc(ASTNode node) {
        block6: {
            Unit unit;
            Unit unit2;
            ASTNode aSTNode = AstNodeUtilsKt.findChildBefore(node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getKDOC());
            if (aSTNode == null) {
                unit2 = null;
            } else {
                ASTNode headerKdoc = aSTNode;
                boolean bl = false;
                if (headerKdoc.getTreeNext() != null && Intrinsics.areEqual((Object)headerKdoc.getTreeNext().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                    String string = headerKdoc.getTreeNext().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"headerKdoc.treeNext.text");
                    CharSequence $this$count$iv = string;
                    boolean $i$f$count = false;
                    int count$iv = 0;
                    CharSequence charSequence = $this$count$iv;
                    for (int i = 0; i < charSequence.length(); ++i) {
                        char element$iv = charSequence.charAt(i);
                        char it = element$iv;
                        boolean bl2 = false;
                        if (!(it == '\n')) continue;
                        ++count$iv;
                    }
                    if (count$iv != 2) {
                        Warnings.warnAndFix$default(Warnings.HEADER_WRONG_FORMAT, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "header KDoc should have a new line after", headerKdoc.getStartOffset(), headerKdoc, false, (Function0)new Function0<Unit>(node, headerKdoc){
                            final /* synthetic */ ASTNode $node;
                            final /* synthetic */ ASTNode $headerKdoc;
                            {
                                this.$node = $node;
                                this.$headerKdoc = $headerKdoc;
                                super(0);
                            }

                            public final void invoke() {
                                this.$node.replaceChild(this.$headerKdoc.getTreeNext(), (ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n\n"));
                            }
                        }, 64, null);
                    }
                }
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit != null) break block6;
            HeaderCommentRule $this$checkHeaderKdoc_u24lambda_u2d2 = this;
            boolean bl = false;
            int numDeclaredClassesAndObjects = AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getCLASS()).size() + AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getOBJECT_DECLARATION()).size();
            if (numDeclaredClassesAndObjects != 1) {
                Warnings.HEADER_MISSING_IN_NON_SINGLE_CLASS_FILE.warn($this$checkHeaderKdoc_u24lambda_u2d2.getConfigRules(), $this$checkHeaderKdoc_u24lambda_u2d2.getEmitWarn(), $this$checkHeaderKdoc_u24lambda_u2d2.isFixMode(), "there are " + numDeclaredClassesAndObjects + " declared classes and/or objects", node.getStartOffset(), node);
            }
        }
    }

    private final boolean checkHeaderKdocPosition(ASTNode node) {
        ASTNode firstKdoc = AstNodeUtilsKt.findChildAfter(node, ElementType.INSTANCE.getIMPORT_LIST(), ElementType.INSTANCE.getKDOC());
        if (AstNodeUtilsKt.findChildBefore(node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getKDOC()) == null && firstKdoc != null && Intrinsics.areEqual((Object)firstKdoc.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            Warnings.warnAndFix$default(Warnings.HEADER_NOT_BEFORE_PACKAGE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "header KDoc is located after package or imports", firstKdoc.getStartOffset(), firstKdoc, false, (Function0)new Function0<Unit>(node, firstKdoc){
                final /* synthetic */ ASTNode $node;
                final /* synthetic */ ASTNode $firstKdoc;
                {
                    this.$node = $node;
                    this.$firstKdoc = $firstKdoc;
                    super(0);
                }

                public final void invoke() {
                    AstNodeUtilsKt.moveChildBefore(this.$node, this.$firstKdoc, AstNodeUtilsKt.getFirstChildWithType(this.$node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE()), true);
                    ASTNode aSTNode = AstNodeUtilsKt.findChildBefore(this.$node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getBLOCK_COMMENT());
                    if (aSTNode != null) {
                        ASTNode aSTNode2 = aSTNode;
                        ASTNode aSTNode3 = this.$node;
                        ASTNode $this$invoke_u24lambda_u2d0 = aSTNode2;
                        boolean bl = false;
                        if (Intrinsics.areEqual((Object)$this$invoke_u24lambda_u2d0.getTreeNext().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                            aSTNode3.replaceChild($this$invoke_u24lambda_u2d0.getTreeNext(), (ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"));
                        } else {
                            aSTNode3.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), $this$invoke_u24lambda_u2d0.getTreeNext());
                        }
                    }
                }
            }, 64, null);
            if (!this.isFixMode()) {
                return false;
            }
        }
        return true;
    }

    private final String makeCopyrightCorrectYear(String copyrightText) {
        String string;
        List copyrightYears;
        List list;
        MatchResult afterCopyrightYear;
        String[] stringArray;
        MatchResult hyphenYear;
        MatchResult matchResult = hyphenYear = Regex.find$default((Regex)hyphenRegex, (CharSequence)copyrightText, (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult it = matchResult;
            boolean bl = false;
            stringArray = new String[]{"-"};
            List copyrightYears2 = StringsKt.split$default((CharSequence)hyphenYear.getValue(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (Integer.parseInt((String)copyrightYears2.get(1)) != curYear) {
                String validYears = (String)copyrightYears2.get(0) + '-' + curYear;
                CharSequence charSequence = copyrightText;
                return hyphenRegex.replace(charSequence, validYears);
            }
        }
        MatchResult matchResult2 = afterCopyrightYear = Regex.find$default((Regex)afterCopyrightRegex, (CharSequence)copyrightText, (int)0, (int)2, null);
        if (matchResult2 == null) {
            list = null;
        } else {
            String string2 = matchResult2.getValue();
            if (string2 == null) {
                list = null;
            } else {
                stringArray = new String[]{"(c)", "(C)", "\u00a9"};
                list = copyrightYears = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            }
        }
        if (copyrightYears != null && Integer.parseInt(((Object)StringsKt.trim((CharSequence)((String)copyrightYears.get(1)))).toString()) != curYear) {
            String validYears = (String)copyrightYears.get(0) + '-' + curYear;
            CharSequence charSequence = copyrightText;
            string = afterCopyrightRegex.replace(charSequence, validYears);
        } else {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCopyright(ASTNode node) {
        boolean isMissingCopyright;
        boolean isWrongCopyright;
        ASTNode headerComment;
        String copyrightWithCorrectYear;
        String copyrightText;
        block22: {
            String string;
            boolean isCopyrightInsideKdoc;
            block21: {
                block20: {
                    boolean bl;
                    void $this$any$iv;
                    RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.getConfigRules(), (Rule)Warnings.HEADER_MISSING_OR_WRONG_COPYRIGHT);
                    Map map = rulesConfig == null ? null : rulesConfig.getConfiguration();
                    CopyrightConfiguration configuration2 = new CopyrightConfiguration(map == null ? MapsKt.emptyMap() : map);
                    if (!configuration2.isCopyrightMandatory() && !configuration2.hasCopyrightText$diktat_rules()) {
                        return;
                    }
                    copyrightText = configuration2.getCopyrightText();
                    copyrightWithCorrectYear = this.makeCopyrightCorrectYear(copyrightText);
                    if (((CharSequence)copyrightWithCorrectYear).length() > 0) {
                        log.warn("Copyright year in your configuration file is not up to date.");
                    }
                    boolean isCopyrightMatchesPatternExceptFirstYear = this.isCopyRightTextMatchesPattern(headerComment = AstNodeUtilsKt.findChildBefore(node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getBLOCK_COMMENT()), copyrightText) || this.isCopyRightTextMatchesPattern(headerComment, copyrightWithCorrectYear);
                    isWrongCopyright = headerComment != null && !isCopyrightMatchesPatternExceptFirstYear && !this.isHeaderCommentContainText(headerComment, copyrightText) && !this.isHeaderCommentContainText(headerComment, copyrightWithCorrectYear);
                    isMissingCopyright = headerComment == null && configuration2.isCopyrightMandatory();
                    Iterable iterable = CollectionsKt.plus((Collection)AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getKDOC()), (Iterable)AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getEOL_COMMENT()));
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl2;
                            block19: {
                                ASTNode commentNode = (ASTNode)element$iv;
                                boolean bl3 = false;
                                Iterable $this$any$iv2 = AstConstantsKt.getCopyrightWords();
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv2) {
                                        String it = (String)element$iv2;
                                        boolean bl4 = false;
                                        String string2 = commentNode.getText();
                                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"commentNode.text");
                                        if (!StringsKt.contains((CharSequence)string2, (CharSequence)it, (boolean)true)) continue;
                                        bl2 = true;
                                        break block19;
                                    }
                                    bl2 = false;
                                }
                            }
                            if (!bl2) continue;
                            bl = true;
                            break block20;
                        }
                        bl = isCopyrightInsideKdoc = false;
                    }
                }
                if (isWrongCopyright || isMissingCopyright) break block21;
                if (!isCopyrightInsideKdoc) break block22;
            }
            if (isCopyrightInsideKdoc) {
                string = "copyright is placed inside KDoc, but should be inside a block comment";
            } else if (isWrongCopyright) {
                string = "copyright comment doesn't have correct copyright text";
            } else if (isMissingCopyright) {
                string = "copyright is mandatory, but is missing";
            } else {
                throw new IllegalStateException("Should never get to this point".toString());
            }
            String freeText = string;
            Warnings.warnAndFix$default(Warnings.HEADER_MISSING_OR_WRONG_COPYRIGHT, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), freeText, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(headerComment, node, this, copyrightWithCorrectYear, copyrightText){
                final /* synthetic */ ASTNode $headerComment;
                final /* synthetic */ ASTNode $node;
                final /* synthetic */ HeaderCommentRule this$0;
                final /* synthetic */ String $copyrightWithCorrectYear;
                final /* synthetic */ String $copyrightText;
                {
                    this.$headerComment = $headerComment;
                    this.$node = $node;
                    this.this$0 = $receiver;
                    this.$copyrightWithCorrectYear = $copyrightWithCorrectYear;
                    this.$copyrightText = $copyrightText;
                    super(0);
                }

                public final void invoke() {
                    Object object;
                    String string;
                    Object object2;
                    Object object3;
                    ASTNode aSTNode = this.$headerComment;
                    if (aSTNode != null) {
                        object3 = aSTNode;
                        object2 = this.$node;
                        ASTNode copyrightNode = object3;
                        boolean bl = false;
                        if (PackageKt.isWhiteSpace((ASTNode)copyrightNode.getTreeNext())) {
                            object2.removeChild(copyrightNode.getTreeNext());
                        }
                        object2.removeChild(copyrightNode);
                    }
                    ASTNode aSTNode2 = AstNodeUtilsKt.findChildBefore(this.$node, ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getKDOC());
                    if (aSTNode2 == null) {
                        string = "\n\n";
                    } else {
                        ASTNode it = aSTNode2;
                        boolean bl = false;
                        object2 = "\n";
                        string = object2;
                    }
                    String newLines = string;
                    this.$node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)newLines), this.$node.getFirstChildNode());
                    ASTNode aSTNode3 = this.$node;
                    IElementType iElementType = ElementType.INSTANCE.getBLOCK_COMMENT();
                    StringBuilder stringBuilder = new StringBuilder().append("\n                        |/*\n                        |");
                    HeaderCommentRule headerCommentRule = this.this$0;
                    object3 = this.$copyrightWithCorrectYear;
                    object2 = this.$copyrightText;
                    if (object3.length() == 0) {
                        HeaderCommentRule headerCommentRule2 = headerCommentRule;
                        StringBuilder stringBuilder2 = stringBuilder;
                        IElementType iElementType2 = iElementType;
                        ASTNode aSTNode4 = aSTNode3;
                        boolean bl = false;
                        Object object4 = object2;
                        aSTNode3 = aSTNode4;
                        iElementType = iElementType2;
                        stringBuilder = stringBuilder2;
                        headerCommentRule = headerCommentRule2;
                        object = object4;
                    } else {
                        object = object3;
                    }
                    CharSequence charSequence = StringsKt.trimMargin$default((String)stringBuilder.append(HeaderCommentRule.access$handleMultilineCopyright(headerCommentRule, (String)object)).append("\n                        |*/\n                    ").toString(), null, (int)1, null);
                    IElementType iElementType3 = iElementType;
                    aSTNode3.addChild((ASTNode)new LeafPsiElement(iElementType3, charSequence), this.$node.getFirstChildNode());
                }
            }, 64, null);
        }
        if (!isMissingCopyright && !isWrongCopyright && ((CharSequence)copyrightWithCorrectYear).length() > 0) {
            Warnings.warnAndFix$default(Warnings.WRONG_COPYRIGHT_YEAR, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), Intrinsics.stringPlus((String)"year should be ", (Object)curYear), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(headerComment, copyrightText, copyrightWithCorrectYear){
                final /* synthetic */ ASTNode $headerComment;
                final /* synthetic */ String $copyrightText;
                final /* synthetic */ String $copyrightWithCorrectYear;
                {
                    this.$headerComment = $headerComment;
                    this.$copyrightText = $copyrightText;
                    this.$copyrightWithCorrectYear = $copyrightWithCorrectYear;
                    super(0);
                }

                public final void invoke() {
                    ASTNode aSTNode = this.$headerComment;
                    if (aSTNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
                    }
                    LeafElement leafElement = (LeafElement)aSTNode;
                    String string = ((LeafElement)this.$headerComment).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"headerComment.text");
                    leafElement.rawReplaceWithText(StringsKt.replace$default((String)string, (String)this.$copyrightText, (String)this.$copyrightWithCorrectYear, (boolean)false, (int)4, null));
                }
            }, 64, null);
        }
    }

    private final boolean isHeaderCommentContainText(ASTNode headerComment, String text) {
        boolean bl;
        if (((CharSequence)text).length() > 0) {
            String string = headerComment.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"headerComment.text");
            bl = StringsKt.contains$default((CharSequence)this.flatten(string), (CharSequence)this.flatten(text), (boolean)false, (int)2, null);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isCopyRightTextMatchesPattern(ASTNode copyrightNode, String copyrightPattern) {
        String textWithoutDates;
        String string;
        String string2;
        ASTNode aSTNode = copyrightNode;
        if (aSTNode == null) {
            string2 = null;
        } else {
            String string3 = aSTNode.getText();
            if (string3 == null) {
                string2 = null;
            } else {
                String string4 = StringsKt.replace$default((String)string3, (String)"/*", (String)"", (boolean)false, (int)4, null);
                if (string4 == null) {
                    string2 = null;
                } else {
                    String string5 = StringsKt.replace$default((String)string4, (String)"*/", (String)"", (boolean)false, (int)4, null);
                    string2 = string5 == null ? null : StringsKt.replace$default((String)string5, (String)"*", (String)"", (boolean)false, (int)4, null);
                }
            }
        }
        String copyrightText = string2;
        MatchResult matchResult = Regex.find$default((Regex)hyphenRegex, (CharSequence)copyrightPattern, (int)0, (int)2, null);
        String datesInPattern = matchResult == null ? null : matchResult.getValue();
        String string6 = copyrightText;
        if (string6 == null) {
            string = null;
        } else {
            String it = string6;
            boolean bl = false;
            MatchResult matchResult2 = Regex.find$default((Regex)hyphenRegex, (CharSequence)it, (int)0, (int)2, null);
            string = matchResult2 == null ? null : matchResult2.getValue();
        }
        String datesInCode = string;
        if (datesInPattern == null || datesInCode == null) {
            return false;
        }
        String patternWithoutDates = this.flatten(StringsKt.replace$default((String)copyrightPattern, (String)datesInPattern, (String)"", (boolean)false, (int)4, null));
        return Intrinsics.areEqual((Object)patternWithoutDates, (Object)(textWithoutDates = this.flatten(StringsKt.replace$default((String)copyrightText, (String)datesInCode, (String)"", (boolean)false, (int)4, null)))) && Intrinsics.areEqual((Object)StringsKt.substringAfter$default((String)datesInCode, (String)"-", null, (int)2, null), (Object)String.valueOf(curYear));
    }

    private final String flatten(String $this$flatten) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)$this$flatten, (String)"\n", (String)"", (boolean)false, (int)4, null), (String)" ", (String)"", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String handleMultilineCopyright(String copyrightText) {
        if (StringsKt.startsWith$default((String)copyrightText, (String)" ", (boolean)false, (int)2, null)) {
            Iterable $this$dropWhile$iv = StringsKt.lines((CharSequence)copyrightText);
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                String it = (String)item$iv;
                boolean bl = false;
                if (StringsKt.isBlank((CharSequence)it)) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            Iterable $this$reduce$iv = list$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void nextLine;
                String string = (String)iterator$iv.next();
                String acc = (String)accumulator$iv;
                boolean bl = false;
                accumulator$iv = StringsKt.isBlank((CharSequence)((CharSequence)nextLine)) ? Intrinsics.stringPlus((String)acc, (Object)"\n") : acc + '\n' + (String)nextLine;
            }
            return (String)accumulator$iv;
        }
        return Intrinsics.stringPlus((String)"    ", (Object)copyrightText);
    }

    public static final /* synthetic */ String access$handleMultilineCopyright(HeaderCommentRule $this, String copyrightText) {
        return $this.handleMultilineCopyright(copyrightText);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0004J\r\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0006\u0010\n\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter2/comments/HeaderCommentRule$CopyrightConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "getCopyrightText", "hasCopyrightText", "", "hasCopyrightText$diktat_rules", "isCopyrightMandatory", "diktat-rules"})
    public static final class CopyrightConfiguration
    extends RuleConfiguration {
        public CopyrightConfiguration(@NotNull Map<String, String> config2) {
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
        }

        public final boolean isCopyrightMandatory() {
            boolean bl;
            String string = (String)this.getConfig().get("isCopyrightMandatory");
            return string == null ? false : (bl = Boolean.parseBoolean(string));
        }

        public final boolean hasCopyrightText$diktat_rules() {
            return this.getConfig().keySet().contains("copyrightText");
        }

        @NotNull
        public final String getCopyrightText() {
            String string;
            String string2 = (String)this.getConfig().get("copyrightText");
            String string3 = string = string2 == null ? null : StringsKt.replace$default((String)string2, (String)HeaderCommentRule.CURR_YEAR_PATTERN, (String)String.valueOf(Companion.getCurYear()), (boolean)false, (int)4, null);
            if (string == null) {
                throw new IllegalStateException("Copyright is not set in configuration".toString());
            }
            return string;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter2/comments/HeaderCommentRule$Companion;", "", "()V", "CURR_YEAR_PATTERN", "", "NAME_ID", "afterCopyrightRegex", "Lkotlin/text/Regex;", "getAfterCopyrightRegex", "()Lkotlin/text/Regex;", "curYear", "", "getCurYear", "()I", "hyphenRegex", "getHyphenRegex", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getHyphenRegex() {
            return hyphenRegex;
        }

        @NotNull
        public final Regex getAfterCopyrightRegex() {
            return afterCopyrightRegex;
        }

        public final int getCurYear() {
            return curYear;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

