/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter2.kdoc;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter2.kdoc.CommentsFormatting;
import org.cqfn.diktat.ruleset.utils.AstConstantsKt;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J2\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0002J\f\u0010\u001e\u001a\u00020\u0016*\u00020\tH\u0002\u00a8\u0006!"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter2/kdoc/CommentsFormatting;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "basicCommentsChecks", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter2/kdoc/CommentsFormatting$CommentsFormattingConfiguration;", "checkBlankLineAfterKdoc", "checkClassComment", "checkCommentsInCodeBlocks", "checkFirstCommentSpaces", "checkSpaceBeforeComment", "checkWhiteSpaceBeginInComment", "handleEolAndBlockComments", "handleIfElse", "handleKdocComments", "isFirstComment", "", "logic", "modifyKdocText", "moveCommentToElse", "elseBlock", "elseKeyWord", "comment", "copyComment", "isChildOfBlockOrClassBody", "CommentsFormattingConfiguration", "Companion", "diktat-rules"})
public final class CommentsFormatting
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int APPROPRIATE_COMMENT_SPACES = 1;
    private static final int MAX_SPACES = 1;
    @NotNull
    public static final String NAME_ID = "aaf-kdoc-comments-codeblocks-formatting";

    public CommentsFormatting(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        Warnings[] warningsArray = new Warnings[]{Warnings.COMMENT_WHITE_SPACE, Warnings.FIRST_COMMENT_NO_BLANK_LINE, Warnings.IF_ELSE_COMMENTS, Warnings.WRONG_NEWLINES_AROUND_KDOC};
        super(NAME_ID, configRules, CollectionsKt.listOf((Object[])warningsArray), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.getConfigRules(), (Rule)Warnings.COMMENT_WHITE_SPACE);
        Map map = rulesConfig == null ? null : rulesConfig.getConfiguration();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        CommentsFormattingConfiguration configuration2 = new CommentsFormattingConfiguration(map);
        IElementType iElementType = node.getElementType();
        if ((Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCLASS()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getFUN())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getPROPERTY())) {
            this.checkBlankLineAfterKdoc(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getIF())) {
            this.handleIfElse(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getEOL_COMMENT()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getBLOCK_COMMENT())) {
            this.handleEolAndBlockComments(node, configuration2);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getKDOC())) {
            this.handleKdocComments(node, configuration2);
        }
    }

    private final void checkBlankLineAfterKdoc(ASTNode node) {
        Iterable $this$forEach$iv = AstConstantsKt.getCommentType();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode nodeAfterKdoc;
            ASTNode kdoc;
            IElementType it = (IElementType)element$iv;
            boolean bl = false;
            ASTNode aSTNode = kdoc = AstNodeUtilsKt.getFirstChildWithType(node, it);
            ASTNode aSTNode2 = nodeAfterKdoc = aSTNode == null ? null : aSTNode.getTreeNext();
            if (!Intrinsics.areEqual((Object)(aSTNode2 == null ? null : aSTNode2.getElementType()), (Object)ElementType.INSTANCE.getWHITE_SPACE()) || AstNodeUtilsKt.numNewLines(nodeAfterKdoc) <= 1) continue;
            Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES_AROUND_KDOC, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), Intrinsics.stringPlus((String)"redundant blank line after ", (Object)kdoc.getText()), nodeAfterKdoc.getStartOffset(), nodeAfterKdoc, false, (Function0)new Function0<Unit>(nodeAfterKdoc){
                final /* synthetic */ ASTNode $nodeAfterKdoc;
                {
                    this.$nodeAfterKdoc = $nodeAfterKdoc;
                    super(0);
                }

                public final void invoke() {
                    AstNodeUtilsKt.leaveOnlyOneNewLine(this.$nodeAfterKdoc);
                }
            }, 64, null);
        }
    }

    private final void handleKdocComments(ASTNode node, CommentsFormattingConfiguration configuration2) {
        if (node.getTreeParent().getTreeParent() != null && Intrinsics.areEqual((Object)node.getTreeParent().getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getBLOCK())) {
            ASTNode aSTNode = node.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
            this.checkCommentsInCodeBlocks(aSTNode);
        } else if (!Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getIF())) {
            this.checkClassComment(node);
        }
        this.checkWhiteSpaceBeginInComment(node, configuration2);
    }

    private final void handleEolAndBlockComments(ASTNode node, CommentsFormattingConfiguration configuration2) {
        this.basicCommentsChecks(node, configuration2);
        this.checkWhiteSpaceBeginInComment(node, configuration2);
    }

    private final void basicCommentsChecks(ASTNode node, CommentsFormattingConfiguration configuration2) {
        this.checkSpaceBeforeComment(node, configuration2);
        if (Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getBLOCK()) && node.getTreeNext() != null) {
            if (this.isFirstComment(node)) {
                if (this.isChildOfBlockOrClassBody(node)) {
                    this.checkFirstCommentSpaces(node);
                }
                return;
            }
        } else if (!Intrinsics.areEqual((Object)node.getTreeParent().getLastChildNode(), (Object)node) && !Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getIF()) && Intrinsics.areEqual((Object)node.getTreeParent().getFirstChildNode(), (Object)node) && !Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT_LIST())) {
            this.checkClassComment(node);
        }
    }

    private final void handleIfElse(ASTNode node) {
        if (AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getELSE())) {
            ASTNode comment;
            ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getELSE_KEYWORD());
            Intrinsics.checkNotNull((Object)aSTNode);
            ASTNode elseKeyWord = aSTNode;
            ASTNode aSTNode2 = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getELSE());
            Intrinsics.checkNotNull((Object)aSTNode2);
            ASTNode elseBlock = aSTNode2;
            ASTNode aSTNode3 = comment = AstNodeUtilsKt.prevNodeUntilNode(elseKeyWord, ElementType.INSTANCE.getTHEN(), ElementType.INSTANCE.getEOL_COMMENT()) != null ? AstNodeUtilsKt.prevNodeUntilNode(elseKeyWord, ElementType.INSTANCE.getTHEN(), ElementType.INSTANCE.getEOL_COMMENT()) : (AstNodeUtilsKt.prevNodeUntilNode(elseKeyWord, ElementType.INSTANCE.getTHEN(), ElementType.INSTANCE.getBLOCK_COMMENT()) != null ? AstNodeUtilsKt.prevNodeUntilNode(elseKeyWord, ElementType.INSTANCE.getTHEN(), ElementType.INSTANCE.getBLOCK_COMMENT()) : (AstNodeUtilsKt.prevNodeUntilNode(elseKeyWord, ElementType.INSTANCE.getTHEN(), ElementType.INSTANCE.getKDOC()) != null ? AstNodeUtilsKt.prevNodeUntilNode(elseKeyWord, ElementType.INSTANCE.getTHEN(), ElementType.INSTANCE.getKDOC()) : null));
            ASTNode copyComment = aSTNode3 == null ? null : aSTNode3.copyElement();
            ASTNode aSTNode4 = comment;
            if (aSTNode4 != null) {
                ASTNode it = aSTNode4;
                boolean bl = false;
                List<RulesConfig> list = this.getConfigRules();
                Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                boolean bl2 = this.isFixMode();
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                Warnings.warnAndFix$default(Warnings.IF_ELSE_COMMENTS, list, function3, bl2, string, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, node, elseBlock, elseKeyWord, it, copyComment){
                    final /* synthetic */ CommentsFormatting this$0;
                    final /* synthetic */ ASTNode $node;
                    final /* synthetic */ ASTNode $elseBlock;
                    final /* synthetic */ ASTNode $elseKeyWord;
                    final /* synthetic */ ASTNode $it;
                    final /* synthetic */ ASTNode $copyComment;
                    {
                        this.this$0 = $receiver;
                        this.$node = $node;
                        this.$elseBlock = $elseBlock;
                        this.$elseKeyWord = $elseKeyWord;
                        this.$it = $it;
                        this.$copyComment = $copyComment;
                        super(0);
                    }

                    public final void invoke() {
                        CommentsFormatting.access$moveCommentToElse(this.this$0, this.$node, this.$elseBlock, this.$elseKeyWord, this.$it, this.$copyComment);
                    }
                }, 64, null);
            }
        }
    }

    private final void moveCommentToElse(ASTNode node, ASTNode elseBlock, ASTNode elseKeyWord, ASTNode comment, ASTNode copyComment) {
        ASTNode whiteSpace;
        if (AstNodeUtilsKt.hasChildOfType(elseBlock, ElementType.INSTANCE.getBLOCK())) {
            ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(elseBlock, ElementType.INSTANCE.getBLOCK());
            Intrinsics.checkNotNull((Object)aSTNode);
            ASTNode elseCodeBlock = aSTNode;
            ASTNode aSTNode2 = copyComment;
            Intrinsics.checkNotNull((Object)aSTNode2);
            elseCodeBlock.addChild(aSTNode2, elseCodeBlock.getFirstChildNode().getTreeNext());
            elseCodeBlock.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), elseCodeBlock.getFirstChildNode().getTreeNext());
            node.removeChild(comment);
        } else {
            ASTNode aSTNode = elseKeyWord.getTreeParent();
            ASTNode aSTNode3 = copyComment;
            Intrinsics.checkNotNull((Object)aSTNode3);
            aSTNode.addChild(aSTNode3, elseKeyWord.getTreeNext());
            elseKeyWord.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), elseKeyWord.getTreeNext());
            node.removeChild(comment);
        }
        ASTNode aSTNode = whiteSpace = AstNodeUtilsKt.prevNodeUntilNode(elseKeyWord, ElementType.INSTANCE.getTHEN(), ElementType.INSTANCE.getWHITE_SPACE());
        if (aSTNode != null) {
            ASTNode it = aSTNode;
            boolean bl = false;
            node.removeChild(it);
        }
    }

    private final void checkCommentsInCodeBlocks(ASTNode node) {
        block6: {
            Object object;
            block7: {
                block5: {
                    if (this.isFirstComment(node)) {
                        if (this.isChildOfBlockOrClassBody(node)) {
                            this.checkFirstCommentSpaces(node);
                        }
                        return;
                    }
                    if (PackageKt.isWhiteSpace((ASTNode)node.getTreePrev())) break block5;
                    List<RulesConfig> list = this.getConfigRules();
                    Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                    boolean bl = this.isFixMode();
                    String string = node.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
                    Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES_AROUND_KDOC, list, function3, bl, string, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                        final /* synthetic */ ASTNode $node;
                        {
                            this.$node = $node;
                            super(0);
                        }

                        public final void invoke() {
                            this.$node.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), this.$node.getTreeParent());
                        }
                    }, 64, null);
                    break block6;
                }
                object = node.getTreePrev();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.treePrev");
                if (AstNodeUtilsKt.numNewLines(object) == 1) break block7;
                object = node.getTreePrev();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.treePrev");
                if (AstNodeUtilsKt.numNewLines(object) <= 2) break block6;
            }
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            object = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.text");
            Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES_AROUND_KDOC, list, function3, bl, (String)object, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                final /* synthetic */ ASTNode $node;
                {
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    ASTNode aSTNode = this.$node.getTreePrev();
                    if (aSTNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    ((LeafPsiElement)aSTNode).rawReplaceWithText("\n\n");
                }
            }, 64, null);
        }
    }

    private final void checkSpaceBeforeComment(ASTNode node, CommentsFormattingConfiguration configuration2) {
        if (Intrinsics.areEqual((Object)node.getTreeParent().getFirstChildNode(), (Object)node)) {
            return;
        }
        if (Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            if (!PackageKt.isWhiteSpaceWithNewline((ASTNode)node.getTreePrev())) {
                char it;
                char element$iv;
                int n;
                String string = node.getTreePrev().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.treePrev.text");
                CharSequence $this$count$iv = string;
                boolean $i$f$count = false;
                int count$iv = 0;
                CharSequence charSequence = $this$count$iv;
                for (n = 0; n < charSequence.length(); ++n) {
                    element$iv = charSequence.charAt(n);
                    it = element$iv;
                    boolean bl = false;
                    if (!(it == ' ')) continue;
                    ++count$iv;
                }
                if (count$iv > 0) {
                    List<RulesConfig> list = this.getConfigRules();
                    Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                    boolean bl = this.isFixMode();
                    StringBuilder stringBuilder = new StringBuilder().append("There should be 0 space(s) before comment text, but are ");
                    $this$count$iv = node.getTreePrev().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)$this$count$iv, (String)"node.treePrev.text");
                    StringBuilder stringBuilder2 = stringBuilder;
                    boolean bl2 = bl;
                    Function3<Integer, String, Boolean, Unit> function32 = function3;
                    List<RulesConfig> list2 = list;
                    Warnings warnings = Warnings.COMMENT_WHITE_SPACE;
                    $i$f$count = false;
                    count$iv = 0;
                    charSequence = $this$count$iv;
                    for (n = 0; n < charSequence.length(); ++n) {
                        element$iv = charSequence.charAt(n);
                        it = element$iv;
                        boolean bl3 = false;
                        if (!(it == ' ')) continue;
                        ++count$iv;
                    }
                    int n2 = count$iv;
                    Warnings.warnAndFix$default(warnings, list2, function32, bl2, stringBuilder2.append(n2).append(" in ").append(node.getText()).toString(), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                        final /* synthetic */ ASTNode $node;
                        {
                            this.$node = $node;
                            super(0);
                        }

                        public final void invoke() {
                            if (Intrinsics.areEqual((Object)this.$node.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                                ASTNode aSTNode = this.$node.getTreePrev();
                                if (aSTNode == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                                }
                                ((LeafPsiElement)aSTNode).rawReplaceWithText("\n");
                            } else {
                                this.$node.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), this.$node);
                            }
                        }
                    }, 64, null);
                }
            }
        } else if (!PackageKt.isWhiteSpace((ASTNode)node.getTreePrev())) {
            Warnings.warnAndFix$default(Warnings.COMMENT_WHITE_SPACE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "There should be " + configuration2.getMaxSpacesBeforeComment() + " space(s) before comment text, but are none in " + node.getText(), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node, configuration2){
                final /* synthetic */ ASTNode $node;
                final /* synthetic */ CommentsFormattingConfiguration $configuration;
                {
                    this.$node = $node;
                    this.$configuration = $configuration;
                    super(0);
                }

                public final void invoke() {
                    this.$node.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)StringsKt.repeat((CharSequence)" ", (int)this.$configuration.getMaxSpacesBeforeComment())), this.$node);
                }
            }, 64, null);
        } else if (!node.getTreePrev().textContains('\n') && node.getTreePrev().getText().length() != configuration2.getMaxSpacesBeforeComment()) {
            Warnings.warnAndFix$default(Warnings.COMMENT_WHITE_SPACE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "There should be " + configuration2.getMaxSpacesBeforeComment() + " space(s) before comment text, but there are too many in " + node.getText(), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node, configuration2){
                final /* synthetic */ ASTNode $node;
                final /* synthetic */ CommentsFormattingConfiguration $configuration;
                {
                    this.$node = $node;
                    this.$configuration = $configuration;
                    super(0);
                }

                public final void invoke() {
                    ASTNode aSTNode = this.$node.getTreePrev();
                    if (aSTNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    ((LeafPsiElement)aSTNode).rawReplaceWithText(StringsKt.repeat((CharSequence)" ", (int)this.$configuration.getMaxSpacesBeforeComment()));
                }
            }, 64, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkWhiteSpaceBeginInComment(ASTNode node, CommentsFormattingConfiguration configuration2) {
        String string;
        block25: {
            block26: {
                Object object;
                block22: {
                    Object object2;
                    int index$iv;
                    int n;
                    int n2;
                    boolean $i$f$takeWhile;
                    Object $this$takeWhile$iv;
                    block21: {
                        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getEOL_COMMENT())) {
                            Object object3;
                            block20: {
                                Object object4 = node.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"node\n                    .text");
                                String string2 = object4;
                                object4 = new char[1];
                                object4[0] = 47;
                                $this$takeWhile$iv = StringsKt.trimStart((String)string2, (char[])object4);
                                $i$f$takeWhile = false;
                                n2 = 0;
                                n = ((String)$this$takeWhile$iv).length();
                                while (n2 < n) {
                                    index$iv = n2++;
                                    char it22 = ((String)$this$takeWhile$iv).charAt(index$iv);
                                    int n3 = 0;
                                    if (it22 == ' ') continue;
                                    Object it22 = $this$takeWhile$iv;
                                    n3 = 0;
                                    string = ((String)it22).substring(n3, index$iv);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                    object3 = string;
                                    break block20;
                                }
                                object3 = $this$takeWhile$iv;
                            }
                            if (((String)object3).length() == configuration2.getMaxSpacesInComment()) {
                                return;
                            }
                        }
                        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT())) break block25;
                        $this$takeWhile$iv = node.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)$this$takeWhile$iv, (String)"node\n                    .text");
                        String string3 = $this$takeWhile$iv;
                        $this$takeWhile$iv = new char[2];
                        $this$takeWhile$iv[0] = 47;
                        $this$takeWhile$iv[1] = 42;
                        $this$takeWhile$iv = StringsKt.trim((String)string3, (char[])$this$takeWhile$iv);
                        $i$f$takeWhile = false;
                        n2 = 0;
                        n = ((String)$this$takeWhile$iv).length();
                        while (n2 < n) {
                            index$iv = n2++;
                            char it32 = ((String)$this$takeWhile$iv).charAt(index$iv);
                            int n4 = 0;
                            if (it32 == ' ') continue;
                            Object it32 = $this$takeWhile$iv;
                            n4 = 0;
                            string = ((String)it32).substring(n4, index$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            object2 = string;
                            break block21;
                        }
                        object2 = $this$takeWhile$iv;
                    }
                    if (((String)object2).length() == configuration2.getMaxSpacesInComment()) break block26;
                    $this$takeWhile$iv = node.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)$this$takeWhile$iv, (String)"node\n                            .text");
                    Object object5 = $this$takeWhile$iv;
                    $this$takeWhile$iv = new char[2];
                    $this$takeWhile$iv[0] = 47;
                    $this$takeWhile$iv[1] = 42;
                    $this$takeWhile$iv = StringsKt.trim((String)object5, (char[])$this$takeWhile$iv);
                    $i$f$takeWhile = false;
                    n2 = 0;
                    n = ((String)$this$takeWhile$iv).length();
                    while (n2 < n) {
                        index$iv = n2++;
                        char it42 = ((String)$this$takeWhile$iv).charAt(index$iv);
                        int n5 = 0;
                        if (it42 == '\n') continue;
                        Object it42 = $this$takeWhile$iv;
                        n5 = 0;
                        string = ((String)it42).substring(n5, index$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        object = string;
                        break block22;
                    }
                    object = $this$takeWhile$iv;
                }
                if (!(((CharSequence)object).length() > 0)) break block25;
            }
            return;
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getKDOC())) {
            boolean $i$f$all;
            ASTNode section = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getKDOC_SECTION());
            if (section != null) {
                boolean bl;
                block23: {
                    void $this$all$iv;
                    Iterable $i$f$takeWhile = AstNodeUtilsKt.findChildrenMatching(section, ElementType.INSTANCE.getKDOC_TEXT(), (Function1<? super ASTNode, Boolean>)((Function1)checkWhiteSpaceBeginInComment.4.INSTANCE));
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            ASTNode it = (ASTNode)element$iv;
                            boolean bl2 = false;
                            string = it.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                            if (StringsKt.startsWith$default((String)string, (String)StringsKt.repeat((CharSequence)" ", (int)configuration2.getMaxSpacesInComment()), (boolean)false, (int)2, null)) continue;
                            bl = false;
                            break block23;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return;
                }
            }
            if (section != null && !((Collection)AstNodeUtilsKt.getAllChildrenWithType(section, ElementType.INSTANCE.getKDOC_CODE_BLOCK_TEXT())).isEmpty()) {
                boolean bl;
                block24: {
                    Iterable $this$all$iv = AstNodeUtilsKt.getAllChildrenWithType(section, ElementType.INSTANCE.getKDOC_CODE_BLOCK_TEXT());
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            ASTNode it = (ASTNode)element$iv;
                            boolean bl3 = false;
                            string = it.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                            if (StringsKt.startsWith$default((String)string, (String)StringsKt.repeat((CharSequence)" ", (int)configuration2.getMaxSpacesInComment()), (boolean)false, (int)2, null)) continue;
                            bl = false;
                            break block24;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return;
                }
            }
        }
        Warnings.warnAndFix$default(Warnings.COMMENT_WHITE_SPACE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "There should be " + configuration2.getMaxSpacesInComment() + " space(s) before comment token in " + node.getText(), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node, this, configuration2){
            final /* synthetic */ ASTNode $node;
            final /* synthetic */ CommentsFormatting this$0;
            final /* synthetic */ CommentsFormattingConfiguration $configuration;
            {
                this.$node = $node;
                this.this$0 = $receiver;
                this.$configuration = $configuration;
                super(0);
            }

            public final void invoke() {
                String string = this.$node.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
                String commentText = ((Object)StringsKt.trim((CharSequence)StringsKt.drop((String)string, (int)2))).toString();
                string = this.$node.getElementType();
                if (Intrinsics.areEqual((Object)string, (Object)ElementType.INSTANCE.getEOL_COMMENT())) {
                    ((LeafPsiElement)this.$node).rawReplaceWithText(Intrinsics.stringPlus((String)"// ", (Object)commentText));
                } else if (Intrinsics.areEqual((Object)string, (Object)ElementType.INSTANCE.getBLOCK_COMMENT())) {
                    ((LeafPsiElement)this.$node).rawReplaceWithText(Intrinsics.stringPlus((String)"/* ", (Object)commentText));
                } else if (Intrinsics.areEqual((Object)string, (Object)ElementType.INSTANCE.getKDOC())) {
                    ASTNode it;
                    Iterable $this$forEach$iv;
                    Iterable iterable = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(this.$node, ElementType.INSTANCE.getKDOC_TEXT(), false, 2, null);
                    CommentsFormatting commentsFormatting = this.this$0;
                    CommentsFormattingConfiguration commentsFormattingConfiguration = this.$configuration;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (ASTNode)element$iv;
                        boolean bl = false;
                        CommentsFormatting.access$modifyKdocText(commentsFormatting, it, commentsFormattingConfiguration);
                    }
                    $this$forEach$iv = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(this.$node, ElementType.INSTANCE.getKDOC_CODE_BLOCK_TEXT(), false, 2, null);
                    commentsFormatting = this.this$0;
                    commentsFormattingConfiguration = this.$configuration;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (ASTNode)element$iv;
                        boolean bl = false;
                        CommentsFormatting.access$modifyKdocText(commentsFormatting, it, commentsFormattingConfiguration);
                    }
                }
            }
        }, 64, null);
    }

    private final void modifyKdocText(ASTNode node, CommentsFormattingConfiguration configuration2) {
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
        if (!StringsKt.startsWith$default((String)string, (String)StringsKt.repeat((CharSequence)" ", (int)configuration2.getMaxSpacesInComment()), (boolean)false, (int)2, null)) {
            String string2 = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.text");
            String commentText = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            String indent = StringsKt.repeat((CharSequence)" ", (int)configuration2.getMaxSpacesInComment());
            ((LeafPsiElement)node).rawReplaceWithText(Intrinsics.stringPlus((String)indent, (Object)commentText));
        }
    }

    private final void checkClassComment(ASTNode node) {
        block6: {
            Object object;
            block8: {
                block7: {
                    block5: {
                        if (!this.isFirstComment(node)) break block5;
                        if (this.isChildOfBlockOrClassBody(node)) {
                            this.checkFirstCommentSpaces(node);
                        } else {
                            ASTNode aSTNode = node.getTreeParent();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
                            this.checkFirstCommentSpaces(aSTNode);
                        }
                        break block6;
                    }
                    if (Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFILE()) || PackageKt.isWhiteSpace((ASTNode)node.getTreeParent().getTreePrev())) break block7;
                    List<RulesConfig> list = this.getConfigRules();
                    Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                    boolean bl = this.isFixMode();
                    String string = node.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
                    Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES_AROUND_KDOC, list, function3, bl, string, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                        final /* synthetic */ ASTNode $node;
                        {
                            this.$node = $node;
                            super(0);
                        }

                        public final void invoke() {
                            this.$node.getTreeParent().getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), this.$node.getTreeParent());
                        }
                    }, 64, null);
                    break block6;
                }
                if (Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFILE())) break block6;
                object = node.getTreeParent().getTreePrev();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.treeParent.treePrev");
                if (AstNodeUtilsKt.numNewLines(object) == 1) break block8;
                object = node.getTreeParent().getTreePrev();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.treeParent.treePrev");
                if (AstNodeUtilsKt.numNewLines(object) <= 2) break block6;
            }
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            object = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.text");
            Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES_AROUND_KDOC, list, function3, bl, (String)object, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                final /* synthetic */ ASTNode $node;
                {
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    ASTNode aSTNode = this.$node.getTreeParent().getTreePrev();
                    if (aSTNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    ((LeafPsiElement)aSTNode).rawReplaceWithText("\n\n");
                }
            }, 64, null);
        }
    }

    private final void checkFirstCommentSpaces(ASTNode node) {
        block2: {
            Object object;
            block3: {
                if (!PackageKt.isWhiteSpace((ASTNode)node.getTreePrev())) break block2;
                object = node.getTreePrev();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.treePrev");
                if (AstNodeUtilsKt.numNewLines(object) > 1) break block3;
                object = node.getTreePrev();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.treePrev");
                if (AstNodeUtilsKt.numNewLines(object) != 0) break block2;
            }
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            object = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.text");
            Warnings.warnAndFix$default(Warnings.FIRST_COMMENT_NO_BLANK_LINE, list, function3, bl, (String)object, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                final /* synthetic */ ASTNode $node;
                {
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    ASTNode aSTNode = this.$node.getTreePrev();
                    if (aSTNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    ((LeafPsiElement)aSTNode).rawReplaceWithText("\n");
                }
            }, 64, null);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFirstComment(ASTNode node) {
        ASTNode aSTNode;
        Object object;
        boolean bl;
        if (this.isChildOfBlockOrClassBody(node)) {
            if (PackageKt.isWhiteSpace((ASTNode)node.getTreePrev())) {
                Object object2;
                ASTNode aSTNode2 = node.getTreePrev();
                if (aSTNode2 == null) {
                    object2 = null;
                } else {
                    ASTNode aSTNode3 = aSTNode2.getTreePrev();
                    object2 = aSTNode3 == null ? null : aSTNode3.getElementType();
                }
                bl = Intrinsics.areEqual((Object)object2, (Object)ElementType.INSTANCE.getLBRACE());
                return bl;
            }
            if (node.getTreePrev() == null) return true;
            if (!Intrinsics.areEqual((Object)node.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getLBRACE())) return false;
            return true;
        }
        ASTNode aSTNode4 = node.getTreeParent();
        if (aSTNode4 == null) {
            object = null;
        } else {
            ASTNode aSTNode5 = aSTNode4.getTreeParent();
            object = aSTNode5 == null ? null : aSTNode5.getElementType();
        }
        if (Intrinsics.areEqual((Object)object, (Object)ElementType.INSTANCE.getFILE())) {
            ASTNode n$iv;
            block12: {
                void $this$prevSibling$iv;
                aSTNode = node.getTreeParent();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
                boolean $i$f$prevSibling = false;
                n$iv = $this$prevSibling$iv.getTreePrev();
                while (n$iv != null) {
                    ASTNode it = n$iv;
                    boolean bl2 = false;
                    String string = it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                    if (!(!StringsKt.isBlank((CharSequence)string))) {
                        n$iv = n$iv.getTreePrev();
                        continue;
                    }
                    break block12;
                }
                return true;
            }
            ASTNode aSTNode6 = n$iv;
            if (aSTNode6 == null) {
                return true;
            }
        }
        if (!Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFILE()) && node.getTreeParent().getTreePrev() != null && node.getTreeParent().getTreePrev().getTreePrev() != null) {
            bl = Intrinsics.areEqual((Object)node.getTreeParent().getTreePrev().getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getLBRACE());
            return bl;
        } else {
            aSTNode = node.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
            ASTNode aSTNode7 = aSTNode;
            aSTNode = node.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.elementType");
            bl = Intrinsics.areEqual((Object)CollectionsKt.first(AstNodeUtilsKt.getAllChildrenWithType(aSTNode7, (IElementType)aSTNode)), (Object)node);
        }
        return bl;
    }

    private final boolean isChildOfBlockOrClassBody(ASTNode $this$isChildOfBlockOrClassBody) {
        return Intrinsics.areEqual((Object)$this$isChildOfBlockOrClassBody.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getBLOCK()) || Intrinsics.areEqual((Object)$this$isChildOfBlockOrClassBody.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getCLASS_BODY());
    }

    public static final /* synthetic */ void access$modifyKdocText(CommentsFormatting $this, ASTNode node, CommentsFormattingConfiguration configuration2) {
        $this.modifyKdocText(node, configuration2);
    }

    public static final /* synthetic */ void access$moveCommentToElse(CommentsFormatting $this, ASTNode node, ASTNode elseBlock, ASTNode elseKeyWord, ASTNode comment, ASTNode copyComment) {
        $this.moveCommentToElse(node, elseBlock, elseKeyWord, comment, copyComment);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter2/kdoc/CommentsFormatting$CommentsFormattingConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "maxSpacesBeforeComment", "", "getMaxSpacesBeforeComment", "()I", "maxSpacesInComment", "getMaxSpacesInComment", "diktat-rules"})
    public static final class CommentsFormattingConfiguration
    extends RuleConfiguration {
        private final int maxSpacesBeforeComment;
        private final int maxSpacesInComment;

        public CommentsFormattingConfiguration(@NotNull Map<String, String> config2) {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            String string = config2.get("maxSpacesBeforeComment");
            if (string == null) {
                n2 = 1;
            } else {
                Integer n3 = StringsKt.toIntOrNull((String)string);
                n2 = n3 == null ? 1 : n3;
            }
            this.maxSpacesBeforeComment = n2;
            String string2 = config2.get("maxSpacesInComment");
            if (string2 == null) {
                n = 1;
            } else {
                Integer n4 = StringsKt.toIntOrNull((String)string2);
                n = n4 == null ? 1 : n4;
            }
            this.maxSpacesInComment = n;
        }

        public final int getMaxSpacesBeforeComment() {
            return this.maxSpacesBeforeComment;
        }

        public final int getMaxSpacesInComment() {
            return this.maxSpacesInComment;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter2/kdoc/CommentsFormatting$Companion;", "", "()V", "APPROPRIATE_COMMENT_SPACES", "", "MAX_SPACES", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

