/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter2.kdoc;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter2.kdoc.KdocFormatting;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.KdocUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocTag;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0002,-B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0012\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003H\u0002J\u0016\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003H\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0018H\u0002J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u0014H\u0002J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J-\u0010\"\u001a\u00020\u000e*\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000e0&\u00a2\u0006\u0002\b'H\u0002J\f\u0010(\u001a\u00020\u001e*\u00020\u0010H\u0002J\f\u0010)\u001a\u00020\u001e*\u00020\u0014H\u0002J\u0012\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003*\u00020\u0010H\u0002J\u000e\u0010+\u001a\u0004\u0018\u00010\u0010*\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter2/kdoc/KdocFormatting;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "basicTagsList", "Lorg/jetbrains/kotlin/kdoc/parser/KDocKnownTag;", "specialTagNames", "", "", "versionRegex", "Lkotlin/text/Regex;", "checkAuthorAndDate", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "checkBasicTagsOrder", "checkEmptyLineBeforeBasicTags", "basicTags", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocTag;", "checkEmptyLinesBetweenBasicTags", "checkEmptyTags", "kdocTags", "", "checkNewLineAfterSpecialTags", "checkNoDeprecatedTag", "checkSpaceAfterTag", "findBeforeAndAfterSpaces", "Lkotlin/Pair;", "", "tag", "isKdocNotEmpty", "logic", "applyToPrevSibling", "elementType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "consumer", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "hasEmptyLineAfter", "hasInvalidVersion", "kDocBasicTags", "previousAsterisk", "Companion", "KdocFormatConfiguration", "diktat-rules"})
public final class KdocFormatting
extends DiktatRule {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<KDocKnownTag> basicTagsList;
    @NotNull
    private final Set<String> specialTagNames;
    @Nullable
    private Regex versionRegex;
    @NotNull
    public static final String NAME_ID = "aae-kdoc-formatting";
    @NotNull
    private static final List<DateTimeFormatter> dateFormats;

    public KdocFormatting(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        Object[] objectArray = new Warnings[]{Warnings.KDOC_CONTAINS_DATE_OR_AUTHOR, Warnings.KDOC_EMPTY_KDOC, Warnings.KDOC_NEWLINES_BEFORE_BASIC_TAGS, Warnings.KDOC_NO_DEPRECATED_TAG, Warnings.KDOC_NO_EMPTY_TAGS, Warnings.KDOC_NO_NEWLINES_BETWEEN_BASIC_TAGS, Warnings.KDOC_NO_NEWLINE_AFTER_SPECIAL_TAGS, Warnings.KDOC_WRONG_SPACES_AFTER_TAG, Warnings.KDOC_WRONG_TAGS_ORDER};
        super(NAME_ID, configRules, CollectionsKt.listOf((Object[])objectArray), null, 8, null);
        objectArray = new KDocKnownTag[]{KDocKnownTag.PARAM, KDocKnownTag.RETURN, KDocKnownTag.THROWS};
        this.basicTagsList = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"implSpec", "implNote", "apiNote"};
        this.specialTagNames = SetsKt.setOf((Object[])objectArray);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Regex regex = this.versionRegex;
        if (regex == null) {
            KdocFormatting $this$logic_u24lambda_u2d0 = this;
            boolean bl = false;
            RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig($this$logic_u24lambda_u2d0.getConfigRules(), (Rule)Warnings.KDOC_CONTAINS_DATE_OR_AUTHOR);
            Map map = rulesConfig == null ? null : rulesConfig.getConfiguration();
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            $this$logic_u24lambda_u2d0.versionRegex = new KdocFormatConfiguration(map).getVersionRegex();
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getKDOC()) && this.isKdocNotEmpty(node)) {
            this.checkNoDeprecatedTag(node);
            this.checkEmptyTags((Collection<? extends KDocTag>)KdocUtilsKt.kDocTags(node));
            this.checkSpaceAfterTag((Collection<? extends KDocTag>)KdocUtilsKt.kDocTags(node));
            this.checkEmptyLineBeforeBasicTags(this.kDocBasicTags(node));
            this.checkEmptyLinesBetweenBasicTags(this.kDocBasicTags(node));
            this.checkBasicTagsOrder(node);
            this.checkNewLineAfterSpecialTags(node);
            this.checkAuthorAndDate(node);
        }
    }

    private final boolean isKdocNotEmpty(ASTNode node) {
        boolean bl;
        boolean isKdocNotEmpty2;
        Object object = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getKDOC_SECTION());
        boolean bl2 = isKdocNotEmpty2 = object == null ? false : (bl = AstNodeUtilsKt.hasChildMatching$default(object, null, isKdocNotEmpty.isKdocNotEmpty.1.INSTANCE, 1, null));
        if (!isKdocNotEmpty2) {
            Warnings warnings = Warnings.KDOC_EMPTY_KDOC;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl3 = this.isFixMode();
            ASTNode aSTNode = node.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
            ASTNode aSTNode2 = AstNodeUtilsKt.getIdentifierName(aSTNode);
            String string = aSTNode2 == null ? null : aSTNode2.getText();
            if (string == null) {
                ASTNode aSTNode3;
                Warnings warnings2;
                List<RulesConfig> list2;
                Function3<Integer, String, Boolean, Unit> function32;
                boolean bl4;
                block3: {
                    ASTNode aSTNode4 = node;
                    bl4 = bl3;
                    function32 = function3;
                    list2 = list;
                    warnings2 = warnings;
                    boolean $i$f$nextSibling = false;
                    for (ASTNode n$iv = $this$nextSibling$iv.getTreeNext(); n$iv != null; n$iv = n$iv.getTreeNext()) {
                        ASTNode it = n$iv;
                        boolean bl5 = false;
                        if (!KtTokens.KEYWORDS.contains(it.getElementType())) continue;
                        aSTNode3 = n$iv;
                        break block3;
                    }
                    aSTNode3 = null;
                }
                ASTNode aSTNode5 = aSTNode3;
                warnings = warnings2;
                list = list2;
                function3 = function32;
                bl3 = bl4;
                ASTNode aSTNode6 = aSTNode5;
                String string2 = aSTNode6 == null ? null : aSTNode6.getText();
                string = string2 == null ? node.getText() : string2;
            }
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.treeParent.getIdent\u2026             ?: node.text");
            warnings.warn(list, function3, bl3, (String)object, node.getStartOffset(), node);
        }
        return isKdocNotEmpty2;
    }

    private final void checkNoDeprecatedTag(ASTNode node) {
        Object v0;
        block2: {
            List<KDocTag> kdocTags = KdocUtilsKt.kDocTags(node);
            for (Object object : (Iterable)kdocTags) {
                KDocTag it = (KDocTag)object;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"deprecated")) continue;
                v0 = object;
                break block2;
            }
            v0 = null;
        }
        KDocTag kDocTag = v0;
        if (kDocTag != null) {
            Object object;
            KDocTag kdocTag = kDocTag;
            boolean bl = false;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl2 = this.isFixMode();
            object = kdocTag.getText();
            Intrinsics.checkNotNullExpressionValue(object, (String)"kdocTag.text");
            Object object2 = object;
            int n = kdocTag.getNode().getStartOffset();
            object = kdocTag.getNode();
            Intrinsics.checkNotNullExpressionValue(object, (String)"kdocTag.node");
            Warnings.warnAndFix$default(Warnings.KDOC_NO_DEPRECATED_TAG, list, function3, bl2, object2, n, object, false, (Function0)new Function0<Unit>(kdocTag, node){
                final /* synthetic */ KDocTag $kdocTag;
                final /* synthetic */ ASTNode $node;
                {
                    this.$kdocTag = $kdocTag;
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    ASTNode aSTNode;
                    ASTNode aSTNode2;
                    block5: {
                        ASTNode aSTNode3;
                        boolean $i$f$nextSibling;
                        ASTNode aSTNode4;
                        ASTNode it;
                        ASTNode n$iv;
                        block4: {
                            ASTNode aSTNode5;
                            ASTNode deprecatedTagNode;
                            block3: {
                                ASTNode kdocSection = this.$kdocTag.getNode().getTreeParent();
                                ASTNode aSTNode6 = this.$kdocTag.getNode();
                                Intrinsics.checkNotNullExpressionValue((Object)aSTNode6, (String)"kdocTag.node");
                                aSTNode6 = deprecatedTagNode = aSTNode6;
                                aSTNode2 = kdocSection;
                                boolean $i$f$prevSibling = false;
                                for (n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                                    it = n$iv;
                                    boolean bl = false;
                                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) continue;
                                    aSTNode5 = n$iv;
                                    break block3;
                                }
                                aSTNode5 = null;
                            }
                            Intrinsics.checkNotNull(aSTNode5);
                            ASTNode $this$prevSibling$iv = deprecatedTagNode;
                            aSTNode4 = aSTNode5;
                            $i$f$nextSibling = false;
                            for (n$iv = $this$nextSibling$iv.getTreeNext(); n$iv != null; n$iv = n$iv.getTreeNext()) {
                                it = n$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) continue;
                                aSTNode3 = n$iv;
                                break block4;
                            }
                            aSTNode3 = null;
                        }
                        ASTNode aSTNode7 = aSTNode3;
                        aSTNode2.removeRange(aSTNode4, aSTNode7);
                        this.$node.getTreeParent().addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getANNOTATION(), (CharSequence)("@Deprecated(message = \"" + this.$kdocTag.getContent() + "\")")), this.$node.getTreeNext());
                        ASTNode $this$nextSibling$iv = this.$node;
                        aSTNode2 = this.$node.getTreeParent();
                        $i$f$nextSibling = false;
                        for (n$iv = $this$nextSibling$iv.getTreeNext(); n$iv != null; n$iv = n$iv.getTreeNext()) {
                            it = n$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) continue;
                            aSTNode = n$iv;
                            break block5;
                        }
                        aSTNode = null;
                    }
                    Intrinsics.checkNotNull(aSTNode);
                    aSTNode2.addChild((ASTNode)((PsiWhiteSpaceImpl)aSTNode.clone()), this.$node.getTreeNext());
                }
            }, 64, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEmptyTags(Collection<? extends KDocTag> kdocTags) {
        Collection<? extends KDocTag> collection = kdocTags;
        if (collection != null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KDocTag it = (KDocTag)element$iv$iv;
                boolean bl = false;
                boolean bl2 = it.getSubjectName() == null && ((CharSequence)it.getContent()).length() == 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            $this$filter$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KDocTag it = (KDocTag)element$iv;
                boolean bl = false;
                List<RulesConfig> list2 = this.getConfigRules();
                Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                boolean bl3 = this.isFixMode();
                String string = it.getName();
                Intrinsics.checkNotNull((Object)string);
                String string2 = Intrinsics.stringPlus((String)"@", (Object)string);
                int n = it.getNode().getStartOffset();
                ASTNode aSTNode = it.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.node");
                Warnings.KDOC_NO_EMPTY_TAGS.warn(list2, function3, bl3, string2, n, aSTNode);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSpaceAfterTag(Collection<? extends KDocTag> kdocTags) {
        Collection<? extends KDocTag> collection = kdocTags;
        if (collection != null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                boolean bl2;
                boolean hasSubject;
                KDocTag tag = (KDocTag)element$iv$iv;
                boolean bl3 = false;
                Pair<Boolean, Boolean> pair = tag.getSubjectName();
                boolean bl4 = pair == null ? false : (hasSubject = (bl2 = !StringsKt.isBlank((CharSequence)((CharSequence)pair))));
                if (!hasSubject && StringsKt.isBlank((CharSequence)tag.getContent())) {
                    bl = false;
                } else {
                    pair = this.findBeforeAndAfterSpaces(tag);
                    boolean isSpaceBeforeContentError = (Boolean)pair.component1();
                    boolean isSpaceAfterTagError = (Boolean)pair.component2();
                    bl = hasSubject && isSpaceBeforeContentError || isSpaceAfterTagError;
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            $this$filter$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KDocTag tag = (KDocTag)element$iv;
                boolean bl = false;
                List<RulesConfig> list2 = this.getConfigRules();
                Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                boolean bl5 = this.isFixMode();
                String string = tag.getName();
                Intrinsics.checkNotNull((Object)string);
                String string2 = Intrinsics.stringPlus((String)"@", (Object)string);
                int n = tag.getNode().getStartOffset();
                ASTNode aSTNode = tag.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"tag.node");
                Warnings.warnAndFix$default(Warnings.KDOC_WRONG_SPACES_AFTER_TAG, list2, function3, bl5, string2, n, aSTNode, false, (Function0)new Function0<Unit>(tag){
                    final /* synthetic */ KDocTag $tag;
                    {
                        this.$tag = $tag;
                        super(0);
                    }

                    public final void invoke() {
                        ASTNode it;
                        KDocTag kDocTag;
                        ASTNode aSTNode = this.$tag.getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"tag.node");
                        ASTNode aSTNode2 = AstNodeUtilsKt.findChildBefore(aSTNode, ElementType.INSTANCE.getKDOC_TEXT(), ElementType.INSTANCE.getWHITE_SPACE());
                        if (aSTNode2 != null) {
                            aSTNode = aSTNode2;
                            kDocTag = this.$tag;
                            it = aSTNode;
                            boolean bl = false;
                            kDocTag.getNode().replaceChild(it, (ASTNode)new LeafPsiElement(ElementType.INSTANCE.getWHITE_SPACE(), (CharSequence)" "));
                        }
                        aSTNode = this.$tag.getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"tag.node");
                        aSTNode2 = AstNodeUtilsKt.findChildAfter(aSTNode, ElementType.INSTANCE.getKDOC_TAG_NAME(), ElementType.INSTANCE.getWHITE_SPACE());
                        if (aSTNode2 != null) {
                            aSTNode = aSTNode2;
                            kDocTag = this.$tag;
                            it = aSTNode;
                            boolean bl = false;
                            kDocTag.getNode().replaceChild(it, (ASTNode)new LeafPsiElement(ElementType.INSTANCE.getWHITE_SPACE(), (CharSequence)" "));
                        }
                    }
                }, 64, null);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Pair<Boolean, Boolean> findBeforeAndAfterSpaces(KDocTag tag) {
        var2_2 = tag.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)var2_2, (String)"tag.node");
        it = AstNodeUtilsKt.findChildBefore(var2_2, ElementType.INSTANCE.getKDOC_TEXT(), ElementType.INSTANCE.getWHITE_SPACE());
        $i$a$-let-KdocFormatting$findBeforeAndAfterSpaces$1 = false;
        v0 = it;
        if (Intrinsics.areEqual((Object)(v0 == null ? null : v0.getText()), (Object)" ")) ** GOTO lbl-1000
        v1 = it;
        if (!(v1 == null ? false : (var5_5 = PackageKt.isWhiteSpaceWithNewline((ASTNode)v1)))) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        v3 = v2;
        var2_2 = tag.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)var2_2, (String)"tag.node");
        it = AstNodeUtilsKt.findChildAfter(var2_2, ElementType.INSTANCE.getKDOC_TAG_NAME(), ElementType.INSTANCE.getWHITE_SPACE());
        var6_6 = v3;
        $i$a$-let-KdocFormatting$findBeforeAndAfterSpaces$2 = false;
        v4 = it;
        if (Intrinsics.areEqual((Object)(v4 == null ? null : v4.getText()), (Object)" ")) ** GOTO lbl-1000
        v5 = it;
        if (!(v5 == null ? false : (var5_5 = PackageKt.isWhiteSpaceWithNewline((ASTNode)v5)))) {
            v6 = true;
        } else lbl-1000:
        // 2 sources

        {
            v6 = false;
        }
        var7_7 = v6;
        var8_8 = var6_6;
        return new Pair((Object)var8_8, (Object)var7_7);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBasicTagsOrder(ASTNode node) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$fold$iv;
        void initial$iv;
        List $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        List<KDocTag> kdocTags = KdocUtilsKt.kDocTags(node);
        Iterable $this$filter$iv = this.basicTagsList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable<Object> destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Object v0;
            block9: {
                KDocKnownTag basicTag = (KDocKnownTag)element$iv$iv;
                boolean bl = false;
                for (Object t : (Iterable)kdocTags) {
                    KDocTag it = (KDocTag)t;
                    boolean bl2 = false;
                    if (!(it.getKnownTag() == basicTag)) continue;
                    v0 = t;
                    break block9;
                }
                v0 = null;
            }
            boolean bl = v0 != null;
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List basicTagsOrdered = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = kdocTags;
        boolean $i$f$filter22 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KDocTag it = (KDocTag)element$iv$iv;
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)basicTagsOrdered, (Object)it.getKnownTag())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List basicTags = (List)destination$iv$iv2;
        Iterable $i$f$filter22 = basicTags;
        $this$filterTo$iv$iv = new ArrayList();
        boolean $i$f$fold22 = false;
        void accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void kdocTag;
            KDocTag it = (KDocTag)element$iv;
            void acc = accumulator$iv;
            boolean bl = false;
            if (acc.size() > 0 && ((KDocTag)CollectionsKt.last((List)acc)).getKnownTag() != kdocTag.getKnownTag()) {
                acc.add(kdocTag);
            } else if (acc.size() == 0) {
                acc.add(kdocTag);
            }
            accumulator$iv = acc;
        }
        $this$fold$iv = (Iterable)accumulator$iv;
        boolean $i$f$map = false;
        void $i$f$fold22 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KDocTag acc = (KDocTag)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(it.getKnownTag());
        }
        boolean isTagsInCorrectOrder = Intrinsics.areEqual((Object)((List)destination$iv$iv3), (Object)basicTagsOrdered);
        if (!isTagsInCorrectOrder) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            String string = CollectionsKt.joinToString$default((Iterable)basicTags, (CharSequence)", ", null, null, (int)0, null, (Function1)checkBasicTagsOrder.1.INSTANCE, (int)30, null);
            int n = ((KDocTag)CollectionsKt.first((List)basicTags)).getNode().getStartOffset();
            ASTNode aSTNode = ((KDocTag)CollectionsKt.first((List)basicTags)).getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"basicTags.first().node");
            Warnings.warnAndFix$default(Warnings.KDOC_WRONG_TAGS_ORDER, list, function3, bl, string, n, aSTNode, false, (Function0)new Function0<Unit>(node, kdocTags, (List<? extends KDocTag>)basicTags, (List<? extends KDocKnownTag>)basicTagsOrdered){
                final /* synthetic */ ASTNode $node;
                final /* synthetic */ List<KDocTag> $kdocTags;
                final /* synthetic */ List<KDocTag> $basicTags;
                final /* synthetic */ List<KDocKnownTag> $basicTagsOrdered;
                {
                    this.$node = $node;
                    this.$kdocTags = $kdocTags;
                    this.$basicTags = $basicTags;
                    this.$basicTagsOrdered = $basicTagsOrdered;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$mapIndexedTo$iv$iv;
                    Iterable $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable $this$sortedBy$iv;
                    Collection collection;
                    List<KDocKnownTag> $this$mapTo$iv$iv2;
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(this.$node, ElementType.INSTANCE.getKDOC_SECTION());
                    Intrinsics.checkNotNull((Object)aSTNode);
                    ASTNode kdocSection = aSTNode;
                    Iterable iterable = this.$kdocTags;
                    List<KDocKnownTag> list = this.$basicTagsOrdered;
                    boolean $i$f$filter232 = false;
                    void var6_9 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        KDocTag it = (KDocTag)element$iv$iv;
                        boolean bl = false;
                        if (!CollectionsKt.contains((Iterable)list, (Object)it.getKnownTag())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$map$iv2 = (List)destination$iv$iv;
                    boolean $i$f$map232 = false;
                    Iterable $i$f$filter232 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T t : $this$mapTo$iv$iv2) {
                        void it;
                        Object element$iv$iv;
                        element$iv$iv = (KDocTag)t;
                        collection = destination$iv$iv2;
                        boolean bl = false;
                        collection.add(it.getNode());
                    }
                    List basicTagChildren = (List)destination$iv$iv2;
                    Iterable $i$f$map232 = this.$basicTags;
                    $this$mapTo$iv$iv2 = this.$basicTagsOrdered;
                    boolean $i$f$sortedBy232 = false;
                    $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator($this$mapTo$iv$iv2){
                        final /* synthetic */ List $basicTagsOrdered$inlined;
                        {
                            this.$basicTagsOrdered$inlined = list;
                        }

                        public final int compare(T a, T b) {
                            KDocTag it = (KDocTag)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(CollectionsKt.indexOf((List)this.$basicTagsOrdered$inlined, (Object)it.getKnownTag()));
                            it = (KDocTag)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(CollectionsKt.indexOf((List)this.$basicTagsOrdered$inlined, (Object)it.getKnownTag())));
                        }
                    });
                    boolean $i$f$map = false;
                    void $i$f$sortedBy232 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        KDocTag bl = (KDocTag)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(it.getNode());
                    }
                    List correctKdocOrder = (List)destination$iv$iv;
                    Iterable $this$mapIndexed$iv = basicTagChildren;
                    boolean $i$f$mapIndexed = false;
                    $this$mapTo$iv$iv = $this$mapIndexed$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                    boolean $i$f$mapIndexedTo = false;
                    boolean bl = false;
                    for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                        void astNode;
                        void index;
                        void var9_23;
                        void var12_29 = var9_23;
                        var9_23 = var12_29 + true;
                        if (var12_29 < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        ASTNode aSTNode2 = (ASTNode)item$iv$iv;
                        void var14_33 = var12_29;
                        collection = destination$iv$iv;
                        boolean bl2 = false;
                        kdocSection.addChild((ASTNode)((CompositeElement)((ASTNode)correctKdocOrder.get((int)index)).clone()), (ASTNode)astNode);
                        kdocSection.removeChild((ASTNode)astNode);
                        collection.add(Unit.INSTANCE);
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv;
                }
            }, 64, null);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkEmptyLineBeforeBasicTags(List<? extends KDocTag> basicTags) {
        block9: {
            block8: {
                block10: {
                    v0 = (KDocTag)CollectionsKt.firstOrNull(basicTags);
                    if (v0 == null) {
                        return;
                    }
                    firstBasicTag = v0;
                    var4_3 /* !! */  = firstBasicTag.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)var4_3 /* !! */ , (String)"firstBasicTag\n            .node");
                    it = AstNodeUtilsKt.allSiblings(var4_3 /* !! */ , true);
                    $i$a$-let-KdocFormatting$checkEmptyLineBeforeBasicTags$hasContentBefore$1 = false;
                    var4_3 /* !! */  = it.subList(0, it.indexOf(firstBasicTag.getNode()));
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block10;
                    v1 = false;
                    break block8;
                }
                for (T element$iv : $this$any$iv) {
                    it = (ASTNode)element$iv;
                    $i$a$-any-KdocFormatting$checkEmptyLineBeforeBasicTags$hasContentBefore$2 = false;
                    var10_15 /* !! */  = new IElementType[]{ElementType.INSTANCE.getWHITE_SPACE(), ElementType.INSTANCE.getKDOC_LEADING_ASTERISK()};
                    v2 = var10_15 /* !! */ ;
                    var10_15 /* !! */  = it.getElementType();
                    Intrinsics.checkNotNullExpressionValue((Object)var10_15 /* !! */ , (String)"it.elementType");
                    if (ArraysKt.contains((Object[])v2, (Object)var10_15 /* !! */ )) ** GOTO lbl-1000
                    var10_15 /* !! */  = it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)var10_15 /* !! */ , (String)"it.text");
                    if (StringsKt.isBlank((CharSequence)((CharSequence)var10_15 /* !! */ )) == false) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = false;
                    }
                    if (!v3) continue;
                    v1 = true;
                    break block8;
                }
                v1 = false;
            }
            hasContentBefore = v1;
            $i$f$any = firstBasicTag.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$any, (String)"firstBasicTag.node");
            $this$prevSibling$iv = $i$f$any;
            $i$f$prevSibling = false;
            for (n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                it = n$iv;
                $i$a$-prevSibling-KdocFormatting$checkEmptyLineBeforeBasicTags$previousTag$1 = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getKDOC_TAG())) continue;
                v4 = n$iv;
                break block9;
            }
            v4 = null;
        }
        v5 = previousTag = v4;
        v6 = var6_10 = v5 == null ? null : Boolean.valueOf(this.hasEmptyLineAfter(v5));
        if (var6_10 == null) {
            var8_12 = firstBasicTag.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)var8_12, (String)"firstBasicTag\n                .node");
            var7_11 = this.previousAsterisk(var8_12);
            v7 = Intrinsics.areEqual(var7_11 == null ? null : ((var8_12 = this.previousAsterisk(var7_11)) == null ? null : ((var9_14 = var8_12.getTreeNext()) == null ? null : var9_14.getElementType())), (Object)ElementType.INSTANCE.getWHITE_SPACE());
        } else {
            v7 = hasEmptyLineBefore = var6_10.booleanValue();
        }
        if (hasContentBefore ^ hasEmptyLineBefore) {
            v8 = this.getConfigRules();
            v9 = this.getEmitWarn();
            v10 = this.isFixMode();
            v11 = firstBasicTag.getName();
            Intrinsics.checkNotNull((Object)v11);
            v12 = Intrinsics.stringPlus((String)"@", (Object)v11);
            v13 = firstBasicTag.getNode().getStartOffset();
            var6_10 = firstBasicTag.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)var6_10, (String)"firstBasicTag.node");
            Warnings.warnAndFix$default(Warnings.KDOC_NEWLINES_BEFORE_BASIC_TAGS, v8, v9, v10, v12, v13, (ASTNode)var6_10, false, (Function0)new Function0<Unit>(hasContentBefore, previousTag, this, firstBasicTag){
                final /* synthetic */ boolean $hasContentBefore;
                final /* synthetic */ ASTNode $previousTag;
                final /* synthetic */ KdocFormatting this$0;
                final /* synthetic */ KDocTag $firstBasicTag;
                {
                    this.$hasContentBefore = $hasContentBefore;
                    this.$previousTag = $previousTag;
                    this.this$0 = $receiver;
                    this.$firstBasicTag = $firstBasicTag;
                    super(0);
                }

                public final void invoke() {
                    if (this.$hasContentBefore) {
                        Unit unit;
                        Unit unit2;
                        ASTNode aSTNode = this.$previousTag;
                        if (aSTNode == null) {
                            unit2 = null;
                        } else {
                            KdocFormatting.access$applyToPrevSibling(this.this$0, aSTNode, ElementType.INSTANCE.getKDOC_LEADING_ASTERISK(), (Function1)new Function1<ASTNode, Unit>(this.$previousTag){
                                final /* synthetic */ ASTNode $previousTag;
                                {
                                    this.$previousTag = $previousTag;
                                    super(1);
                                }

                                public final void invoke(@NotNull ASTNode $this$applyToPrevSibling) {
                                    Intrinsics.checkNotNullParameter((Object)$this$applyToPrevSibling, (String)"$this$applyToPrevSibling");
                                    this.$previousTag.addChild((ASTNode)$this$applyToPrevSibling.getTreePrev().clone(), null);
                                    this.$previousTag.addChild((ASTNode)$this$applyToPrevSibling.clone(), null);
                                }
                            });
                            unit2 = unit = Unit.INSTANCE;
                        }
                        if (unit == null) {
                            aSTNode = this.$firstBasicTag.getNode();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"firstBasicTag.node");
                            KdocFormatting.access$applyToPrevSibling(this.this$0, aSTNode, ElementType.INSTANCE.getKDOC_LEADING_ASTERISK(), checkEmptyLineBeforeBasicTags.2.INSTANCE);
                        }
                    } else {
                        ASTNode aSTNode = this.$firstBasicTag.getNode();
                        KdocFormatting kdocFormatting = this.this$0;
                        ASTNode $this$invoke_u24lambda_u2d0 = aSTNode;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)$this$invoke_u24lambda_u2d0, (String)"");
                        ASTNode aSTNode2 = KdocFormatting.access$previousAsterisk(kdocFormatting, $this$invoke_u24lambda_u2d0);
                        Intrinsics.checkNotNull((Object)aSTNode2);
                        ASTNode asteriskNode = aSTNode2;
                        $this$invoke_u24lambda_u2d0.getTreeParent().removeChild(asteriskNode.getTreePrev());
                        $this$invoke_u24lambda_u2d0.getTreeParent().removeChild(asteriskNode.getTreePrev());
                    }
                }
            }, 64, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkEmptyLinesBetweenBasicTags(List<? extends KDocTag> basicTags) {
        $this$filter$iv = CollectionsKt.dropLast(basicTags, (int)1);
        $i$f$filter = false;
        var5_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block10: {
                tag = (KDocTag)element$iv$iv;
                $i$a$-filter-KdocFormatting$checkEmptyLinesBetweenBasicTags$tagsWithRedundantEmptyLines$1 = false;
                var12_13 = tag.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)var12_13, (String)"tag.node");
                $this$nextSibling$iv = var12_13;
                $i$f$nextSibling = false;
                for (n$iv = $this$nextSibling$iv.getTreeNext(); n$iv != null; n$iv = n$iv.getTreeNext()) {
                    it = n$iv;
                    $i$a$-nextSibling-KdocFormatting$checkEmptyLinesBetweenBasicTags$tagsWithRedundantEmptyLines$1$nextWhiteSpace$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) continue;
                    v0 = n$iv;
                    break block10;
                }
                v0 = nextWhiteSpace = null;
            }
            if (KdocUtilsKt.hasTrailingNewlineInTagBody(tag)) ** GOTO lbl-1000
            v1 = nextWhiteSpace;
            if (v1 == null) {
                v2 = false;
            } else {
                v3 = v1.getText();
                if (v3 == null) {
                    v2 = false;
                } else {
                    $this$count$iv = v3;
                    $i$f$count = false;
                    count$iv = 0;
                    var18_20 = $this$count$iv;
                    for (var19_21 = 0; var19_21 < var18_20.length(); ++var19_21) {
                        element$iv = var18_20.charAt(var19_21);
                        it = element$iv;
                        $i$a$-count-KdocFormatting$checkEmptyLinesBetweenBasicTags$tagsWithRedundantEmptyLines$1$1 = false;
                        if (!(it == '\n')) continue;
                        ++count$iv;
                    }
                    v2 = count$iv == 1;
                }
            }
            if (!v2) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = false;
            }
            if (!v4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        tagsWithRedundantEmptyLines = (List)destination$iv$iv;
        $this$forEach$iv = tagsWithRedundantEmptyLines;
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            tag = (KDocTag)element$iv;
            $i$a$-forEach-KdocFormatting$checkEmptyLinesBetweenBasicTags$1 = false;
            v5 = this.getConfigRules();
            v6 = this.getEmitWarn();
            v7 = this.isFixMode();
            v8 = Intrinsics.stringPlus((String)"@", (Object)tag.getName());
            v9 = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)tag));
            var9_10 = tag.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)var9_10, (String)"tag.node");
            Warnings.warnAndFix$default(Warnings.KDOC_NO_NEWLINES_BETWEEN_BASIC_TAGS, v5, v6, v7, v8, v9, var9_10, false, (Function0)new Function0<Unit>(tag){
                final /* synthetic */ KDocTag $tag;
                {
                    this.$tag = $tag;
                    super(0);
                }

                public final void invoke() {
                    if (KdocUtilsKt.hasTrailingNewlineInTagBody(this.$tag)) {
                        Object v0;
                        Sequence $this$firstOrNull$iv;
                        block6: {
                            ASTNode aSTNode = this.$tag.getNode();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"tag.node");
                            $this$firstOrNull$iv = SequencesKt.takeWhile(AstNodeUtilsKt.reversedChildren(aSTNode), (Function1)checkEmptyLinesBetweenBasicTags.1.1.INSTANCE);
                            boolean $i$f$firstOrNull = false;
                            for (E element$iv : $this$firstOrNull$iv) {
                                ASTNode it = (ASTNode)element$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getKDOC_LEADING_ASTERISK())) continue;
                                v0 = element$iv;
                                break block6;
                            }
                            v0 = null;
                        }
                        ASTNode aSTNode = v0;
                        if (aSTNode != null) {
                            $this$firstOrNull$iv = aSTNode;
                            KDocTag $i$f$firstOrNull = this.$tag;
                            Sequence it = $this$firstOrNull$iv;
                            boolean bl = false;
                            $i$f$firstOrNull.getNode().removeRange(it.getTreePrev(), null);
                        }
                    } else {
                        ASTNode aSTNode;
                        block7: {
                            ASTNode $this$firstOrNull$iv = this.$tag.getNode();
                            Intrinsics.checkNotNullExpressionValue((Object)$this$firstOrNull$iv, (String)"tag.node");
                            boolean $i$f$nextSibling = false;
                            for (ASTNode n$iv = $this$nextSibling$iv.getTreeNext(); n$iv != null; n$iv = n$iv.getTreeNext()) {
                                ASTNode it = n$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) continue;
                                aSTNode = n$iv;
                                break block7;
                            }
                            aSTNode = null;
                        }
                        if (aSTNode != null) {
                            AstNodeUtilsKt.leaveOnlyOneNewLine(aSTNode);
                        }
                    }
                }
            }, 64, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkNewLineAfterSpecialTags(ASTNode node) {
        block12: {
            block11: {
                var3_2 = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getKDOC_SECTION());
                if (var3_2 == null) {
                    v0 = null;
                } else {
                    var4_3 = AstNodeUtilsKt.getAllChildrenWithType(var3_2, ElementType.INSTANCE.getKDOC_TAG());
                    if (var4_3 == null) {
                        v0 = null;
                    } else {
                        var5_4 = var4_3;
                        $i$f$filter = false;
                        var7_6 = $this$filter$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (ASTNode)element$iv$iv;
                            $i$a$-filter-KdocFormatting$checkNewLineAfterSpecialTags$presentSpecialTagNodes$1 = false;
                            v1 = it.getPsi();
                            if (v1 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.kdoc.psi.impl.KDocTag");
                            }
                            if (!CollectionsKt.contains((Iterable)this.specialTagNames, (Object)((KDocTag)v1).getName())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        v0 = (List)destination$iv$iv;
                    }
                }
                v2 = presentSpecialTagNodes = v0;
                if (v2 != null) break block11;
                v3 = null;
                break block12;
            }
            $this$filterNot$iv = v2;
            $i$f$filterNot = false;
            $this$filterTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterNotTo = false;
            for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                block13: {
                    specialTagNode = (ASTNode)element$iv$iv;
                    $i$a$-filterNot-KdocFormatting$checkNewLineAfterSpecialTags$poorlyFormattedTagNodes$1 = false;
                    if (!Intrinsics.areEqual((Object)specialTagNode.getLastChildNode().getElementType(), (Object)ElementType.INSTANCE.getKDOC_LEADING_ASTERISK())) ** GOTO lbl-1000
                    if (specialTagNode.getTreeNext() == null) break block13;
                    if (!Intrinsics.areEqual((Object)specialTagNode.getTreeNext().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) ** GOTO lbl-1000
                    var14_14 = specialTagNode.getTreeNext().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)var14_14, (String)"specialTagNode.treeNext.text");
                    $this$count$iv = var14_14;
                    $i$f$count = false;
                    count$iv = 0;
                    var17_17 = $this$count$iv;
                    for (var18_18 = 0; var18_18 < var17_17.length(); ++var18_18) {
                        element$iv = var17_17.charAt(var18_18);
                        it = element$iv;
                        $i$a$-count-KdocFormatting$checkNewLineAfterSpecialTags$poorlyFormattedTagNodes$1$1 = false;
                        if (!(it == '\n')) continue;
                        ++count$iv;
                    }
                    if (count$iv != true) ** GOTO lbl-1000
                }
                if (Intrinsics.areEqual((Object)specialTagNode.getLastChildNode().getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && !Intrinsics.areEqual((Object)specialTagNode.getLastChildNode().getTreePrev().getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getKDOC_LEADING_ASTERISK())) {
                    v4 = true;
                } else lbl-1000:
                // 4 sources

                {
                    v4 = false;
                }
                if (v4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            v3 = (List)destination$iv$iv;
        }
        poorlyFormattedTagNodes = v3;
        if (poorlyFormattedTagNodes != null && ((Collection)poorlyFormattedTagNodes).isEmpty() == false) {
            Warnings.warnAndFix$default(Warnings.KDOC_NO_NEWLINE_AFTER_SPECIAL_TAGS, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), CollectionsKt.joinToString$default((Iterable)poorlyFormattedTagNodes, (CharSequence)", ", null, null, (int)0, null, (Function1)checkNewLineAfterSpecialTags.1.INSTANCE, (int)30, null), ((ASTNode)CollectionsKt.first((List)poorlyFormattedTagNodes)).getStartOffset(), node, false, (Function0)new Function0<Unit>((List<? extends ASTNode>)poorlyFormattedTagNodes){
                final /* synthetic */ List<ASTNode> $poorlyFormattedTagNodes;
                {
                    this.$poorlyFormattedTagNodes = $poorlyFormattedTagNodes;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    Iterable $this$forEach$iv = this.$poorlyFormattedTagNodes;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        int n;
                        ASTNode aSTNode;
                        Object it;
                        Object object;
                        ASTNode node;
                        block10: {
                            ASTNode aSTNode2;
                            node = (ASTNode)element$iv;
                            boolean bl = false;
                            while (Intrinsics.areEqual((Object)node.getLastChildNode().getElementType(), (Object)ElementType.INSTANCE.getKDOC_LEADING_ASTERISK()) && Intrinsics.areEqual((Object)node.getLastChildNode().getTreePrev().getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getKDOC_LEADING_ASTERISK())) {
                                node.removeChild(node.getLastChildNode());
                                node.removeChild(node.getLastChildNode());
                            }
                            if (Intrinsics.areEqual((Object)node.getTreeParent().getLastChildNode(), (Object)node) || Intrinsics.areEqual((Object)node.getLastChildNode().getElementType(), (Object)ElementType.INSTANCE.getKDOC_LEADING_ASTERISK())) continue;
                            object = node;
                            boolean $i$f$prevSibling = false;
                            for (ASTNode n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                                it = n$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) continue;
                                aSTNode2 = n$iv;
                                break block10;
                            }
                            aSTNode2 = aSTNode = null;
                        }
                        if (aSTNode == null) {
                            n = 0;
                        } else {
                            object = aSTNode.getText();
                            if (object == null) {
                                n = 0;
                            } else {
                                String string = StringsKt.substringAfter$default((String)object, (char)'\n', null, (int)2, null);
                                if (string == null) {
                                    n = 0;
                                } else {
                                    int n2;
                                    void $this$count$iv;
                                    it = string;
                                    boolean $i$f$count = false;
                                    int count$iv = 0;
                                    void var14_16 = $this$count$iv;
                                    for (int i = 0; i < var14_16.length(); ++i) {
                                        char element$iv2 = var14_16.charAt(i);
                                        char it2 = element$iv2;
                                        boolean bl = false;
                                        if (!(it2 == ' ')) continue;
                                        ++count$iv;
                                    }
                                    n = n2 = count$iv;
                                }
                            }
                        }
                        int indent = n;
                        node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)Intrinsics.stringPlus((String)"\n", (Object)StringsKt.repeat((CharSequence)" ", (int)indent))), null);
                        node.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getKDOC_LEADING_ASTERISK(), (CharSequence)"*"), null);
                    }
                }
            }, 64, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAuthorAndDate(ASTNode node) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = KdocUtilsKt.kDocTags(node);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KDocTag it = (KDocTag)element$iv$iv;
            boolean bl = false;
            boolean bl2 = it.getKnownTag() == KDocKnownTag.AUTHOR || it.getKnownTag() == KDocKnownTag.SINCE && this.hasInvalidVersion(it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KDocTag it = (KDocTag)element$iv;
            boolean bl = false;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl3 = this.isFixMode();
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
            int n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it));
            string = it.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.node");
            Warnings.KDOC_CONTAINS_DATE_OR_AUTHOR.warn(list, function3, bl3, string2, n, (ASTNode)string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasEmptyLineAfter(ASTNode $this$hasEmptyLineAfter) {
        if (!Intrinsics.areEqual((Object)$this$hasEmptyLineAfter.getElementType(), (Object)ElementType.INSTANCE.getKDOC_TAG())) {
            boolean $i$a$-require-KdocFormatting$hasEmptyLineAfter$22 = false;
            String $i$a$-require-KdocFormatting$hasEmptyLineAfter$22 = "This check is only for KDOC_TAG";
            throw new IllegalArgumentException($i$a$-require-KdocFormatting$hasEmptyLineAfter$22.toString());
        }
        if (!Intrinsics.areEqual((Object)$this$hasEmptyLineAfter.getLastChildNode().getElementType(), (Object)ElementType.INSTANCE.getKDOC_LEADING_ASTERISK())) return false;
        if ($this$hasEmptyLineAfter.getTreeNext() == null) return true;
        if (!Intrinsics.areEqual((Object)$this$hasEmptyLineAfter.getTreeNext().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) return false;
        String string = $this$hasEmptyLineAfter.getTreeNext().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"treeNext.text");
        CharSequence $this$count$iv = string;
        boolean $i$f$count = false;
        int count$iv = 0;
        CharSequence charSequence = $this$count$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv = charSequence.charAt(i);
            char it = element$iv;
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        if (count$iv != true) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KDocTag> kDocBasicTags(ASTNode $this$kDocBasicTags) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = KdocUtilsKt.kDocTags($this$kDocBasicTags);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KDocTag it = (KDocTag)element$iv$iv;
            boolean bl = false;
            if (!CollectionsKt.contains((Iterable)this.basicTagsList, (Object)it.getKnownTag())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ASTNode previousAsterisk(ASTNode $this$previousAsterisk) {
        ASTNode aSTNode;
        block1: {
            ASTNode $this$prevSibling$iv = $this$previousAsterisk;
            boolean $i$f$prevSibling = false;
            for (ASTNode n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                ASTNode it = n$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getKDOC_LEADING_ASTERISK())) continue;
                aSTNode = n$iv;
                break block1;
            }
            aSTNode = null;
        }
        return aSTNode;
    }

    private final void applyToPrevSibling(ASTNode $this$applyToPrevSibling, IElementType elementType, Function1<? super ASTNode, Unit> consumer) {
        ASTNode aSTNode;
        block2: {
            ASTNode $this$prevSibling$iv = $this$applyToPrevSibling;
            boolean $i$f$prevSibling = false;
            for (ASTNode n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                ASTNode it = n$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)elementType)) continue;
                aSTNode = n$iv;
                break block2;
            }
            aSTNode = null;
        }
        if (aSTNode != null) {
            ASTNode aSTNode2 = aSTNode;
            consumer.invoke(aSTNode2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasInvalidVersion(KDocTag $this$hasInvalidVersion) {
        boolean bl;
        boolean bl2;
        Boolean bl3;
        String content = ((Object)StringsKt.trim((CharSequence)$this$hasInvalidVersion.getContent())).toString();
        if (StringsKt.contains$default((CharSequence)content, (char)' ', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)content, (char)'/', (boolean)false, (int)2, null)) {
            return true;
        }
        Regex regex = this.versionRegex;
        Boolean bl4 = regex == null ? null : (bl3 = Boolean.valueOf(!(bl2 = regex.matches((CharSequence)content))));
        if (bl3 == null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = dateFormats;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Integer it$iv$iv;
                Object object;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                DateTimeFormatter it = (DateTimeFormatter)element$iv$iv;
                boolean bl6 = false;
                Object object2 = $this$hasInvalidVersion;
                try {
                    KDocTag $this$hasInvalidVersion_u24lambda_u2d33_u24lambda_u2d32 = object2;
                    boolean bl7 = false;
                    object = Result.constructor-impl((Object)it.parse(content).get(ChronoField.YEAR));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                if ((Integer)(Result.isFailure-impl((Object)object2) ? null : object2) == null) continue;
                boolean bl8 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            bl = !((Collection)((List)destination$iv$iv)).isEmpty();
        } else {
            bl = bl3;
        }
        return bl;
    }

    public static final /* synthetic */ void access$applyToPrevSibling(KdocFormatting $this, ASTNode $receiver, IElementType elementType, Function1 consumer) {
        $this.applyToPrevSibling($receiver, elementType, (Function1<? super ASTNode, Unit>)consumer);
    }

    public static final /* synthetic */ ASTNode access$previousAsterisk(KdocFormatting $this, ASTNode $receiver) {
        return $this.previousAsterisk($receiver);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Object[] objectArray = new String[]{"yyyy-dd-mm", "yy-dd-mm", "yyyy-mm-dd", "yy-mm-dd", "yyyy.mm.dd", "yyyy.dd.mm"};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DateTimeFormatter.ofPattern((String)it));
        }
        dateFormats = (List)var3_3;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter2/kdoc/KdocFormatting$KdocFormatConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "versionRegex", "Lkotlin/text/Regex;", "getVersionRegex", "()Lkotlin/text/Regex;", "versionRegex$delegate", "Lkotlin/Lazy;", "diktat-rules"})
    public static final class KdocFormatConfiguration
    extends RuleConfiguration {
        @NotNull
        private final Lazy versionRegex$delegate;

        public KdocFormatConfiguration(@NotNull Map<String, String> config2) {
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            this.versionRegex$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Regex>(config2){
                final /* synthetic */ Map<String, String> $config;
                {
                    this.$config = $config;
                    super(0);
                }

                @Nullable
                public final Regex invoke() {
                    Regex regex;
                    String string = this.$config.get("versionRegex");
                    if (string == null) {
                        regex = null;
                    } else {
                        String it = string;
                        boolean bl = false;
                        regex = new Regex(it);
                    }
                    return regex;
                }
            }));
        }

        @Nullable
        public final Regex getVersionRegex() {
            Lazy lazy = this.versionRegex$delegate;
            return (Regex)lazy.getValue();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter2/kdoc/KdocFormatting$Companion;", "", "()V", "NAME_ID", "", "dateFormats", "", "Ljava/time/format/DateTimeFormatter;", "getDateFormats", "()Ljava/util/List;", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<DateTimeFormatter> getDateFormats() {
            return dateFormats;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

